/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.websocket.internals;

import gg.skytils.ktor.util.cio.ByteBufferPoolKt;
import gg.skytils.ktor.utils.io.core.BytePacketBuilder;
import gg.skytils.ktor.utils.io.core.ByteReadPacket;
import gg.skytils.ktor.utils.io.core.OutputArraysJVMKt;
import gg.skytils.ktor.utils.io.core.StringsKt;
import gg.skytils.ktor.utils.io.pool.ObjectPool;
import gg.skytils.ktor.websocket.internals.BytePacketUtilsKt;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001b\u0010\u0003\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a+\u0010\f\u001a\u00020\u000b*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001b\u0010\u000f\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Ljava/util/zip/Deflater;", "", "data", "deflateFully", "(Ljava/util/zip/Deflater;[B)[B", "Lgg/skytils/ktor/utils/io/core/BytePacketBuilder;", "deflater", "Ljava/nio/ByteBuffer;", "buffer", "", "flush", "", "deflateTo", "(Lgg/skytils/ktor/utils/io/core/BytePacketBuilder;Ljava/util/zip/Deflater;Ljava/nio/ByteBuffer;Z)I", "Ljava/util/zip/Inflater;", "inflateFully", "(Ljava/util/zip/Inflater;[B)[B", "EMPTY_CHUNK", "[B", "PADDED_EMPTY_CHUNK", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nDeflaterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Pool.kt\nio/ktor/utils/io/pool/PoolKt\n*L\n1#1,85:1\n12#2,7:86\n19#2,4:98\n12#2,11:102\n12#2,7:113\n19#2,4:125\n159#3,5:93\n159#3,5:120\n*S KotlinDebug\n*F\n+ 1 DeflaterUtils.kt\nio/ktor/websocket/internals/DeflaterUtilsKt\n*L\n19#1:86,7\n19#1:98,4\n35#1:102,11\n45#1:113,7\n45#1:125,4\n20#1:93,5\n46#1:120,5\n*E\n"})
public final class DeflaterUtilsKt {
    @NotNull
    private static final byte[] PADDED_EMPTY_CHUNK;
    @NotNull
    private static final byte[] EMPTY_CHUNK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] deflateFully(@NotNull Deflater $this$deflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        Intrinsics.checkNotNullParameter($this$deflateFully, "<this>");
        Intrinsics.checkNotNullParameter(data2, "data");
        $this$deflateFully.setInput(data2);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u241 = builder$iv;
            boolean bl = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl2 = false;
                while (!$this$deflateFully.needsInput()) {
                    DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, false);
                }
                while (DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u241, $this$deflateFully, buffer, true) != 0) {
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket deflatedBytes = byteReadPacket2;
        if (BytePacketUtilsKt.endsWith(deflatedBytes, PADDED_EMPTY_CHUNK)) {
            byte[] it = $i$f$buildPacket = StringsKt.readBytes(deflatedBytes, (int)deflatedBytes.getRemaining() - EMPTY_CHUNK.length);
            boolean bl = false;
            deflatedBytes.release();
            return $i$f$buildPacket;
        }
        $i$f$buildPacket = false;
        builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u243 = builder$iv;
            boolean bl = false;
            $this$deflateFully_u24lambda_u243.writePacket(deflatedBytes);
            $this$deflateFully_u24lambda_u243.writeByte((byte)0);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] inflateFully(@NotNull Inflater $this$inflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$inflateFully, "<this>");
        Intrinsics.checkNotNullParameter(data2, "data");
        byte[] dataToInflate = ArraysKt.plus(data2, EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$inflateFully_u24lambda_u245 = builder$iv;
            boolean bl = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl2 = false;
                long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
                while ($this$inflateFully.getBytesRead() < limit) {
                    buffer.clear();
                    int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                    buffer.position(buffer.position() + inflated);
                    buffer.flip();
                    OutputArraysJVMKt.writeFully($this$inflateFully_u24lambda_u245, buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet2 = byteReadPacket;
        return StringsKt.readBytes$default(packet2, 0, 1, null);
    }

    private static final int deflateTo(BytePacketBuilder $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        int deflated2;
        buffer.clear();
        int n = deflated2 = flush2 ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated2 == 0) {
            return 0;
        }
        buffer.position(buffer.position() + deflated2);
        buffer.flip();
        OutputArraysJVMKt.writeFully($this$deflateTo, buffer);
        return deflated2;
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, -1, -1};
        PADDED_EMPTY_CHUNK = byArray;
        byArray = new byte[]{0, 0, -1, -1};
        EMPTY_CHUNK = byArray;
    }
}

