/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-BC\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0010\u0010\u0016\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0012JL\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u0012J\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010\u0012R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b$\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b%\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\"\u001a\u0004\b&\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b'\u0010\u0012R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\"\u001a\u0004\b(\u0010\u0012R\u0011\u0010*\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010!R\u0011\u0010,\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010!\u00a8\u0006."}, d2={"Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "", "", "year", "month", "day", "hour", "minute", "second", "<init>", "(IIIIII)V", "Ljava/time/Instant;", "toInstant", "()Ljava/time/Instant;", "", "toMillis", "()J", "component1", "()I", "component2", "component3", "component4", "component5", "component6", "copy", "(IIIIII)Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getYear", "getMonth", "getDay", "getHour", "getMinute", "getSecond", "getMonthName", "monthName", "getDayName", "dayName", "Companion", "1.8.9"})
public final class SkyBlockTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private static final long SKYBLOCK_EPOCH_START_MILLIS = 1559829300000L;
    public static final long SKYBLOCK_YEAR_MILLIS = 446400000L;
    public static final long SKYBLOCK_SEASON_MILLIS = 111600000L;
    private static final long SKYBLOCK_MONTH_MILLIS = 37200000L;
    public static final long SKYBLOCK_DAY_MILLIS = 1200000L;
    public static final long SKYBLOCK_HOUR_MILLIS = 50000L;
    private static final long SKYBLOCK_MINUTE_MILLIS = 833L;
    private static final long SKYBLOCK_SECOND_MILLIS = 13L;

    public SkyBlockTime(int year, int month, int day, int hour, int minute, int second2) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second2;
    }

    public /* synthetic */ SkyBlockTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 1) != 0) {
            n = 1;
        }
        if ((n7 & 2) != 0) {
            n2 = 1;
        }
        if ((n7 & 4) != 0) {
            n3 = 1;
        }
        if ((n7 & 8) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 0;
        }
        this(n, n2, n3, n4, n5, n6);
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getDay() {
        return this.day;
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second;
    }

    @NotNull
    public final String getMonthName() {
        return Companion.monthName(this.month);
    }

    @NotNull
    public final String getDayName() {
        return this.day + Companion.daySuffix(this.day);
    }

    @Nullable
    public final Instant toInstant() {
        return Instant.ofEpochMilli(this.toMillis());
    }

    public final long toMillis() {
        return SkyBlockTime.Companion.calculateTimeInSkyBlockMillis(this.year, this.month, this.day, this.hour, this.minute, this.second) + 1559829300000L;
    }

    public final int component1() {
        return this.year;
    }

    public final int component2() {
        return this.month;
    }

    public final int component3() {
        return this.day;
    }

    public final int component4() {
        return this.hour;
    }

    public final int component5() {
        return this.minute;
    }

    public final int component6() {
        return this.second;
    }

    @NotNull
    public final SkyBlockTime copy(int year, int month, int day, int hour, int minute, int second2) {
        return new SkyBlockTime(year, month, day, hour, minute, second2);
    }

    public static /* synthetic */ SkyBlockTime copy$default(SkyBlockTime skyBlockTime, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = skyBlockTime.year;
        }
        if ((n7 & 2) != 0) {
            n2 = skyBlockTime.month;
        }
        if ((n7 & 4) != 0) {
            n3 = skyBlockTime.day;
        }
        if ((n7 & 8) != 0) {
            n4 = skyBlockTime.hour;
        }
        if ((n7 & 0x10) != 0) {
            n5 = skyBlockTime.minute;
        }
        if ((n7 & 0x20) != 0) {
            n6 = skyBlockTime.second;
        }
        return skyBlockTime.copy(n, n2, n3, n4, n5, n6);
    }

    @NotNull
    public String toString() {
        return "SkyBlockTime(year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.year);
        result2 = result2 * 31 + Integer.hashCode(this.month);
        result2 = result2 * 31 + Integer.hashCode(this.day);
        result2 = result2 * 31 + Integer.hashCode(this.hour);
        result2 = result2 * 31 + Integer.hashCode(this.minute);
        result2 = result2 * 31 + Integer.hashCode(this.second);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SkyBlockTime)) {
            return false;
        }
        SkyBlockTime skyBlockTime = (SkyBlockTime)other;
        if (this.year != skyBlockTime.year) {
            return false;
        }
        if (this.month != skyBlockTime.month) {
            return false;
        }
        if (this.day != skyBlockTime.day) {
            return false;
        }
        if (this.hour != skyBlockTime.hour) {
            return false;
        }
        if (this.minute != skyBlockTime.minute) {
            return false;
        }
        return this.second == skyBlockTime.second;
    }

    public SkyBlockTime() {
        this(0, 0, 0, 0, 0, 0, 63, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J?\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0014\u0010&\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010$R\u0014\u0010'\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010$R\u0014\u0010(\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010$R\u0014\u0010)\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010$R\u0014\u0010*\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010$R\u0014\u0010+\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b+\u0010$\u00a8\u0006,"}, d2={"Lat/hannibal2/skyhanni/utils/SkyBlockTime$Companion;", "", "<init>", "()V", "Ljava/time/Instant;", "instant", "Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "fromInstant", "(Ljava/time/Instant;)Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "", "year", "fromSbYear", "(I)Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "now", "()Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "", "realMillis", "calculateSkyBlockTime", "(J)Lat/hannibal2/skyhanni/utils/SkyBlockTime;", "millis", "factor", "getUnit", "(JJ)I", "month", "day", "hour", "minute", "second", "calculateTimeInSkyBlockMillis", "(IIIIII)J", "", "monthName", "(I)Ljava/lang/String;", "n", "daySuffix", "SKYBLOCK_EPOCH_START_MILLIS", "J", "SKYBLOCK_YEAR_MILLIS", "SKYBLOCK_SEASON_MILLIS", "SKYBLOCK_MONTH_MILLIS", "SKYBLOCK_DAY_MILLIS", "SKYBLOCK_HOUR_MILLIS", "SKYBLOCK_MINUTE_MILLIS", "SKYBLOCK_SECOND_MILLIS", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SkyBlockTime fromInstant(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "instant");
            return this.calculateSkyBlockTime(instant.toEpochMilli() - 1559829300000L);
        }

        @NotNull
        public final SkyBlockTime fromSbYear(int year) {
            Instant instant = Instant.ofEpochMilli(1559829300000L + 446400000L * (long)year);
            Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(...)");
            return this.fromInstant(instant);
        }

        @NotNull
        public final SkyBlockTime now() {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue(instant, "now(...)");
            return this.fromInstant(instant);
        }

        private final SkyBlockTime calculateSkyBlockTime(long realMillis) {
            long remainingMillis = realMillis;
            int year = this.getUnit(remainingMillis, 446400000L);
            int month = this.getUnit(remainingMillis %= 446400000L, 37200000L) + 1;
            int day = this.getUnit(remainingMillis %= 37200000L, 1200000L) + 1;
            int hour = this.getUnit(remainingMillis %= 1200000L, 50000L);
            int minute = this.getUnit(remainingMillis %= 50000L, 833L);
            int second2 = this.getUnit(remainingMillis %= 833L, 13L);
            return new SkyBlockTime(year, month, day, hour, minute, second2);
        }

        private final int getUnit(long millis, long factor) {
            return (int)(millis / factor);
        }

        private final long calculateTimeInSkyBlockMillis(int year, int month, int day, int hour, int minute, int second2) {
            long time = 0L;
            time += (long)year * 446400000L;
            time += (long)(month - 1) * 37200000L;
            time += (long)(day - 1) * 1200000L;
            time += (long)hour * 50000L;
            time += (long)minute * 833L;
            return time += (long)second2 * 13L;
        }

        @NotNull
        public final String monthName(int month) {
            String string2;
            String string3;
            switch ((month - 1) % 3) {
                case 0: {
                    string3 = "Early ";
                    break;
                }
                case 1: {
                    string3 = "";
                    break;
                }
                case 2: {
                    string3 = "Late ";
                    break;
                }
                default: {
                    string3 = "Undefined!";
                }
            }
            String prefix = string3;
            switch ((month - 1) / 3) {
                case 0: {
                    string2 = "Spring";
                    break;
                }
                case 1: {
                    string2 = "Summer";
                    break;
                }
                case 2: {
                    string2 = "Autumn";
                    break;
                }
                case 3: {
                    string2 = "Winter";
                    break;
                }
                default: {
                    string2 = "Undefined!";
                }
            }
            String name2 = string2;
            return prefix + name2;
        }

        @NotNull
        public final String daySuffix(int n) {
            String string2;
            boolean bl = 11 <= n ? n < 14 : false;
            if (bl) {
                string2 = "th";
            } else {
                switch (n % 10) {
                    case 1: {
                        string2 = "st";
                        break;
                    }
                    case 2: {
                        string2 = "nd";
                        break;
                    }
                    case 3: {
                        string2 = "rd";
                        break;
                    }
                    default: {
                        string2 = "th";
                    }
                }
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

