/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ParkourShortCut;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.util.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010\u001d\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c\u0018\u00010\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b&\u0010'R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010(\u001a\u0004\b)\u0010*R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010(R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010\t\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010+\u001a\u0004\b.\u0010-R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010/\u001a\u0004\b0\u0010\u0012R\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u00101\u001a\u0004\b2\u00103R\u0016\u00104\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00106\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u0010/R\"\u00107\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u0010/\u001a\u0004\b8\u0010\u0012\"\u0004\b9\u0010:R\"\u0010;\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\"\u0010A\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u00105\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\"\u0010F\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010/\u001a\u0004\bG\u0010\u0012\"\u0004\bH\u0010:R\"\u0010I\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010/\u001a\u0004\bJ\u0010\u0012\"\u0004\bK\u0010:\u00a8\u0006L"}, d2={"Lat/hannibal2/skyhanni/utils/ParkourHelper;", "", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "locations", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ParkourShortCut;", "shortCuts", "", "platformSize", "detectionRange", "", "depth", "Lkotlin/Function0;", "", "onEndReach", "<init>", "(Ljava/util/List;Ljava/util/List;DDZLkotlin/jvm/functions/Function0;)V", "inParkour", "()Z", "reset", "()V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "event", "render", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "offsetCenter", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lkotlin/Pair;", "Lkotlin/collections/IndexedValue;", "getInProgressPair", "()Lkotlin/Pair;", "loc", "Lnet/minecraft/util/AxisAlignedBB;", "axisAlignedBB", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/util/AxisAlignedBB;", "", "index", "Ljava/awt/Color;", "colorForIndex", "(I)Ljava/awt/Color;", "Ljava/util/List;", "getLocations", "()Ljava/util/List;", "D", "getPlatformSize", "()D", "getDetectionRange", "Z", "getDepth", "Lkotlin/jvm/functions/Function0;", "getOnEndReach", "()Lkotlin/jvm/functions/Function0;", "current", "I", "visible", "rainbowColor", "getRainbowColor", "setRainbowColor", "(Z)V", "monochromeColor", "Ljava/awt/Color;", "getMonochromeColor", "()Ljava/awt/Color;", "setMonochromeColor", "(Ljava/awt/Color;)V", "lookAhead", "getLookAhead", "()I", "setLookAhead", "(I)V", "outline", "getOutline", "setOutline", "showEverything", "getShowEverything", "setShowEverything", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nParkourHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParkourHelper.kt\nat/hannibal2/skyhanni/utils/ParkourHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1557#2:158\n1628#2,3:159\n*S KotlinDebug\n*F\n+ 1 ParkourHelper.kt\nat/hannibal2/skyhanni/utils/ParkourHelper\n*L\n112#1:158\n112#1:159,3\n*E\n"})
public final class ParkourHelper {
    @NotNull
    private final List<LorenzVec> locations;
    @NotNull
    private final List<ParkourShortCut> shortCuts;
    private final double platformSize;
    private final double detectionRange;
    private final boolean depth;
    @NotNull
    private final Function0<Unit> onEndReach;
    private int current;
    private boolean visible;
    private boolean rainbowColor;
    @NotNull
    private Color monochromeColor;
    private int lookAhead;
    private boolean outline;
    private boolean showEverything;

    public ParkourHelper(@NotNull List<LorenzVec> locations, @NotNull List<ParkourShortCut> shortCuts, double platformSize, double detectionRange, boolean depth, @NotNull Function0<Unit> onEndReach) {
        Intrinsics.checkNotNullParameter(locations, "locations");
        Intrinsics.checkNotNullParameter(shortCuts, "shortCuts");
        Intrinsics.checkNotNullParameter(onEndReach, "onEndReach");
        this.locations = locations;
        this.shortCuts = shortCuts;
        this.platformSize = platformSize;
        this.detectionRange = detectionRange;
        this.depth = depth;
        this.onEndReach = onEndReach;
        this.current = -1;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.monochromeColor = color;
        this.lookAhead = 2;
    }

    public /* synthetic */ ParkourHelper(List list, List list2, double d, double d2, boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        if ((n & 8) != 0) {
            d2 = 1.0;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            function0 = ParkourHelper::_init_$lambda$0;
        }
        this(list, list2, d, d2, bl, function0);
    }

    @NotNull
    public final List<LorenzVec> getLocations() {
        return this.locations;
    }

    public final double getPlatformSize() {
        return this.platformSize;
    }

    public final double getDetectionRange() {
        return this.detectionRange;
    }

    public final boolean getDepth() {
        return this.depth;
    }

    @NotNull
    public final Function0<Unit> getOnEndReach() {
        return this.onEndReach;
    }

    public final boolean getRainbowColor() {
        return this.rainbowColor;
    }

    public final void setRainbowColor(boolean bl) {
        this.rainbowColor = bl;
    }

    @NotNull
    public final Color getMonochromeColor() {
        return this.monochromeColor;
    }

    public final void setMonochromeColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.monochromeColor = color;
    }

    public final int getLookAhead() {
        return this.lookAhead;
    }

    public final void setLookAhead(int n) {
        this.lookAhead = n;
    }

    public final boolean getOutline() {
        return this.outline;
    }

    public final void setOutline(boolean bl) {
        this.outline = bl;
    }

    public final boolean getShowEverything() {
        return this.showEverything;
    }

    public final void setShowEverything(boolean bl) {
        this.showEverything = bl;
    }

    public final boolean inParkour() {
        return this.current != -1;
    }

    public final void reset() {
        this.current = -1;
        this.visible = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (this.locations.isEmpty()) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new IllegalArgumentException("locations is empty"), "Trying to render an empty parkour", new Pair[0], false, false, false, 56, null);
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            if (!this.showEverything) {
                double distanceToPlayer;
                if (this.current == this.locations.size() - 1) {
                    this.visible = false;
                }
                if (this.visible) {
                    Iterator iterator2 = ((Iterable)this.locations).iterator();
                    int n = 0;
                    while (iterator2.hasNext()) {
                        int index = n++;
                        LorenzVec indexedValue = (LorenzVec)iterator2.next();
                        boolean onGround = Minecraft.func_71410_x().field_71439_g.field_70122_E;
                        boolean closeEnough = LocationUtils.INSTANCE.distanceToPlayer(this.offsetCenter(indexedValue)) < this.detectionRange;
                        if (!closeEnough || !onGround) continue;
                        this.current = index;
                    }
                }
                if ((distanceToPlayer = LocationUtils.INSTANCE.distanceToPlayer(this.offsetCenter(CollectionsKt.first(this.locations)))) < this.detectionRange) {
                    this.visible = true;
                } else if (distanceToPlayer > 15.0 && this.current < 1) {
                    this.visible = false;
                }
                if (!this.visible) {
                    return;
                }
                if (this.current < 0) {
                    return;
                }
            } else {
                this.current = 0;
                this.lookAhead = this.locations.size();
            }
            List<Pair<IndexedValue<LorenzVec>, IndexedValue<LorenzVec>>> inProgressVec = CollectionUtils.INSTANCE.toSingletonListOrEmpty(this.getInProgressPair());
            if (this.locations.size() == this.current + 1) {
                this.onEndReach.invoke();
            }
            Iterator iterator3 = SequencesKt.plus(SequencesKt.take(SequencesKt.drop(SequencesKt.zipWithNext(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)this.locations))), this.current), this.lookAhead - 1), (Iterable)inProgressVec).iterator();
            while (iterator3.hasNext()) {
                Pair pair = iterator3.next();
                IndexedValue indexedValue = pair.component1();
                IndexedValue next = pair.component2();
                RenderUtils.INSTANCE.draw3DLine_nea(event, this.offsetCenter((LorenzVec)indexedValue.getValue()), this.offsetCenter((LorenzVec)next.getValue()), this.colorForIndex(indexedValue.getIndex()), 5, false);
            }
            IntRange nextShortcuts = RangesKt.until(this.current, this.current + this.lookAhead);
            for (ParkourShortCut parkourShortCut : this.shortCuts) {
                int next = nextShortcuts.getFirst();
                int closeEnough = nextShortcuts.getLast();
                int n = parkourShortCut.getFrom();
                boolean bl = next <= n ? n <= closeEnough : false;
                if (!bl) continue;
                next = ((Collection)this.locations).size();
                closeEnough = parkourShortCut.getTo();
                boolean bl2 = 0 <= closeEnough ? closeEnough < next : false;
                if (!bl2) continue;
                LorenzVec from = this.offsetCenter(this.locations.get(parkourShortCut.getFrom()));
                LorenzVec to = this.offsetCenter(this.locations.get(parkourShortCut.getTo()));
                Color color = Color.RED;
                Intrinsics.checkNotNullExpressionValue(color, "RED");
                RenderUtils.INSTANCE.draw3DLine_nea(event, from, to, color, 3, false);
                LorenzVec textLocation = from.plus(to.minus(from).normalize());
                RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, textLocation.add(-0.5, 1.0, -0.5), "\u00a7cShortcut", 1.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                AxisAlignedBB aabb = this.axisAlignedBB(this.locations.get(parkourShortCut.getTo()));
                Color color2 = Color.RED;
                Intrinsics.checkNotNullExpressionValue(color2, "RED");
                RenderUtils.drawFilledBoundingBox_nea$default(RenderUtils.INSTANCE, event, aabb, color2, 1.0f, false, false, 24, null);
                if (!this.outline) continue;
                Color color3 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue(color3, "BLACK");
                RenderUtils.INSTANCE.outlineTopFace(event, aabb, 2, color3, this.depth);
            }
            Iterable iterable = inProgressVec;
            Sequence sequence = SequencesKt.take(SequencesKt.drop(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)this.locations)), this.current), this.lookAhead);
            boolean $i$f$map = false;
            Iterable to = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IndexedValue)it.getSecond());
            }
            Iterator<Object> iterator4 = SequencesKt.plus(sequence, (List)destination$iv$iv).iterator();
            while (iterator4.hasNext()) {
                AxisAlignedBB aabb;
                boolean isMovingPlatform;
                IndexedValue indexedValue = (IndexedValue)iterator4.next();
                int index = indexedValue.component1();
                LorenzVec location = (LorenzVec)indexedValue.component2();
                boolean bl = isMovingPlatform = !this.locations.contains(location);
                if (isMovingPlatform && this.showEverything) continue;
                if (isMovingPlatform) {
                    aabb = RenderUtils.expandBlock$default(RenderUtils.INSTANCE, this.axisAlignedBB(location), 0, 1, null);
                    RenderUtils.drawFilledBoundingBox_nea$default(RenderUtils.INSTANCE, event, aabb, this.colorForIndex(index), 0.6f, false, false, 24, null);
                } else {
                    aabb = this.axisAlignedBB(location);
                    RenderUtils.drawFilledBoundingBox_nea$default(RenderUtils.INSTANCE, event, aabb, this.colorForIndex(index), 1.0f, false, false, 24, null);
                    if (this.outline) {
                        Color color = Color.BLACK;
                        Intrinsics.checkNotNullExpressionValue(color, "BLACK");
                        RenderUtils.INSTANCE.outlineTopFace(event, aabb, 2, color, this.depth);
                    }
                }
                if (!SkyHanniMod.feature.dev.waypoint.showPlatformNumber || isMovingPlatform) continue;
                RenderUtils.drawString$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(this.offsetCenter(location), 0, 1, 0, 5, null), "\u00a7a\u00a7l" + index, true, null, 8, null);
            }
        }
        catch (Throwable e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while rendering a parkour", new Pair[0], false, false, false, 56, null);
        }
    }

    private final LorenzVec offsetCenter(LorenzVec $this$offsetCenter) {
        return $this$offsetCenter.add(this.platformSize / (double)2, 1.0, this.platformSize / (double)2);
    }

    private final Pair<IndexedValue<LorenzVec>, IndexedValue<LorenzVec>> getInProgressPair() {
        if (this.current < 0 || this.current + this.lookAhead >= this.locations.size()) {
            return null;
        }
        LorenzVec currentPosition = this.offsetCenter(this.locations.get(this.current));
        LorenzVec nextPosition = this.offsetCenter(this.locations.get(this.current + 1));
        LorenzVec lookAheadStart = this.locations.get(this.current + this.lookAhead - 1);
        LorenzVec lookAheadEnd = this.locations.get(this.current + this.lookAhead);
        if (LocationUtils.INSTANCE.playerLocation().distance(nextPosition) > currentPosition.distance(nextPosition)) {
            return null;
        }
        double factor = LocationUtils.INSTANCE.playerLocation().distance(currentPosition) / currentPosition.distance(nextPosition);
        LorenzVec slopeLocation = lookAheadStart.slope(lookAheadEnd, factor);
        return new Pair<IndexedValue<LorenzVec>, IndexedValue<LorenzVec>>(new IndexedValue<LorenzVec>(this.current + this.lookAhead - 1, lookAheadStart), new IndexedValue<LorenzVec>(this.current + this.lookAhead, slopeLocation));
    }

    private final AxisAlignedBB axisAlignedBB(LorenzVec loc) {
        return RenderUtils.expandBlock$default(RenderUtils.INSTANCE, loc.boundingToOffset(this.platformSize, 1.0, this.platformSize), 0, 1, null);
    }

    private final Color colorForIndex(int index) {
        return this.rainbowColor ? RenderUtils.chromaColor-gRj5Bb8$default(RenderUtils.INSTANCE, DurationKt.toDuration(4, DurationUnit.SECONDS), (float)(-index) / 12.0f, 0.0f, 0.7f, 0L, 20, null) : this.monochromeColor;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

