/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ClipboardUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0086@\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/utils/OSUtils;", "", "<init>", "()V", "", "url", "", "openBrowser", "(Ljava/lang/String;)V", "text", "copyToClipboard", "readFromClipboard", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "1.8.9"})
public final class OSUtils {
    @NotNull
    public static final OSUtils INSTANCE = new OSUtils();

    private OSUtils() {
    }

    @JvmStatic
    public static final void openBrowser(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        boolean desktopSupported = Desktop.isDesktopSupported();
        boolean supportedActionBrowse = Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        if (desktopSupported && supportedActionBrowse) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("url", url)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while opening website.", pairArray, false, false, false, 56, null);
            }
        } else {
            INSTANCE.copyToClipboard(url);
            Pair[] pairArray = new Pair[]{TuplesKt.to("url", url), TuplesKt.to("desktopSupported", desktopSupported), TuplesKt.to("supportedActionBrowse", supportedActionBrowse)};
            ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Cannot open website! Copied url to clipboard instead", "Web browser is not supported", pairArray, false, false, false, null, 120, null);
        }
    }

    public final void copyToClipboard(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        ClipboardUtils.copyToClipboard$default(ClipboardUtils.INSTANCE, text, 0, 2, null);
    }

    @Nullable
    public final Object readFromClipboard(@NotNull Continuation<? super String> $completion) {
        return ClipboardUtils.readFromClipboard$default(ClipboardUtils.INSTANCE, 0, $completion, 1, null);
    }
}

