/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.data.PetAPI;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.features.misc.items.EstimatedItemValueCalculator;
import at.hannibal2.skyhanni.mixins.hooks.ItemStackCachedData;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.CachedItemData;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.ItemNameResolver;
import at.hannibal2.skyhanni.utils.ItemPriceSource;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveIngredient;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.PrimitiveRecipe;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.UtilsPatterns;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.common.collect.Lists;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\r\u0010\u0010J\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\t*\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u000bJ\u0011\u0010\u001b\u001a\u00020\t*\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u000bJ\u0015\u0010\u001c\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u000bJ\u0015\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\b\b\u0002\u0010!\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010#J\u0011\u0010%\u001a\u00020$*\u00020\u0004\u00a2\u0006\u0004\b%\u0010&J\u0013\u0010'\u001a\u0004\u0018\u00010$*\u00020\u0004\u00a2\u0006\u0004\b'\u0010&J\u0015\u0010(\u001a\u0004\u0018\u00010$*\u00020\u0004H\u0002\u00a2\u0006\u0004\b(\u0010&J\u0011\u0010)\u001a\u00020\t*\u00020\u0004\u00a2\u0006\u0004\b)\u0010\u000bJ\u0011\u0010*\u001a\u00020\t*\u00020\u0004\u00a2\u0006\u0004\b*\u0010\u000bJ\u0011\u0010+\u001a\u00020\t*\u00020\u0004\u00a2\u0006\u0004\b+\u0010\u000bJ\u0011\u0010,\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b,\u0010-J\u0013\u0010.\u001a\u0004\u0018\u00010\u0005*\u00020\u0004\u00a2\u0006\u0004\b.\u0010\u0007J\u0013\u0010/\u001a\u0004\u0018\u00010\u0005*\u00020\u0004\u00a2\u0006\u0004\b/\u0010\u0007J9\u00104\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000503\"\u00020\u0005\u00a2\u0006\u0004\b4\u00105J1\u00108\u001a\u00020\u00042\u0006\u00107\u001a\u0002062\u0006\u00100\u001a\u00020\u00052\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000503\"\u00020\u0005\u00a2\u0006\u0004\b8\u00109J?\u00108\u001a\u00020\u00042\u0006\u00107\u001a\u0002062\u0006\u00100\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\b\u0002\u0010:\u001a\u00020\u001e2\b\b\u0002\u0010;\u001a\u00020\u001e\u00a2\u0006\u0004\b8\u0010<J3\u0010?\u001a\u00020>2\u0006\u0010=\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u00052\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000503\"\u00020\u0005H\u0002\u00a2\u0006\u0004\b?\u0010@J\u0011\u0010B\u001a\u00020A*\u00020\u0004\u00a2\u0006\u0004\bB\u0010CJ#\u0010F\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010A\u0012\u0006\u0012\u0004\u0018\u00010E0D*\u00020\u0004H\u0002\u00a2\u0006\u0004\bF\u0010GJ+\u0010I\u001a\u0004\u0018\u00010E2\u0006\u0010H\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\bI\u0010JJ\u0013\u0010K\u001a\u00020>*\u00020\u0004H\u0002\u00a2\u0006\u0004\bK\u0010LJ\u0013\u0010M\u001a\u0004\u0018\u00010E*\u00020\u0004\u00a2\u0006\u0004\bM\u0010NJ\u0013\u0010O\u001a\u0004\u0018\u00010A*\u00020\u0004\u00a2\u0006\u0004\bO\u0010CJ\u0017\u0010R\u001a\u00020\t2\u0006\u0010Q\u001a\u00020PH\u0002\u00a2\u0006\u0004\bR\u0010SJ/\u0010U\u001a\u00020\u0004*\u00020\u00042\u0006\u00100\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0004\bU\u0010VJ\u0017\u0010W\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\bW\u0010\u000bJ#\u0010Y\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e\u0018\u00010D2\u0006\u0010X\u001a\u00020\u0005\u00a2\u0006\u0004\bY\u0010ZJ3\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0D2\u0006\u0010[\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010^\u001a\u00020]H\u0002\u00a2\u0006\u0004\b_\u0010`J\u0019\u0010b\u001a\u0004\u0018\u00010A2\u0006\u0010a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\bb\u0010CJ\u0011\u0010c\u001a\u00020\t*\u00020$\u00a2\u0006\u0004\bc\u0010dJ\u001f\u0010e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e\u0018\u00010D*\u00020\u0004\u00a2\u0006\u0004\be\u0010GJ\u0013\u0010f\u001a\u00020\u0005*\u00020$H\u0002\u00a2\u0006\u0004\bf\u0010gJ\u0017\u0010i\u001a\b\u0012\u0004\u0012\u00020$0h*\u00020\u0004\u00a2\u0006\u0004\bi\u0010\u000eJ!\u0010m\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001e0l2\u0006\u0010k\u001a\u00020j\u00a2\u0006\u0004\bm\u0010nJ+\u0010s\u001a\u00020r*\u00020j2\b\b\u0002\u0010p\u001a\u00020o2\u000e\b\u0002\u0010q\u001a\b\u0012\u0004\u0012\u00020j0\f\u00a2\u0006\u0004\bs\u0010tJ\u0017\u0010w\u001a\u00020>2\u0006\u0010v\u001a\u00020uH\u0007\u00a2\u0006\u0004\bw\u0010xJ\u001d\u0010z\u001a\u00020>2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010y\u001a\u00020\u0005\u00a2\u0006\u0004\bz\u0010{J\u000f\u0010|\u001a\u00020>H\u0002\u00a2\u0006\u0004\b|\u0010\u0003R \u0010~\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00050}8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b~\u0010\u007fR\u001e\u0010\u0081\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u0080\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0081\u0001\u0010\u0082\u0001R-\u0010\u0087\u0001\u001a\u00020\u000f*\u00020\u00042\u0006\u00102\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001\"\u0006\b\u0085\u0001\u0010\u0086\u0001R\u0018\u0010\u0087\u0001\u001a\u00020\u000f*\u00020\u000f8F\u00a2\u0006\b\u001a\u0006\b\u0083\u0001\u0010\u0088\u0001R!\u0010\u008e\u0001\u001a\u00030\u0089\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u008a\u0001\u0010\u008b\u0001\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001R!\u0010\u0091\u0001\u001a\u00030\u0089\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u008f\u0001\u0010\u008b\u0001\u001a\u0006\b\u0090\u0001\u0010\u008d\u0001R+\u0010\u001d\u001a\u00020\u0005*\u00020\u00042\u0006\u00102\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\u000f\u001a\u0005\b\u0092\u0001\u0010\u0007\"\u0006\b\u0093\u0001\u0010\u0094\u0001R.\u0010\u0095\u0001\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0D0}8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0095\u0001\u0010\u007fR\u0018\u0010\u0096\u0001\u001a\u00030\u0089\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0096\u0001\u0010\u0097\u0001R\u0016\u0010\\\u001a\u00020\u0005*\u00020\u00048F\u00a2\u0006\u0007\u001a\u0005\b\u0098\u0001\u0010\u0007R\u0017\u0010\u009a\u0001\u001a\u00020\u0005*\u00020\u00048F\u00a2\u0006\u0007\u001a\u0005\b\u0099\u0001\u0010\u0007R\u0016\u0010\\\u001a\u00020\u0005*\u00020$8F\u00a2\u0006\u0007\u001a\u0005\b\u0098\u0001\u0010gR\u0017\u0010\u009a\u0001\u001a\u00020\u0005*\u00020$8F\u00a2\u0006\u0007\u001a\u0005\b\u0099\u0001\u0010gR\u0017\u0010\u009c\u0001\u001a\u00020\u0005*\u00020$8F\u00a2\u0006\u0007\u001a\u0005\b\u009b\u0001\u0010g\u00a8\u0006\u009d\u0001"}, d2={"Lat/hannibal2/skyhanni/utils/ItemUtils;", "", "<init>", "()V", "Lnet/minecraft/item/ItemStack;", "", "cleanName", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "stack", "", "isSack", "(Lnet/minecraft/item/ItemStack;)Z", "", "getLore", "(Lnet/minecraft/item/ItemStack;)Ljava/util/List;", "Lnet/minecraft/nbt/NBTTagCompound;", "(Lnet/minecraft/nbt/NBTTagCompound;)Ljava/util/List;", "compound", "getDisplayName", "(Lnet/minecraft/nbt/NBTTagCompound;)Ljava/lang/String;", "lore", "setLore", "(Lnet/minecraft/item/ItemStack;Ljava/util/List;)Lnet/minecraft/item/ItemStack;", "id", "overrideId", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Lnet/minecraft/item/ItemStack;", "isCoopSoulBound", "isSoulBound", "isRecombobulated", "name", "", "maxPetLevel", "(Ljava/lang/String;)I", "withCursorItem", "getItemsInInventory", "(Z)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "getInternalName", "(Lnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/utils/NEUInternalName;", "getInternalNameOrNull", "grabInternalNameOrNull", "isVanilla", "isEnchanted", "hasEnchantments", "removeEnchants", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", "getSkullTexture", "getSkullOwner", "displayName", "uuid", "value", "", "createSkull", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lnet/minecraft/item/ItemStack;", "Lnet/minecraft/item/Item;", "item", "createItemStack", "(Lnet/minecraft/item/Item;Ljava/lang/String;[Ljava/lang/String;)Lnet/minecraft/item/ItemStack;", "amount", "damage", "(Lnet/minecraft/item/Item;Ljava/lang/String;Ljava/util/List;II)Lnet/minecraft/item/ItemStack;", "tag", "", "addNameAndLore", "(Lnet/minecraft/nbt/NBTTagCompound;Ljava/lang/String;[Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/utils/LorenzRarity;", "getItemRarityOrCommon", "(Lnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/utils/LorenzRarity;", "Lkotlin/Pair;", "Lat/hannibal2/skyhanni/utils/ItemCategory;", "readItemCategoryAndRarity", "(Lnet/minecraft/item/ItemStack;)Lkotlin/Pair;", "itemCategory", "getItemCategory", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/ItemCategory;", "updateCategoryAndRarity", "(Lnet/minecraft/item/ItemStack;)V", "getItemCategoryOrNull", "(Lnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/utils/ItemCategory;", "getItemRarityOrNull", "Lat/hannibal2/skyhanni/utils/CachedItemData;", "data", "itemRarityLastCheck", "(Lat/hannibal2/skyhanni/utils/CachedItemData;)Z", "disableNeuTooltips", "editItemInfo", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;ZLjava/util/List;)Lnet/minecraft/item/ItemStack;", "isSkyBlockMenuItem", "originalInput", "readItemAmount", "(Ljava/lang/String;)Lkotlin/Pair;", "input", "itemName", "Ljava/util/regex/Matcher;", "matcher", "makePair", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/regex/Matcher;)Lkotlin/Pair;", "pet", "getPetRarity", "isRune", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Z", "getAttributeFromShard", "grabItemName", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Ljava/lang/String;", "", "loreCosts", "Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;", "recipe", "", "neededItems", "(Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;)Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/ItemPriceSource;", "priceSource", "pastRecipes", "", "getRecipePrice", "(Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;Lat/hannibal2/skyhanni/utils/ItemPriceSource;Ljava/util/List;)D", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "message", "addMissingRepoItem", "(Ljava/lang/String;Ljava/lang/String;)V", "showRepoWarning", "", "itemNameCache", "Ljava/util/Map;", "", "missingRepoItems", "Ljava/util/Set;", "getExtraAttributes", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/nbt/NBTTagCompound;", "setExtraAttributes", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/nbt/NBTTagCompound;)V", "extraAttributes", "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", "Ljava/util/regex/Pattern;", "itemCategoryRepoCheckPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getItemCategoryRepoCheckPattern", "()Ljava/util/regex/Pattern;", "itemCategoryRepoCheckPattern", "rarityCategoryRepoCheckPattern$delegate", "getRarityCategoryRepoCheckPattern", "rarityCategoryRepoCheckPattern", "getName", "setName", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)V", "itemAmountCache", "bookPattern", "Ljava/util/regex/Pattern;", "getItemName", "getItemNameWithoutColor", "itemNameWithoutColor", "getReadableInternalName", "readableInternalName", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nItemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemUtils.kt\nat/hannibal2/skyhanni/utils/ItemUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SkyBlockItemModifierUtils.kt\nat/hannibal2/skyhanni/utils/SkyBlockItemModifierUtils\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 7 LorenzUtils.kt\nat/hannibal2/skyhanni/utils/LorenzUtils\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 9 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 10 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,564:1\n1#2:565\n1#2:576\n1#2:585\n1#2:587\n1755#3,3:566\n1755#3,3:569\n96#4:572\n96#4:581\n96#4:582\n96#4:583\n37#5,2:573\n8#6:575\n8#6:584\n8#6:586\n326#7,2:577\n1310#8,2:579\n381#9,7:588\n126#10:595\n153#10,3:596\n*S KotlinDebug\n*F\n+ 1 ItemUtils.kt\nat/hannibal2/skyhanni/utils/ItemUtils\n*L\n246#1:576\n375#1:585\n381#1:587\n95#1:566,3\n100#1:569,3\n125#1:572\n299#1:581\n313#1:582\n321#1:583\n207#1:573,2\n246#1:575\n375#1:584\n381#1:586\n295#1:577,2\n295#1:579,2\n446#1:588,7\n524#1:595\n524#1:596,3\n*E\n"})
public final class ItemUtils {
    @NotNull
    public static final ItemUtils INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Map<NEUInternalName, String> itemNameCache;
    @NotNull
    private static final Set<String> missingRepoItems;
    @NotNull
    private static final RepoPattern itemCategoryRepoCheckPattern$delegate;
    @NotNull
    private static final RepoPattern rarityCategoryRepoCheckPattern$delegate;
    @NotNull
    private static final Map<String, Pair<String, Integer>> itemAmountCache;
    @NotNull
    private static final Pattern bookPattern;

    private ItemUtils() {
    }

    @NotNull
    public final String cleanName(@NotNull ItemStack $this$cleanName) {
        Intrinsics.checkNotNullParameter($this$cleanName, "<this>");
        String string2 = $this$cleanName.func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        return StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null);
    }

    public final boolean isSack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.getInternalName(stack).endsWith("_SACK") && StringsKt.endsWith$default(this.cleanName(stack), " Sack", false, 2, null);
    }

    @NotNull
    public final List<String> getLore(@NotNull ItemStack $this$getLore) {
        Intrinsics.checkNotNullParameter($this$getLore, "<this>");
        return this.getLore($this$getLore.func_77978_p());
    }

    @NotNull
    public final List<String> getLore(@Nullable NBTTagCompound $this$getLore) {
        if ($this$getLore == null) {
            return CollectionsKt.emptyList();
        }
        NBTTagList tagList = $this$getLore.func_74775_l("display").func_150295_c("Lore", 8);
        List list = new ArrayList();
        int n = tagList.func_74745_c();
        for (int i2 = 0; i2 < n; ++i2) {
            String string2 = tagList.func_150307_f(i2);
            Intrinsics.checkNotNullExpressionValue(string2, "getStringTagAt(...)");
            list.add(string2);
        }
        return list;
    }

    @Nullable
    public final String getDisplayName(@Nullable NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        String name2 = compound.func_74775_l("display").func_74779_i("Name");
        if (name2 == null || ((CharSequence)name2).length() == 0) {
            return null;
        }
        return name2;
    }

    @NotNull
    public final ItemStack setLore(@NotNull ItemStack $this$setLore, @NotNull List<String> lore) {
        Intrinsics.checkNotNullParameter($this$setLore, "<this>");
        Intrinsics.checkNotNullParameter(lore, "lore");
        NBTTagCompound nBTTagCompound = $this$setLore.func_77978_p();
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound tagCompound = nBTTagCompound;
        NBTTagCompound display2 = tagCompound.func_74775_l("display");
        NBTTagList tagList = new NBTTagList();
        for (String line : lore) {
            tagList.func_74742_a((NBTBase)new NBTTagString(line));
        }
        display2.func_74782_a("Lore", (NBTBase)tagList);
        tagCompound.func_74782_a("display", (NBTBase)display2);
        $this$setLore.func_77982_d(tagCompound);
        return $this$setLore;
    }

    @NotNull
    public final NBTTagCompound getExtraAttributes(@NotNull ItemStack $this$extraAttributes) {
        Intrinsics.checkNotNullParameter($this$extraAttributes, "<this>");
        NBTTagCompound nBTTagCompound = $this$extraAttributes.func_77978_p();
        if (nBTTagCompound == null || (nBTTagCompound = this.getExtraAttributes(nBTTagCompound)) == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public final void setExtraAttributes(@NotNull ItemStack $this$extraAttributes, @NotNull NBTTagCompound value) {
        Intrinsics.checkNotNullParameter($this$extraAttributes, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        NBTTagCompound nBTTagCompound = $this$extraAttributes.func_77978_p();
        if (nBTTagCompound == null) {
            NBTTagCompound nBTTagCompound2;
            NBTTagCompound it = nBTTagCompound2 = new NBTTagCompound();
            boolean bl = false;
            $this$extraAttributes.func_77982_d(it);
            nBTTagCompound = nBTTagCompound2;
        }
        NBTTagCompound tag = nBTTagCompound;
        tag.func_74782_a("ExtraAttributes", (NBTBase)value);
    }

    @NotNull
    public final NBTTagCompound getExtraAttributes(@NotNull NBTTagCompound $this$extraAttributes) {
        Intrinsics.checkNotNullParameter($this$extraAttributes, "<this>");
        NBTTagCompound nBTTagCompound = $this$extraAttributes.func_74775_l("ExtraAttributes");
        Intrinsics.checkNotNullExpressionValue(nBTTagCompound, "getCompoundTag(...)");
        return nBTTagCompound;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemStack overrideId(@NotNull ItemStack $this$overrideId, @NotNull String id) {
        void $this$overrideId_u24lambda_u241;
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkNotNullParameter($this$overrideId, "<this>");
        Intrinsics.checkNotNullParameter(id, "id");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound = this.getExtraAttributes($this$overrideId);
        ItemStack itemStack2 = $this$overrideId;
        ItemUtils itemUtils = this;
        boolean bl = false;
        $this$overrideId_u24lambda_u241.func_74778_a("id", id);
        Unit unit = Unit.INSTANCE;
        itemUtils.setExtraAttributes(itemStack2, nBTTagCompound);
        return $this$overrideId;
    }

    public final boolean isCoopSoulBound(@NotNull ItemStack $this$isCoopSoulBound) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isCoopSoulBound, "<this>");
            Iterable $this$any$iv = this.getLore($this$isCoopSoulBound);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it, "\u00a78\u00a7l* \u00a78Co-op Soulbound \u00a78\u00a7l*") || Intrinsics.areEqual(it, "\u00a78\u00a7l* \u00a78Soulbound \u00a78\u00a7l*"))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isSoulBound(@NotNull ItemStack $this$isSoulBound) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isSoulBound, "<this>");
            Iterable $this$any$iv = this.getLore($this$isSoulBound);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it, "\u00a78\u00a7l* \u00a78Soulbound \u00a78\u00a7l*")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isRecombobulated(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return SkyBlockItemModifierUtils.INSTANCE.isRecombobulated(stack);
    }

    public final int maxPetLevel(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return StringsKt.contains$default((CharSequence)name2, "Golden Dragon", false, 2, null) ? 200 : 100;
    }

    @NotNull
    public final List<ItemStack> getItemsInInventory(boolean withCursorItem) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayerSP == null) {
            ErrorManager.INSTANCE.skyHanniError("getItemsInInventoryWithSlots: player is null!", new Pair[0]);
            throw new KotlinNothingValueException();
        }
        EntityPlayerSP player = entityPlayerSP;
        for (Slot slot : player.field_71070_bA.field_75151_b) {
            if (!slot.func_75216_d()) continue;
            list.add(slot.func_75211_c());
        }
        if (withCursorItem && player.field_71071_by != null && player.field_71071_by.func_70445_o() != null) {
            list.add(player.field_71071_by.func_70445_o());
        }
        return list;
    }

    public static /* synthetic */ List getItemsInInventory$default(ItemUtils itemUtils, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return itemUtils.getItemsInInventory(bl);
    }

    @NotNull
    public final NEUInternalName getInternalName(@NotNull ItemStack $this$getInternalName) {
        Intrinsics.checkNotNullParameter($this$getInternalName, "<this>");
        NEUInternalName nEUInternalName = this.getInternalNameOrNull($this$getInternalName);
        if (nEUInternalName == null) {
            nEUInternalName = NEUInternalName.Companion.getNONE();
        }
        return nEUInternalName;
    }

    @Nullable
    public final NEUInternalName getInternalNameOrNull(@NotNull ItemStack $this$getInternalNameOrNull) {
        Intrinsics.checkNotNullParameter($this$getInternalNameOrNull, "<this>");
        SkyBlockItemModifierUtils skyBlockItemModifierUtils = SkyBlockItemModifierUtils.INSTANCE;
        ItemStack $this$cachedData$iv = $this$getInternalNameOrNull;
        boolean $i$f$getCachedData = false;
        CachedItemData data2 = ((ItemStackCachedData)$this$cachedData$iv).getSkyhanni_cachedData();
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(data2.getLastInternalNameFetchTime-uFjCsEo()), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
            return data2.getLastInternalName();
        }
        NEUInternalName internalName = this.grabInternalNameOrNull($this$getInternalNameOrNull);
        data2.setLastInternalName(internalName);
        data2.setLastInternalNameFetchTime-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
        return internalName;
    }

    private final NEUInternalName grabInternalNameOrNull(ItemStack $this$grabInternalNameOrNull) {
        NEUInternalName nEUInternalName;
        String internalName;
        if (Intrinsics.areEqual(this.getName($this$grabInternalNameOrNull), "\u00a7fWisp's Ice-Flavored Water I Splash Potion")) {
            return NEUInternalName.Companion.getWISP_POTION();
        }
        String string2 = NEUItems.INSTANCE.getInternalName($this$grabInternalNameOrNull);
        String string3 = internalName = string2 != null ? StringsKt.replace$default(string2, "ULTIMATE_ULTIMATE_", "ULTIMATE_", false, 4, null) : null;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            nEUInternalName = ItemNameResolver.INSTANCE.fixEnchantmentName(it);
        } else {
            nEUInternalName = null;
        }
        return nEUInternalName;
    }

    public final boolean isVanilla(@NotNull ItemStack $this$isVanilla) {
        Intrinsics.checkNotNullParameter($this$isVanilla, "<this>");
        return NEUItems.INSTANCE.isVanillaItem($this$isVanilla);
    }

    public final boolean isEnchanted(@NotNull ItemStack $this$isEnchanted) {
        Intrinsics.checkNotNullParameter($this$isEnchanted, "<this>");
        return $this$isEnchanted.func_77948_v();
    }

    public final boolean hasEnchantments(@NotNull ItemStack $this$hasEnchantments) {
        Intrinsics.checkNotNullParameter($this$hasEnchantments, "<this>");
        Map<String, Integer> map2 = SkyBlockItemModifierUtils.INSTANCE.getEnchantments($this$hasEnchantments);
        return map2 != null ? !map2.isEmpty() : false;
    }

    @NotNull
    public final ItemStack removeEnchants(@NotNull ItemStack $this$removeEnchants) {
        ItemStack itemStack2;
        Intrinsics.checkNotNullParameter($this$removeEnchants, "<this>");
        ItemStack $this$removeEnchants_u24lambda_u245 = itemStack2 = $this$removeEnchants;
        boolean bl = false;
        NBTTagCompound nBTTagCompound = $this$removeEnchants_u24lambda_u245.func_77978_p();
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound tag = nBTTagCompound;
        tag.func_82580_o("ench");
        tag.func_82580_o("StoredEnchantments");
        $this$removeEnchants_u24lambda_u245.func_77982_d(tag);
        return itemStack2;
    }

    @Nullable
    public final String getSkullTexture(@NotNull ItemStack $this$getSkullTexture) {
        Intrinsics.checkNotNullParameter($this$getSkullTexture, "<this>");
        if (!Intrinsics.areEqual($this$getSkullTexture.func_77973_b(), Items.field_151144_bL)) {
            return null;
        }
        if ($this$getSkullTexture.func_77978_p() == null) {
            return null;
        }
        NBTTagCompound nbt = $this$getSkullTexture.func_77978_p();
        if (!nbt.func_74764_b("SkullOwner")) {
            return null;
        }
        return nbt.func_74775_l("SkullOwner").func_74775_l("Properties").func_150295_c("textures", 10).func_150305_b(0).func_74779_i("Value");
    }

    @Nullable
    public final String getSkullOwner(@NotNull ItemStack $this$getSkullOwner) {
        Intrinsics.checkNotNullParameter($this$getSkullOwner, "<this>");
        if (!Intrinsics.areEqual($this$getSkullOwner.func_77973_b(), Items.field_151144_bL)) {
            return null;
        }
        if ($this$getSkullOwner.func_77978_p() == null) {
            return null;
        }
        NBTTagCompound nbt = $this$getSkullOwner.func_77978_p();
        if (!nbt.func_74764_b("SkullOwner")) {
            return null;
        }
        return nbt.func_74775_l("SkullOwner").func_74779_i("Id");
    }

    @NotNull
    public final ItemStack createSkull(@NotNull String displayName, @NotNull String uuid, @NotNull String value, String ... lore) {
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(lore, "lore");
        ItemStack render2 = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound skullOwner = new NBTTagCompound();
        NBTTagCompound properties2 = new NBTTagCompound();
        NBTTagList textures = new NBTTagList();
        NBTTagCompound textures0 = new NBTTagCompound();
        skullOwner.func_74778_a("Id", uuid);
        skullOwner.func_74778_a("Name", uuid);
        textures0.func_74778_a("Value", value);
        textures.func_74742_a((NBTBase)textures0);
        this.addNameAndLore(tag, displayName, Arrays.copyOf(lore, lore.length));
        properties2.func_74782_a("textures", (NBTBase)textures);
        skullOwner.func_74782_a("Properties", (NBTBase)properties2);
        tag.func_74782_a("SkullOwner", (NBTBase)skullOwner);
        render2.func_77982_d(tag);
        return render2;
    }

    @NotNull
    public final ItemStack createItemStack(@NotNull Item item, @NotNull String displayName, String ... lore) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(lore, "lore");
        return ItemUtils.createItemStack$default(this, item, displayName, ArraysKt.toList(lore), 0, 0, 24, null);
    }

    @NotNull
    public final ItemStack createItemStack(@NotNull Item item, @NotNull String displayName, @NotNull List<String> lore, int amount, int damage) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(lore, "lore");
        ItemStack stack = new ItemStack(item, amount, damage);
        NBTTagCompound tag = new NBTTagCompound();
        Collection $this$toTypedArray$iv = lore;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        this.addNameAndLore(tag, displayName, Arrays.copyOf(stringArray, stringArray.length));
        tag.func_74768_a("HideFlags", 254);
        stack.func_77982_d(tag);
        return stack;
    }

    public static /* synthetic */ ItemStack createItemStack$default(ItemUtils itemUtils, Item item, String string2, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 1;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        return itemUtils.createItemStack(item, string2, list, n, n2);
    }

    private final void addNameAndLore(NBTTagCompound tag, String displayName, String ... lore) {
        NBTTagCompound display2 = new NBTTagCompound();
        display2.func_74778_a("Name", displayName);
        if (!(lore.length == 0)) {
            NBTTagList tagLore = new NBTTagList();
            for (String line : lore) {
                tagLore.func_74742_a((NBTBase)new NBTTagString(line));
            }
            display2.func_74782_a("Lore", (NBTBase)tagLore);
        }
        tag.func_74782_a("display", (NBTBase)display2);
    }

    @NotNull
    public final LorenzRarity getItemRarityOrCommon(@NotNull ItemStack $this$getItemRarityOrCommon) {
        Intrinsics.checkNotNullParameter($this$getItemRarityOrCommon, "<this>");
        LorenzRarity lorenzRarity = this.getItemRarityOrNull($this$getItemRarityOrCommon);
        if (lorenzRarity == null) {
            lorenzRarity = LorenzRarity.COMMON;
        }
        return lorenzRarity;
    }

    private final Pattern getItemCategoryRepoCheckPattern() {
        return (Pattern)itemCategoryRepoCheckPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getRarityCategoryRepoCheckPattern() {
        return (Pattern)rarityCategoryRepoCheckPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pair<LorenzRarity, ItemCategory> readItemCategoryAndRarity(ItemStack $this$readItemCategoryAndRarity) {
        String cleanName = this.cleanName($this$readItemCategoryAndRarity);
        if (PetAPI.INSTANCE.hasPetName(cleanName)) {
            return TuplesKt.to(this.getPetRarity($this$readItemCategoryAndRarity), ItemCategory.PET);
        }
        for (String line : CollectionsKt.reversed((Iterable)this.getLore($this$readItemCategoryAndRarity))) {
            Pair[] pairArray;
            Pair<String, String> pair;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = UtilsPatterns.INSTANCE.getRarityLoreLinePattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$readItemCategoryAndRarity_u24lambda_u248 = it$iv;
                boolean bl2 = false;
                String string2 = $this$readItemCategoryAndRarity_u24lambda_u248.group("itemCategory");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                String string3 = StringsKt.replace$default(string2, " ", "_", false, 4, null);
                String string4 = $this$readItemCategoryAndRarity_u24lambda_u248.group("rarity");
                Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
                pair = TuplesKt.to(string3, StringsKt.replace$default(string4, " ", "_", false, 4, null));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair<String, String> pair2 = pair;
            String category = (String)pair2.component1();
            String rarity = (String)pair2.component2();
            ItemCategory itemCategory = this.getItemCategory(category, this.getName($this$readItemCategoryAndRarity), cleanName);
            LorenzRarity itemRarity = LorenzRarity.Companion.getByName(rarity);
            if (itemCategory == null) {
                pairArray = new Pair[]{TuplesKt.to("internal name", this.getInternalName($this$readItemCategoryAndRarity)), TuplesKt.to("item name", this.getName($this$readItemCategoryAndRarity)), TuplesKt.to("inventory name", InventoryUtils.INSTANCE.openInventoryName()), TuplesKt.to("pattern result", category), TuplesKt.to("lore", this.getLore($this$readItemCategoryAndRarity))};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Could not read category for item " + this.getName($this$readItemCategoryAndRarity), "Failed to read category from item rarity via item lore", pairArray, false, false, true, () -> ItemUtils.readItemCategoryAndRarity$lambda$9(category), 24, null);
            }
            if (itemRarity == null) {
                pairArray = new Pair[]{TuplesKt.to("internal name", this.getInternalName($this$readItemCategoryAndRarity)), TuplesKt.to("item name", this.getName($this$readItemCategoryAndRarity)), TuplesKt.to("inventory name", InventoryUtils.INSTANCE.openInventoryName()), TuplesKt.to("pattern result", rarity), TuplesKt.to("lore", this.getLore($this$readItemCategoryAndRarity))};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Could not read rarity for item " + this.getName($this$readItemCategoryAndRarity), "Failed to read rarity from item rarity via item lore", pairArray, false, false, true, () -> ItemUtils.readItemCategoryAndRarity$lambda$10(rarity), 24, null);
            }
            return TuplesKt.to(itemRarity, itemCategory);
        }
        return TuplesKt.to(null, null);
    }

    private final ItemCategory getItemCategory(String itemCategory, String name2, String cleanName) {
        ItemCategory itemCategory2;
        if (((CharSequence)itemCategory).length() == 0) {
            itemCategory2 = RegexUtils.INSTANCE.matches(UtilsPatterns.INSTANCE.getAbiPhonePattern(), name2) ? ItemCategory.ABIPHONE : (PetAPI.INSTANCE.hasPetName(cleanName) ? ItemCategory.PET : (RegexUtils.INSTANCE.matches(UtilsPatterns.INSTANCE.getBaitPattern(), cleanName) ? ItemCategory.FISHING_BAIT : (RegexUtils.INSTANCE.matches(UtilsPatterns.INSTANCE.getEnchantedBookPattern(), name2) ? ItemCategory.ENCHANTED_BOOK : (RegexUtils.INSTANCE.matches(UtilsPatterns.INSTANCE.getPotionPattern(), name2) ? ItemCategory.POTION : (RegexUtils.INSTANCE.matches(UtilsPatterns.INSTANCE.getSackPattern(), name2) ? ItemCategory.SACK : ItemCategory.NONE)))));
        } else {
            ItemCategory itemCategory3;
            block3: {
                ItemCategory[] enums$iv;
                LorenzUtils this_$iv = LorenzUtils.INSTANCE;
                boolean $i$f$enumValueOfOrNull = false;
                ItemCategory[] $this$firstOrNull$iv$iv = enums$iv = ItemCategory.values();
                boolean $i$f$firstOrNull = false;
                for (ItemCategory element$iv$iv : $this$firstOrNull$iv$iv) {
                    Enum it$iv = element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it$iv.name(), itemCategory)) continue;
                    itemCategory3 = element$iv$iv;
                    break block3;
                }
                itemCategory3 = null;
            }
            itemCategory2 = (ItemCategory)((Enum)itemCategory3);
        }
        return itemCategory2;
    }

    static /* synthetic */ ItemCategory getItemCategory$default(ItemUtils itemUtils, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = StringUtils.removeColor$default(StringUtils.INSTANCE, string3, false, 1, null);
        }
        return itemUtils.getItemCategory(string2, string3, string4);
    }

    private final void updateCategoryAndRarity(ItemStack $this$updateCategoryAndRarity) {
        SkyBlockItemModifierUtils skyBlockItemModifierUtils = SkyBlockItemModifierUtils.INSTANCE;
        ItemStack $this$cachedData$iv = $this$updateCategoryAndRarity;
        boolean $i$f$getCachedData = false;
        Intrinsics.checkNotNull($this$cachedData$iv, "null cannot be cast to non-null type at.hannibal2.skyhanni.mixins.hooks.ItemStackCachedData");
        CachedItemData data2 = ((ItemStackCachedData)$this$cachedData$iv).getSkyhanni_cachedData();
        data2.setItemRarityLastCheck-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
        NEUInternalName internalName = this.getInternalName($this$updateCategoryAndRarity);
        if (Intrinsics.areEqual(internalName, NEUInternalName.Companion.getNONE())) {
            data2.setItemRarity(null);
            data2.setItemCategory(null);
            return;
        }
        Pair<LorenzRarity, ItemCategory> pair = this.readItemCategoryAndRarity($this$updateCategoryAndRarity);
        data2.setItemRarity(pair.getFirst());
        data2.setItemCategory(pair.getSecond());
    }

    @Nullable
    public final ItemCategory getItemCategoryOrNull(@NotNull ItemStack $this$getItemCategoryOrNull) {
        Intrinsics.checkNotNullParameter($this$getItemCategoryOrNull, "<this>");
        SkyBlockItemModifierUtils skyBlockItemModifierUtils = SkyBlockItemModifierUtils.INSTANCE;
        ItemStack $this$cachedData$iv = $this$getItemCategoryOrNull;
        boolean $i$f$getCachedData = false;
        CachedItemData data2 = ((ItemStackCachedData)$this$cachedData$iv).getSkyhanni_cachedData();
        Intrinsics.checkNotNull(data2);
        if (this.itemRarityLastCheck(data2)) {
            this.updateCategoryAndRarity($this$getItemCategoryOrNull);
        }
        return data2.getItemCategory();
    }

    @Nullable
    public final LorenzRarity getItemRarityOrNull(@NotNull ItemStack $this$getItemRarityOrNull) {
        Intrinsics.checkNotNullParameter($this$getItemRarityOrNull, "<this>");
        SkyBlockItemModifierUtils skyBlockItemModifierUtils = SkyBlockItemModifierUtils.INSTANCE;
        ItemStack $this$cachedData$iv = $this$getItemRarityOrNull;
        boolean $i$f$getCachedData = false;
        CachedItemData data2 = ((ItemStackCachedData)$this$cachedData$iv).getSkyhanni_cachedData();
        Intrinsics.checkNotNull(data2);
        if (this.itemRarityLastCheck(data2)) {
            this.updateCategoryAndRarity($this$getItemRarityOrNull);
        }
        return data2.getItemRarity();
    }

    private final boolean itemRarityLastCheck(CachedItemData data2) {
        return Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(data2.getItemRarityLastCheck-uFjCsEo()), DurationKt.toDuration(10, DurationUnit.SECONDS)) > 0;
    }

    @NotNull
    public final String getName(@NotNull ItemStack $this$name) {
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        String string2 = $this$name.func_82833_r();
        if (string2 == null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("itemStack", $this$name), TuplesKt.to("displayName", $this$name.func_82833_r()), TuplesKt.to("internal name", this.getInternalNameOrNull($this$name))};
            ErrorManager.INSTANCE.skyHanniError("Could not get name of ItemStack", pairArray);
            throw new KotlinNothingValueException();
        }
        return string2;
    }

    public final void setName(@NotNull ItemStack $this$name, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$name.func_151001_c(value);
    }

    @NotNull
    public final ItemStack editItemInfo(@NotNull ItemStack $this$editItemInfo, @NotNull String displayName, boolean disableNeuTooltips, @NotNull List<String> lore) {
        Intrinsics.checkNotNullParameter($this$editItemInfo, "<this>");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(lore, "lore");
        NBTTagCompound nBTTagCompound = $this$editItemInfo.func_77978_p();
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound tag = nBTTagCompound;
        NBTTagCompound display2 = tag.func_74775_l("display");
        NBTTagList loreList = new NBTTagList();
        for (String line : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(line));
        }
        display2.func_74778_a("Name", displayName);
        display2.func_74782_a("Lore", (NBTBase)loreList);
        tag.func_74782_a("display", (NBTBase)display2);
        tag.func_74768_a("HideFlags", 254);
        if (disableNeuTooltips) {
            tag.func_74757_a("disableNeuTooltip", true);
        }
        $this$editItemInfo.func_77982_d(tag);
        return $this$editItemInfo;
    }

    public final boolean isSkyBlockMenuItem(@Nullable ItemStack stack) {
        Object object = stack;
        return object != null && (object = this.getInternalName((ItemStack)object)) != null ? ((NEUInternalName)object).equals("SKYBLOCK_MENU") : false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<String, Integer> readItemAmount(@NotNull String originalInput) {
        String input2;
        String string2;
        Intrinsics.checkNotNullParameter(originalInput, "originalInput");
        StringUtils stringUtils = StringUtils.INSTANCE;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = bookPattern;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(originalInput);
        boolean bl = false;
        if (it$iv.matches()) {
            void $this$readItemAmount_u24lambda_u2411;
            Intrinsics.checkNotNull(it$iv);
            Matcher matcher = it$iv;
            StringUtils stringUtils2 = stringUtils;
            boolean bl2 = false;
            string2 = $this$readItemAmount_u24lambda_u2411.group("name");
            stringUtils = stringUtils2;
        } else {
            string2 = null;
        }
        String string3 = string2;
        if (string2 == null) {
            string3 = originalInput;
        }
        if (itemAmountCache.containsKey(input2 = stringUtils.removeResets(string3))) {
            Pair<String, Integer> pair = itemAmountCache.get(input2);
            Intrinsics.checkNotNull(pair);
            return pair;
        }
        RegexUtils regexUtils2 = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv2 = UtilsPatterns.INSTANCE.getReadAmountBeforePattern();
        boolean $i$f$matchMatcher2 = false;
        Matcher it$iv2 = $this$matchMatcher$iv2.matcher(input2);
        $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
        if (it$iv2.matches()) {
            Intrinsics.checkNotNull(it$iv2);
            Matcher $this$readItemAmount_u24lambda_u2412 = it$iv2;
            boolean bl3 = false;
            String itemName = $this$readItemAmount_u24lambda_u2412.group("name");
            Intrinsics.checkNotNull(itemName);
            if (!StringsKt.contains$default((CharSequence)itemName, "\u00a78x", false, 2, null)) {
                return INSTANCE.makePair(input2, ((Object)StringsKt.trim((CharSequence)itemName)).toString(), $this$readItemAmount_u24lambda_u2412);
            }
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)input2)).toString();
        String string5 = string4.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
        String color = string5;
        String string6 = string4.substring(2);
        Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
        string4 = string6;
        Matcher matcher = UtilsPatterns.INSTANCE.getReadAmountAfterPattern().matcher(string4);
        if (!matcher.matches()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append(color);
        String string7 = matcher.group("name");
        Intrinsics.checkNotNullExpressionValue(string7, "group(...)");
        String itemName = stringBuilder.append(((Object)StringsKt.trim((CharSequence)string7)).toString()).toString();
        Intrinsics.checkNotNull(matcher);
        return this.makePair(input2, itemName, matcher);
    }

    private final Pair<String, Integer> makePair(String input2, String itemName, Matcher matcher) {
        String matcherAmount;
        String string2 = matcherAmount = matcher.group("amount");
        int amount = string2 != null ? NumberUtil.INSTANCE.formatInt(string2) : 1;
        Pair<String, Integer> pair = new Pair<String, Integer>(itemName, amount);
        itemAmountCache.put(input2, pair);
        return pair;
    }

    private final LorenzRarity getPetRarity(ItemStack pet) {
        String[] stringArray = new String[]{";"};
        int rarityId = Integer.parseInt((String)CollectionsKt.last(StringsKt.split$default((CharSequence)this.getInternalName(pet).asString(), stringArray, false, 0, 6, null)));
        LorenzRarity rarity = LorenzRarity.Companion.getById(rarityId);
        String name2 = this.getName(pet);
        if (rarity == null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("internal name", this.getInternalName(pet)), TuplesKt.to("item name", name2), TuplesKt.to("rarity id", rarityId), TuplesKt.to("inventory name", InventoryUtils.INSTANCE.openInventoryName())};
            ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Could not read rarity for pet " + name2, "Failed to read rarity from pet item via internal name", pairArray, false, false, false, null, 120, null);
        }
        return rarity;
    }

    public final boolean isRune(@NotNull NEUInternalName $this$isRune) {
        Intrinsics.checkNotNullParameter($this$isRune, "<this>");
        return $this$isRune.contains("_RUNE;");
    }

    @NotNull
    public final String getItemName(@NotNull ItemStack $this$itemName) {
        Intrinsics.checkNotNullParameter($this$itemName, "<this>");
        Pair<String, Integer> pair = this.getAttributeFromShard($this$itemName);
        if (pair != null) {
            Pair<String, Integer> it = pair;
            boolean bl = false;
            return EstimatedItemValueCalculator.INSTANCE.getAttributeName(it);
        }
        Object object = this.getInternalNameOrNull($this$itemName);
        if (object == null || (object = this.getItemName((NEUInternalName)object)) == null) {
            object = "<null>";
        }
        return object;
    }

    @Nullable
    public final Pair<String, Integer> getAttributeFromShard(@NotNull ItemStack $this$getAttributeFromShard) {
        Intrinsics.checkNotNullParameter($this$getAttributeFromShard, "<this>");
        if (!Intrinsics.areEqual(this.getInternalName($this$getAttributeFromShard).asString(), "ATTRIBUTE_SHARD")) {
            return null;
        }
        List<Pair<String, Integer>> list = SkyBlockItemModifierUtils.INSTANCE.getAttributes($this$getAttributeFromShard);
        if (list == null) {
            return null;
        }
        List<Pair<String, Integer>> attributes = list;
        return CollectionsKt.firstOrNull(attributes);
    }

    @NotNull
    public final String getItemNameWithoutColor(@NotNull ItemStack $this$itemNameWithoutColor) {
        Intrinsics.checkNotNullParameter($this$itemNameWithoutColor, "<this>");
        return StringUtils.removeColor$default(StringUtils.INSTANCE, this.getItemName($this$itemNameWithoutColor), false, 1, null);
    }

    @NotNull
    public final String getItemName(@NotNull NEUInternalName $this$itemName) {
        String string2;
        Intrinsics.checkNotNullParameter($this$itemName, "<this>");
        Map<NEUInternalName, String> $this$getOrPut$iv = itemNameCache;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get($this$itemName);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = INSTANCE.grabItemName($this$itemName);
            $this$getOrPut$iv.put($this$itemName, answer$iv);
            string2 = answer$iv;
        } else {
            string2 = value$iv;
        }
        return string2;
    }

    @NotNull
    public final String getItemNameWithoutColor(@NotNull NEUInternalName $this$itemNameWithoutColor) {
        Intrinsics.checkNotNullParameter($this$itemNameWithoutColor, "<this>");
        return StringUtils.removeColor$default(StringUtils.INSTANCE, this.getItemName($this$itemNameWithoutColor), false, 1, null);
    }

    @NotNull
    public final String getReadableInternalName(@NotNull NEUInternalName $this$readableInternalName) {
        Intrinsics.checkNotNullParameter($this$readableInternalName, "<this>");
        String string2 = StringsKt.replace$default($this$readableInternalName.asString(), "_", " ", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return string2;
    }

    private final String grabItemName(NEUInternalName $this$grabItemName) {
        if (Intrinsics.areEqual($this$grabItemName, NEUInternalName.Companion.getWISP_POTION())) {
            return "\u00a7fWisp's Ice-Flavored Water";
        }
        if (Intrinsics.areEqual($this$grabItemName, NEUInternalName.Companion.getSKYBLOCK_COIN())) {
            return "\u00a76Coins";
        }
        if (Intrinsics.areEqual($this$grabItemName, NEUInternalName.Companion.getNONE())) {
            throw new IllegalStateException("NEUInternalName.NONE has no name!".toString());
        }
        if (NEUItems.INSTANCE.getIgnoreItemsFilter().match($this$grabItemName.asString())) {
            return "\u00a7cBugged Item";
        }
        ItemStack itemStack2 = NEUItems.INSTANCE.getItemStackOrNull($this$grabItemName);
        Object object = itemStack2;
        if (object == null || (object = this.getName((ItemStack)object)) == null) {
            NEUInternalName $this$grabItemName_u24lambda_u2415 = $this$grabItemName;
            boolean bl = false;
            String name2 = $this$grabItemName_u24lambda_u2415.toString();
            INSTANCE.addMissingRepoItem(name2, "Could not find item name for " + name2);
            return "\u00a7c" + name2;
        }
        Object name3 = object;
        if (this.getItemCategoryOrNull(itemStack2) == ItemCategory.ENCHANTED_BOOK) {
            return this.getLore(itemStack2).get(0);
        }
        if (StringsKt.endsWith$default((String)name3, "Enchanted Book Bundle", false, 2, null)) {
            return StringsKt.replace$default((String)name3, "Enchanted Book", StringUtils.removeColor$default(StringUtils.INSTANCE, this.getLore(itemStack2).get(0), false, 1, null), false, 4, null);
        }
        if (StringsKt.contains$default((CharSequence)name3, "\u00a7kObfuscated", false, 2, null)) {
            return StringsKt.replace$default((String)name3, "\u00a7kObfuscated", "Obfuscated", false, 4, null);
        }
        String string2 = PetAPI.INSTANCE.getCleanName((String)name3);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it + " Pet";
        }
        return name3;
    }

    @NotNull
    public final List<NEUInternalName> loreCosts(@NotNull ItemStack $this$loreCosts) {
        Intrinsics.checkNotNullParameter($this$loreCosts, "<this>");
        boolean found = false;
        List list = new ArrayList();
        for (String lines : this.getLore($this$loreCosts)) {
            NEUInternalName it;
            if (Intrinsics.areEqual(lines, "\u00a77Cost")) {
                found = true;
                continue;
            }
            if (!found) continue;
            if (((CharSequence)lines).length() == 0) {
                return list;
            }
            if (NEUInternalName.Companion.fromItemNameOrNull(lines) == null) continue;
            boolean bl = false;
            list.add(it);
        }
        return list;
    }

    @NotNull
    public final Map<NEUInternalName, Integer> neededItems(@NotNull PrimitiveRecipe recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        Map neededItems = new LinkedHashMap();
        for (PrimitiveItemStack primitiveItemStack : PrimitiveIngredient.Companion.toPrimitiveItemStacks(recipe.getIngredients())) {
            NEUInternalName material = primitiveItemStack.component1();
            int amount = primitiveItemStack.component2();
            CollectionUtils.INSTANCE.addOrPut(neededItems, material, amount);
        }
        return neededItems;
    }

    /*
     * WARNING - void declaration
     */
    public final double getRecipePrice(@NotNull PrimitiveRecipe $this$getRecipePrice, @NotNull ItemPriceSource priceSource, @NotNull List<PrimitiveRecipe> pastRecipes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getRecipePrice, "<this>");
        Intrinsics.checkNotNullParameter((Object)priceSource, "priceSource");
        Intrinsics.checkNotNullParameter(pastRecipes, "pastRecipes");
        Map<NEUInternalName, Integer> $this$map$iv = this.neededItems($this$getRecipePrice);
        boolean $i$f$map = false;
        Map<NEUInternalName, Integer> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ItemPriceUtils.INSTANCE.getPrice((NEUInternalName)it.getKey(), priceSource, pastRecipes) * ((Number)it.getValue()).doubleValue());
        }
        return CollectionsKt.sumOfDouble((List)destination$iv$iv);
    }

    public static /* synthetic */ double getRecipePrice$default(ItemUtils itemUtils, PrimitiveRecipe primitiveRecipe, ItemPriceSource itemPriceSource, List list, int n, Object object) {
        if ((n & 1) != 0) {
            itemPriceSource = ItemPriceSource.BAZAAR_INSTANT_BUY;
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return itemUtils.getRecipePrice(primitiveRecipe, itemPriceSource, list);
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Missing Repo Items");
        if (!((Collection)missingRepoItems).isEmpty()) {
            event.addData(ItemUtils::onDebugDataCollect$lambda$19);
        } else {
            event.addIrrelevant("No Repo Item fails detected.");
        }
    }

    public final void addMissingRepoItem(@NotNull String name2, @NotNull String message) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(message, "message");
        if (!missingRepoItems.add(name2)) {
            return;
        }
        ChatUtils.INSTANCE.debug(message);
    }

    private final void showRepoWarning() {
        Object[] objectArray = new String[]{"\u00a7c\u00a7lMissing repo data", "\u00a7cData used for some SkyHanni features is not up to date, this should normally not be the case.", "\u00a7cYou can try \u00a7l/neuresetrepo\u00a7r\u00a7c and restart your game to see if that fixes the issue.", "\u00a7cIf the problem persists please join the SkyHanni Discord and message in \u00a7l#support\u00a7r\u00a7c to get support."};
        NotificationHandler.displayNotification((List)Lists.newArrayList((Object[])objectArray), (boolean)true, (boolean)true);
    }

    private static final CharSequence itemCategoryRepoCheckPattern_delegate$lambda$6(ItemCategory it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.name();
    }

    private static final CharSequence rarityCategoryRepoCheckPattern_delegate$lambda$7(LorenzRarity it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.name();
    }

    private static final boolean readItemCategoryAndRarity$lambda$9(String $category) {
        Intrinsics.checkNotNullParameter($category, "$category");
        return !RegexUtils.INSTANCE.matches(INSTANCE.getItemCategoryRepoCheckPattern(), $category);
    }

    private static final boolean readItemCategoryAndRarity$lambda$10(String $rarity) {
        Intrinsics.checkNotNullParameter($rarity, "$rarity");
        return !RegexUtils.INSTANCE.matches(INSTANCE.getRarityCategoryRepoCheckPattern(), $rarity);
    }

    private static final Unit onDebugDataCollect$lambda$19(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Detected " + missingRepoItems.size() + " missing items:");
        for (String itemName : missingRepoItems) {
            $this$addData.add(" - " + itemName);
        }
        return Unit.INSTANCE;
    }

    static {
        Object object = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ItemUtils.class, "itemCategoryRepoCheckPattern", "getItemCategoryRepoCheckPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ItemUtils.class, "rarityCategoryRepoCheckPattern", "getRarityCategoryRepoCheckPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = object;
        INSTANCE = new ItemUtils();
        itemNameCache = new LinkedHashMap();
        missingRepoItems = new LinkedHashSet();
        itemCategoryRepoCheckPattern$delegate = RepoPattern.Companion.pattern("itemcategory.repocheck", CollectionsKt.joinToString$default(ItemCategory.getEntries(), "|", null, null, 0, null, ItemUtils::itemCategoryRepoCheckPattern_delegate$lambda$6, 30, null));
        rarityCategoryRepoCheckPattern$delegate = RepoPattern.Companion.pattern("rarity.repocheck", CollectionsKt.joinToString$default(LorenzRarity.getEntries(), "|", null, null, 0, null, ItemUtils::rarityCategoryRepoCheckPattern_delegate$lambda$7, 30, null));
        itemAmountCache = new LinkedHashMap();
        object = "(?<name>.* [IVX]+) Book";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        bookPattern = pattern;
    }
}

