/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.data.jsonobjects.repo.neu.NeuEssenceCostJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.NeuRepositoryReloadEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import com.google.gson.Gson;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n*\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ;\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u00122\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014JY\u0010\u0019\u001a2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0012\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\n0\u00120\u00172\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00150\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ#\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001f0\u00122\u0006\u0010\u001e\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b \u0010!R:\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/utils/EssenceItemUtils;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent;", "event", "", "onNeuRepoReload", "(Lat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "", "Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssenceUpgradePrice;", "getEssencePrices", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Ljava/util/Map;", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/neu/NeuEssenceCostJson;", "unformattedData", "", "reformatData", "(Ljava/util/Map;)Ljava/util/Map;", "", "extraItems", "Lkotlin/Pair;", "", "loadCoinAndItemPrices", "(Ljava/util/Map;)Lkotlin/Pair;", "string", "split", "(Ljava/lang/String;)Lkotlin/Pair;", "data", "Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "loadEssencePrices", "(Lat/hannibal2/skyhanni/data/jsonobjects/repo/neu/NeuEssenceCostJson;)Ljava/util/Map;", "itemPrices", "Ljava/util/Map;", "getItemPrices", "()Ljava/util/Map;", "setItemPrices", "(Ljava/util/Map;)V", "EssenceUpgradePrice", "EssencePrice", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEssenceItemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssenceItemUtils.kt\nat/hannibal2/skyhanni/utils/EssenceItemUtils\n+ 2 NeuRepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n33#2,6:130\n477#3:136\n423#3:137\n1246#4,4:138\n1557#4:142\n1628#4,3:143\n1#5:146\n*S KotlinDebug\n*F\n+ 1 EssenceItemUtils.kt\nat/hannibal2/skyhanni/utils/EssenceItemUtils\n*L\n17#1:130,6\n51#1:136\n51#1:137\n51#1:138,4\n54#1:142\n54#1:143,3\n*E\n"})
public final class EssenceItemUtils {
    @NotNull
    public static final EssenceItemUtils INSTANCE = new EssenceItemUtils();
    @NotNull
    private static Map<NEUInternalName, ? extends Map<Integer, EssenceUpgradePrice>> itemPrices = MapsKt.emptyMap();

    private EssenceItemUtils() {
    }

    @NotNull
    public final Map<NEUInternalName, Map<Integer, EssenceUpgradePrice>> getItemPrices() {
        return itemPrices;
    }

    public final void setItemPrices(@NotNull Map<NEUInternalName, ? extends Map<Integer, EssenceUpgradePrice>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        itemPrices = map2;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onNeuRepoReload(@NotNull NeuRepositoryReloadEvent event) {
        Map map2;
        void constant$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String string2 = "essencecosts";
        Type type$iv = NeuEssenceCostJson.Companion.getTYPE();
        Gson gson$iv = ConfigManager.Companion.getGson();
        boolean $i$f$getConstant = false;
        try {
            if (!NEUItems.INSTANCE.getManager().repoLocation.exists()) {
                throw new RepoError("NEU-Repo folder does not exist!");
            }
            File file = NEUItems.INSTANCE.getManager().repoLocation;
            Intrinsics.checkNotNullExpressionValue(file, "repoLocation");
            map2 = RepoUtils.INSTANCE.getConstant(file, (String)constant$iv, gson$iv, Map.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + (String)constant$iv + '\'', e$iv);
        }
        Map unformattedData = map2;
        itemPrices = this.reformatData(unformattedData);
    }

    @Nullable
    public final Map<Integer, EssenceUpgradePrice> getEssencePrices(@NotNull NEUInternalName $this$getEssencePrices) {
        Intrinsics.checkNotNullParameter($this$getEssencePrices, "<this>");
        return itemPrices.get($this$getEssencePrices);
    }

    private final Map<NEUInternalName, Map<Integer, EssenceUpgradePrice>> reformatData(Map<String, NeuEssenceCostJson> unformattedData) {
        Map itemPrices = new LinkedHashMap();
        for (Map.Entry<String, NeuEssenceCostJson> entry : unformattedData.entrySet()) {
            String name2 = entry.getKey();
            NeuEssenceCostJson data2 = entry.getValue();
            Map<Integer, EssencePrice> essencePrices = this.loadEssencePrices(data2);
            Map<String, List<String>> map2 = data2.getExtraItems();
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map<String, List<String>> extraItems = map2;
            Pair<Map<Integer, Long>, Map<Integer, Map<NEUInternalName, Integer>>> pair = this.loadCoinAndItemPrices(extraItems);
            Map<Integer, Long> coinPrices = pair.component1();
            Map<Integer, Map<NEUInternalName, Integer>> iemPrices = pair.component2();
            Map upgradePrices = new LinkedHashMap();
            for (Map.Entry<Integer, EssencePrice> entry2 : essencePrices.entrySet()) {
                int tier = ((Number)entry2.getKey()).intValue();
                EssencePrice essencePrice = entry2.getValue();
                Long coinPrice = coinPrices.get(tier);
                Map<NEUInternalName, Integer> map3 = iemPrices.get(tier);
                if (map3 == null) {
                    map3 = MapsKt.emptyMap();
                }
                Map<NEUInternalName, Integer> itemPrice = map3;
                Integer n = tier;
                upgradePrices.put(n, new EssenceUpgradePrice(essencePrice, coinPrice, itemPrice));
            }
            NEUInternalName internalName = NEUInternalName.Companion.asInternalName(name2);
            itemPrices.put(internalName, upgradePrices);
        }
        return itemPrices;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Map<Integer, Long>, Map<Integer, Map<NEUInternalName, Integer>>> loadCoinAndItemPrices(Map<String, ? extends List<String>> extraItems) {
        Object object;
        Object object2;
        Object object3;
        void $this$mapKeysTo$iv$iv;
        Map collectCoinPrices = new LinkedHashMap();
        Map collectItemPrices = new LinkedHashMap();
        Map<String, ? extends List<String>> $this$mapKeys$iv = extraItems;
        boolean $i$f$mapKeys = false;
        Map<String, ? extends List<String>> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object2 = (Map.Entry)element$iv$iv$iv;
            object = Integer.parseInt((String)it.getKey());
            Map map3 = object3;
            boolean bl2 = false;
            it = it$iv$iv.getValue();
            map3.put(object, it);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            Serializable serializable2;
            void $this$mapTo$iv$iv;
            int tier = ((Number)entry.getKey()).intValue();
            List rawItems = (List)entry.getValue();
            Map itemPrices = new LinkedHashMap();
            Iterable $this$map$iv = rawItems;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                object3 = destination$iv$iv2;
                boolean bl = false;
                object3.add(INSTANCE.split((String)it));
            }
            for (Serializable serializable2 : (List)destination$iv$iv2) {
                NEUInternalName itemName = (NEUInternalName)((Pair)serializable2).component1();
                long amount = ((Number)((Pair)serializable2).component2()).longValue();
                if (Intrinsics.areEqual(itemName, NEUInternalName.Companion.getSKYBLOCK_COIN())) {
                    Integer n = tier;
                    object2 = amount;
                    collectCoinPrices.put(n, object2);
                    continue;
                }
                itemPrices.put(itemName, (int)amount);
            }
            serializable2 = Integer.valueOf(tier);
            collectItemPrices.put(serializable2, itemPrices);
        }
        return new Pair<Map<Integer, Long>, Map<Integer, Map<NEUInternalName, Integer>>>(collectCoinPrices, collectItemPrices);
    }

    private final Pair<NEUInternalName, Long> split(String string2) {
        String[] stringArray = new String[]{":"};
        List it = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
        boolean bl = false;
        return TuplesKt.to(NEUInternalName.Companion.asInternalName((String)it.get(0)), Long.parseLong((String)it.get(1)));
    }

    private final Map<Integer, EssencePrice> loadEssencePrices(NeuEssenceCostJson data2) {
        Map map2;
        block14: {
            int it;
            map2 = new LinkedHashMap();
            String essenceType = data2.getEssenceType();
            Integer n = data2.getEssenceFor1();
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                map2.put(1, new EssencePrice(it, essenceType));
            }
            Integer n2 = data2.getEssenceFor2();
            if (n2 != null) {
                it = ((Number)n2).intValue();
                boolean bl = false;
                map2.put(2, new EssencePrice(it, essenceType));
            }
            Integer n3 = data2.getEssenceFor3();
            if (n3 != null) {
                it = ((Number)n3).intValue();
                boolean bl = false;
                map2.put(3, new EssencePrice(it, essenceType));
            }
            Integer n4 = data2.getEssenceFor4();
            if (n4 != null) {
                it = ((Number)n4).intValue();
                boolean bl = false;
                map2.put(4, new EssencePrice(it, essenceType));
            }
            Integer n5 = data2.getEssenceFor5();
            if (n5 != null) {
                it = ((Number)n5).intValue();
                boolean bl = false;
                map2.put(5, new EssencePrice(it, essenceType));
            }
            Integer n6 = data2.getEssenceFor6();
            if (n6 != null) {
                it = ((Number)n6).intValue();
                boolean bl = false;
                map2.put(6, new EssencePrice(it, essenceType));
            }
            Integer n7 = data2.getEssenceFor7();
            if (n7 != null) {
                it = ((Number)n7).intValue();
                boolean bl = false;
                map2.put(7, new EssencePrice(it, essenceType));
            }
            Integer n8 = data2.getEssenceFor8();
            if (n8 != null) {
                it = ((Number)n8).intValue();
                boolean bl = false;
                map2.put(8, new EssencePrice(it, essenceType));
            }
            Integer n9 = data2.getEssenceFor9();
            if (n9 != null) {
                it = ((Number)n9).intValue();
                boolean bl = false;
                map2.put(9, new EssencePrice(it, essenceType));
            }
            Integer n10 = data2.getEssenceFor10();
            if (n10 != null) {
                it = ((Number)n10).intValue();
                boolean bl = false;
                map2.put(10, new EssencePrice(it, essenceType));
            }
            Integer n11 = data2.getEssenceFor11();
            if (n11 != null) {
                it = ((Number)n11).intValue();
                boolean bl = false;
                map2.put(11, new EssencePrice(it, essenceType));
            }
            Integer n12 = data2.getEssenceFor12();
            if (n12 != null) {
                it = ((Number)n12).intValue();
                boolean bl = false;
                map2.put(12, new EssencePrice(it, essenceType));
            }
            Integer n13 = data2.getEssenceFor13();
            if (n13 != null) {
                it = ((Number)n13).intValue();
                boolean bl = false;
                map2.put(13, new EssencePrice(it, essenceType));
            }
            Integer n14 = data2.getEssenceFor14();
            if (n14 != null) {
                it = ((Number)n14).intValue();
                boolean bl = false;
                map2.put(14, new EssencePrice(it, essenceType));
            }
            Integer n15 = data2.getEssenceFor15();
            if (n15 == null) break block14;
            it = ((Number)n15).intValue();
            boolean bl = false;
            map2.put(15, new EssencePrice(it, essenceType));
        }
        return map2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "", "", "essenceAmount", "", "essenceType", "<init>", "(ILjava/lang/String;)V", "other", "plus", "(Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;)Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "component1", "()I", "component2", "()Ljava/lang/String;", "copy", "(ILjava/lang/String;)Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "I", "getEssenceAmount", "Ljava/lang/String;", "getEssenceType", "1.8.9"})
    public static final class EssencePrice {
        private final int essenceAmount;
        @NotNull
        private final String essenceType;

        public EssencePrice(int essenceAmount, @NotNull String essenceType) {
            Intrinsics.checkNotNullParameter(essenceType, "essenceType");
            this.essenceAmount = essenceAmount;
            this.essenceType = essenceType;
        }

        public final int getEssenceAmount() {
            return this.essenceAmount;
        }

        @NotNull
        public final String getEssenceType() {
            return this.essenceType;
        }

        @NotNull
        public final EssencePrice plus(@NotNull EssencePrice other) {
            Intrinsics.checkNotNullParameter(other, "other");
            if (!Intrinsics.areEqual(other.essenceType, this.essenceType)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("essenceType", this.essenceType), TuplesKt.to("other.essenceType", other.essenceType)};
                ErrorManager.INSTANCE.skyHanniError("Trying to add non compatible essence prices!", pairArray);
                throw new KotlinNothingValueException();
            }
            return new EssencePrice(this.essenceAmount + other.essenceAmount, this.essenceType);
        }

        public final int component1() {
            return this.essenceAmount;
        }

        @NotNull
        public final String component2() {
            return this.essenceType;
        }

        @NotNull
        public final EssencePrice copy(int essenceAmount, @NotNull String essenceType) {
            Intrinsics.checkNotNullParameter(essenceType, "essenceType");
            return new EssencePrice(essenceAmount, essenceType);
        }

        public static /* synthetic */ EssencePrice copy$default(EssencePrice essencePrice, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = essencePrice.essenceAmount;
            }
            if ((n2 & 2) != 0) {
                string2 = essencePrice.essenceType;
            }
            return essencePrice.copy(n, string2);
        }

        @NotNull
        public String toString() {
            return "EssencePrice(essenceAmount=" + this.essenceAmount + ", essenceType=" + this.essenceType + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.essenceAmount);
            result2 = result2 * 31 + this.essenceType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EssencePrice)) {
                return false;
            }
            EssencePrice essencePrice = (EssencePrice)other;
            if (this.essenceAmount != essencePrice.essenceAmount) {
                return false;
            }
            return Intrinsics.areEqual(this.essenceType, essencePrice.essenceType);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J<\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u0010R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010\u0012R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010#\u001a\u0004\b$\u0010\u0014\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssenceUpgradePrice;", "", "Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "essencePrice", "", "coinPrice", "", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "itemPrice", "<init>", "(Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;Ljava/lang/Long;Ljava/util/Map;)V", "other", "plus", "(Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssenceUpgradePrice;)Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssenceUpgradePrice;", "component1", "()Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "component2", "()Ljava/lang/Long;", "component3", "()Ljava/util/Map;", "copy", "(Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;Ljava/lang/Long;Ljava/util/Map;)Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssenceUpgradePrice;", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/EssenceItemUtils$EssencePrice;", "getEssencePrice", "Ljava/lang/Long;", "getCoinPrice", "Ljava/util/Map;", "getItemPrice", "1.8.9"})
    public static final class EssenceUpgradePrice {
        @NotNull
        private final EssencePrice essencePrice;
        @Nullable
        private final Long coinPrice;
        @NotNull
        private final Map<NEUInternalName, Integer> itemPrice;

        public EssenceUpgradePrice(@NotNull EssencePrice essencePrice, @Nullable Long coinPrice, @NotNull Map<NEUInternalName, Integer> itemPrice) {
            Intrinsics.checkNotNullParameter(essencePrice, "essencePrice");
            Intrinsics.checkNotNullParameter(itemPrice, "itemPrice");
            this.essencePrice = essencePrice;
            this.coinPrice = coinPrice;
            this.itemPrice = itemPrice;
        }

        @NotNull
        public final EssencePrice getEssencePrice() {
            return this.essencePrice;
        }

        @Nullable
        public final Long getCoinPrice() {
            return this.coinPrice;
        }

        @NotNull
        public final Map<NEUInternalName, Integer> getItemPrice() {
            return this.itemPrice;
        }

        @NotNull
        public final EssenceUpgradePrice plus(@NotNull EssenceUpgradePrice other) {
            Intrinsics.checkNotNullParameter(other, "other");
            if (!Intrinsics.areEqual(other.essencePrice.getEssenceType(), this.essencePrice.getEssenceType())) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("essencePrice.essenceType", this.essencePrice.getEssenceType()), TuplesKt.to("other.essencePrice.essenceType", other.essencePrice.getEssenceType())};
                ErrorManager.INSTANCE.skyHanniError("Trying to add non compatible EssenceUpgradePrices!", pairArray);
                throw new KotlinNothingValueException();
            }
            Long l = this.coinPrice;
            long coinPrice = l != null ? l : 0L;
            Long l2 = other.coinPrice;
            long otherCoinPrice = l2 != null ? l2 : 0L;
            Map<NEUInternalName, Integer> map2 = MapsKt.toMutableMap(this.itemPrice);
            for (Map.Entry<NEUInternalName, Integer> entry : other.itemPrice.entrySet()) {
                CollectionUtils.INSTANCE.addOrPut(map2, entry.getKey(), ((Number)entry.getValue()).intValue());
            }
            return new EssenceUpgradePrice(this.essencePrice.plus(other.essencePrice), coinPrice + otherCoinPrice, map2);
        }

        @NotNull
        public final EssencePrice component1() {
            return this.essencePrice;
        }

        @Nullable
        public final Long component2() {
            return this.coinPrice;
        }

        @NotNull
        public final Map<NEUInternalName, Integer> component3() {
            return this.itemPrice;
        }

        @NotNull
        public final EssenceUpgradePrice copy(@NotNull EssencePrice essencePrice, @Nullable Long coinPrice, @NotNull Map<NEUInternalName, Integer> itemPrice) {
            Intrinsics.checkNotNullParameter(essencePrice, "essencePrice");
            Intrinsics.checkNotNullParameter(itemPrice, "itemPrice");
            return new EssenceUpgradePrice(essencePrice, coinPrice, itemPrice);
        }

        public static /* synthetic */ EssenceUpgradePrice copy$default(EssenceUpgradePrice essenceUpgradePrice, EssencePrice essencePrice, Long l, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                essencePrice = essenceUpgradePrice.essencePrice;
            }
            if ((n & 2) != 0) {
                l = essenceUpgradePrice.coinPrice;
            }
            if ((n & 4) != 0) {
                map2 = essenceUpgradePrice.itemPrice;
            }
            return essenceUpgradePrice.copy(essencePrice, l, map2);
        }

        @NotNull
        public String toString() {
            return "EssenceUpgradePrice(essencePrice=" + this.essencePrice + ", coinPrice=" + this.coinPrice + ", itemPrice=" + this.itemPrice + ')';
        }

        public int hashCode() {
            int result2 = this.essencePrice.hashCode();
            result2 = result2 * 31 + (this.coinPrice == null ? 0 : ((Object)this.coinPrice).hashCode());
            result2 = result2 * 31 + ((Object)this.itemPrice).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EssenceUpgradePrice)) {
                return false;
            }
            EssenceUpgradePrice essenceUpgradePrice = (EssenceUpgradePrice)other;
            if (!Intrinsics.areEqual(this.essencePrice, essenceUpgradePrice.essencePrice)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.coinPrice, essenceUpgradePrice.coinPrice)) {
                return false;
            }
            return Intrinsics.areEqual(this.itemPrice, essenceUpgradePrice.itemPrice);
        }
    }
}

