/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.SpecialColor;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\t\u001a\u00020\b*\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b*\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0010J%\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001e\u001a\u00020\b*\u00020\u00052\u0006\u0010\u001d\u001a\u00020\b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010 \u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001d\u001a\u00020\b\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010\nR\u0017\u0010$\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/utils/ColorUtils;", "", "<init>", "()V", "", "Ljava/awt/Color;", "toChromaColor", "(Ljava/lang/String;)Ljava/awt/Color;", "", "toChromaColorInt", "(Ljava/lang/String;)I", "", "getFirstColorCode", "(Ljava/lang/String;)Ljava/lang/Character;", "color", "getRed", "(I)I", "getGreen", "getBlue", "getAlpha", "start", "end", "", "percent", "blendRGB", "(Ljava/awt/Color;Ljava/awt/Color;D)Ljava/awt/Color;", "factor", "darker", "(Ljava/awt/Color;D)Ljava/awt/Color;", "alpha", "withAlpha", "(Ljava/awt/Color;I)I", "addAlpha", "(Ljava/awt/Color;I)Ljava/awt/Color;", "hex", "getColorFromHex", "TRANSPARENT_COLOR", "Ljava/awt/Color;", "getTRANSPARENT_COLOR", "()Ljava/awt/Color;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nColorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorUtils.kt\nat/hannibal2/skyhanni/utils/ColorUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();
    @NotNull
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);

    private ColorUtils() {
    }

    @NotNull
    public final Color toChromaColor(@NotNull String $this$toChromaColor) {
        Intrinsics.checkNotNullParameter($this$toChromaColor, "<this>");
        return new Color(this.toChromaColorInt($this$toChromaColor), true);
    }

    public final int toChromaColorInt(@NotNull String $this$toChromaColorInt) {
        Intrinsics.checkNotNullParameter($this$toChromaColorInt, "<this>");
        return SpecialColor.specialToChromaRGB($this$toChromaColorInt);
    }

    @Nullable
    public final Character getFirstColorCode(@NotNull String $this$getFirstColorCode) {
        String string2;
        Intrinsics.checkNotNullParameter($this$getFirstColorCode, "<this>");
        String it = string2 = $this$getFirstColorCode;
        boolean bl = false;
        Character c = StringsKt.firstOrNull(it);
        char c2 = '\u00a7';
        String string3 = c != null && c.charValue() == c2 ? string2 : null;
        return string3 != null ? StringsKt.getOrNull(string3, 1) : null;
    }

    public final int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public final int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public final int getBlue(int color) {
        return color & 0xFF;
    }

    public final int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    @NotNull
    public final Color blendRGB(@NotNull Color start2, @NotNull Color end, double percent) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        return new Color((int)((double)start2.getRed() * (1.0 - percent) + (double)end.getRed() * percent), (int)((double)start2.getGreen() * (1.0 - percent) + (double)end.getGreen() * percent), (int)((double)start2.getBlue() * (1.0 - percent) + (double)end.getBlue() * percent));
    }

    @NotNull
    public final Color darker(@NotNull Color $this$darker, double factor) {
        Intrinsics.checkNotNullParameter($this$darker, "<this>");
        return new Color(RangesKt.coerceIn((int)((double)$this$darker.getRed() * factor), 0, 255), RangesKt.coerceIn((int)((double)$this$darker.getGreen() * factor), 0, 255), RangesKt.coerceIn((int)((double)$this$darker.getBlue() * factor), 0, 255), $this$darker.getAlpha());
    }

    public static /* synthetic */ Color darker$default(ColorUtils colorUtils, Color color, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.7;
        }
        return colorUtils.darker(color, d);
    }

    @NotNull
    public final Color getTRANSPARENT_COLOR() {
        return TRANSPARENT_COLOR;
    }

    public final int withAlpha(@NotNull Color $this$withAlpha, int alpha) {
        Intrinsics.checkNotNullParameter($this$withAlpha, "<this>");
        return RangesKt.coerceIn(alpha, 0, 255) << 24 | $this$withAlpha.getRGB() & 0xFFFFFF;
    }

    @NotNull
    public final Color addAlpha(@NotNull Color $this$addAlpha, int alpha) {
        Intrinsics.checkNotNullParameter($this$addAlpha, "<this>");
        return new Color($this$addAlpha.getRed(), $this$addAlpha.getGreen(), $this$addAlpha.getBlue(), alpha);
    }

    public final int getColorFromHex(@NotNull String hex) {
        Object object;
        Intrinsics.checkNotNullParameter(hex, "hex");
        Object object2 = this;
        try {
            ColorUtils $this$getColorFromHex_u24lambda_u241 = object2;
            boolean bl = false;
            Integer n = Integer.decode(hex);
            Intrinsics.checkNotNullExpressionValue(n, "decode(...)");
            object = Result.constructor-impl(new Color(((Number)n).intValue()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        Color color = (Color)(Result.isFailure-impl(object2) ? null : object2);
        return color != null ? color.getRGB() : 0;
    }
}

