/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\t\u001a\u00020\b*\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\f\u001a\u00020\u000b*\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u000b*\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/utils/BlockUtils;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lnet/minecraft/block/Block;", "getBlockAt", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/block/Block;", "Lnet/minecraft/block/state/IBlockState;", "getBlockStateAt", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/block/state/IBlockState;", "", "isInLoadedChunk", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "Lnet/minecraft/util/BlockPos;", "position", "", "getTextureFromSkull", "(Lnet/minecraft/util/BlockPos;)Ljava/lang/String;", "isBabyCrop", "(Lnet/minecraft/block/state/IBlockState;)Z", "start", "direction", "", "distance", "rayTrace", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "getBlockLookingAt", "(D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "1.8.9"})
public final class BlockUtils {
    @NotNull
    public static final BlockUtils INSTANCE = new BlockUtils();

    private BlockUtils() {
    }

    @NotNull
    public final Block getBlockAt(@NotNull LorenzVec $this$getBlockAt) {
        Intrinsics.checkNotNullParameter($this$getBlockAt, "<this>");
        Block block = this.getBlockStateAt($this$getBlockAt).func_177230_c();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        return block;
    }

    @NotNull
    public final IBlockState getBlockStateAt(@NotNull LorenzVec $this$getBlockStateAt) {
        Intrinsics.checkNotNullParameter($this$getBlockStateAt, "<this>");
        IBlockState iBlockState = Minecraft.func_71410_x().field_71441_e.func_180495_p($this$getBlockStateAt.toBlockPos());
        Intrinsics.checkNotNullExpressionValue(iBlockState, "getBlockState(...)");
        return iBlockState;
    }

    public final boolean isInLoadedChunk(@NotNull LorenzVec $this$isInLoadedChunk) {
        Intrinsics.checkNotNullParameter($this$isInLoadedChunk, "<this>");
        return Minecraft.func_71410_x().field_71441_e.func_72863_F().func_177459_a($this$isInLoadedChunk.toBlockPos()).func_177410_o();
    }

    @Nullable
    public final String getTextureFromSkull(@Nullable BlockPos position) {
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(position);
        Intrinsics.checkNotNull(tileEntity, "null cannot be cast to non-null type net.minecraft.tileentity.TileEntitySkull");
        TileEntitySkull entity = (TileEntitySkull)tileEntity;
        NBTTagCompound serializeNBT = entity.serializeNBT();
        return serializeNBT.func_74775_l("Owner").func_74775_l("Properties").func_150295_c("textures", 10).func_150305_b(0).func_74779_i("Value");
    }

    public final boolean isBabyCrop(@NotNull IBlockState $this$isBabyCrop) {
        Intrinsics.checkNotNullParameter($this$isBabyCrop, "<this>");
        for (IProperty property : $this$isBabyCrop.func_177230_c().func_176194_O().func_177623_d()) {
            String name2 = property.func_177701_a();
            if (!Intrinsics.areEqual(name2, "age") || !(property instanceof PropertyInteger)) continue;
            Comparable comparable = $this$isBabyCrop.func_177229_b(property);
            Intrinsics.checkNotNull(comparable);
            int value = ((Number)((Object)comparable)).intValue();
            if (value != 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final LorenzVec rayTrace(@NotNull LorenzVec start2, @NotNull LorenzVec direction, double distance) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(direction, "direction");
        LorenzVec target = start2.plus(direction.normalize().times(distance));
        MovingObjectPosition result2 = Minecraft.func_71410_x().field_71441_e.func_72933_a(start2.toVec3(), target.toVec3());
        MovingObjectPosition movingObjectPosition = result2;
        return movingObjectPosition != null && (movingObjectPosition = movingObjectPosition.func_178782_a()) != null ? LorenzVecKt.toLorenzVec((BlockPos)movingObjectPosition) : null;
    }

    public static /* synthetic */ LorenzVec rayTrace$default(BlockUtils blockUtils, LorenzVec lorenzVec, LorenzVec lorenzVec2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 50.0;
        }
        return blockUtils.rayTrace(lorenzVec, lorenzVec2, d);
    }

    @Nullable
    public final LorenzVec getBlockLookingAt(double distance) {
        LorenzVec lorenzVec = LocationUtils.INSTANCE.playerEyeLocation();
        Vec3 vec3 = Minecraft.func_71410_x().field_71439_g.func_70040_Z();
        Intrinsics.checkNotNullExpressionValue(vec3, "getLookVec(...)");
        return this.rayTrace(lorenzVec, LorenzVecKt.toLorenzVec(vec3), distance);
    }

    public static /* synthetic */ LorenzVec getBlockLookingAt$default(BlockUtils blockUtils, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 10.0;
        }
        return blockUtils.getBlockLookingAt(d);
    }
}

