/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.command;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.PlaySoundEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R&\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000e0\u001c0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001c\u0010'\u001a\n $*\u0004\u0018\u00010#0#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R(\u0010.\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0(0,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/test/command/TrackSoundsCommand;", "", "<init>", "()V", "", "", "args", "", "command", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/PlaySoundEvent;", "onPlaySound", "(Lat/hannibal2/skyhanni/events/PlaySoundEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onWorldRender", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "cutOffTime", "J", "startTime", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lkotlin/Pair;", "Lkotlin/time/Duration;", "sounds", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "", "isRecording", "Z", "Lat/hannibal2/skyhanni/config/core/config/Position;", "kotlin.jvm.PlatformType", "getPosition", "()Lat/hannibal2/skyhanni/config/core/config/Position;", "position", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Ljava/util/List;", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "worldSounds", "Ljava/util/Map;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTrackSoundsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackSoundsCommand.kt\nat/hannibal2/skyhanni/test/command/TrackSoundsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,133:1\n967#2,7:134\n1557#2:141\n1628#2,3:142\n1557#2:145\n1628#2,3:146\n1485#2:149\n1510#2,3:150\n1513#2,3:160\n1485#2:163\n1510#2,3:164\n1513#2,3:174\n381#3,7:153\n381#3,7:167\n216#4,2:177\n*S KotlinDebug\n*F\n+ 1 TrackSoundsCommand.kt\nat/hannibal2/skyhanni/test/command/TrackSoundsCommand\n*L\n71#1:134,7\n73#1:141\n73#1:142,3\n76#1:145\n76#1:146,3\n76#1:149\n76#1:150,3\n76#1:160,3\n111#1:163\n111#1:164,3\n111#1:174,3\n76#1:153,7\n111#1:167,7\n111#1:177,2\n*E\n"})
public final class TrackSoundsCommand {
    @NotNull
    public static final TrackSoundsCommand INSTANCE = new TrackSoundsCommand();
    private static long cutOffTime = SimpleTimeMark.Companion.farPast();
    private static long startTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final ConcurrentLinkedDeque<Pair<Duration, PlaySoundEvent>> sounds = new ConcurrentLinkedDeque();
    private static boolean isRecording;
    @NotNull
    private static List<? extends Renderable> display;
    @NotNull
    private static Map<LorenzVec, ? extends List<PlaySoundEvent>> worldSounds;

    private TrackSoundsCommand() {
    }

    private final Position getPosition() {
        return SkyHanniMod.feature.dev.debug.trackSoundPosition;
    }

    public final void command(@NotNull String[] args2) {
        long l;
        Intrinsics.checkNotNullParameter(args2, "args");
        if (Intrinsics.areEqual(ArraysKt.firstOrNull(args2), "end")) {
            if (!isRecording) {
                ChatUtils.INSTANCE.userError("Nothing to end");
            } else {
                cutOffTime = SimpleTimeMark.Companion.now-uFjCsEo();
            }
            return;
        }
        if (isRecording) {
            ChatUtils.INSTANCE.userError("Still tracking sounds, wait for the other tracking to complete before starting a new one, or type \u00a7e/shtracksounds end \u00a7cto end it prematurely");
            return;
        }
        isRecording = true;
        sounds.clear();
        startTime = SimpleTimeMark.Companion.now-uFjCsEo();
        String string2 = ArraysKt.firstOrNull(args2);
        if (string2 != null) {
            int n = Integer.parseInt(string2);
            long it = DurationKt.toDuration(n, DurationUnit.SECONDS);
            boolean bl = false;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Now started tracking sounds for " + Duration.getInWholeSeconds-impl(it) + " Seconds", false, null, 6, null);
            l = SimpleTimeMark.Companion.fromNow-qeHQSLg(it);
        } else {
            TrackSoundsCommand $this$command_u24lambda_u241 = this;
            boolean bl = false;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Now started tracking sounds until manually ended", false, null, 6, null);
            l = SimpleTimeMark.Companion.farFuture-uFjCsEo();
        }
        cutOffTime = l;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        void $this$groupByTo$iv$iv;
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!isRecording) {
            return;
        }
        Iterable $this$takeWhile$iv = sounds;
        boolean $i$f$takeWhile = false;
        Iterable list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            Pair it2 = (Pair)item$iv;
            boolean bl = false;
            if (!(Duration.compareTo-LRDsOJo(Duration.minus-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(startTime), ((Duration)it2.getFirst()).unbox-impl()), DurationKt.toDuration(3, DurationUnit.SECONDS)) < 0)) break;
            ((ArrayList)list$iv).add(item$iv);
        }
        List soundsToDisplay = (List)list$iv;
        Iterable $this$map$iv = CollectionsKt.reversed(CollectionsKt.take(soundsToDisplay, 10));
        boolean $i$f$map = false;
        list$iv = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a73" + ((PlaySoundEvent)((Object)((Pair)it).getSecond())).getSoundName() + " \u00a78p:" + ((PlaySoundEvent)((Object)((Pair)it).getSecond())).getPitch() + " \u00a77v:" + ((PlaySoundEvent)((Object)((Pair)it).getSecond())).getVolume(), 0.0, null, null, null, 30, null));
        }
        display = (List)destination$iv$iv;
        $this$map$iv = soundsToDisplay;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PlaySoundEvent)((Object)((Pair)it).getSecond()));
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (PlaySoundEvent)((Object)element$iv$iv);
            boolean bl = false;
            LorenzVec key$iv$iv = ((PlaySoundEvent)((Object)it)).getLocation();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        worldSounds = destination$iv$iv;
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(cutOffTime), DurationKt.toDuration(0.1, DurationUnit.SECONDS)) <= 0) {
            return;
        }
        String string2 = CollectionsKt.joinToString$default(CollectionsKt.reversed((Iterable)sounds), "\n", null, null, 0, null, TrackSoundsCommand::onTick$lambda$6, 30, null);
        int counter = sounds.size();
        OSUtils.INSTANCE.copyToClipboard(string2);
        ChatUtils.chat$default(ChatUtils.INSTANCE, counter + " sounds copied into the clipboard!", false, null, 6, null);
        sounds.clear();
        isRecording = false;
    }

    @SubscribeEvent
    public final void onPlaySound(@NotNull PlaySoundEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (SimpleTimeMark.isInPast-impl(cutOffTime)) {
            return;
        }
        if (Intrinsics.areEqual(event.getSoundName(), "game.player.hurt") && event.getPitch() == 0.0f && event.getVolume() == 0.0f) {
            return;
        }
        if (Intrinsics.areEqual(event.getSoundName(), "")) {
            return;
        }
        event.getDistanceToPlayer();
        sounds.addFirst(TuplesKt.to(Duration.box-impl(SimpleTimeMark.passedSince-UwyO8pc(startTime)), event));
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (SimpleTimeMark.isInPast-impl(cutOffTime)) {
            return;
        }
        Position position = this.getPosition();
        Intrinsics.checkNotNullExpressionValue(position, "<get-position>(...)");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Track sound log", false, 10, null);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onWorldRender(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (SimpleTimeMark.isInPast-impl(cutOffTime)) {
            return;
        }
        for (Map.Entry<LorenzVec, ? extends List<PlaySoundEvent>> entry : worldSounds.entrySet()) {
            String volumeColor;
            LorenzVec key = entry.getKey();
            List<PlaySoundEvent> value = entry.getValue();
            if (value.size() != 1) {
                void $this$forEach$iv;
                void $this$groupByTo$iv$iv;
                RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, key, "\u00a7e" + value.size() + " sounds", 0.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                double offset = 0.0;
                offset = -0.2;
                Object $this$groupBy$iv = value;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    PlaySoundEvent it = (PlaySoundEvent)((Object)element$iv$iv);
                    boolean bl = false;
                    String key$iv$iv = it.getSoundName();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry2 = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    String soundName = (String)entry2.getKey();
                    List sounds = (List)entry2.getValue();
                    RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, key.up(offset), "\u00a77\u00a7l" + soundName + " \u00a77(\u00a7e" + sounds.size() + "\u00a77)", 0.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                    offset -= 0.2;
                }
                continue;
            }
            PlaySoundEvent sound2 = CollectionsKt.first(value);
            float f = sound2.getVolume();
            double d = f;
            Intrinsics.checkNotNullExpressionValue(((0.0 <= d ? d <= 0.25 : false) ? ChatFormatting.RED : ((0.25 <= (d = (double)f) ? d <= 0.5 : false) ? ChatFormatting.GOLD : ChatFormatting.GREEN)).toString(), "toString(...)");
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, key, "\u00a77\u00a7l" + sound2.getSoundName(), 0.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, key.up(-0.2), "\u00a77P: \u00a7e" + NumberUtil.INSTANCE.roundTo(sound2.getPitch(), 2) + " \u00a77V: " + volumeColor + NumberUtil.INSTANCE.roundTo(sound2.getVolume(), 2), 0.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    private static final CharSequence onTick$lambda$6(Pair it) {
        return "Time: " + Duration.getInWholeMilliseconds-impl(((Duration)it.getFirst()).unbox-impl()) + "  " + it.getSecond();
    }

    static {
        display = CollectionsKt.emptyList();
        worldSounds = MapsKt.emptyMap();
    }
}

