/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer.enderman;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.slayer.endermen.EndermanBeaconConfig;
import at.hannibal2.skyhanni.config.features.slayer.endermen.EndermanConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.ServerBlockChangeEvent;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010*\u001a\n '*\u0004\u0018\u00010&0&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001c\u0010.\u001a\n '*\u0004\u0018\u00010+0+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\t0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000203028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001a\u00106\u001a\b\u0012\u0004\u0012\u000203028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00105R\"\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u000208078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010<\u001a\u00020;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010?\u001a\u00020>8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lat/hannibal2/skyhanni/features/slayer/enderman/EndermanSlayerFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "event", "", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lnet/minecraft/entity/monster/EntityEnderman;", "enderman", "", "hasBeaconInHand", "(Lnet/minecraft/entity/monster/EntityEnderman;)Z", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "b", "canSee", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "showBeacon", "()Z", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onWorldRender", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "drawNukekubiSkulls", "drawFlyingBeacon", "drawSittingBeacon", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;", "onBlockChange", "(Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanConfig;", "config", "Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanBeaconConfig;", "getBeaconConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanBeaconConfig;", "beaconConfig", "", "endermenWithBeacons", "Ljava/util/List;", "", "Lnet/minecraft/entity/item/EntityArmorStand;", "flyingBeacons", "Ljava/util/Set;", "nukekubiSkulls", "", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "sittingBeacon", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "", "NUKEKUBI_SKULL_TEXTURE", "Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEndermanSlayerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndermanSlayerFeatures.kt\nat/hannibal2/skyhanni/features/slayer/enderman/EndermanSlayerFeatures\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n12511#2,2:264\n1557#3:266\n1628#3,3:267\n1863#3,2:278\n535#4:270\n520#4,6:271\n1#5:277\n*S KotlinDebug\n*F\n+ 1 EndermanSlayerFeatures.kt\nat/hannibal2/skyhanni/features/slayer/enderman/EndermanSlayerFeatures\n*L\n84#1:264,2\n108#1:266\n108#1:267,3\n211#1:278,2\n208#1:270\n208#1:271,6\n*E\n"})
public final class EndermanSlayerFeatures {
    @NotNull
    public static final EndermanSlayerFeatures INSTANCE = new EndermanSlayerFeatures();
    @NotNull
    private static final List<EntityEnderman> endermenWithBeacons = new ArrayList();
    @NotNull
    private static final Set<EntityArmorStand> flyingBeacons = new LinkedHashSet();
    @NotNull
    private static final Set<EntityArmorStand> nukekubiSkulls = new LinkedHashSet();
    @NotNull
    private static Map<LorenzVec, SimpleTimeMark> sittingBeacon = MapsKt.emptyMap();
    @NotNull
    private static final LorenzLogger logger = new LorenzLogger("slayer/enderman");
    @NotNull
    private static final String NUKEKUBI_SKULL_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWIwNzU5NGUyZGYyNzM5MjFhNzdjMTAxZDBiZmRmYTExMTVhYmVkNWI5YjIwMjllYjQ5NmNlYmE5YmRiYjRiMyJ9fX0=";

    private EndermanSlayerFeatures() {
    }

    private final EndermanConfig getConfig() {
        return SkyHanniMod.feature.slayer.endermen;
    }

    private final EndermanBeaconConfig getBeaconConfig() {
        return this.getConfig().beacon;
    }

    @SubscribeEvent
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.THE_END)) {
            return;
        }
        Object entity = event.getEntity();
        if (CollectionsKt.contains((Iterable)endermenWithBeacons, entity) || CollectionsKt.contains((Iterable)flyingBeacons, entity)) {
            return;
        }
        if (entity instanceof EntityEnderman && this.showBeacon() && this.hasBeaconInHand((EntityEnderman)entity) && EntityUtils.INSTANCE.canBeSeen((Entity)entity, 15.0)) {
            endermenWithBeacons.add((EntityEnderman)entity);
            logger.log("Added enderman with beacon at " + LorenzVecKt.getLorenzVec(entity));
        }
        if (entity instanceof EntityArmorStand) {
            if (this.showBeacon()) {
                ItemStack itemStack2 = ((EntityArmorStand)entity).func_70035_c()[4];
                if (itemStack2 == null) {
                    return;
                }
                ItemStack stack = itemStack2;
                if (Intrinsics.areEqual(ItemUtils.INSTANCE.getName(stack), "Beacon") && EntityUtils.INSTANCE.canBeSeen((Entity)entity, 15.0)) {
                    flyingBeacons.add((EntityArmorStand)entity);
                    EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                    String string2 = this.getBeaconConfig().beaconColor;
                    Intrinsics.checkNotNullExpressionValue(string2, "beaconColor");
                    RenderLivingEntityHelper.INSTANCE.setEntityColor(entityLivingBase, ColorUtils.INSTANCE.withAlpha(ColorUtils.INSTANCE.toChromaColor(string2), 1), EndermanSlayerFeatures::onCheckRender$lambda$0);
                    if (this.getBeaconConfig().showWarning) {
                        LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a74Beacon", DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
                    }
                    logger.log("Added flying beacons at " + LorenzVecKt.getLorenzVec(entity));
                }
            }
            if (this.getConfig().highlightNukekebi) {
                boolean bl;
                block11: {
                    ItemStack[] itemStackArray = ((EntityArmorStand)entity).func_70035_c();
                    Intrinsics.checkNotNullExpressionValue(itemStackArray, "getInventory(...)");
                    Object[] $this$any$iv = itemStackArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        ItemStack itemStack3 = it;
                        if (!Intrinsics.areEqual(itemStack3 != null ? ItemUtils.INSTANCE.getSkullTexture(itemStack3) : null, NUKEKUBI_SKULL_TEXTURE)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
                if (bl && !nukekubiSkulls.contains(entity)) {
                    nukekubiSkulls.add((EntityArmorStand)entity);
                    RenderLivingEntityHelper.INSTANCE.setEntityColor((EntityLivingBase)entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.GOLD.toColor(), 1), EndermanSlayerFeatures::onCheckRender$lambda$2);
                    logger.log("Added Nukekubi skulls at " + LorenzVecKt.getLorenzVec(entity));
                }
            }
        }
    }

    private final boolean hasBeaconInHand(EntityEnderman enderman) {
        IBlockState iBlockState = EntityUtils.INSTANCE.getBlockInHand(enderman);
        return Intrinsics.areEqual(iBlockState != null ? iBlockState.func_177230_c() : null, Blocks.field_150461_bJ);
    }

    private final boolean canSee(LorenzVec b) {
        return LocationUtils.canBeSeen$default(LocationUtils.INSTANCE, b, 15.0, null, 2, null);
    }

    private final boolean showBeacon() {
        return this.getBeaconConfig().highlightBeacon || this.getBeaconConfig().showWarning || this.getBeaconConfig().showLine;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onWorldRender(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.THE_END)) {
            return;
        }
        if (this.getBeaconConfig().highlightBeacon) {
            void $this$mapTo$iv$iv;
            endermenWithBeacons.removeIf(arg_0 -> EndermanSlayerFeatures.onWorldRender$lambda$4(EndermanSlayerFeatures::onWorldRender$lambda$3, arg_0));
            Iterable $this$map$iv = endermenWithBeacons;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityEnderman entityEnderman = (EntityEnderman)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LorenzVecKt.getLorenzVec((Entity)it).add(-0.5, 0.2, -0.5));
            }
            for (LorenzVec location : (List)destination$iv$iv) {
                String string2 = this.getBeaconConfig().beaconColor;
                Intrinsics.checkNotNullExpressionValue(string2, "beaconColor");
                RenderUtils.drawColor$default(RenderUtils.INSTANCE, event, location, ColorUtils.INSTANCE.toChromaColor(string2), false, 0.5f, 4, null);
            }
        }
        this.drawSittingBeacon(event);
        this.drawFlyingBeacon(event);
        this.drawNukekubiSkulls(event);
    }

    private final void drawNukekubiSkulls(LorenzRenderWorldEvent event) {
        for (EntityArmorStand skull : nukekubiSkulls) {
            LorenzVec skullLocation;
            if (skull.field_70128_L) continue;
            if (this.getConfig().highlightNukekebi) {
                RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, LorenzVecKt.getLorenzVec((Entity)skull).add(-0.5, 1.5, -0.5), "\u00a76Nukekubi Skull", 1.6, 0.0f, 0.0, 0.0, false, false, 20, 184, null);
            }
            if (!this.getConfig().drawLineToNukekebi || LocationUtils.INSTANCE.distanceToPlayer(skullLocation = RenderUtils.INSTANCE.exactLocation(event, (Entity)skull)) > 20.0 || !LocationUtils.canBeSeen$default(LocationUtils.INSTANCE, skullLocation, 0.0, null, 3, null)) continue;
            RenderUtils.INSTANCE.draw3DLine(event, RenderUtils.INSTANCE.exactPlayerEyeLocation(event), LorenzVec.add$default(skullLocation, 0, 1, 0, 5, null), LorenzColor.GOLD.toColor(), 3, true);
        }
    }

    private final void drawFlyingBeacon(LorenzRenderWorldEvent event) {
        for (EntityArmorStand beacon : flyingBeacons) {
            LorenzVec beaconLocation;
            if (beacon.field_70128_L) continue;
            if (this.getBeaconConfig().highlightBeacon) {
                beaconLocation = RenderUtils.INSTANCE.exactLocation(event, (Entity)beacon);
                RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(beaconLocation, 0, 1, 0, 5, null), "\u00a74Beacon", 1.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            }
            if (!this.getBeaconConfig().showLine) continue;
            beaconLocation = RenderUtils.INSTANCE.exactLocation(event, (Entity)beacon);
            LorenzVec lorenzVec = RenderUtils.INSTANCE.exactPlayerEyeLocation(event);
            LorenzVec lorenzVec2 = beaconLocation.add(0.5, 1.0, 0.5);
            String string2 = this.getBeaconConfig().lineColor;
            Intrinsics.checkNotNullExpressionValue(string2, "lineColor");
            RenderUtils.INSTANCE.draw3DLine(event, lorenzVec, lorenzVec2, ColorUtils.INSTANCE.toChromaColor(string2), this.getBeaconConfig().lineWidth, true);
        }
    }

    private final void drawSittingBeacon(LorenzRenderWorldEvent event) {
        for (Map.Entry<LorenzVec, SimpleTimeMark> entry : sittingBeacon.entrySet()) {
            LorenzVec location = entry.getKey();
            long time = entry.getValue().unbox-impl();
            if (LocationUtils.INSTANCE.distanceToPlayer(location) > 20.0) continue;
            if (this.getBeaconConfig().showLine) {
                LorenzVec lorenzVec = RenderUtils.INSTANCE.exactPlayerEyeLocation(event);
                LorenzVec lorenzVec2 = location.add(0.5, 1.0, 0.5);
                String string2 = this.getBeaconConfig().lineColor;
                Intrinsics.checkNotNullExpressionValue(string2, "lineColor");
                RenderUtils.INSTANCE.draw3DLine(event, lorenzVec, lorenzVec2, ColorUtils.INSTANCE.toChromaColor(string2), this.getBeaconConfig().lineWidth, true);
            }
            if (!this.getBeaconConfig().highlightBeacon) continue;
            long duration = Duration.minus-LRDsOJo(DurationKt.toDuration(5, DurationUnit.SECONDS), SimpleTimeMark.passedSince-UwyO8pc(time));
            String durationFormat = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, duration, null, true, false, 0, false, 29, null);
            String string3 = this.getBeaconConfig().beaconColor;
            Intrinsics.checkNotNullExpressionValue(string3, "beaconColor");
            RenderUtils.drawColor$default(RenderUtils.INSTANCE, event, location, ColorUtils.INSTANCE.toChromaColor(string3), false, 1.0f, 4, null);
            String string4 = this.getBeaconConfig().beaconColor;
            Intrinsics.checkNotNullExpressionValue(string4, "beaconColor");
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, ColorUtils.INSTANCE.toChromaColor(string4), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(location, 0, 1, 0, 5, null), "\u00a74Beacon \u00a7b" + durationFormat, 1.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.THE_END)) {
            return;
        }
        CollectionsKt.removeAll((Iterable)nukekubiSkulls, EndermanSlayerFeatures::onSecondPassed$lambda$6);
        CollectionsKt.removeAll((Iterable)flyingBeacons, EndermanSlayerFeatures::onSecondPassed$lambda$7);
        Map<LorenzVec, SimpleTimeMark> $this$filter$iv = sittingBeacon;
        boolean $i$f$filter = false;
        Map<LorenzVec, SimpleTimeMark> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(((SimpleTimeMark)it.getValue()).unbox-impl()), DurationKt.toDuration(7, DurationUnit.SECONDS)) > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map toRemove = destination$iv$iv;
        if (!toRemove.isEmpty()) {
            sittingBeacon = CollectionUtils.INSTANCE.editCopy(sittingBeacon, arg_0 -> EndermanSlayerFeatures.onSecondPassed$lambda$10(toRemove, arg_0));
        }
    }

    @SubscribeEvent
    public final void onBlockChange(@NotNull ServerBlockChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.THE_END)) {
            return;
        }
        if (!this.showBeacon()) {
            return;
        }
        LorenzVec location = event.getLocation();
        if (Intrinsics.areEqual(event.getNew(), "beacon")) {
            Object v0;
            block7: {
                Iterable iterable = flyingBeacons;
                for (Object t : iterable) {
                    EntityArmorStand it = (EntityArmorStand)t;
                    boolean bl = false;
                    if (!(location.distance(LorenzVecKt.getLorenzVec((Entity)it)) < 3.0)) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            EntityArmorStand armorStand = v0;
            if (armorStand != null) {
                flyingBeacons.remove(armorStand);
                RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)armorStand);
                sittingBeacon = CollectionUtils.INSTANCE.editCopy(sittingBeacon, arg_0 -> EndermanSlayerFeatures.onBlockChange$lambda$12(location, arg_0));
                logger.log("Replaced flying beacon with sitting beacon at " + location);
            }
        } else if (sittingBeacon.containsKey(location)) {
            logger.log("Removed sitting beacon " + location);
            sittingBeacon = CollectionUtils.INSTANCE.editCopy(sittingBeacon, arg_0 -> EndermanSlayerFeatures.onBlockChange$lambda$13(location, arg_0));
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        endermenWithBeacons.clear();
        flyingBeacons.clear();
        nukekubiSkulls.clear();
        sittingBeacon = MapsKt.emptyMap();
        logger.log("Reset everything (world change)");
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.highlightBeacon", "slayer.endermen.endermanBeaconConfig.highlightBeacon", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.beaconColor", "slayer.endermen.endermanBeaconConfig.beaconColor", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.showWarning", "slayer.endermen.endermanBeaconConfig.showWarning", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.showLine", "slayer.endermen.endermanBeaconConfig.showLine", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.lneColor", "slayer.endermen.endermanBeaconConfig.lineColor", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.lineWidth", "slayer.endermen.endermanBeaconConfig.lineWidth", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanHighlightNukekebi", "slayer.endermen.highlightNukekebi", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 9, "slayer.enderman.endermanBeaconConfig", "slayer.endermen.beacon", null, 8, null);
    }

    private static final boolean onCheckRender$lambda$0() {
        return EndermanSlayerFeatures.INSTANCE.getBeaconConfig().highlightBeacon;
    }

    private static final boolean onCheckRender$lambda$2() {
        return EndermanSlayerFeatures.INSTANCE.getConfig().highlightNukekebi;
    }

    private static final boolean onWorldRender$lambda$3(EntityEnderman it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.field_70128_L || !INSTANCE.hasBeaconInHand(it);
    }

    private static final boolean onWorldRender$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onSecondPassed$lambda$6(EntityArmorStand it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.field_70128_L) {
            RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)it);
        }
        return it.field_70128_L;
    }

    private static final boolean onSecondPassed$lambda$7(EntityArmorStand it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.field_70128_L) {
            RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)it);
        }
        return it.field_70128_L;
    }

    private static final Unit onSecondPassed$lambda$10(Map $toRemove, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($toRemove, "$toRemove");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Iterable $this$forEach$iv = $toRemove.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LorenzVec it = (LorenzVec)element$iv;
            boolean bl = false;
            $this$editCopy.remove(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onBlockChange$lambda$12(LorenzVec $location, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.put($location, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
        return Unit.INSTANCE;
    }

    private static final Unit onBlockChange$lambda$13(LorenzVec $location, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.remove($location);
        return Unit.INSTANCE;
    }
}

