/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.slayer.RngMeterDisplayConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.SlayerAPI;
import at.hannibal2.skyhanni.data.jsonobjects.repo.neu.NeuRNGScore;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.NeuRepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.SlayerChangeEvent;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0019\u0010\u001c\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\u0003J\u0017\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0012\u00a2\u0006\u0004\b&\u0010\u0014J\u0017\u0010(\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020'H\u0007\u00a2\u0006\u0004\b(\u0010)J\r\u0010+\u001a\u00020*\u00a2\u0006\u0004\b+\u0010,R\u001c\u00101\u001a\n .*\u0004\u0018\u00010-0-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001b\u0010:\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u001b\u0010=\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u00107\u001a\u0004\b<\u00109R\u001b\u0010@\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u00107\u001a\u0004\b?\u00109R\u001b\u0010C\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u00107\u001a\u0004\bB\u00109R\u001b\u0010F\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u00107\u001a\u0004\bE\u00109R\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020#0G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010K\u001a\u00020J8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR:\u0010O\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020N0M0M8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010T\u00a8\u0006U"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerRngMeterDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/SlayerChangeEvent;", "onSlayerChange", "(Lat/hannibal2/skyhanni/events/SlayerChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$SlayerRngMeterStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$SlayerRngMeterStorage;", "", "getCurrentSlayer", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "readRngMeterInventory", "readSlayerInventory", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "setNewGoal", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)V", "Lat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent;", "onNeuRepoReload", "(Lat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent;)V", "update", "text", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "makeLink", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawDisplay", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/slayer/RngMeterDisplayConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/RngMeterDisplayConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "inventoryNamePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getInventoryNamePattern", "()Ljava/util/regex/Pattern;", "inventoryNamePattern", "slayerInventoryNamePattern$delegate", "getSlayerInventoryNamePattern", "slayerInventoryNamePattern", "updatePattern$delegate", "getUpdatePattern", "updatePattern", "changedItemPattern$delegate", "getChangedItemPattern", "changedItemPattern", "bookFormatPattern$delegate", "getBookFormatPattern", "bookFormatPattern", "", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastItemDroppedTime", "J", "", "", "rngScore", "Ljava/util/Map;", "getRngScore", "()Ljava/util/Map;", "setRngScore", "(Ljava/util/Map;)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSlayerRngMeterDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerRngMeterDisplay.kt\nat/hannibal2/skyhanni/features/slayer/SlayerRngMeterDisplay\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 NeuRepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent\n+ 7 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,257:1\n8#2:258\n8#2:260\n8#2:269\n8#2:275\n1#3:259\n1#3:261\n1#3:270\n1#3:271\n1#3:276\n381#4,7:262\n1755#5,3:272\n20#6,4:277\n24#6,6:282\n16#7:281\n*S KotlinDebug\n*F\n+ 1 SlayerRngMeterDisplay.kt\nat/hannibal2/skyhanni/features/slayer/SlayerRngMeterDisplay\n*L\n93#1:258\n98#1:260\n153#1:269\n173#1:275\n93#1:259\n98#1:261\n153#1:270\n173#1:276\n137#1:262,7\n160#1:272,3\n200#1:277,4\n200#1:282,6\n200#1:281\n*E\n"})
public final class SlayerRngMeterDisplay {
    @NotNull
    public static final SlayerRngMeterDisplay INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern inventoryNamePattern$delegate;
    @NotNull
    private static final RepoPattern slayerInventoryNamePattern$delegate;
    @NotNull
    private static final RepoPattern updatePattern$delegate;
    @NotNull
    private static final RepoPattern changedItemPattern$delegate;
    @NotNull
    private static final RepoPattern bookFormatPattern$delegate;
    @NotNull
    private static List<? extends Renderable> display;
    private static long lastItemDroppedTime;
    @NotNull
    private static Map<String, ? extends Map<NEUInternalName, Long>> rngScore;

    private SlayerRngMeterDisplay() {
    }

    private final RngMeterDisplayConfig getConfig() {
        return SkyHanniMod.feature.slayer.rngMeterDisplay;
    }

    private final Pattern getInventoryNamePattern() {
        return (Pattern)inventoryNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getSlayerInventoryNamePattern() {
        return (Pattern)slayerInventoryNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getUpdatePattern() {
        return (Pattern)updatePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getChangedItemPattern() {
        return (Pattern)changedItemPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getBookFormatPattern() {
        return (Pattern)bookFormatPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    @NotNull
    public final Map<String, Map<NEUInternalName, Long>> getRngScore() {
        return rngScore;
    }

    public final void setRngScore(@NotNull Map<String, ? extends Map<NEUInternalName, Long>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        rngScore = map2;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!SimpleTimeMark.isFarPast-impl(lastItemDroppedTime)) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastItemDroppedTime), DurationKt.toDuration(4, DurationUnit.SECONDS)) > 0) {
                lastItemDroppedTime = SimpleTimeMark.Companion.farPast();
                this.update();
            }
        }
    }

    @SubscribeEvent
    public final void onSlayerChange(@NotNull SlayerChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Long l;
        void $this$matchMatcher$iv;
        Object it$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (this.getConfig().hideChat && SlayerAPI.INSTANCE.isInCorrectArea()) {
            void $this$matchMatcher$iv2;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this.getChangedItemPattern();
            String text$iv = event.getMessage();
            boolean $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv2.matcher(text$iv);
            boolean bl = false;
            if (((Matcher)it$iv).matches()) {
                Intrinsics.checkNotNull(it$iv);
                Object $this$onChat_u24lambda_u240 = it$iv;
                boolean bl2 = false;
                event.setBlockedReason("slayer_rng_meter");
            }
        }
        RegexUtils $i$f$matchMatcher = RegexUtils.INSTANCE;
        it$iv = this.getUpdatePattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher2 = false;
        Matcher it$iv2 = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv2.matches()) {
            Intrinsics.checkNotNull(it$iv2);
            Matcher $this$onChat_u24lambda_u241 = it$iv2;
            boolean bl3 = false;
            String string2 = $this$onChat_u24lambda_u241.group("exp");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            l = NumberUtil.INSTANCE.formatLong(string2);
        } else {
            l = null;
        }
        if (l == null) {
            return;
        }
        long currentMeter = l;
        ProfileSpecificStorage.SlayerRngMeterStorage slayerRngMeterStorage = this.getStorage();
        if (slayerRngMeterStorage == null) {
            return;
        }
        ProfileSpecificStorage.SlayerRngMeterStorage storage2 = slayerRngMeterStorage;
        long old = storage2.currentMeter;
        storage2.currentMeter = currentMeter;
        if (old != -1L) {
            boolean hasItemSelected;
            String item = storage2.itemGoal;
            boolean bl4 = hasItemSelected = !Intrinsics.areEqual(item, "") && !Intrinsics.areEqual(item, "?");
            if (!hasItemSelected && this.getConfig().warnEmpty) {
                ChatUtils.INSTANCE.userError("No Slayer RNG Meter Item selected!");
                LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7cNo RNG Meter Item!", DurationKt.toDuration(3, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
            }
            boolean blockChat = this.getConfig().hideChat && hasItemSelected;
            long diff = currentMeter - old;
            if (diff > 0L) {
                storage2.gainPerBoss = diff;
            } else {
                storage2.currentMeter = 0L;
                blockChat = false;
                String from = NumberUtil.INSTANCE.addSeparators(old);
                String to = NumberUtil.INSTANCE.addSeparators(storage2.goalNeeded);
                double rawPercentage = (double)old / (double)storage2.goalNeeded;
                if (rawPercentage > 1.0) {
                    rawPercentage = 1.0;
                }
                String percentage = LorenzUtils.INSTANCE.formatPercentage(rawPercentage);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7dRNG Meter \u00a77dropped at \u00a7e" + percentage + " \u00a77XP (" + from + '/' + to + "\u00a77)", false, null, 6, null);
                lastItemDroppedTime = SimpleTimeMark.Companion.now-uFjCsEo();
            }
            if (blockChat) {
                event.setBlockedReason("slayer_rng_meter");
            }
        }
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    private final ProfileSpecificStorage.SlayerRngMeterStorage getStorage() {
        ProfileSpecificStorage.SlayerRngMeterStorage slayerRngMeterStorage;
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (object != null && (object = ((ProfileSpecificStorage)object).slayerRngMeter) != null) {
            Object object2;
            void $this$getOrPut$iv;
            Object object3 = object;
            String key$iv = this.getCurrentSlayer();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ProfileSpecificStorage.SlayerRngMeterStorage answer$iv = new ProfileSpecificStorage.SlayerRngMeterStorage();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            slayerRngMeterStorage = (ProfileSpecificStorage.SlayerRngMeterStorage)object2;
        } else {
            slayerRngMeterStorage = null;
        }
        return slayerRngMeterStorage;
    }

    private final String getCurrentSlayer() {
        return StringUtils.removeColor$default(StringUtils.INSTANCE, StringUtils.INSTANCE.removeWordsAtEnd(SlayerAPI.INSTANCE.getLatestSlayerCategory(), 1), false, 1, null);
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        this.readRngMeterInventory(event);
        this.readSlayerInventory(event);
    }

    /*
     * WARNING - void declaration
     */
    private final void readRngMeterInventory(InventoryFullyOpenedEvent event) {
        ItemStack internalName;
        Object v2;
        block9: {
            String string2;
            void $this$matchMatcher$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Object object = this.getInventoryNamePattern();
            String text$iv = event.getInventoryName();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$readRngMeterInventory_u24lambda_u243 = it$iv;
                boolean bl2 = false;
                string2 = $this$readRngMeterInventory_u24lambda_u243.group("name");
            } else {
                string2 = null;
            }
            if (string2 == null) {
                return;
            }
            String name2 = string2;
            if (!Intrinsics.areEqual(name2, this.getCurrentSlayer())) {
                return;
            }
            object = event.getInventoryItems().values();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                boolean bl3;
                Object t;
                block8: {
                    t = iterator2.next();
                    ItemStack item = (ItemStack)t;
                    boolean bl4 = false;
                    Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(item);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            if (!StringsKt.contains$default((CharSequence)it, "\u00a7a\u00a7lSELECTED", false, 2, null)) continue;
                            bl3 = true;
                            break block8;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                v2 = t;
                break block9;
            }
            v2 = null;
        }
        ItemStack itemStack2 = internalName = (ItemStack)v2;
        this.setNewGoal(itemStack2 != null ? ItemUtils.INSTANCE.getInternalName(itemStack2) : null);
    }

    private final void readSlayerInventory(InventoryFullyOpenedEvent event) {
        String string2;
        if (!RegexUtils.INSTANCE.matches(this.getSlayerInventoryNamePattern(), event.getInventoryName())) {
            return;
        }
        ItemStack itemStack2 = event.getInventoryItems().get(35);
        if (itemStack2 == null) {
            return;
        }
        ItemStack item = itemStack2;
        List<String> lore = ItemUtils.INSTANCE.getLore(item);
        String string3 = CollectionsKt.firstOrNull(lore);
        if (string3 == null || (string3 = StringUtils.removeColor$default(StringUtils.INSTANCE, string3, false, 1, null)) == null) {
            return;
        }
        String name2 = string3;
        if (!Intrinsics.areEqual(name2, this.getCurrentSlayer())) {
            return;
        }
        String string4 = CollectionUtils.nextAfter$default(CollectionUtils.INSTANCE, lore, "\u00a77Selected Drop", 0, 2, null);
        if (string4 == null) {
            return;
        }
        String rawName = string4;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getBookFormatPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(rawName);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$readSlayerInventory_u24lambda_u246 = it$iv;
            boolean bl2 = false;
            string2 = $this$readSlayerInventory_u24lambda_u246.group("name");
        } else {
            string2 = null;
        }
        String string5 = string2;
        if (string2 == null) {
            string5 = rawName;
        }
        String itemName = string5;
        NEUInternalName internalName = NEUInternalName.Companion.fromItemName(itemName);
        this.setNewGoal(internalName);
    }

    private final void setNewGoal(NEUInternalName internalName) {
        ProfileSpecificStorage.SlayerRngMeterStorage slayerRngMeterStorage = this.getStorage();
        if (slayerRngMeterStorage == null) {
            return;
        }
        ProfileSpecificStorage.SlayerRngMeterStorage storage2 = slayerRngMeterStorage;
        if (internalName == null) {
            storage2.itemGoal = "";
            storage2.goalNeeded = -1L;
        } else {
            storage2.itemGoal = ItemUtils.INSTANCE.getItemName(internalName);
            Map<NEUInternalName, Long> map2 = rngScore.get(this.getCurrentSlayer());
            if (map2 == null || (map2 = map2.get(internalName)) == null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("internalName", internalName), TuplesKt.to("currentSlayer", this.getCurrentSlayer()), TuplesKt.to("repo", rngScore)};
                ErrorManager.INSTANCE.skyHanniError("RNG Meter goal setting failed", pairArray);
                throw new KotlinNothingValueException();
            }
            storage2.goalNeeded = (Long)((Object)map2);
        }
        this.update();
    }

    @SubscribeEvent
    public final void onNeuRepoReload(@NotNull NeuRepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String file$iv = "rngscore";
        Gson gson$iv = ConfigManager.Companion.getGson();
        boolean $i$f$readConstant = false;
        JsonObject jsonObject2 = event.getConstant(file$iv);
        if (jsonObject2 == null) {
            ErrorManager.INSTANCE.skyHanniError(file$iv + " failed to load from neu repo!", new Pair[0]);
            throw new KotlinNothingValueException();
        }
        JsonObject data$iv = jsonObject2;
        try {
            Gson $this$fromJson$iv$iv = gson$iv;
            boolean $i$f$fromJson = false;
            Object object2 = $this$fromJson$iv$iv.fromJson((JsonElement)data$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(NeuRNGScore.class)));
            Intrinsics.checkNotNullExpressionValue(object2, "fromJson(...)");
            object = object2;
        }
        catch (JsonSyntaxException e$iv) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("data", data$iv)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e$iv, file$iv + " failed to read from neu repo!", pairArray, false, false, false, 56, null);
            throw e$iv;
        }
        rngScore = ((NeuRNGScore)object).getSlayer();
    }

    private final void update() {
        display = CollectionsKt.listOf(this.makeLink(this.drawDisplay()));
    }

    private final Renderable makeLink(String text) {
        return Renderable.Companion.clickAndHover$default(Renderable.Companion, text, CollectionsKt.listOf("\u00a7eClick to open RNG Meter Inventory."), false, SlayerRngMeterDisplay::makeLink$lambda$7, null, 20, null);
    }

    @NotNull
    public final String drawDisplay() {
        ProfileSpecificStorage.SlayerRngMeterStorage slayerRngMeterStorage = this.getStorage();
        if (slayerRngMeterStorage == null) {
            return "";
        }
        ProfileSpecificStorage.SlayerRngMeterStorage storage2 = slayerRngMeterStorage;
        String it = SlayerAPI.INSTANCE.getLatestSlayerCategory();
        boolean bl = false;
        boolean bl2 = StringsKt.endsWith$default(it, " I", false, 2, null) || StringsKt.endsWith$default(it, " II", false, 2, null);
        if (bl2) {
            return "";
        }
        String latestSlayerCategory = SlayerAPI.INSTANCE.getLatestSlayerCategory();
        StringsKt.endsWith$default(latestSlayerCategory, " I", false, 2, null);
        ProfileSpecificStorage.SlayerRngMeterStorage $this$drawDisplay_u24lambda_u249 = storage2;
        boolean bl3 = false;
        if (Intrinsics.areEqual($this$drawDisplay_u24lambda_u249.itemGoal, "?")) {
            return "\u00a7cOpen RNG Meter Inventory!";
        }
        if (Intrinsics.areEqual($this$drawDisplay_u24lambda_u249.itemGoal, "")) {
            return !SimpleTimeMark.isFarPast-impl(lastItemDroppedTime) ? "\u00a7a\u00a7lRNG Item dropped!" : "\u00a7eNo RNG Item selected!";
        }
        if ($this$drawDisplay_u24lambda_u249.currentMeter == -1L || $this$drawDisplay_u24lambda_u249.gainPerBoss == -1L) {
            return "\u00a7cKill the slayer boss 2 times!";
        }
        long missing = $this$drawDisplay_u24lambda_u249.goalNeeded - $this$drawDisplay_u24lambda_u249.currentMeter + $this$drawDisplay_u24lambda_u249.gainPerBoss;
        double timesMissing = (double)missing / (double)$this$drawDisplay_u24lambda_u249.gainPerBoss;
        if (timesMissing < 1.0) {
            timesMissing = 1.0;
        }
        timesMissing = Math.ceil(timesMissing);
        return $this$drawDisplay_u24lambda_u249.itemGoal + " \u00a77in \u00a7e" + NumberUtil.INSTANCE.addSeparators((int)timesMissing) + " \u00a77bosses!";
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!SlayerAPI.INSTANCE.isInCorrectArea()) {
            return;
        }
        if (!SlayerAPI.INSTANCE.hasActiveSlayerQuest()) {
            return;
        }
        Position position = this.getConfig().pos;
        Intrinsics.checkNotNullExpressionValue(position, "pos");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "RNG Meter Display", false, 10, null);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    private static final Unit makeLink$lambda$7() {
        SlayerType slayerType = SlayerAPI.INSTANCE.getActiveSlayer();
        HypixelCommands.INSTANCE.showRng("slayer", slayerType != null ? slayerType.getRngName() : null);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SlayerRngMeterDisplay.class, "inventoryNamePattern", "getInventoryNamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SlayerRngMeterDisplay.class, "slayerInventoryNamePattern", "getSlayerInventoryNamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SlayerRngMeterDisplay.class, "updatePattern", "getUpdatePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SlayerRngMeterDisplay.class, "changedItemPattern", "getChangedItemPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SlayerRngMeterDisplay.class, "bookFormatPattern", "getBookFormatPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerRngMeterDisplay();
        patternGroup = RepoPattern.Companion.group("slayer.rngmeter");
        inventoryNamePattern$delegate = patternGroup.pattern("inventoryname", "(?<name>.*) RNG Meter");
        slayerInventoryNamePattern$delegate = patternGroup.pattern("inventoryname.slayer", "Slayer");
        updatePattern$delegate = patternGroup.pattern("update", " {3}\u00a7dRNG Meter \u00a7f- \u00a7d(?<exp>.*) Stored XP");
        changedItemPattern$delegate = patternGroup.pattern("changeditem", "\u00a7aYou set your \u00a7r.* RNG Meter \u00a7r\u00a7ato drop \u00a7r.*\u00a7a!");
        bookFormatPattern$delegate = patternGroup.pattern("book.format", "\u00a7aEnchanted Book \\((?<name>.*)\u00a7a\\)");
        display = CollectionsKt.emptyList();
        lastItemDroppedTime = SimpleTimeMark.Companion.farPast();
        rngScore = MapsKt.emptyMap();
    }
}

