/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedCache;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/features/slayer/HideMobNames;", "", "<init>", "()V", "", "bossName", "", "addMobToHide", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Specials$Pre;", "Lnet/minecraft/entity/EntityLivingBase;", "event", "onRenderLiving", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Specials$Pre;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "name", "", "shouldNameBeHidden", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "", "lastMobName", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "", "mobNamesHidden", "Ljava/util/List;", "Ljava/util/regex/Pattern;", "patterns", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHideMobNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HideMobNames.kt\nat/hannibal2/skyhanni/features/slayer/HideMobNames\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n8#2:101\n1#3:102\n*S KotlinDebug\n*F\n+ 1 HideMobNames.kt\nat/hannibal2/skyhanni/features/slayer/HideMobNames\n*L\n88#1:101\n88#1:102\n*E\n"})
public final class HideMobNames {
    @NotNull
    public static final HideMobNames INSTANCE = new HideMobNames();
    @NotNull
    private static final TimeLimitedCache<Integer, String> lastMobName = new TimeLimitedCache(DurationKt.toDuration(2, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static final List<Integer> mobNamesHidden = new ArrayList();
    @NotNull
    private static final List<Pattern> patterns = new ArrayList();

    private HideMobNames() {
    }

    private final void addMobToHide(String bossName) {
        String string2 = "\u00a78\\[\u00a77Lv\\d+\u00a78] \u00a7c" + bossName + "\u00a7r \u00a7[ae](?<min>.+)\u00a7f/\u00a7a(?<max>.+)\u00a7c\u2764";
        int n = 0;
        Pattern pattern = Pattern.compile(string2, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        patterns.add(pattern);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onRenderLiving(@NotNull SkyHanniRenderEntityEvent.Specials.Pre<EntityLivingBase> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!SkyHanniMod.feature.slayer.hideMobNames) {
            return;
        }
        Object entity = event.getEntity();
        if (!(entity instanceof EntityArmorStand)) {
            return;
        }
        if (!entity.func_145818_k_()) {
            return;
        }
        String name2 = ((EntityArmorStand)entity).func_70005_c_();
        int id = ((EntityArmorStand)entity).func_145782_y();
        if (Intrinsics.areEqual(lastMobName.getOrNull(id), name2)) {
            if (mobNamesHidden.contains(id)) {
                event.cancel();
            }
            return;
        }
        Integer n = id;
        Intrinsics.checkNotNull(name2);
        lastMobName.set(n, name2);
        mobNamesHidden.remove((Object)id);
        if (this.shouldNameBeHidden(name2)) {
            event.cancel();
            mobNamesHidden.add(id);
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastMobName.clear();
        mobNamesHidden.clear();
    }

    private final boolean shouldNameBeHidden(String name2) {
        for (Pattern pattern : patterns) {
            String max;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = pattern;
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(name2);
            boolean bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$shouldNameBeHidden_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String min = $this$shouldNameBeHidden_u24lambda_u240.group("min");
            if (!Intrinsics.areEqual(min, max = $this$shouldNameBeHidden_u24lambda_u240.group("max")) && !Intrinsics.areEqual(min, "0")) continue;
            return true;
        }
        return false;
    }

    static {
        INSTANCE.addMobToHide("Zombie");
        INSTANCE.addMobToHide("Zombie Villager");
        INSTANCE.addMobToHide("Crypt Ghoul");
        INSTANCE.addMobToHide("Dasher Spider");
        INSTANCE.addMobToHide("Weaver Spider");
        INSTANCE.addMobToHide("Splitter Spider");
        INSTANCE.addMobToHide("Voracious Spider");
        INSTANCE.addMobToHide("Silverfish");
        INSTANCE.addMobToHide("Wolf");
        INSTANCE.addMobToHide("\u00a7bHowling Spirit");
        INSTANCE.addMobToHide("\u00a7bPack Spirit");
        INSTANCE.addMobToHide("Enderman");
        INSTANCE.addMobToHide("Voidling Fanatic");
        INSTANCE.addMobToHide("Blaze");
        INSTANCE.addMobToHide("Mutated Blaze");
        INSTANCE.addMobToHide("Bezal");
        INSTANCE.addMobToHide("Smoldering Blaze");
    }
}

