/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.everywhere;

import at.hannibal2.skyhanni.config.features.rift.EnigmaSoulConfig;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.jsonobjects.repo.EnigmaPosition;
import at.hannibal2.skyhanni.data.jsonobjects.repo.EnigmaSoulsJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.render.gui.ReplaceItemEvent;
import at.hannibal2.skyhanni.features.rift.RiftAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003J\r\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!R\u001c\u0010&\u001a\n #*\u0004\u0018\u00010\"0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010'\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020*0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020*0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00100R\u0016\u00102\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010(R\u001b\u00108\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107\u00a8\u00069"}, d2={"Lat/hannibal2/skyhanni/features/rift/everywhere/EnigmaSoulWaypoints;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;", "event", "", "replaceItem", "(Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "hideClosestSoul", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/rift/EnigmaSoulConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/EnigmaSoulConfig;", "config", "inInventory", "Z", "", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "soulLocations", "Ljava/util/Map;", "", "trackedSouls", "Ljava/util/List;", "inventoryUnfound", "adding", "Lnet/minecraft/item/ItemStack;", "item$delegate", "Lkotlin/Lazy;", "getItem", "()Lnet/minecraft/item/ItemStack;", "item", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEnigmaSoulWaypoints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnigmaSoulWaypoints.kt\nat/hannibal2/skyhanni/features/rift/everywhere/EnigmaSoulWaypoints\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,196:1\n12#2,7:197\n*S KotlinDebug\n*F\n+ 1 EnigmaSoulWaypoints.kt\nat/hannibal2/skyhanni/features/rift/everywhere/EnigmaSoulWaypoints\n*L\n158#1:197,7\n*E\n"})
public final class EnigmaSoulWaypoints {
    @NotNull
    public static final EnigmaSoulWaypoints INSTANCE = new EnigmaSoulWaypoints();
    private static boolean inInventory;
    @NotNull
    private static Map<String, LorenzVec> soulLocations;
    @NotNull
    private static final List<String> trackedSouls;
    @NotNull
    private static final List<String> inventoryUnfound;
    private static boolean adding;
    @NotNull
    private static final Lazy item$delegate;

    private EnigmaSoulWaypoints() {
    }

    private final EnigmaSoulConfig getConfig() {
        return RiftAPI.INSTANCE.getConfig().enigmaSoulWaypoints;
    }

    private final ItemStack getItem() {
        Lazy lazy = item$delegate;
        return (ItemStack)lazy.getValue();
    }

    @SubscribeEvent
    public final void replaceItem(@NotNull ReplaceItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (inventoryUnfound.isEmpty()) {
            return;
        }
        if (event.getInventory() instanceof ContainerLocalMenu && inInventory && event.getSlot() == 31) {
            event.replace(this.getItem());
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
        if (!StringsKt.contains$default((CharSequence)event.getInventoryName(), "Enigma Souls", false, 2, null)) {
            return;
        }
        inInventory = true;
        for (ItemStack stack : event.getInventoryItems().values()) {
            String string2 = stack.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            String[] stringArray = new String[]{"Enigma: "};
            List split = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
            if (split.size() != 2 || !Intrinsics.areEqual(CollectionsKt.last(ItemUtils.INSTANCE.getLore(stack)), "\u00a78\u2716 Not completed yet!")) continue;
            inventoryUnfound.add((String)CollectionsKt.last(split));
        }
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
        inventoryUnfound.clear();
        adding = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!inInventory || !this.isEnabled()) {
            return;
        }
        if (event.getSlotId() == 31 && !((Collection)inventoryUnfound).isEmpty()) {
            event.makePickblock();
            if (adding) {
                trackedSouls.addAll((Collection<String>)inventoryUnfound);
                adding = false;
            } else {
                trackedSouls.removeAll((Collection)inventoryUnfound);
                adding = true;
            }
        }
        Slot slot = event.getSlot();
        if ((slot != null ? slot.func_75211_c() : null) == null) {
            return;
        }
        String string2 = event.getSlot().func_75211_c().func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        String[] stringArray = new String[]{"Enigma: "};
        List split = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
        if (split.size() != 2) {
            return;
        }
        event.makePickblock();
        String name2 = (String)CollectionsKt.last(split);
        if (!soulLocations.containsKey(name2)) {
            return;
        }
        if (!trackedSouls.contains(name2)) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a75Tracking the " + name2 + " Enigma Soul!", false, "\u00a75", 2, null);
            if (this.getConfig().showPathFinder) {
                LorenzVec lorenzVec = soulLocations.get(name2);
                if (lorenzVec != null) {
                    LorenzVec it = lorenzVec;
                    boolean bl = false;
                    String string3 = EnigmaSoulWaypoints.INSTANCE.getConfig().color;
                    Intrinsics.checkNotNullExpressionValue(string3, "color");
                    IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, it, ColorUtils.INSTANCE.toChromaColor(string3), null, false, EnigmaSoulWaypoints::onSlotClick$lambda$2$lambda$1, 12, null);
                }
            }
            trackedSouls.add(name2);
        } else {
            trackedSouls.remove(name2);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a75No longer tracking the " + name2 + " Enigma Soul!", false, "\u00a75", 2, null);
            IslandGraphs.INSTANCE.stop();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled() || !inInventory) {
            return;
        }
        if (!(event.getGui() instanceof GuiChest)) {
            return;
        }
        GuiContainer guiChest = event.getGui();
        Container container = guiChest.field_147002_h;
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest chest = (ContainerChest)container;
        for (Map.Entry<Slot, ItemStack> entry : InventoryUtils.INSTANCE.getAllItems(chest).entrySet()) {
            Slot slot = entry.getKey();
            ItemStack stack = entry.getValue();
            for (String soul : trackedSouls) {
                String string2 = stack.func_82833_r();
                Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
                if (!StringsKt.contains$default((CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null), soul, false, 2, null)) continue;
                RenderUtils.INSTANCE.highlight(slot, LorenzColor.DARK_PURPLE);
            }
        }
        if (!adding) {
            Object e = chest.field_75151_b.get(31);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            RenderUtils.INSTANCE.highlight((Slot)e, LorenzColor.DARK_PURPLE);
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        for (String soul : trackedSouls) {
            LorenzVec it;
            if (soulLocations.get(soul) == null) continue;
            boolean bl = false;
            String string2 = EnigmaSoulWaypoints.INSTANCE.getConfig().color;
            Intrinsics.checkNotNullExpressionValue(string2, "color");
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, it, ColorUtils.INSTANCE.toChromaColor(string2), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(it, 0, 1, 0, 5, null), "\u00a75" + StringsKt.removeSuffix(soul, (CharSequence)" Soul") + " Soul", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Map<String, LorenzVec> map2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "EnigmaSouls";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            object = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, EnigmaSoulsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        EnigmaSoulsJson data2 = object;
        Map<String, List<EnigmaPosition>> areas = data2.getAreas();
        Map<String, LorenzVec> $this$onRepoReload_u24lambda_u244 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        object = areas.entrySet().iterator();
        while (object.hasNext()) {
            List locations = (List)((Map.Entry)object.next()).getValue();
            for (EnigmaPosition location : locations) {
                $this$onRepoReload_u24lambda_u244.put(location.getName(), location.getPosition());
            }
        }
        soulLocations = MapsKt.build(map2);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        String message = ((Object)StringsKt.trim((CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null))).toString();
        if (Intrinsics.areEqual(message, "You have already found that Enigma Soul!") || Intrinsics.areEqual(message, "SOUL! You unlocked an Enigma Soul!")) {
            this.hideClosestSoul();
        }
    }

    private final void hideClosestSoul() {
        String closestSoul = "";
        double closestDistance = 8.0;
        for (Map.Entry<String, LorenzVec> entry : soulLocations.entrySet()) {
            String soul = entry.getKey();
            LorenzVec location = entry.getValue();
            if (!(LocationUtils.INSTANCE.distanceToPlayer(location) < closestDistance)) continue;
            closestSoul = soul;
            closestDistance = LocationUtils.INSTANCE.distanceToPlayer(location);
        }
        if (trackedSouls.contains(closestSoul)) {
            trackedSouls.remove(closestSoul);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a75Found the " + closestSoul + " Enigma Soul!", false, "\u00a75", 2, null);
        }
    }

    public final boolean isEnabled() {
        return RiftAPI.INSTANCE.inRift() && this.getConfig().enabled;
    }

    private static final ItemStack item_delegate$lambda$0() {
        ItemStack neuItem = NEUItems.INSTANCE.getItemStack(NEUInternalName.Companion.asInternalName("SKYBLOCK_ENIGMA_SOUL"));
        Item item = neuItem.func_77973_b();
        Intrinsics.checkNotNullExpressionValue(item, "getItem(...)");
        String[] stringArray = new String[]{"\u00a77Click here to toggle", "\u00a77the waypoints for each", "\u00a77missing souls on this page"};
        return ItemUtils.INSTANCE.createItemStack(item, "\u00a75Toggle Missing", stringArray);
    }

    private static final boolean onSlotClick$lambda$2$lambda$1() {
        return EnigmaSoulWaypoints.INSTANCE.getConfig().showPathFinder;
    }

    static {
        soulLocations = MapsKt.emptyMap();
        trackedSouls = new ArrayList();
        inventoryUnfound = new ArrayList();
        adding = true;
        item$delegate = LazyKt.lazy(EnigmaSoulWaypoints::item_delegate$lambda$0);
    }
}

