/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.area.livingcave;

import at.hannibal2.skyhanni.config.features.rift.area.livingcave.LivingCaveLivingMetalConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.ServerBlockChangeEvent;
import at.hannibal2.skyhanni.events.TitleReceivedEvent;
import at.hannibal2.skyhanni.features.rift.RiftAPI;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u001c\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/rift/area/livingcave/LivingCaveLivingMetalHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "event", "", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;", "onBlockChange", "(Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/TitleReceivedEvent;", "onTitleReceived", "(Lat/hannibal2/skyhanni/events/TitleReceivedEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/rift/area/livingcave/LivingCaveLivingMetalConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/area/livingcave/LivingCaveLivingMetalConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastClicked", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lkotlin/Pair;", "pair", "Lkotlin/Pair;", "", "startTime", "J", "1.8.9"})
public final class LivingCaveLivingMetalHelper {
    @NotNull
    public static final LivingCaveLivingMetalHelper INSTANCE = new LivingCaveLivingMetalHelper();
    @Nullable
    private static LorenzVec lastClicked;
    @Nullable
    private static Pair<LorenzVec, LorenzVec> pair;
    private static long startTime;

    private LivingCaveLivingMetalHelper() {
    }

    private final LivingCaveLivingMetalConfig getConfig() {
        return RiftAPI.INSTANCE.getConfig().area.livingCave.livingCaveLivingMetalConfig;
    }

    @SubscribeEvent
    public final void onBlockClick(@NotNull BlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() == ClickType.LEFT_CLICK) {
            String string2 = event.getGetBlockState().func_177230_c().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String name2 = string2;
            if (StringsKt.contains$default((CharSequence)name2, "lapis_ore", false, 2, null)) {
                lastClicked = event.getPosition();
            }
        }
    }

    @SubscribeEvent
    public final void onBlockChange(@NotNull ServerBlockChangeEvent event) {
        block7: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            LorenzVec location = event.getLocation();
            if (LocationUtils.INSTANCE.distanceToPlayer(location) >= 7.0) {
                return;
            }
            if (Intrinsics.areEqual(event.getOld(), "lapis_ore")) {
                Pair<LorenzVec, LorenzVec> pair = LivingCaveLivingMetalHelper.pair;
                if (pair != null) {
                    it = pair;
                    boolean bl = false;
                    if (Intrinsics.areEqual(((Pair)it).getSecond(), location)) {
                        LivingCaveLivingMetalHelper.pair = null;
                    }
                }
            }
            if (!Intrinsics.areEqual(event.getNew(), "lapis_ore")) {
                return;
            }
            LorenzVec lorenzVec = lastClicked;
            if (lorenzVec == null) break block7;
            it = lorenzVec;
            boolean bl = false;
            double distance = location.distance((LorenzVec)it);
            if (distance < 2.0) {
                pair = new Pair<Object, LorenzVec>(it, location);
                startTime = System.currentTimeMillis();
            }
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        LorenzVec lorenzVec;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Pair<LorenzVec, LorenzVec> pair = LivingCaveLivingMetalHelper.pair;
        if (pair == null) {
            return;
        }
        Pair<LorenzVec, LorenzVec> pair2 = pair;
        LorenzVec a = pair2.component1();
        LorenzVec b = pair2.component2();
        if (System.currentTimeMillis() > startTime + (long)5000) {
            return;
        }
        int maxTime = 500;
        long diff = startTime + (long)maxTime - System.currentTimeMillis();
        if (diff > 0L) {
            double percentage = (double)diff / (double)maxTime;
            lorenzVec = a.slope(b, 1.0 - percentage);
        } else {
            lorenzVec = b;
        }
        LorenzVec location = lorenzVec;
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.AQUA.toColor(), LocationUtils.INSTANCE.distanceToPlayer(location) < 10.0, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
    }

    @SubscribeEvent
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            if (!this.getConfig().hideParticles) {
                return;
            }
            Pair<LorenzVec, LorenzVec> pair = LivingCaveLivingMetalHelper.pair;
            if (pair == null) break block3;
            Pair<LorenzVec, LorenzVec> it = pair;
            boolean bl = false;
            if (it.getSecond().distance(event.getLocation()) < 3.0) {
                event.cancel();
            }
        }
    }

    @SubscribeEvent
    public final void onTitleReceived(@NotNull TitleReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)event.getTitle(), "Living Metal", false, 2, null)) {
            pair = null;
        }
    }

    public final boolean isEnabled() {
        return RiftAPI.INSTANCE.inRift() && (RiftAPI.INSTANCE.inLivingCave() || RiftAPI.INSTANCE.inLivingStillness()) && this.getConfig().enabled;
    }
}

