/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.crimsonisle.ReputationHelperConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.CrimsonIsleReputationJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SackChangeEvent;
import at.hannibal2.skyhanni.features.nether.reputationhelper.FactionType;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.DailyQuestHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.QuestLoader;
import at.hannibal2.skyhanni.features.nether.reputationhelper.kuudra.DailyKuudraBossHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss.DailyMiniBossHelper;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TabListData;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0014\u0010\rJ\u000f\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\b\u00a2\u0006\u0004\b \u0010\u0016J\r\u0010!\u001a\u00020\b\u00a2\u0006\u0004\b!\u0010\u0016J\u001d\u0010&\u001a\u0004\u0018\u00010%2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u001a\u00a2\u0006\u0004\b(\u0010\u001cR\u001c\u0010-\u001a\n **\u0004\u0018\u00010)0)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0017\u00104\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0017\u00109\u001a\u0002088\u0006\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\"\u0010>\u001a\u00020=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0016\u0010E\u001a\u00020D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\"\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\"0\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0016\u0010I\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR\"\u0010K\u001a\u00020\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010J\u001a\u0004\bL\u0010\u001c\"\u0004\bM\u0010NR\u001b\u0010T\u001a\u00020O8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\u00a8\u0006U"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper;", "", "Lat/hannibal2/skyhanni/SkyHanniMod;", "skyHanniMod", "<init>", "(Lat/hannibal2/skyhanni/SkyHanniMod;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/SackChangeEvent;", "onSackChange", "(Lat/hannibal2/skyhanni/events/SackChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "onConfigInit", "updateRender", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "isHotkeyHeld", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "update", "reset", "", "", "locations", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "readLocationData", "(Ljava/util/List;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "showLocations", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "config", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper;", "questHelper", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper;", "getQuestHelper", "()Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper;", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper;", "miniBossHelper", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper;", "getMiniBossHelper", "()Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper;", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper;", "kuudraBossHelper", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper;", "getKuudraBossHelper", "()Lat/hannibal2/skyhanni/features/nether/reputationhelper/kuudra/DailyKuudraBossHelper;", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/FactionType;", "factionType", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/FactionType;", "getFactionType", "()Lat/hannibal2/skyhanni/features/nether/reputationhelper/FactionType;", "setFactionType", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/FactionType;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUpdate", "J", "display", "Ljava/util/List;", "dirty", "Z", "tabListQuestsMissing", "getTabListQuestsMissing", "setTabListQuestsMissing", "(Z)V", "Ljava/util/regex/Pattern;", "tabListQuestPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTabListQuestPattern", "()Ljava/util/regex/Pattern;", "tabListQuestPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCrimsonIsleReputationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrimsonIsleReputationHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n12#2,7:220\n774#3:227\n865#3,2:228\n*S KotlinDebug\n*F\n+ 1 CrimsonIsleReputationHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/CrimsonIsleReputationHelper\n*L\n70#1:220,7\n110#1:227\n110#1:228,2\n*E\n"})
public final class CrimsonIsleReputationHelper {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final DailyQuestHelper questHelper;
    @NotNull
    private final DailyMiniBossHelper miniBossHelper;
    @NotNull
    private final DailyKuudraBossHelper kuudraBossHelper;
    @NotNull
    private FactionType factionType;
    private long lastUpdate;
    @NotNull
    private List<? extends List<? extends Object>> display;
    private boolean dirty;
    private boolean tabListQuestsMissing;
    @NotNull
    private final RepoPattern tabListQuestPattern$delegate;

    public CrimsonIsleReputationHelper(@NotNull SkyHanniMod skyHanniMod) {
        Intrinsics.checkNotNullParameter(skyHanniMod, "skyHanniMod");
        this.questHelper = new DailyQuestHelper(this);
        this.miniBossHelper = new DailyMiniBossHelper(this);
        this.kuudraBossHelper = new DailyKuudraBossHelper(this);
        this.factionType = FactionType.NONE;
        this.lastUpdate = SimpleTimeMark.Companion.farPast();
        this.display = CollectionsKt.emptyList();
        this.dirty = true;
        this.tabListQuestPattern$delegate = RepoPattern.Companion.pattern("crimson.reputation.tablist", " \u00a7r\u00a7[cdea].*");
        skyHanniMod.loadModule(this.questHelper);
        skyHanniMod.loadModule(this.miniBossHelper);
        skyHanniMod.loadModule(this.kuudraBossHelper);
    }

    private final ReputationHelperConfig getConfig() {
        return SkyHanniMod.feature.crimsonIsle.reputationHelper;
    }

    @NotNull
    public final DailyQuestHelper getQuestHelper() {
        return this.questHelper;
    }

    @NotNull
    public final DailyMiniBossHelper getMiniBossHelper() {
        return this.miniBossHelper;
    }

    @NotNull
    public final DailyKuudraBossHelper getKuudraBossHelper() {
        return this.kuudraBossHelper;
    }

    @NotNull
    public final FactionType getFactionType() {
        return this.factionType;
    }

    public final void setFactionType(@NotNull FactionType factionType) {
        Intrinsics.checkNotNullParameter((Object)factionType, "<set-?>");
        this.factionType = factionType;
    }

    public final boolean getTabListQuestsMissing() {
        return this.tabListQuestsMissing;
    }

    public final void setTabListQuestsMissing(boolean bl) {
        this.tabListQuestsMissing = bl;
    }

    @NotNull
    public final Pattern getTabListQuestPattern() {
        return (Pattern)this.tabListQuestPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        CrimsonIsleReputationJson crimsonIsleReputationJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "CrimsonIsleReputation";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            crimsonIsleReputationJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, CrimsonIsleReputationJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        CrimsonIsleReputationJson data2 = crimsonIsleReputationJson;
        this.miniBossHelper.onRepoReload(data2.getMINIBOSS());
        this.kuudraBossHelper.onRepoReload(data2.getKUUDRA());
        QuestLoader.Companion.getQuests().clear();
        QuestLoader.Companion.loadQuests(data2.getFISHING(), "FISHING");
        QuestLoader.Companion.loadQuests(data2.getRESCUE(), "RESCUE");
        QuestLoader.Companion.loadQuests(data2.getFETCH(), "FETCH");
        QuestLoader.Companion.loadQuests(data2.getDOJO(), "DOJO");
        this.update();
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
            if (object == null || (object = ((ProfileSpecificStorage)object).crimsonIsle) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.miniBossHelper.loadData((ProfileSpecificStorage.CrimsonIsleStorage)it);
            this.kuudraBossHelper.loadData((ProfileSpecificStorage.CrimsonIsleStorage)it);
            this.questHelper.load((ProfileSpecificStorage.CrimsonIsleStorage)it);
        }
    }

    @SubscribeEvent
    public final void onSackChange(@NotNull SackChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.dirty = true;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE)) {
            return;
        }
        if (!((Boolean)this.getConfig().enabled.get()).booleanValue()) {
            return;
        }
        if (!this.dirty && this.display.isEmpty()) {
            this.dirty = true;
        }
        if (this.dirty) {
            this.dirty = false;
            this.updateRender();
        }
        if (LorenzTickEvent.repeatSeconds$default(event, 3, 0, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = TabListData.INSTANCE.getTabList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, "Reputation:", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            for (String line : list) {
                this.factionType = StringsKt.contains$default((CharSequence)line, "Mage", false, 2, null) ? FactionType.MAGE : (StringsKt.contains$default((CharSequence)line, "Barbarian", false, 2, null) ? FactionType.BARBARIAN : FactionType.NONE);
            }
        }
    }

    @SubscribeEvent
    public final void onConfigInit(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<Boolean> property = this.getConfig().hideComplete;
        Intrinsics.checkNotNullExpressionValue(property, "hideComplete");
        ConditionalUtils.INSTANCE.afterChange(property, arg_0 -> CrimsonIsleReputationHelper.onConfigInit$lambda$2(this, arg_0));
    }

    private final void updateRender() {
        List newList = new ArrayList();
        if (this.factionType == FactionType.NONE) {
            return;
        }
        CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a7e\u00a7lReputation Helper");
        if (this.tabListQuestsMissing) {
            CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a7cFaction Quests Widget not found!");
            CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a77Open \u00a7e/tab \u00a77and enable it!");
        } else {
            this.questHelper.render(newList);
            this.miniBossHelper.render(newList);
            this.kuudraBossHelper.render(newList);
        }
        this.display = newList;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!((Boolean)this.getConfig().enabled.get()).booleanValue()) {
            return;
        }
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE)) {
            return;
        }
        if (this.getConfig().useHotkey && !this.isHotkeyHeld()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderStringsAndItems$default(RenderUtils.INSTANCE, position, this.display, 0, 0.0, "Crimson Isle Reputation Helper", 6, null);
    }

    public final boolean isHotkeyHeld() {
        GuiScreen it = Minecraft.func_71410_x().field_71462_r;
        boolean bl = false;
        boolean isAllowedGui = it == null || it instanceof GuiInventory;
        if (!isAllowedGui) {
            return false;
        }
        if (NEUItems.INSTANCE.neuHasFocus()) {
            return false;
        }
        return KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().hotkey);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.crimsonIsleReputationHelper", "crimsonIsle.reputationHelper.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.reputationHelperUseHotkey", "crimsonIsle.reputationHelper.useHotkey", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.reputationHelperHotkey", "crimsonIsle.reputationHelper.hotkey", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.crimsonIsleReputationHelperPos", "crimsonIsle.reputationHelper.position", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.crimsonIsleReputationShowLocation", "crimsonIsle.reputationHelper.showLocation", null, 8, null);
        event.transform(15, "crimsonIsle.reputationHelper.showLocation", CrimsonIsleReputationHelper::onConfigFix$lambda$4);
    }

    public final void update() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (object != null && (object = ((ProfileSpecificStorage)object).crimsonIsle) != null) {
            Object it = object;
            boolean bl = false;
            this.questHelper.saveConfig((ProfileSpecificStorage.CrimsonIsleStorage)it);
            this.miniBossHelper.saveConfig((ProfileSpecificStorage.CrimsonIsleStorage)it);
            this.kuudraBossHelper.saveConfig((ProfileSpecificStorage.CrimsonIsleStorage)it);
        }
        this.dirty = true;
    }

    public final void reset() {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Reset Reputation Helper.", false, null, 6, null);
        this.questHelper.reset();
        this.miniBossHelper.reset();
        this.kuudraBossHelper.reset();
        this.update();
    }

    @Nullable
    public final LorenzVec readLocationData(@NotNull List<Double> locations) {
        Intrinsics.checkNotNullParameter(locations, "locations");
        if (locations.isEmpty()) {
            return null;
        }
        double x = ((Number)locations.get(0)).doubleValue();
        double y = ((Number)locations.get(1)).doubleValue();
        double z = ((Number)locations.get(2)).doubleValue();
        return new LorenzVec(x, y, z).add(-1, 0, -1);
    }

    public final boolean showLocations() {
        boolean bl;
        ReputationHelperConfig.ShowLocationEntry showLocationEntry = this.getConfig().showLocation;
        switch (showLocationEntry == null ? -1 : WhenMappings.$EnumSwitchMapping$0[showLocationEntry.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = this.isHotkeyHeld();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit onConfigInit$lambda$2(CrimsonIsleReputationHelper this$0, Boolean $this$afterChange) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.updateRender();
        return Unit.INSTANCE;
    }

    private static final JsonElement onConfigFix$lambda$4(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, ReputationHelperConfig.ShowLocationEntry.class);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CrimsonIsleReputationHelper.class, "tabListQuestPattern", "getTabListQuestPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReputationHelperConfig.ShowLocationEntry.values().length];
            try {
                nArray[ReputationHelperConfig.ShowLocationEntry.ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReputationHelperConfig.ShowLocationEntry.ONLY_HOTKEY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

