/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.update;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.About;
import at.hannibal2.skyhanni.deps.libautoupdate.CurrentVersion;
import at.hannibal2.skyhanni.deps.libautoupdate.PotentialUpdate;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateContext;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateData;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateSource;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateTarget;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateUtils;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.deps.moulconfig.processor.MoulConfigProcessor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.features.misc.update.ConfigVersionDisplay;
import at.hannibal2.skyhanni.features.misc.update.GuiOptionEditorUpdateCheck;
import at.hannibal2.skyhanni.utils.APIUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import com.google.gson.JsonElement;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0011\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\u0003J!\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\t\u00a2\u0006\u0004\b\u001c\u0010\u0003R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001c\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R0\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010 8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010*\u001a\u00020)2\u0006\u0010#\u001a\u00020)8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u001c\u00102\u001a\n /*\u0004\u0018\u00010.0.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0018\u00107\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/features/misc/update/UpdateManager;", "", "<init>", "()V", "", "getNextVersion", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/deps/moulconfig/processor/MoulConfigProcessor;", "processor", "injectConfigProcessor", "(Lat/hannibal2/skyhanni/deps/moulconfig/processor/MoulConfigProcessor;)V", "", "isCurrentlyBeta", "()Z", "reset", "forceDownload", "Lat/hannibal2/skyhanni/config/features/About$UpdateStream;", "forcedUpdateStream", "checkUpdate", "(ZLat/hannibal2/skyhanni/config/features/About$UpdateStream;)V", "queueUpdate", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "Ljava/util/concurrent/CompletableFuture;", "_activePromise", "Ljava/util/concurrent/CompletableFuture;", "value", "getActivePromise", "()Ljava/util/concurrent/CompletableFuture;", "setActivePromise", "(Ljava/util/concurrent/CompletableFuture;)V", "activePromise", "Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "updateState", "Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "getUpdateState", "()Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "Lat/hannibal2/skyhanni/config/features/About;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/About;", "config", "Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateContext;", "context", "Lat/hannibal2/skyhanni/deps/libautoupdate/UpdateContext;", "Lat/hannibal2/skyhanni/deps/libautoupdate/PotentialUpdate;", "potentialUpdate", "Lat/hannibal2/skyhanni/deps/libautoupdate/PotentialUpdate;", "UpdateState", "1.8.9"})
public final class UpdateManager {
    @NotNull
    public static final UpdateManager INSTANCE = new UpdateManager();
    @NotNull
    private static final LorenzLogger logger = new LorenzLogger("update_manager");
    @Nullable
    private static CompletableFuture<?> _activePromise;
    @NotNull
    private static UpdateState updateState;
    @NotNull
    private static final UpdateContext context;
    @Nullable
    private static PotentialUpdate potentialUpdate;

    private UpdateManager() {
    }

    private final CompletableFuture<?> getActivePromise() {
        return _activePromise;
    }

    private final void setActivePromise(CompletableFuture<?> value) {
        CompletableFuture<?> completableFuture = _activePromise;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        _activePromise = value;
    }

    @NotNull
    public final UpdateState getUpdateState() {
        return updateState;
    }

    @Nullable
    public final String getNextVersion() {
        Object object = potentialUpdate;
        return object != null && (object = ((PotentialUpdate)object).getUpdate()) != null && (object = ((UpdateData)object).getVersionNumber()) != null ? object.getAsString() : null;
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<About.UpdateStream> property = SkyHanniMod.feature.about.updateStream;
        Intrinsics.checkNotNullExpressionValue(property, "updateStream");
        ConditionalUtils.INSTANCE.onToggle(property, UpdateManager::onConfigLoad$lambda$0);
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        if (this.getConfig().autoUpdates || this.getConfig().fullAutoUpdates) {
            UpdateManager.checkUpdate$default(this, false, null, 3, null);
        }
    }

    public final void injectConfigProcessor(@NotNull MoulConfigProcessor<?> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        processor.registerConfigEditor(ConfigVersionDisplay.class, UpdateManager::injectConfigProcessor$lambda$1);
    }

    public final boolean isCurrentlyBeta() {
        return StringsKt.contains((CharSequence)SkyHanniMod.Companion.getVersion(), "beta", true);
    }

    private final About getConfig() {
        return SkyHanniMod.feature.about;
    }

    public final void reset() {
        updateState = UpdateState.NONE;
        _activePromise = null;
        potentialUpdate = null;
        logger.log("Reset update state");
    }

    public final void checkUpdate(boolean forceDownload, @NotNull About.UpdateStream forcedUpdateStream) {
        Intrinsics.checkNotNullParameter((Object)forcedUpdateStream, "forcedUpdateStream");
        About.UpdateStream updateStream = forcedUpdateStream;
        if (updateState != UpdateState.NONE) {
            logger.log("Trying to perform update check while another update is already in progress");
            return;
        }
        logger.log("Starting update check");
        About.UpdateStream currentStream = (About.UpdateStream)((Object)this.getConfig().updateStream.get());
        if (currentStream != About.UpdateStream.BETA && (updateStream == About.UpdateStream.BETA || this.isCurrentlyBeta())) {
            this.getConfig().updateStream = Property.of(About.UpdateStream.BETA);
            updateStream = About.UpdateStream.BETA;
        }
        this.setActivePromise((CompletableFuture<?>)context.checkUpdate(updateStream.getStream()).thenAcceptAsync(arg_0 -> UpdateManager.checkUpdate$lambda$3(arg_0 -> UpdateManager.checkUpdate$lambda$2(forceDownload, arg_0), arg_0), DelayedRun.onThread));
    }

    public static /* synthetic */ void checkUpdate$default(UpdateManager updateManager, boolean bl, About.UpdateStream updateStream, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            updateStream = (About.UpdateStream)((Object)updateManager.getConfig().updateStream.get());
        }
        updateManager.checkUpdate(bl, updateStream);
    }

    public final void queueUpdate() {
        if (updateState != UpdateState.AVAILABLE) {
            logger.log("Trying to enqueue an update while another one is already downloaded or none is present");
        }
        updateState = UpdateState.QUEUED;
        this.setActivePromise((CompletableFuture<?>)CompletableFuture.supplyAsync(UpdateManager::queueUpdate$lambda$4).thenAcceptAsync(arg_0 -> UpdateManager.queueUpdate$lambda$6(UpdateManager::queueUpdate$lambda$5, arg_0), DelayedRun.onThread));
    }

    private static final void onConfigLoad$lambda$0() {
        INSTANCE.reset();
    }

    private static final GuiOptionEditor injectConfigProcessor$lambda$1(ProcessedOption option, ConfigVersionDisplay configVersionDisplay) {
        Intrinsics.checkNotNull(option);
        return new GuiOptionEditorUpdateCheck(option);
    }

    private static final Unit checkUpdate$lambda$2(boolean $forceDownload, PotentialUpdate it) {
        logger.log("Update check completed");
        if (updateState != UpdateState.NONE) {
            logger.log("This appears to be the second update check. Ignoring this one");
            return Unit.INSTANCE;
        }
        potentialUpdate = it;
        if (it.isUpdateAvailable()) {
            updateState = UpdateState.AVAILABLE;
            if (UpdateManager.INSTANCE.getConfig().fullAutoUpdates || $forceDownload) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aSkyHanni found a new update: " + it.getUpdate().getVersionName() + ", starting to download now.", false, null, 6, null);
                INSTANCE.queueUpdate();
            } else if (UpdateManager.INSTANCE.getConfig().autoUpdates) {
                ChatUtils.INSTANCE.chatAndOpenConfig("\u00a7aSkyHanni found a new update: " + it.getUpdate().getVersionName() + ". Check \u00a7b/sh download update \u00a7afor more info.", new MutablePropertyReference0Impl(INSTANCE.getConfig()){

                    public Object get() {
                        return ((About)this.receiver).autoUpdates;
                    }

                    public void set(Object value) {
                        ((About)this.receiver).autoUpdates = (Boolean)value;
                    }
                });
            }
        } else if ($forceDownload) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aSkyHanni didn't find a new update.", false, null, 6, null);
        }
        return Unit.INSTANCE;
    }

    private static final void checkUpdate$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit queueUpdate$lambda$4() {
        logger.log("Update download started");
        PotentialUpdate potentialUpdate = UpdateManager.potentialUpdate;
        Intrinsics.checkNotNull(potentialUpdate);
        potentialUpdate.prepareUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit queueUpdate$lambda$5(Unit it) {
        logger.log("Update download completed, setting exit hook");
        updateState = UpdateState.DOWNLOADED;
        PotentialUpdate potentialUpdate = UpdateManager.potentialUpdate;
        Intrinsics.checkNotNull(potentialUpdate);
        potentialUpdate.executePreparedUpdate();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Download of update complete. ", false, null, 6, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aThe update will be installed after your next restart.", false, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final void queueUpdate$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$7(URLConnection it) {
        if (it instanceof HttpsURLConnection) {
            APIUtils.INSTANCE.patchHttpsRequest((HttpsURLConnection)it);
        }
    }

    static {
        updateState = UpdateState.NONE;
        context = new UpdateContext(UpdateSource.githubUpdateSource("hannibal002", "SkyHanni"), UpdateTarget.deleteAndSaveInTheSameFolder(UpdateManager.class), new CurrentVersion(){
            private final CurrentVersion normalDelegate;
            {
                this.normalDelegate = CurrentVersion.ofTag(SkyHanniMod.Companion.getVersion());
            }

            public final CurrentVersion getNormalDelegate() {
                return this.normalDelegate;
            }

            public String display() {
                if (SkyHanniMod.feature.dev.debug.alwaysOutdated) {
                    return "Force Outdated";
                }
                String string2 = this.normalDelegate.display();
                Intrinsics.checkNotNullExpressionValue(string2, "display(...)");
                return string2;
            }

            public boolean isOlderThan(JsonElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (SkyHanniMod.feature.dev.debug.alwaysOutdated) {
                    return true;
                }
                return this.normalDelegate.isOlderThan(element);
            }

            public String toString() {
                return "ForceOutdateDelegate(" + this.normalDelegate + ')';
            }
        }, "skyhanni");
        context.cleanup();
        UpdateUtils.patchConnection(UpdateManager::_init_$lambda$7);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lat/hannibal2/skyhanni/features/misc/update/UpdateManager$UpdateState;", "", "<init>", "(Ljava/lang/String;I)V", "AVAILABLE", "QUEUED", "DOWNLOADED", "NONE", "1.8.9"})
    public static final class UpdateState
    extends Enum<UpdateState> {
        public static final /* enum */ UpdateState AVAILABLE = new UpdateState();
        public static final /* enum */ UpdateState QUEUED = new UpdateState();
        public static final /* enum */ UpdateState DOWNLOADED = new UpdateState();
        public static final /* enum */ UpdateState NONE = new UpdateState();
        private static final /* synthetic */ UpdateState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdateState[] values() {
            return (UpdateState[])$VALUES.clone();
        }

        public static UpdateState valueOf(String value) {
            return Enum.valueOf(UpdateState.class, value);
        }

        @NotNull
        public static EnumEntries<UpdateState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updateStateArray = new UpdateState[]{UpdateState.AVAILABLE, UpdateState.QUEUED, UpdateState.DOWNLOADED, UpdateState.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

