/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.limbo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.HypixelJoinEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.MessageSendToServerEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import com.google.gson.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u0019\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\b,\u0010-R\u0016\u00101\u001a\u0004\u0018\u00010.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001c\u00106\u001a\n 3*\u0004\u0018\u000102028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\"\u0010:\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010(\"\u0004\b=\u0010\u001cR\u0016\u0010>\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010;R\u0016\u0010?\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010;R\u0016\u0010A\u001a\u00020@8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u00109R\u0016\u0010B\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020)8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bD\u0010CR\u0014\u0010E\u001a\u00020)8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bE\u0010CR\u0016\u0010F\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010;R\u0014\u0010H\u001a\u00020G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010;R\u0016\u0010K\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010L\u00a8\u0006M"}, d2={"Lat/hannibal2/skyhanni/features/misc/limbo/LimboTimeTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;", "onMessageSendToServer", "(Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "leaveLimbo", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "onlyPlaytime", "printStats", "(Z)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "personalBest", "workaroundMigration", "(I)V", "Lat/hannibal2/skyhanni/events/HypixelJoinEvent;", "onHypixelJoin", "(Lat/hannibal2/skyhanni/events/HypixelJoinEvent;)V", "isEnabled", "()Z", "", "input", "", "tryTruncateFloat", "(F)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$LimboStats;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$LimboStats;", "storage", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "limboJoinTime", "J", "inLimbo", "Z", "getInLimbo", "setInLimbo", "inFakeLimbo", "shownPB", "Lkotlin/time/Duration;", "oldPB", "userLuck", "F", "USER_LUCK_MULTIPLIER", "FIRE_MULTIPLIER", "onFire", "Lnet/minecraft/util/AxisAlignedBB;", "bedWarsLobbyLimbo", "Lnet/minecraft/util/AxisAlignedBB;", "doMigrate", "notMigratedPB", "I", "1.8.9"})
public final class LimboTimeTracker {
    @NotNull
    public static final LimboTimeTracker INSTANCE = new LimboTimeTracker();
    private static long limboJoinTime = SimpleTimeMark.Companion.farPast();
    private static boolean inLimbo;
    private static boolean inFakeLimbo;
    private static boolean shownPB;
    private static long oldPB;
    private static float userLuck;
    private static final float USER_LUCK_MULTIPLIER = 8.10185E-4f;
    private static final float FIRE_MULTIPLIER = 1.01f;
    private static boolean onFire;
    @NotNull
    private static final AxisAlignedBB bedWarsLobbyLimbo;
    private static boolean doMigrate;
    private static int notMigratedPB;

    private LimboTimeTracker() {
    }

    private final PlayerSpecificStorage.LimboStats getStorage() {
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        return playerSpecificStorage != null ? playerSpecificStorage.limbo : null;
    }

    private final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    public final boolean getInLimbo() {
        return inLimbo;
    }

    public final void setInLimbo(boolean bl) {
        inLimbo = bl;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Intrinsics.areEqual(event.getMessage(), "\u00a7cYou are AFK. Move around to return from AFK.") || Intrinsics.areEqual(event.getMessage(), "\u00a7cYou were spawned in Limbo.")) {
            limboJoinTime = SimpleTimeMark.Companion.now-uFjCsEo();
            inLimbo = true;
            onFire = Minecraft.func_71410_x().field_71439_g.func_70027_ad();
        }
    }

    @SubscribeEvent
    public final void onMessageSendToServer(@NotNull MessageSendToServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (StringsKt.startsWith$default(event.getMessage(), "/playtime", false, 2, null) && inLimbo) {
            event.isCanceled();
            this.printStats(true);
        }
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        String lobbyName;
        JsonObject jsonObject2;
        int personalBest;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
        int n = personalBest = limboStats != null ? limboStats.personalBest : 0;
        if (inLimbo && !shownPB) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime), DurationKt.toDuration(personalBest, DurationUnit.SECONDS)) >= 0 && personalBest != 0) {
                shownPB = true;
                oldPB = DurationKt.toDuration(personalBest, DurationUnit.SECONDS);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7d\u00a7lPERSONAL BEST\u00a7f! You've surpassed your previous record of \u00a7e" + Duration.toString-impl(oldPB) + "\u00a7f!", false, null, 6, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fKeep it up!", false, null, 6, null);
            }
        }
        String string2 = (jsonObject2 = HypixelData.INSTANCE.getLocrawData()) != null && (jsonObject2 = jsonObject2.get("lobbyname")) != null ? jsonObject2.getAsString() : (lobbyName = null);
        if (StringsKt.startsWith$default(String.valueOf(lobbyName), "bedwarslobby", false, 2, null)) {
            if (LocationUtils.INSTANCE.isPlayerInside(bedWarsLobbyLimbo)) {
                if (inFakeLimbo) {
                    return;
                }
                limboJoinTime = SimpleTimeMark.Companion.now-uFjCsEo();
                inLimbo = true;
                inFakeLimbo = true;
            } else if (inLimbo) {
                this.leaveLimbo();
                inFakeLimbo = false;
            }
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!inLimbo) {
            return;
        }
        this.leaveLimbo();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inLimbo) {
            return;
        }
        if (LorenzUtils.INSTANCE.getInSkyBlock()) {
            this.leaveLimbo();
            return;
        }
        String duration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime), null, false, false, 0, false, 31, null);
        Position position = this.getConfig().showTimeInLimboPosition;
        Intrinsics.checkNotNullExpressionValue(position, "showTimeInLimboPosition");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, "\u00a7eIn Limbo since \u00a7b" + duration, 0, 0, "Limbo Time Tracker", 6, null);
    }

    private final void leaveLimbo() {
        float oldLuck;
        inLimbo = false;
        if (!this.isEnabled()) {
            return;
        }
        long passedSince = SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime);
        String duration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, passedSince, null, false, false, 0, false, 31, null);
        PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
        long currentPB = DurationKt.toDuration(limboStats != null ? limboStats.personalBest : 0, DurationUnit.SECONDS);
        PlayerSpecificStorage.LimboStats limboStats2 = this.getStorage();
        float f = oldLuck = limboStats2 != null ? limboStats2.userLuck : 0.0f;
        if (Duration.compareTo-LRDsOJo(passedSince, currentPB) > 0) {
            oldPB = currentPB;
            if (this.getStorage() != null) {
                this.getStorage().personalBest = Duration.toInt-impl(passedSince, DurationUnit.SECONDS);
            }
            PlayerSpecificStorage.LimboStats limboStats3 = this.getStorage();
            userLuck = NumberUtil.INSTANCE.roundTo((float)(limboStats3 != null ? limboStats3.personalBest : 0) * 8.10185E-4f, 2);
            if (onFire) {
                userLuck *= 1.01f;
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYou were in Limbo for \u00a7e" + duration + "\u00a7f! \u00a7d\u00a7lPERSONAL BEST\u00a7r\u00a7f!", false, null, 6, null);
            if (!Duration.equals-impl0(oldPB, DurationKt.toDuration(0, DurationUnit.SECONDS))) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYour previous Personal Best was \u00a7e" + Duration.toString-impl(oldPB) + '.', false, null, 6, null);
            }
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYou were in Limbo for \u00a7e" + duration + "\u00a7f.", false, null, 6, null);
        }
        if (userLuck > oldLuck) {
            if (onFire) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYour \u00a7aPersonal Bests\u00a7f perk is now granting you \u00a7a+" + NumberUtil.INSTANCE.roundTo(userLuck, 2) + "\u00a7c\u2734 \u00a7aSkyHanni User Luck\u00a7f! ", false, null, 6, null);
            } else {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYour \u00a7aPersonal Bests\u00a7f perk is now granting you \u00a7a+" + NumberUtil.INSTANCE.roundTo(userLuck, 2) + "\u2734 SkyHanni User Luck\u00a7f!", false, null, 6, null);
            }
            if (this.getStorage() != null) {
                this.getStorage().userLuck = userLuck;
            }
        }
        if (this.getStorage() != null) {
            PlayerSpecificStorage.LimboStats limboStats4 = this.getStorage();
            this.getStorage().playtime = limboStats4 != null ? limboStats4.playtime + Duration.toInt-impl(passedSince, DurationUnit.SECONDS) : 0;
        }
        onFire = false;
        shownPB = false;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 27, "misc.limboTimePB", "#player.personalBest", null, 8, null);
    }

    public final void printStats(boolean onlyPlaytime) {
        int playtime;
        int n;
        int timeInLimbo;
        int n2 = timeInLimbo = inLimbo ? (int)Duration.getInWholeSeconds-impl(SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime)) : 0;
        if (inLimbo) {
            PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
            n = (limboStats != null ? limboStats.playtime : 0) + (int)Duration.getInWholeSeconds-impl(SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime));
        } else {
            PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
            n = playtime = limboStats != null ? limboStats.playtime : 0;
        }
        if (onlyPlaytime) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aYou have " + playtime / 3600 + " hours and " + playtime % 3600 / 60 + " minutes playtime!", false, null, 4, null);
        } else {
            PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
            int currentPB = limboStats != null ? limboStats.personalBest : 0;
            PlayerSpecificStorage.LimboStats limboStats2 = this.getStorage();
            float userLuck = limboStats2 != null ? limboStats2.userLuck : 0.0f;
            int limboPB = currentPB < timeInLimbo ? timeInLimbo : currentPB;
            String luckString = this.tryTruncateFloat(NumberUtil.INSTANCE.roundTo(userLuck, 2));
            if (userLuck > 0.0f) {
                luckString = '+' + luckString;
            }
            String firstMessage = "\u00a7fYour current PB is \u00a7e" + Duration.toString-impl(DurationKt.toDuration(limboPB, DurationUnit.SECONDS)) + "\u00a7f, granting you \u00a7a" + luckString + "\u2734 SkyHanni User Luck\u00a7f!";
            String secondMessage = "\u00a7fYou have \u00a7e" + Duration.toString-impl(DurationKt.toDuration(playtime, DurationUnit.SECONDS)) + " \u00a7fof playtime!";
            if (userLuck == Float.POSITIVE_INFINITY || userLuck == Float.NEGATIVE_INFINITY) {
                firstMessage = firstMessage + " \u00a7Zwhat";
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, firstMessage, false, null, 6, null);
            ChatUtils.chat$default(ChatUtils.INSTANCE, secondMessage, false, null, 6, null);
        }
    }

    public static /* synthetic */ void printStats$default(LimboTimeTracker limboTimeTracker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        limboTimeTracker.printStats(bl);
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Limbo");
        if (!inLimbo) {
            event.addIrrelevant("not in limbo");
            return;
        }
        event.addData(LimboTimeTracker::onDebugDataCollect$lambda$0);
    }

    public final void workaroundMigration(int personalBest) {
        doMigrate = true;
        notMigratedPB = personalBest;
    }

    @SubscribeEvent
    public final void onHypixelJoin(@NotNull HypixelJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!doMigrate) {
            return;
        }
        if (notMigratedPB != 0) {
            ChatUtils.INSTANCE.debug("Migrating limbo personalBest");
            if (this.getStorage() != null) {
                this.getStorage().personalBest = notMigratedPB;
            }
            if (this.getStorage() != null) {
                this.getStorage().userLuck = (float)notMigratedPB * 8.10185E-4f;
            }
        }
        PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
        PlayerSpecificStorage.LimboStats limboStats2 = this.getStorage();
        if ((limboStats != null ? limboStats.personalBest : 0) > (limboStats2 != null ? limboStats2.playtime : 0)) {
            ChatUtils.INSTANCE.debug("Migrating limbo playtime");
            if (this.getStorage() != null) {
                PlayerSpecificStorage.LimboStats limboStats3 = this.getStorage();
                this.getStorage().playtime = limboStats3 != null ? limboStats3.personalBest : 0;
            }
        }
        doMigrate = false;
        notMigratedPB = 0;
    }

    public final boolean isEnabled() {
        return this.getConfig().showTimeInLimbo;
    }

    private final String tryTruncateFloat(float input2) {
        String string2 = String.valueOf(input2);
        if (StringsKt.endsWith$default(string2, ".0", false, 2, null)) {
            return StringsKt.dropLast(string2, 2);
        }
        return string2;
    }

    private static final Unit onDebugDataCollect$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("inLimbo: " + inLimbo);
        $this$addData.add("isLimboFake: " + inFakeLimbo);
        $this$addData.add("since: " + Duration.toString-impl(SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime)));
        return Unit.INSTANCE;
    }

    static {
        oldPB = DurationKt.toDuration(0, DurationUnit.SECONDS);
        bedWarsLobbyLimbo = new AxisAlignedBB(-662.0, 43.0, -76.0, -619.0, 86.0, -27.0);
    }
}

