/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.eventtracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.mining.MiningEventConfig;
import at.hannibal2.skyhanni.data.BossbarData;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.BossbarUpdateEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventDataReceive;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventDataSend;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventDisplay;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventType;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.APIUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010!\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"R\u001c\u0010'\u001a\n $*\u0004\u0018\u00010#0#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001b\u00100\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001b\u00103\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010-\u001a\u0004\b2\u0010/R\u001b\u00106\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010-\u001a\u0004\b5\u0010/R\u001b\u00109\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010-\u001a\u0004\b8\u0010/R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010>\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010<R\u0018\u0010@\u001a\u0004\u0018\u00010?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010B\u001a\u00020=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010<R\"\u0010D\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0011\u0010K\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\"\u00a8\u0006L"}, d2={"Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/BossbarUpdateEvent;", "onBossbarChange", "(Lat/hannibal2/skyhanni/events/BossbarUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "", "eventName", "time", "sendData", "(Ljava/lang/String;Ljava/lang/String;)V", "json", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "fetchData", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isMiningIsland", "()Z", "Lat/hannibal2/skyhanni/config/features/mining/MiningEventConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningEventConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "bossbarPassivePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getBossbarPassivePattern", "()Ljava/util/regex/Pattern;", "bossbarPassivePattern", "bossbarActivePattern$delegate", "getBossbarActivePattern", "bossbarActivePattern", "eventStartedPattern$delegate", "getEventStartedPattern", "eventStartedPattern", "eventEndedPattern$delegate", "getEventEndedPattern", "eventEndedPattern", "Lkotlin/time/Duration;", "defaultCooldown", "J", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "eventEndTime", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventType;", "lastSentEvent", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventType;", "canRequestAt", "", "apiErrorCount", "I", "getApiErrorCount", "()I", "setApiErrorCount", "(I)V", "getApiError", "apiError", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nMiningEventTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiningEventTracker.kt\nat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventTracker\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,236:1\n8#2:237\n8#2:239\n8#2:241\n8#2:243\n1#3:238\n1#3:240\n1#3:242\n1#3:244\n16#4:245\n*S KotlinDebug\n*F\n+ 1 MiningEventTracker.kt\nat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventTracker\n*L\n82#1:237\n85#1:239\n94#1:241\n97#1:243\n82#1:238\n85#1:240\n94#1:242\n97#1:244\n175#1:245\n*E\n"})
public final class MiningEventTracker {
    @NotNull
    public static final MiningEventTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern bossbarPassivePattern$delegate;
    @NotNull
    private static final RepoPattern bossbarActivePattern$delegate;
    @NotNull
    private static final RepoPattern eventStartedPattern$delegate;
    @NotNull
    private static final RepoPattern eventEndedPattern$delegate;
    private static final long defaultCooldown;
    private static long eventEndTime;
    @Nullable
    private static MiningEventType lastSentEvent;
    private static long canRequestAt;
    private static int apiErrorCount;

    private MiningEventTracker() {
    }

    private final MiningEventConfig getConfig() {
        return SkyHanniMod.feature.mining.miningEvent;
    }

    private final Pattern getBossbarPassivePattern() {
        return (Pattern)bossbarPassivePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getBossbarActivePattern() {
        return (Pattern)bossbarActivePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getEventStartedPattern() {
        return (Pattern)eventStartedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getEventEndedPattern() {
        return (Pattern)eventEndedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    public final int getApiErrorCount() {
        return apiErrorCount;
    }

    public final void setApiErrorCount(int n) {
        apiErrorCount = n;
    }

    public final boolean getApiError() {
        return apiErrorCount > 0;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        eventEndTime = SimpleTimeMark.Companion.farPast();
        lastSentEvent = null;
    }

    @SubscribeEvent
    public final void onBossbarChange(@NotNull BossbarUpdateEvent event) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isMiningIsland()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(LorenzUtils.INSTANCE.getLastWorldSwitch-uFjCsEo()), DurationKt.toDuration(5, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (!SimpleTimeMark.isInPast-impl(eventEndTime)) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getBossbarPassivePattern();
        String text$iv = event.getBossbar();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onBossbarChange_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onBossbarChange_u24lambda_u240.group("event");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            INSTANCE.sendData(string2, $this$onBossbarChange_u24lambda_u240.group("time"));
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getBossbarActivePattern();
        text$iv = event.getBossbar();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onBossbarChange_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            String string3 = $this$onBossbarChange_u24lambda_u241.group("event");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            INSTANCE.sendData(string3, $this$onBossbarChange_u24lambda_u241.group("time"));
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isMiningIsland()) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getEventStartedPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onChat_u24lambda_u242.group("event");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            INSTANCE.sendData(string2, null);
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getEventEndedPattern();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl3 = false;
            lastSentEvent = null;
        }
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.getConfig().enabled) {
            return;
        }
        if (!LorenzUtils.INSTANCE.getInSkyBlock() || !this.getConfig().outsideMining && !this.isMiningIsland()) {
            return;
        }
        if (!SimpleTimeMark.isInPast-impl(canRequestAt)) {
            return;
        }
        this.fetchData();
    }

    private final void sendData(String eventName, String time) {
        if (LorenzUtils.INSTANCE.isInIsland(IslandType.MINESHAFT)) {
            return;
        }
        if (Intrinsics.areEqual(eventName, "SLAYER QUEST")) {
            return;
        }
        MiningEventType miningEventType = MiningEventType.Companion.fromEventName(eventName);
        if (miningEventType == null) {
            MiningEventTracker $this$sendData_u24lambda_u244 = this;
            boolean bl = false;
            if (!$this$sendData_u24lambda_u244.getConfig().enabled) {
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to("eventName", eventName), TuplesKt.to("bossbar", BossbarData.INSTANCE.getBossbar()), TuplesKt.to("serverType", LorenzUtils.INSTANCE.getSkyBlockIsland()), TuplesKt.to("fromChat", time == null)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new Exception("UnknownMiningEvent"), "Unknown mining event detected from string " + eventName, pairArray, false, false, false, 56, null);
            return;
        }
        MiningEventType eventType = miningEventType;
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.DWARVEN_MINES) && eventType.getDwarvenSpecific()) {
            return;
        }
        if (lastSentEvent == eventType) {
            return;
        }
        lastSentEvent = eventType;
        long timeRemaining = time == null ? eventType.getDefaultLength-UwyO8pc() : TimeUtils.INSTANCE.getDuration-5sfh64U(time);
        eventEndTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), timeRemaining);
        String string2 = HypixelData.INSTANCE.getServerId();
        if (string2 == null) {
            return;
        }
        String serverId = string2;
        MiningEventDataSend miningEventData = new MiningEventDataSend(LorenzUtils.INSTANCE.getSkyBlockIsland(), serverId, eventType, Duration.getInWholeMilliseconds-impl(timeRemaining), LorenzUtils.INSTANCE.getPlayerUuid());
        String miningEventJson = ConfigManager.Companion.getGson().toJson((Object)miningEventData);
        if (this.getApiError()) {
            ChatUtils.INSTANCE.debug("blocked sending mining event data: api error");
            return;
        }
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(miningEventJson, null){
            int label;
            final /* synthetic */ String $miningEventJson;
            {
                this.$miningEventJson = $miningEventJson;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        String string2 = this.$miningEventJson;
                        Intrinsics.checkNotNull(string2);
                        MiningEventTracker.access$sendData(MiningEventTracker.INSTANCE, string2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendData(String json) {
        void $this$fromJson$iv;
        APIUtils.ApiResponse apiResponse;
        try {
            apiResponse = APIUtils.postJSON$default(APIUtils.INSTANCE, "https://api.soopy.dev/skyblock/chevents/set", json, false, 4, null);
        }
        catch (IOException e) {
            if (LorenzUtils.INSTANCE.getDebug()) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("sentData", json)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Sending mining event data was unsuccessful", pairArray, false, false, false, 56, null);
            }
            return;
        }
        APIUtils.ApiResponse response = apiResponse;
        if (!response.getSuccess()) {
            return;
        }
        Gson e = ConfigManager.Companion.getGson();
        JsonElement jsonElement$iv = (JsonElement)response.getData();
        boolean $i$f$fromJson = false;
        Object object = $this$fromJson$iv.fromJson(jsonElement$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(MiningEventDataReceive.class)));
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        MiningEventDataReceive formattedResponse = (MiningEventDataReceive)object;
        if (!formattedResponse.getSuccess()) {
            if (!this.getConfig().enabled) {
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to("cause", formattedResponse.getCause()), TuplesKt.to("sentData", json)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new Exception("PostFailure"), "Sending mining event data was unsuccessful", pairArray, false, false, false, 56, null);
        }
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (this.getApiError()) {
            canRequestAt = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    private final void fetchData() {
        canRequestAt = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), defaultCooldown);
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        JsonObject jsonObject2;
                        ResultKt.throwOnFailure(object);
                        try {
                            jsonObject2 = APIUtils.getJSONResponse$default(APIUtils.INSTANCE, "https://api.soopy.dev/skyblock/chevents/get", false, 2, null);
                        }
                        catch (Exception e) {
                            int n = MiningEventTracker.INSTANCE.getApiErrorCount();
                            MiningEventTracker.INSTANCE.setApiErrorCount(n + 1);
                            MiningEventTracker.access$setCanRequestAt$p(SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(20, DurationUnit.MINUTES)));
                            if (LorenzUtils.INSTANCE.getDebug()) {
                                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Receiving mining event data was unsuccessful", new Pair[0], false, false, false, 56, null);
                            }
                            return Unit.INSTANCE;
                        }
                        JsonObject data2 = jsonObject2;
                        MiningEventDataReceive miningEventData = (MiningEventDataReceive)ConfigManager.Companion.getGson().fromJson((JsonElement)data2, MiningEventDataReceive.class);
                        if (!miningEventData.getSuccess()) {
                            Pair[] pairArray = new Pair[]{TuplesKt.to("cause", miningEventData.getCause()), TuplesKt.to("recievedData", data2)};
                            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new Exception("PostFailure"), "Receiving mining event data was unsuccessful", pairArray, false, false, false, 56, null);
                            return Unit.INSTANCE;
                        }
                        MiningEventTracker.INSTANCE.setApiErrorCount(0);
                        MiningEventTracker.access$setCanRequestAt$p(SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(miningEventData.getData().getUpdateIn(), DurationUnit.MILLISECONDS)));
                        MiningEventDisplay.INSTANCE.updateData(miningEventData.getData());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.transform(29, "mining.miningEvent.showType", MiningEventTracker::onConfigFix$lambda$5);
    }

    public final boolean isMiningIsland() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.DWARVEN_MINES) || LorenzUtils.INSTANCE.isInIsland(IslandType.CRYSTAL_HOLLOWS);
    }

    private static final JsonElement onConfigFix$lambda$5(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return Intrinsics.areEqual(element.getAsString(), "BOTH") ? (JsonElement)new JsonPrimitive("ALL") : element;
    }

    public static final /* synthetic */ void access$sendData(MiningEventTracker $this, String json) {
        $this.sendData(json);
    }

    public static final /* synthetic */ void access$setCanRequestAt$p(long l) {
        canRequestAt = l;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MiningEventTracker.class, "bossbarPassivePattern", "getBossbarPassivePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningEventTracker.class, "bossbarActivePattern", "getBossbarActivePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningEventTracker.class, "eventStartedPattern", "getEventStartedPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningEventTracker.class, "eventEndedPattern", "getEventEndedPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new MiningEventTracker();
        patternGroup = RepoPattern.Companion.group("mining.eventtracker");
        bossbarPassivePattern$delegate = patternGroup.pattern("bossbar.passive", "\u00a7e\u00a7lPASSIVE EVENT (?<event>.+) \u00a7e\u00a7lRUNNING FOR \u00a7a\u00a7l(?<time>\\S+)\u00a7r");
        bossbarActivePattern$delegate = patternGroup.pattern("bossbar.active", "\u00a7e\u00a7lEVENT (?<event>.+) \u00a7e\u00a7lACTIVE IN (?<area>.+) \u00a7e\u00a7lfor \u00a7a\u00a7l(?<time>\\S+)\u00a7r");
        eventStartedPattern$delegate = patternGroup.pattern("started", "(?:\u00a7.)*\\s+(?:\u00a7.)+\u00a7l(?<event>.+) STARTED!");
        eventEndedPattern$delegate = patternGroup.pattern("ended", "(?:\u00a7.)*\\s+(?:\u00a7.)+\u00a7l(?<event>.+) ENDED!");
        defaultCooldown = DurationKt.toDuration(1, DurationUnit.MINUTES);
        eventEndTime = SimpleTimeMark.Companion.farPast();
        canRequestAt = SimpleTimeMark.Companion.farPast();
    }
}

