/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.eventtracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.mining.MiningEventConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventData;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventTracker;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventType;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningIslandEventInfo;
import at.hannibal2.skyhanni.features.mining.eventtracker.RunningEventType;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Duration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010*\u001a\n '*\u0004\u0018\u00010&0&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020.0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00102\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "updateDisplay", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "updateEvents", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/data/IslandType;", "islandType", "getIslandIcon", "(Lat/hannibal2/skyhanni/data/IslandType;)Ljava/util/List;", "Lat/hannibal2/skyhanni/features/mining/eventtracker/RunningEventType;", "events", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventType;", "lastEvent", "", "formatUpcomingEvents", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventType;)[Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventData;", "eventData", "updateData", "(Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventData;)V", "", "shouldDisplay", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/mining/MiningEventConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningEventConfig;", "config", "display", "Ljava/util/List;", "", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningIslandEventInfo;", "islandEventData", "Ljava/util/Map;", "unknownDisplay", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "transitionDisplay", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nMiningEventDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiningEventDisplay.kt\nat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n774#2:138\n865#2,2:139\n1368#2:141\n1454#2,5:142\n1557#2:147\n1628#2,3:148\n1368#2:152\n1454#2,5:153\n774#2:160\n865#2,2:161\n1053#2:163\n1#3:151\n37#4,2:158\n*S KotlinDebug\n*F\n+ 1 MiningEventDisplay.kt\nat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventDisplay\n*L\n95#1:138\n95#1:139,2\n96#1:141\n96#1:142,5\n99#1:147\n99#1:148,3\n103#1:152\n103#1:153,5\n111#1:160\n111#1:161,2\n112#1:163\n103#1:158,2\n*E\n"})
public final class MiningEventDisplay {
    @NotNull
    public static final MiningEventDisplay INSTANCE = new MiningEventDisplay();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();
    @NotNull
    private static final Map<IslandType, MiningIslandEventInfo> islandEventData = new LinkedHashMap();
    @NotNull
    private static final Renderable unknownDisplay = Renderable.Companion.string$default(Renderable.Companion, "\u00a77???", 0.0, null, null, null, 30, null);
    @NotNull
    private static final Renderable transitionDisplay = Renderable.Companion.string$default(Renderable.Companion, "\u00a78->", 0.0, null, null, null, 30, null);

    private MiningEventDisplay() {
    }

    private final MiningEventConfig getConfig() {
        return SkyHanniMod.feature.mining.miningEvent;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.updateDisplay();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.shouldDisplay()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Upcoming Mining Events", false, 10, null);
    }

    private final void updateDisplay() {
        display = this.updateEvents();
    }

    private final List<Renderable> updateEvents() {
        List<Renderable> list;
        List<Renderable> $this$updateEvents_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (MiningEventTracker.INSTANCE.getApiError()) {
            int count2 = MiningEventTracker.INSTANCE.getApiErrorCount();
            $this$updateEvents_u24lambda_u241.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7cMining Event API Error! (" + count2 + ')', 0.0, null, null, null, 30, null));
            $this$updateEvents_u24lambda_u241.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7cSwap servers to try again!", 0.0, null, null, null, 30, null));
        }
        for (Map.Entry<IslandType, MiningIslandEventInfo> entry : islandEventData.entrySet()) {
            boolean shouldShow;
            IslandType islandType = entry.getKey();
            MiningIslandEventInfo eventDetails = entry.getValue();
            MiningEventConfig.ShowType showType = MiningEventDisplay.INSTANCE.getConfig().showType;
            switch (showType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[showType.ordinal()]) {
                case 1: {
                    boolean bl2;
                    if (islandType == IslandType.DWARVEN_MINES) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                case 2: {
                    boolean bl2;
                    if (islandType == IslandType.CRYSTAL_HOLLOWS) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                case 3: {
                    boolean bl2 = LorenzUtils.INSTANCE.isInIsland(islandType);
                    break;
                }
                default: {
                    boolean bl2 = shouldShow = true;
                }
            }
            if (CollectionsKt.firstOrNull(eventDetails.getIslandEvents()) != null) {
                RunningEventType firstEvent;
                boolean bl3 = false;
                if (SimpleTimeMark.isInPast-impl(SimpleTimeMark.Companion.asTimeMark-1cd6UlU(firstEvent.getEndsAt()))) {
                    eventDetails.setLastEvent(firstEvent.getEvent());
                }
            }
            if (!shouldShow) continue;
            Renderable[] upcomingEvents = INSTANCE.formatUpcomingEvents(eventDetails.getIslandEvents(), eventDetails.getLastEvent());
            Renderable islandName = MiningEventDisplay.INSTANCE.getConfig().islandAsIcon ? Renderable.Companion.horizontalContainer$default(Renderable.Companion, INSTANCE.getIslandIcon(islandType), 0, null, null, 14, null) : Renderable.Companion.string$default(Renderable.Companion, "\u00a7a" + islandType.getDisplayName() + "\u00a78:", 0.0, null, null, null, 30, null);
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add(islandName);
            spreadBuilder.addSpread(upcomingEvents);
            $this$updateEvents_u24lambda_u241.add(Renderable.Companion.horizontalContainer$default(Renderable.Companion, CollectionsKt.listOf(spreadBuilder.toArray(new Renderable[spreadBuilder.size()])), 3, null, null, 12, null));
        }
        return CollectionsKt.build(list);
    }

    private final List<Renderable> getIslandIcon(IslandType islandType) {
        Renderable renderable2;
        Renderable[] renderableArray = new Renderable[2];
        switch (WhenMappings.$EnumSwitchMapping$1[islandType.ordinal()]) {
            case 1: {
                renderable2 = Renderable.Companion.itemStack$default(Renderable.Companion, NEUItems.INSTANCE.getItemStack(NEUInternalName.Companion.asInternalName("MITHRIL_ORE")), 0.0, 0, 0, false, null, null, 126, null);
                break;
            }
            case 2: {
                renderable2 = Renderable.Companion.itemStack$default(Renderable.Companion, NEUItems.INSTANCE.getItemStack(NEUInternalName.Companion.asInternalName("PERFECT_RUBY_GEM")), 0.0, 0, 0, false, null, null, 126, null);
                break;
            }
            default: {
                renderable2 = unknownDisplay;
            }
        }
        renderableArray[0] = renderable2;
        renderableArray[1] = Renderable.Companion.string$default(Renderable.Companion, "\u00a78:", 0.0, null, null, null, 30, null);
        return CollectionsKt.listOf(renderableArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Renderable[] formatUpcomingEvents(List<RunningEventType> events, MiningEventType lastEvent) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        Object[] objectArray;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RunningEventType)element$iv$iv;
            boolean bl = false;
            if (!(!SimpleTimeMark.isInPast-impl(SimpleTimeMark.Companion.asTimeMark-1cd6UlU(((RunningEventType)it).getEndsAt())))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<MiningEventType> list;
            it = (RunningEventType)element$iv$iv;
            boolean bl = false;
            if (((RunningEventType)it).isDoubleEvent()) {
                objectArray = new MiningEventType[]{((RunningEventType)it).getEvent(), ((RunningEventType)it).getEvent()};
                list = CollectionsKt.listOf(objectArray);
            } else {
                list = CollectionsKt.listOf(((RunningEventType)it).getEvent());
            }
            list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (MiningEventType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((MiningEventType)((Object)it)).getRenderable());
        }
        List upcoming = CollectionsKt.toMutableList((List)destination$iv$iv);
        if (upcoming.isEmpty()) {
            upcoming.add(unknownDisplay);
        }
        if (this.getConfig().passedEvents && upcoming.size() < 4) {
            MiningEventType miningEventType = lastEvent;
            if (miningEventType != null) {
                MiningEventType it2 = miningEventType;
                boolean bl = false;
                upcoming.add(0, it2.getRenderableAsPast());
            }
        }
        $this$flatMap$iv = upcoming;
        $i$f$flatMap = false;
        Iterable bl = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Renderable)element$iv$iv;
            boolean bl2 = false;
            objectArray = new Renderable[]{it, transitionDisplay};
            list$iv$iv = CollectionsKt.listOf(objectArray);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.dropLast((List)destination$iv$iv, 1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Renderable[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateData(@NotNull MiningEventData eventData) {
        Intrinsics.checkNotNullParameter(eventData, "eventData");
        for (Map.Entry<IslandType, List<RunningEventType>> entry : eventData.getRunningEvents().entrySet()) {
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            IslandType islandType = entry.getKey();
            List<RunningEventType> events = entry.getValue();
            if (islandType == IslandType.MINESHAFT) continue;
            Iterable $this$filter$iv = events;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunningEventType it = (RunningEventType)element$iv$iv;
                boolean bl = false;
                if (!(islandType == IslandType.DWARVEN_MINES || !it.getEvent().getDwarvenSpecific())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List<RunningEventType> sorted2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    RunningEventType it = (RunningEventType)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getEndsAt() - Duration.getInWholeMilliseconds-impl(it.getEvent().getDefaultLength-UwyO8pc()));
                    it = (RunningEventType)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getEndsAt() - Duration.getInWholeMilliseconds-impl(it.getEvent().getDefaultLength-UwyO8pc()));
                }
            });
            MiningIslandEventInfo oldData = islandEventData.get((Object)islandType);
            if (oldData == null) {
                if (!(!((Collection)sorted2).isEmpty())) continue;
                islandEventData.put(islandType, new MiningIslandEventInfo(sorted2, null, 2, null));
                continue;
            }
            oldData.setIslandEvents(sorted2);
        }
    }

    private final boolean shouldDisplay() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled && (this.getConfig().outsideMining || MiningEventTracker.INSTANCE.isMiningIsland());
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.transform(46, "mining.miningEvent.compressedFormat", MiningEventDisplay::onConfigFix$lambda$9);
    }

    private static final JsonElement onConfigFix$lambda$9(JsonElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ConfigUtils.INSTANCE.migrateBooleanToEnum(it, (Enum)MiningEventType.Companion.CompressFormat.COMPACT_TEXT, (Enum)MiningEventType.Companion.CompressFormat.DEFAULT);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MiningEventConfig.ShowType.values().length];
            try {
                nArray[MiningEventConfig.ShowType.DWARVEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MiningEventConfig.ShowType.CRYSTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MiningEventConfig.ShowType.CURRENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.DWARVEN_MINES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRYSTAL_HOLLOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

