/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.mining.KingTalismanConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.mining.KingTalismanHelper$checkOffset$;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockTime;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\u0017\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0018\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b \u0010\u001bJ\u0017\u0010\"\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#R\u001c\u0010(\u001a\n %*\u0004\u0018\u00010$0$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010,\u001a\u0004\u0018\u00010)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001b\u00102\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u0018\u00103\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00108\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00160:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00160:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010<R\u0016\u0010>\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00160:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010<\u00a8\u0006A"}, d2={"Lat/hannibal2/skyhanni/features/mining/KingTalismanHelper;", "", "<init>", "()V", "", "getCurrentOffset", "()Ljava/lang/Integer;", "", "kingFix", "", "isNearby", "()Z", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkOffset", "isEnabled", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "", "", "kingsTalkedTo", "update", "(Ljava/util/List;)V", "nextMissingText", "()Ljava/lang/String;", "", "", "getKingTimes", "()Ljava/util/Map;", "getCurrentKing", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/features/mining/KingTalismanConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/KingTalismanConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningConfig;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningConfig;", "storage", "Ljava/util/regex/Pattern;", "kingPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getKingPattern", "()Ljava/util/regex/Pattern;", "kingPattern", "currentOffset", "Ljava/lang/Integer;", "skyblockYear", "I", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "kingLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "kingCircles", "Ljava/util/List;", "allKingsDisplay", "farDisplay", "Ljava/lang/String;", "display", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nKingTalismanHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KingTalismanHelper.kt\nat/hannibal2/skyhanni/features/mining/KingTalismanHelper\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,202:1\n144#2:203\n172#2:204\n477#3:205\n183#3,2:206\n8#4:208\n1#5:209\n1#5:217\n535#6:210\n520#6,6:211\n*S KotlinDebug\n*F\n+ 1 KingTalismanHelper.kt\nat/hannibal2/skyhanni/features/mining/KingTalismanHelper\n*L\n94#1:203\n94#1:204\n94#1:205\n95#1:206,2\n96#1:208\n96#1:209\n168#1:210\n168#1:211,6\n*E\n"})
public final class KingTalismanHelper {
    @NotNull
    public static final KingTalismanHelper INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern kingPattern$delegate;
    @Nullable
    private static Integer currentOffset;
    private static int skyblockYear;
    @NotNull
    private static final LorenzVec kingLocation;
    @NotNull
    private static final List<String> kingCircles;
    @NotNull
    private static List<String> allKingsDisplay;
    @NotNull
    private static String farDisplay;
    @NotNull
    private static List<String> display;

    private KingTalismanHelper() {
    }

    private final KingTalismanConfig getConfig() {
        return SkyHanniMod.feature.mining.kingTalisman;
    }

    private final ProfileSpecificStorage.MiningConfig getStorage() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.mining : null;
    }

    private final Pattern getKingPattern() {
        return (Pattern)kingPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Integer getCurrentOffset() {
        if (SkyBlockTime.Companion.now().getYear() != skyblockYear) {
            return null;
        }
        return currentOffset;
    }

    public final void kingFix() {
        currentOffset = null;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Reset internal offset of King Talisman Helper.", false, null, 6, null);
    }

    private final boolean isNearby() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.DWARVEN_MINES) && Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Royal Palace") && LocationUtils.INSTANCE.distanceToPlayer(kingLocation) < 10.0;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        ProfileSpecificStorage.MiningConfig miningConfig = this.getStorage();
        if (miningConfig == null) {
            return;
        }
        ProfileSpecificStorage.MiningConfig storage2 = miningConfig;
        boolean nearby = this.isNearby();
        if (nearby && this.getCurrentOffset() == null) {
            this.checkOffset();
        }
        List<String> kingsTalkedTo = storage2.kingsTalkedTo;
        if (this.getCurrentOffset() == null) {
            boolean allKings = kingsTalkedTo.size() == kingCircles.size();
            display = allKings ? CollectionsKt.emptyList() : CollectionsKt.listOf("\u00a7cVisit the king to sync up.");
            return;
        }
        Intrinsics.checkNotNull(kingsTalkedTo);
        this.update(kingsTalkedTo);
        if (nearby) {
            list = allKingsDisplay;
        } else {
            List<String> list2 = Collections.singletonList(farDisplay);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, "singletonList(...)");
        }
        display = list;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOffset() {
        String string2;
        void $this$matchMatcher$iv;
        Entity entity;
        Object radius$iv22;
        block5: {
            void location$iv;
            void this_$iv;
            EntityUtils entityUtils = EntityUtils.INSTANCE;
            LorenzVec lorenzVec = new LorenzVec(129.6, 196.0, 196.7);
            double radius$iv22 = 2.0;
            boolean $i$f$getEntitiesNearby = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$getEntities = false;
            Sequence<Entity> $this$filterIsInstance$iv$iv$iv = this_$iv$iv.getAllEntities();
            boolean $i$f$filterIsInstance = false;
            Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv$iv, checkOffset$$inlined$getEntitiesNearby$1.INSTANCE);
            Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence<Entity> $this$firstOrNull$iv = SequencesKt.filter(sequence, (Function1)new Function1<EntityArmorStand, Boolean>((LorenzVec)location$iv, radius$iv22){
                final /* synthetic */ LorenzVec $location;
                final /* synthetic */ double $radius;
                {
                    this.$location = $location;
                    this.$radius = $radius;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Entity it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius;
                }
            });
            boolean $i$f$firstOrNull = false;
            radius$iv22 = $this$firstOrNull$iv.iterator();
            while (radius$iv22.hasNext()) {
                Entity element$iv = radius$iv22.next();
                EntityArmorStand it = (EntityArmorStand)element$iv;
                boolean bl = false;
                String string3 = it.func_70005_c_();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                if (!StringsKt.startsWith$default(string3, "\u00a76\u00a7lKing ", false, 2, null)) continue;
                entity = element$iv;
                break block5;
            }
            entity = null;
        }
        EntityArmorStand entityArmorStand = (EntityArmorStand)entity;
        if (entityArmorStand == null) {
            return;
        }
        EntityArmorStand king = entityArmorStand;
        RegexUtils $i$f$firstOrNull = RegexUtils.INSTANCE;
        radius$iv22 = this.getKingPattern();
        String string4 = king.func_70005_c_();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        String text$iv = string4;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$checkOffset_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            string2 = $this$checkOffset_u24lambda_u241.group("name");
        } else {
            string2 = null;
        }
        if (string2 == null) {
            return;
        }
        String foundKing = string2;
        int currentId = kingCircles.indexOf(this.getCurrentKing());
        int foundId = kingCircles.indexOf(foundKing);
        currentOffset = currentId - foundId;
        skyblockYear = SkyBlockTime.Companion.now().getYear();
    }

    public final boolean isEnabled() {
        return this.getConfig().enabled && LorenzUtils.INSTANCE.getInSkyBlock() && (LorenzUtils.INSTANCE.isInIsland(IslandType.DWARVEN_MINES) || this.getConfig().outsideMines);
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!Intrinsics.areEqual(event.getInventoryName(), "Commissions")) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentOffset() == null) {
            return;
        }
        if (!this.isNearby()) {
            return;
        }
        ProfileSpecificStorage.MiningConfig miningConfig = this.getStorage();
        if (miningConfig == null) {
            return;
        }
        ProfileSpecificStorage.MiningConfig storage2 = miningConfig;
        List<String> kingsTalkedTo = storage2.kingsTalkedTo;
        String currentKing = this.getCurrentKing();
        if (!kingsTalkedTo.contains(currentKing)) {
            kingsTalkedTo.add(currentKing);
            Intrinsics.checkNotNull(kingsTalkedTo);
            this.update(kingsTalkedTo);
            display = allKingsDisplay;
        }
    }

    private final void update(List<String> kingsTalkedTo) {
        List<String> list;
        if (kingsTalkedTo.size() == kingCircles.size()) {
            allKingsDisplay = Collections.singletonList("\u00a7eAll Kings found.");
            farDisplay = "";
            return;
        }
        List<String> $this$update_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String farDisplay_ = null;
        String currentKing = INSTANCE.getCurrentKing();
        for (Map.Entry<String, Long> entry : INSTANCE.getKingTimes().entrySet()) {
            String currentString;
            String string2;
            String king = entry.getKey();
            long timeUntil = ((Number)entry.getValue()).longValue();
            boolean missing = !kingsTalkedTo.contains(king);
            String missingString = missing ? "" : " \u00a7aDone";
            boolean current = Intrinsics.areEqual(king, currentKing);
            if (current) {
                long changedTime = timeUntil - (long)(1200000 * (kingCircles.size() - 1));
                String time = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, DurationKt.toDuration(changedTime, DurationUnit.MILLISECONDS), null, false, false, 2, false, 23, null);
                string2 = "\u00a77(\u00a7b" + time + " remaining\u00a77)";
            } else {
                String time = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, DurationKt.toDuration(timeUntil, DurationUnit.MILLISECONDS), null, false, false, 2, false, 23, null);
                string2 = "\u00a77(\u00a7bin " + time + "\u00a77)";
            }
            String missingTimeFormat = string2;
            String string3 = currentString = current ? "\u00a76King " : "";
            if (missing && current) {
                farDisplay_ = "\u00a7cNext missing king: \u00a77" + king + " \u00a7eNow " + missingTimeFormat;
            }
            String timeString = missing ? " \u00a7cMissing " + missingTimeFormat : "";
            $this$update_u24lambda_u242.add("\u00a77" + currentString + king + missingString + timeString);
        }
        String string4 = farDisplay_;
        if (string4 == null) {
            string4 = INSTANCE.nextMissingText();
        }
        farDisplay = string4;
        allKingsDisplay = CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    private final String nextMissingText() {
        Map.Entry entry;
        block5: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ProfileSpecificStorage.MiningConfig miningConfig = this.getStorage();
            if (miningConfig == null) {
                throw new IllegalStateException("profileSpecific is null".toString());
            }
            ProfileSpecificStorage.MiningConfig storage2 = miningConfig;
            List<String> kingsTalkedTo = storage2.kingsTalkedTo;
            Map<String, Long> map2 = this.getKingTimes();
            CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!kingsTalkedTo.contains(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            for (Map.Entry it : collectionUtils.sorted(destination$iv$iv).entrySet()) {
                boolean bl = false;
                entry = it;
                if (entry == null) {
                    continue;
                }
                break block5;
            }
            entry = null;
        }
        if (entry == null) {
            throw new NoSuchElementException("No element of the map was transformed to a non-null value.");
        }
        Map.Entry entry2 = entry;
        String nextKing = (String)entry2.getKey();
        long until = ((Number)entry2.getValue()).longValue();
        String time = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, DurationKt.toDuration(until, DurationUnit.MILLISECONDS), null, false, false, 2, false, 23, null);
        return "\u00a7cNext missing king: \u00a77" + nextKing + " \u00a77(\u00a7bin " + time + "\u00a77)";
    }

    private final Map<String, Long> getKingTimes() {
        Integer n = this.getCurrentOffset();
        int currentOffset = n != null ? n : 0;
        int oneSbDay = 1200000;
        int oneCircleTime = oneSbDay * kingCircles.size();
        Map kingTime = new LinkedHashMap();
        Iterator iterator2 = ((Iterable)kingCircles).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            long timeNext;
            int index = n2++;
            String king = (String)iterator2.next();
            SkyBlockTime startTime = new SkyBlockTime(0, 0, index + currentOffset - kingCircles.size(), 0, 0, 0, 59, null);
            for (timeNext = startTime.toMillis(); timeNext < System.currentTimeMillis(); timeNext += (long)oneCircleTime) {
            }
            long timeUntil = timeNext - System.currentTimeMillis();
            Long l = timeUntil;
            kingTime.put(king, l);
        }
        return kingTime;
    }

    private final String getCurrentKing() {
        String string2;
        block3: {
            for (Map.Entry<String, Long> it : CollectionUtils.INSTANCE.sortedDesc(this.getKingTimes()).entrySet()) {
                boolean bl = false;
                string2 = it.getKey();
                if (string2 == null) {
                    continue;
                }
                break block3;
            }
            string2 = null;
        }
        if (string2 == null) {
            throw new NoSuchElementException("No element of the map was transformed to a non-null value.");
        }
        return string2;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, position, display, 0, "King Talisman Helper", 2, null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(KingTalismanHelper.class, "kingPattern", "getKingPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new KingTalismanHelper();
        kingPattern$delegate = RepoPattern.Companion.pattern("mining.kingtalisman.king", "\u00a76\u00a7lKing (?<name>.*)");
        kingLocation = new LorenzVec(129.6, 196.5, 194.1);
        objectArray = new String[]{"Brammor", "Emkam", "Redros", "Erren", "Thormyr", "Emmor", "Grandan"};
        kingCircles = CollectionsKt.listOf(objectArray);
        allKingsDisplay = CollectionsKt.emptyList();
        farDisplay = "";
        display = CollectionsKt.emptyList();
    }
}

