/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.mining.ColdOverlayConfig;
import at.hannibal2.skyhanni.data.MiningAPI;
import at.hannibal2.skyhanni.events.ColdUpdateEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001b\u0010#\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/mining/ColdOverlay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "event", "", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "getColdAlpha", "()F", "Lat/hannibal2/skyhanni/events/ColdUpdateEvent;", "onColdUpdate", "(Lat/hannibal2/skyhanni/events/ColdUpdateEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/mining/ColdOverlayConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/ColdOverlayConfig;", "config", "", "cold", "I", "lastCold", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastColdUpdate", "J", "Lnet/minecraft/util/ResourceLocation;", "textureLocation$delegate", "Lkotlin/Lazy;", "getTextureLocation", "()Lnet/minecraft/util/ResourceLocation;", "textureLocation", "1.8.9"})
public final class ColdOverlay {
    @NotNull
    public static final ColdOverlay INSTANCE = new ColdOverlay();
    private static int cold;
    private static int lastCold;
    private static long lastColdUpdate;
    @NotNull
    private static final Lazy textureLocation$delegate;

    private ColdOverlay() {
    }

    private final ColdOverlayConfig getConfig() {
        return SkyHanniMod.feature.mining.coldOverlay;
    }

    private final ResourceLocation getTextureLocation() {
        Lazy lazy = textureLocation$delegate;
        return (ResourceLocation)lazy.getValue();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        float alpha = this.getColdAlpha();
        if (alpha == 0.0f) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTextureLocation());
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GL11.glDepthMask((boolean)false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiRenderUtils.INSTANCE.drawTexturedRect(0.0f, 0.0f);
        GL11.glDepthMask((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private final float getColdAlpha() {
        float coldInterp = NumberUtil.INSTANCE.interpolate(cold, lastCold, SimpleTimeMark.toMillis-impl(lastColdUpdate));
        float coldPercentage = (coldInterp - (float)this.getConfig().coldThreshold) / (float)(100 - this.getConfig().coldThreshold);
        return RangesKt.coerceAtLeast(coldPercentage, 0.0f) * (this.getConfig().maxAlpha / (float)100);
    }

    @SubscribeEvent
    public final void onColdUpdate(@NotNull ColdUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        long duration = event.getCold() == 0 ? DurationKt.toDuration(1, DurationUnit.SECONDS) : DurationKt.toDuration(0, DurationUnit.SECONDS);
        DelayedRun.INSTANCE.runDelayed-bouF650(duration, () -> ColdOverlay.onColdUpdate$lambda$1(event));
    }

    private final boolean isEnabled() {
        return MiningAPI.INSTANCE.inColdIsland() && this.getConfig().enabled;
    }

    private static final ResourceLocation textureLocation_delegate$lambda$0() {
        return new ResourceLocation("skyhanni", "cold_overlay.png");
    }

    private static final Unit onColdUpdate$lambda$1(ColdUpdateEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, "$event");
        lastCold = cold;
        cold = $event.getCold();
        lastColdUpdate = SimpleTimeMark.Companion.now-uFjCsEo();
        return Unit.INSTANCE;
    }

    static {
        lastColdUpdate = SimpleTimeMark.Companion.farPast();
        textureLocation$delegate = LazyKt.lazy(ColdOverlay::textureLocation_delegate$lambda$0);
    }
}

