/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.itemabilities;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.itemability.ChickenHeadConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u001c\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010!R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/itemabilities/ChickenHeadTimer;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/itemability/ChickenHeadConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/itemability/ChickenHeadConfig;", "config", "hasChickenHead", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastTime", "J", "Lkotlin/time/Duration;", "cooldown", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "chickenHead", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "1.8.9"})
public final class ChickenHeadTimer {
    @NotNull
    public static final ChickenHeadTimer INSTANCE = new ChickenHeadTimer();
    private static boolean hasChickenHead;
    private static long lastTime;
    private static final long cooldown;
    @NotNull
    private static final NEUInternalName chickenHead;

    private ChickenHeadTimer() {
    }

    private final ChickenHeadConfig getConfig() {
        return SkyHanniMod.feature.inventory.itemAbilities.chickenHead;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            return;
        }
        ItemStack itemStack2 = InventoryUtils.INSTANCE.getHelmet();
        hasChickenHead = Intrinsics.areEqual(itemStack2 != null ? ItemUtils.INSTANCE.getInternalName(itemStack2) : null, chickenHead);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!hasChickenHead) {
            return;
        }
        if (Intrinsics.areEqual(event.getMessage(), "\u00a7aYou laid an egg!")) {
            lastTime = SimpleTimeMark.Companion.now-uFjCsEo();
            if (this.getConfig().hideChat) {
                event.setBlockedReason("chicken_head_timer");
            }
        }
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!hasChickenHead) {
            return;
        }
        long remainingTime = Duration.minus-LRDsOJo(cooldown, SimpleTimeMark.passedSince-UwyO8pc(lastTime));
        if (Duration.isNegative-impl(remainingTime)) {
            string2 = "Chicken Head Timer: \u00a7aNow";
        } else {
            String formatDuration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, remainingTime, null, false, false, 0, false, 31, null);
            string2 = "Chicken Head Timer: \u00a7b" + formatDuration;
        }
        String displayText = string2;
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, displayText, 0, 0, "Chicken Head Timer", 6, null);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.chickenHeadTimerHideChat", "itemAbilities.chickenHead.hideChat", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.chickenHeadTimerPosition", "itemAbilities.chickenHead.position", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.chickenHeadTimerDisplay", "itemAbilities.chickenHead.displayTimer", null, 8, null);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().displayTimer;
    }

    static {
        lastTime = SimpleTimeMark.Companion.farPast();
        cooldown = DurationKt.toDuration(5, DurationUnit.SECONDS);
        chickenHead = NEUInternalName.Companion.asInternalName("CHICKEN_HEAD");
    }
}

