/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateShopPriceConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateAmount;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.utils.DisplayTableEntry;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.UtilsPatterns;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001EB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001e\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010\"R\u001b\u0010*\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u001b\u0010-\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010'\u001a\u0004\b,\u0010)R\u001b\u00100\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010'\u001a\u0004\b/\u0010)R\"\u00101\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u0010\u0019\"\u0004\b4\u00105R\u0016\u00106\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00102R.\u0010:\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0014\u0010@\u001a\u0002088\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010C\u001a\u00020B8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010D\u00a8\u0006F"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateShopPrice;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "updateProducts", "update", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateShopPriceConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateShopPriceConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateShopPrice$Product;", "products", "Ljava/util/regex/Pattern;", "menuNamePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMenuNamePattern", "()Ljava/util/regex/Pattern;", "menuNamePattern", "itemBoughtPattern$delegate", "getItemBoughtPattern", "itemBoughtPattern", "chocolateSpentPattern$delegate", "getChocolateSpentPattern", "chocolateSpentPattern", "inInventory", "Z", "getInInventory", "setInInventory", "(Z)V", "callUpdate", "", "", "Lnet/minecraft/item/ItemStack;", "inventoryItems", "Ljava/util/Map;", "getInventoryItems", "()Ljava/util/Map;", "setInventoryItems", "(Ljava/util/Map;)V", "MILESTONE_INDEX", "I", "", "chocolateSpent", "J", "Product", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nChocolateShopPrice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChocolateShopPrice.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateShopPrice\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1863#2,2:206\n32#3,3:208\n18#3,2:211\n21#3:214\n8#3:216\n1#4:213\n1#4:215\n1#4:217\n1#4:218\n*S KotlinDebug\n*F\n+ 1 ChocolateShopPrice.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateShopPrice\n*L\n85#1:206,2\n96#1:208,3\n96#1:211,2\n96#1:214\n184#1:216\n96#1:213\n184#1:217\n*E\n"})
public final class ChocolateShopPrice {
    @NotNull
    public static final ChocolateShopPrice INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static List<? extends Renderable> display;
    @NotNull
    private static List<Product> products;
    @NotNull
    private static final RepoPattern menuNamePattern$delegate;
    @NotNull
    private static final RepoPattern itemBoughtPattern$delegate;
    @NotNull
    private static final RepoPattern chocolateSpentPattern$delegate;
    private static boolean inInventory;
    private static boolean callUpdate;
    @NotNull
    private static Map<Integer, ItemStack> inventoryItems;
    private static final int MILESTONE_INDEX = 50;
    private static long chocolateSpent;

    private ChocolateShopPrice() {
    }

    private final ChocolateShopPriceConfig getConfig() {
        return ChocolateFactoryAPI.INSTANCE.getConfig().chocolateShopPrice;
    }

    private final Pattern getMenuNamePattern() {
        return (Pattern)menuNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getItemBoughtPattern() {
        return (Pattern)itemBoughtPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getChocolateSpentPattern() {
        return (Pattern)chocolateSpentPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    public final boolean getInInventory() {
        return inInventory;
    }

    public final void setInInventory(boolean bl) {
        inInventory = bl;
    }

    @NotNull
    public final Map<Integer, ItemStack> getInventoryItems() {
        return inventoryItems;
    }

    public final void setInventoryItems(@NotNull Map<Integer, ItemStack> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        inventoryItems = map2;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (inInventory) {
            this.update();
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        boolean isInShop = RegexUtils.INSTANCE.matches(this.getMenuNamePattern(), event.getInventoryName());
        boolean isInShopOptions = RegexUtils.INSTANCE.matches(UtilsPatterns.INSTANCE.getShopOptionsPattern(), event.getInventoryName());
        if (!isInShop && !isInShopOptions) {
            return;
        }
        Object object = event.getInventoryItems().get(48);
        if (!Intrinsics.areEqual(object != null && (object = ItemUtils.INSTANCE.getLore((ItemStack)object)) != null ? (String)CollectionsKt.first(object) : null, "\u00a77To Chocolate Shop") && isInShopOptions) {
            return;
        }
        inInventory = true;
        callUpdate = isInShop;
        inventoryItems = event.getInventoryItems();
        if (!callUpdate) {
            Iterable $this$forEach$iv = products;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Product it = (Product)element$iv;
                boolean bl = false;
                it.setSlot(null);
            }
        }
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProducts() {
        List newProducts = new ArrayList();
        for (Map.Entry<Integer, ItemStack> entry : inventoryItems.entrySet()) {
            Object object;
            Object sequence$iv$iv$iv;
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack item = entry.getValue();
            List<String> lore = ItemUtils.INSTANCE.getLore(item);
            if (slot == 50) {
                void $this$matchFirst$iv;
                void this_$iv$iv;
                void this_$iv;
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                List<String> list = lore;
                Pattern pattern$iv = this.getChocolateSpentPattern();
                boolean $i$f$matchFirst = false;
                void var11_13 = this_$iv;
                Pattern $this$firstMatcher$iv$iv = pattern$iv;
                boolean $i$f$firstMatcher = false;
                void var14_17 = this_$iv$iv;
                Pattern pattern = $this$firstMatcher$iv$iv;
                sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
                boolean $i$f$firstMatcher2 = false;
                object = sequence$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    void $this$firstMatcher$iv$iv$iv;
                    String line$iv$iv$iv = (String)object.next();
                    Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
                    boolean bl = false;
                    if (!it$iv$iv$iv.matches()) continue;
                    Intrinsics.checkNotNull(it$iv$iv$iv);
                    Matcher $this$updateProducts_u24lambda_u241 = it$iv$iv$iv;
                    boolean bl2 = false;
                    String string2 = $this$updateProducts_u24lambda_u241.group("amount");
                    Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                    chocolateSpent = NumberUtil.INSTANCE.formatLong(string2);
                    break;
                }
            }
            Long l = ChocolateFactoryAPI.INSTANCE.getChocolateBuyCost(lore);
            if (l == null) {
                continue;
            }
            long chocolate = l;
            NEUInternalName internalName = ItemUtils.INSTANCE.getInternalName(item);
            Double d = ItemPriceUtils.getPriceOrNull$default(ItemPriceUtils.INSTANCE, internalName, null, null, 3, null);
            if (d == null) {
                continue;
            }
            double itemPrice = d;
            Object object2 = ItemUtils.INSTANCE.loreCosts(item);
            double this_$iv$iv$iv = 0.0;
            sequence$iv$iv$iv = object2.iterator();
            while (sequence$iv$iv$iv.hasNext()) {
                void it;
                Object e = sequence$iv$iv$iv.next();
                object = (NEUInternalName)e;
                double d2 = this_$iv$iv$iv;
                boolean bl = false;
                double d3 = NEUItems.getPrice$default(NEUItems.INSTANCE, (NEUInternalName)it, null, null, 3, null);
                this_$iv$iv$iv = d2 + d3;
            }
            object2 = this_$iv$iv$iv;
            double it = ((Number)object2).doubleValue();
            boolean bl = false;
            Object otherItemsPrice = !(it == 0.0) ? object2 : null;
            newProducts.add(new Product(slot, ItemUtils.INSTANCE.getItemName(item), internalName, chocolate, itemPrice, (Double)otherItemsPrice));
        }
        products = newProducts;
    }

    private final void update() {
        if (callUpdate) {
            this.updateProducts();
        }
        double multiplier = NumberUtil.INSTANCE.getMillion(1);
        List table2 = new ArrayList();
        Object object = products.iterator();
        while (object.hasNext()) {
            Object object2;
            List<String> list;
            NEUInternalName nEUInternalName;
            double d;
            String string2;
            String string3;
            List list2;
            block8: {
                block7: {
                    List<String> list3;
                    Product product = object.next();
                    Double d2 = product.getOtherItemPrice();
                    double profit = product.getItemPrice() - (d2 != null ? d2 : 0.0);
                    double factor = profit / (double)product.getChocolate() * multiplier;
                    String perFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, factor, false, 1, null);
                    List<String> $this$update_u24lambda_u245 = list3 = CollectionsKt.createListBuilder();
                    boolean bl = false;
                    $this$update_u24lambda_u245.add(product.getName());
                    $this$update_u24lambda_u245.add("");
                    $this$update_u24lambda_u245.add("\u00a77Item price: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, product.getItemPrice(), false, 1, null) + ' ');
                    Double d3 = product.getOtherItemPrice();
                    if (d3 != null) {
                        double it = ((Number)d3).doubleValue();
                        boolean bl2 = false;
                        $this$update_u24lambda_u245.add("\u00a77Additional cost: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, it, false, 1, null) + ' ');
                    }
                    $this$update_u24lambda_u245.add("\u00a77Profit per purchase: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, profit, false, 1, null) + ' ');
                    $this$update_u24lambda_u245.add("");
                    $this$update_u24lambda_u245.add("\u00a77Chocolate amount: \u00a7c" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, product.getChocolate(), false, 1, null) + ' ');
                    $this$update_u24lambda_u245.add("\u00a77Profit per million chocolate: \u00a76" + perFormat + ' ');
                    $this$update_u24lambda_u245.add("");
                    String formattedTimeUntilGoal = ChocolateAmount.CURRENT.formattedTimeUntilGoal(product.getChocolate());
                    $this$update_u24lambda_u245.add("\u00a77Time until affordable: \u00a76" + formattedTimeUntilGoal + ' ');
                    List<String> hover = CollectionsKt.build(list3);
                    list2 = table2;
                    string3 = product.getName() + "\u00a7f:";
                    string2 = "\u00a76\u00a7l" + perFormat;
                    d = factor;
                    nEUInternalName = product.getItem();
                    list = hover;
                    object2 = product.getSlot();
                    if (object2 == null) break block7;
                    int it = ((Number)object2).intValue();
                    List<String> list4 = list;
                    NEUInternalName nEUInternalName2 = nEUInternalName;
                    double d4 = d;
                    String string4 = string2;
                    String string5 = string3;
                    List list5 = list2;
                    boolean bl3 = false;
                    List<Integer> list6 = CollectionsKt.listOf(it);
                    list2 = list5;
                    string3 = string5;
                    string2 = string4;
                    d = d4;
                    nEUInternalName = nEUInternalName2;
                    list = list4;
                    List<Integer> list7 = list6;
                    object2 = list7;
                    if (list7 != null) break block8;
                }
                object2 = CollectionsKt.emptyList();
            }
            List<Integer> list8 = object2;
            List<String> list9 = list;
            NEUInternalName nEUInternalName3 = nEUInternalName;
            double d5 = d;
            String string6 = string2;
            String string7 = string3;
            list2.add(new DisplayTableEntry(string7, string6, d5, nEUInternalName3, list9, list8));
        }
        Object $this$update_u24lambda_u247 = object = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$update_u24lambda_u247.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7e\u00a7lCoins per million chocolate\u00a7f:", 0.0, null, null, null, 30, null));
        $this$update_u24lambda_u247.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7eChocolate available: \u00a76" + ChocolateAmount.CURRENT.getFormatted(), 0.0, null, null, null, 30, null));
        $this$update_u24lambda_u247.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7eChocolate spent: \u00a76" + NumberUtil.INSTANCE.addSeparators(chocolateSpent), 0.0, null, null, null, 30, null));
        $this$update_u24lambda_u247.add(LorenzUtils.INSTANCE.fillTable(table2, 5, ChocolateShopPrice.INSTANCE.getConfig().itemScale));
        display = CollectionsKt.build(object);
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
        callUpdate = false;
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (inInventory) {
            Position position = this.getConfig().position;
            Intrinsics.checkNotNullExpressionValue(position, "position");
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 5, "Chocolate Shop Price", false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getItemBoughtPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Object v1;
            int amount;
            block5: {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$onChat_u24lambda_u249 = it$iv;
                boolean bl2 = false;
                String item = $this$onChat_u24lambda_u249.group("item");
                Object object = RegexUtils.INSTANCE.groupOrNull($this$onChat_u24lambda_u249, "amount");
                amount = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
                Iterable iterable = products;
                for (Object t : iterable) {
                    Product it = (Product)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, it.getName(), false, 1, null), item)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            Product product = v1;
            if (product == null) {
                return;
            }
            Product product2 = product;
            ChocolateAmount.Companion.addToCurrent(product2.getChocolate() * (long)(-amount));
        }
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ChocolateShopPrice.class, "menuNamePattern", "getMenuNamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateShopPrice.class, "itemBoughtPattern", "getItemBoughtPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateShopPrice.class, "chocolateSpentPattern", "getChocolateSpentPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ChocolateShopPrice();
        display = CollectionsKt.emptyList();
        products = CollectionsKt.emptyList();
        menuNamePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("shop.title", "Chocolate Shop");
        itemBoughtPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("shop.bought", "\u00a7aYou bought \u00a7r\u00a7.(?<item>[\\w ]+)\u00a7r(?:\u00a78 x(?<amount>\\d+)\u00a7r)?\u00a7a!");
        chocolateSpentPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("shop.spent", "\u00a77Chocolate Spent: \u00a76(?<amount>[\\d,]+)");
        inventoryItems = MapsKt.emptyMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJP\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001f\u001a\u00020\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010\u0012R$\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010'R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010*\u001a\u0004\b+\u0010\u0014R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010,\u001a\u0004\b-\u0010\u0016R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010.\u001a\u0004\b/\u0010\u0018R\u0019\u0010\f\u001a\u0004\u0018\u00010\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u00100\u001a\u0004\b1\u0010\u001a\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateShopPrice$Product;", "", "", "slot", "", "name", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "item", "", "chocolate", "", "itemPrice", "otherItemPrice", "<init>", "(Ljava/lang/Integer;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/NEUInternalName;JDLjava/lang/Double;)V", "component1", "()Ljava/lang/Integer;", "component2", "()Ljava/lang/String;", "component3", "()Lat/hannibal2/skyhanni/utils/NEUInternalName;", "component4", "()J", "component5", "()D", "component6", "()Ljava/lang/Double;", "copy", "(Ljava/lang/Integer;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/NEUInternalName;JDLjava/lang/Double;)Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateShopPrice$Product;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "Ljava/lang/Integer;", "getSlot", "setSlot", "(Ljava/lang/Integer;)V", "Ljava/lang/String;", "getName", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "getItem", "J", "getChocolate", "D", "getItemPrice", "Ljava/lang/Double;", "getOtherItemPrice", "1.8.9"})
    private static final class Product {
        @Nullable
        private Integer slot;
        @NotNull
        private final String name;
        @NotNull
        private final NEUInternalName item;
        private final long chocolate;
        private final double itemPrice;
        @Nullable
        private final Double otherItemPrice;

        public Product(@Nullable Integer slot, @NotNull String name2, @NotNull NEUInternalName item, long chocolate, double itemPrice, @Nullable Double otherItemPrice) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(item, "item");
            this.slot = slot;
            this.name = name2;
            this.item = item;
            this.chocolate = chocolate;
            this.itemPrice = itemPrice;
            this.otherItemPrice = otherItemPrice;
        }

        @Nullable
        public final Integer getSlot() {
            return this.slot;
        }

        public final void setSlot(@Nullable Integer n) {
            this.slot = n;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final NEUInternalName getItem() {
            return this.item;
        }

        public final long getChocolate() {
            return this.chocolate;
        }

        public final double getItemPrice() {
            return this.itemPrice;
        }

        @Nullable
        public final Double getOtherItemPrice() {
            return this.otherItemPrice;
        }

        @Nullable
        public final Integer component1() {
            return this.slot;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final NEUInternalName component3() {
            return this.item;
        }

        public final long component4() {
            return this.chocolate;
        }

        public final double component5() {
            return this.itemPrice;
        }

        @Nullable
        public final Double component6() {
            return this.otherItemPrice;
        }

        @NotNull
        public final Product copy(@Nullable Integer slot, @NotNull String name2, @NotNull NEUInternalName item, long chocolate, double itemPrice, @Nullable Double otherItemPrice) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(item, "item");
            return new Product(slot, name2, item, chocolate, itemPrice, otherItemPrice);
        }

        public static /* synthetic */ Product copy$default(Product product, Integer n, String string2, NEUInternalName nEUInternalName, long l, double d, Double d2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = product.slot;
            }
            if ((n2 & 2) != 0) {
                string2 = product.name;
            }
            if ((n2 & 4) != 0) {
                nEUInternalName = product.item;
            }
            if ((n2 & 8) != 0) {
                l = product.chocolate;
            }
            if ((n2 & 0x10) != 0) {
                d = product.itemPrice;
            }
            if ((n2 & 0x20) != 0) {
                d2 = product.otherItemPrice;
            }
            return product.copy(n, string2, nEUInternalName, l, d, d2);
        }

        @NotNull
        public String toString() {
            return "Product(slot=" + this.slot + ", name=" + this.name + ", item=" + this.item + ", chocolate=" + this.chocolate + ", itemPrice=" + this.itemPrice + ", otherItemPrice=" + this.otherItemPrice + ')';
        }

        public int hashCode() {
            int result2 = this.slot == null ? 0 : ((Object)this.slot).hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.item.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.chocolate);
            result2 = result2 * 31 + Double.hashCode(this.itemPrice);
            result2 = result2 * 31 + (this.otherItemPrice == null ? 0 : ((Object)this.otherItemPrice).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Product)) {
                return false;
            }
            Product product = (Product)other;
            if (!Intrinsics.areEqual(this.slot, product.slot)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, product.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.item, product.item)) {
                return false;
            }
            if (this.chocolate != product.chocolate) {
                return false;
            }
            if (Double.compare(this.itemPrice, product.itemPrice) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.otherItemPrice, (Object)product.otherItemPrice);
        }
    }
}

