/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateUpgradeWarningsConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryCustomReminder;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.time.Duration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001f\u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryUpgradeWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkUpgradeWarning", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileChange", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "", "slot", "level", "checkUpgradeChange", "(II)V", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateUpgradeWarningsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateUpgradeWarningsConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ChocolateFactoryStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ChocolateFactoryStorage;", "profileStorage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUpgradeWarning", "J", "lastUpgradeSlot", "I", "lastUpgradeLevel", "1.8.9"})
public final class ChocolateFactoryUpgradeWarning {
    @NotNull
    public static final ChocolateFactoryUpgradeWarning INSTANCE = new ChocolateFactoryUpgradeWarning();
    private static long lastUpgradeWarning = SimpleTimeMark.Companion.farPast();
    private static int lastUpgradeSlot = -1;
    private static int lastUpgradeLevel;

    private ChocolateFactoryUpgradeWarning() {
    }

    private final ChocolateUpgradeWarningsConfig getConfig() {
        return ChocolateFactoryAPI.INSTANCE.getConfig().chocolateUpgradeWarnings;
    }

    private final ProfileSpecificStorage.ChocolateFactoryStorage getProfileStorage() {
        return ChocolateFactoryAPI.INSTANCE.getProfileStorage();
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        SimpleTimeMark upgradeAvailableAt = profileStorage.bestUpgradeAvailableAt;
        if (SimpleTimeMark.isInPast-impl(upgradeAvailableAt.unbox-impl()) && !SimpleTimeMark.isFarPast-impl(upgradeAvailableAt.unbox-impl())) {
            this.checkUpgradeWarning();
        }
    }

    private final void checkUpgradeWarning() {
        if (!ChocolateFactoryAPI.INSTANCE.isEnabled()) {
            return;
        }
        if (!this.getConfig().upgradeWarning) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (ChocolateFactoryCustomReminder.INSTANCE.isActive()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastUpgradeWarning), TimeUtils.INSTANCE.getMinutes-5sfh64U(this.getConfig().timeBetweenWarnings)) < 0) {
            return;
        }
        lastUpgradeWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        if (this.getConfig().upgradeWarningSound) {
            SoundUtils.INSTANCE.playBeepSound();
        }
        if (ChocolateFactoryAPI.INSTANCE.getInChocolateFactory()) {
            return;
        }
        ChatUtils.INSTANCE.clickToActionOrDisable("You have a Chocolate factory upgrade available to purchase!", new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((ChocolateUpgradeWarningsConfig)this.receiver).upgradeWarning;
            }

            public void set(Object value) {
                ((ChocolateUpgradeWarningsConfig)this.receiver).upgradeWarning = (Boolean)value;
            }
        }, "open Chocolate Factory", ChocolateFactoryUpgradeWarning::checkUpgradeWarning$lambda$0);
    }

    @SubscribeEvent
    public final void onProfileChange(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastUpgradeWarning = SimpleTimeMark.Companion.farPast();
    }

    public final void checkUpgradeChange(int slot, int level) {
        if (slot != lastUpgradeSlot || level != lastUpgradeLevel) {
            lastUpgradeWarning = SimpleTimeMark.Companion.now-uFjCsEo();
            lastUpgradeSlot = slot;
            lastUpgradeLevel = level;
        }
    }

    private static final Unit checkUpgradeWarning$lambda$0() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }
}

