/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\r\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u000f\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010 \u001a\u00020\u001b\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\r\u0010#\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010\u001dJ\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b$\u0010\bR\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010,\u001a\u0004\u0018\u00010)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryTimeTowerManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkTimeTowerExpired", "", "inInventory", "checkTimeTowerWarning", "(Z)V", "", "timeTowerCharges", "()Ljava/lang/String;", "", "currentCharges", "()I", "maxCharges", "timeTowerFull", "()Z", "timeTowerActive", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "timeTowerEnds-uFjCsEo", "()J", "timeTowerEnds", "timeTowerFullTimeMark-uFjCsEo", "timeTowerFullTimeMark", "Lkotlin/time/Duration;", "timeTowerActiveDuration-UwyO8pc", "timeTowerActiveDuration", "onProfileChange", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ChocolateFactoryStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ChocolateFactoryStorage;", "profileStorage", "lastTimeTowerWarning", "J", "wasTimeTowerRecentlyActive", "Z", "HOVER_TEXT", "Ljava/lang/String;", "1.8.9"})
public final class ChocolateFactoryTimeTowerManager {
    @NotNull
    public static final ChocolateFactoryTimeTowerManager INSTANCE = new ChocolateFactoryTimeTowerManager();
    private static long lastTimeTowerWarning = SimpleTimeMark.Companion.farPast();
    private static boolean wasTimeTowerRecentlyActive;
    @NotNull
    private static final String HOVER_TEXT = "\u00a7eClick to run /cf!";

    private ChocolateFactoryTimeTowerManager() {
    }

    private final ChocolateFactoryConfig getConfig() {
        return ChocolateFactoryAPI.INSTANCE.getConfig();
    }

    private final ProfileSpecificStorage.ChocolateFactoryStorage getProfileStorage() {
        return ChocolateFactoryAPI.INSTANCE.getProfileStorage();
    }

    @SubscribeEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        wasTimeTowerRecentlyActive = false;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        if (SimpleTimeMark.isInPast-impl(profileStorage.currentTimeTowerEnds.unbox-impl())) {
            profileStorage.currentTimeTowerEnds = SimpleTimeMark.box-impl(SimpleTimeMark.Companion.farPast());
        }
        this.checkTimeTowerExpired();
        if (ChocolateFactoryAPI.INSTANCE.getInChocolateFactory()) {
            return;
        }
        SimpleTimeMark nextCharge = profileStorage.nextTimeTower;
        if (SimpleTimeMark.isInPast-impl(nextCharge.unbox-impl()) && !SimpleTimeMark.isFarPast-impl(nextCharge.unbox-impl()) && this.currentCharges() < this.maxCharges()) {
            int n = profileStorage.currentTimeTowerUses;
            profileStorage.currentTimeTowerUses = n + 1;
            long nextTimeTower = SimpleTimeMark.plus-qeHQSLg(profileStorage.nextTimeTower.unbox-impl(), DurationKt.toDuration(profileStorage.timeTowerCooldown, DurationUnit.HOURS));
            profileStorage.nextTimeTower = SimpleTimeMark.box-impl(nextTimeTower);
            if (!this.getConfig().timeTowerWarning || this.timeTowerActive()) {
                return;
            }
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Your Time Tower has another charge available \u00a77(" + this.timeTowerCharges() + ")\u00a7e, Click here to use one.", ChocolateFactoryTimeTowerManager::onSecondPassed$lambda$0, HOVER_TEXT, 0L, false, null, false, 120, null);
            SoundUtils.INSTANCE.playBeepSound();
            lastTimeTowerWarning = SimpleTimeMark.Companion.now-uFjCsEo();
            return;
        }
        this.checkTimeTowerWarning(false);
    }

    private final void checkTimeTowerExpired() {
        boolean isTimeTowerActive = this.timeTowerActive();
        if (!isTimeTowerActive && wasTimeTowerRecentlyActive && this.getConfig().timeTowerReminder && this.currentCharges() > 0) {
            String charges = StringUtils.INSTANCE.pluralize(this.currentCharges(), "charge", "charges", true);
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "\u00a7cYour Time Tower just expired and has " + charges + " remaining. Click here to use one.", ChocolateFactoryTimeTowerManager::checkTimeTowerExpired$lambda$1, HOVER_TEXT, 0L, false, null, false, 120, null);
            SoundUtils.INSTANCE.playBeepSound();
        }
        wasTimeTowerRecentlyActive = isTimeTowerActive;
    }

    public final void checkTimeTowerWarning(boolean inInventory) {
        long warningSeparation;
        if (!ChocolateFactoryAPI.INSTANCE.isEnabled()) {
            return;
        }
        if (!this.getConfig().timeTowerWarning) {
            return;
        }
        if (!this.timeTowerFull()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        long l = inInventory ? DurationKt.toDuration(30, DurationUnit.SECONDS) : (warningSeparation = DurationKt.toDuration(5, DurationUnit.MINUTES));
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastTimeTowerWarning), warningSeparation) < 0) {
            return;
        }
        ChatUtils.INSTANCE.clickToActionOrDisable("\u00a7cYour Time Tower is full \u00a77(" + this.timeTowerCharges() + ")\u00a7c, Use one to avoid wasting time tower usages!", new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((ChocolateFactoryConfig)this.receiver).timeTowerWarning;
            }

            public void set(Object value) {
                ((ChocolateFactoryConfig)this.receiver).timeTowerWarning = (Boolean)value;
            }
        }, "open Chocolate Factory", ChocolateFactoryTimeTowerManager::checkTimeTowerWarning$lambda$2);
        SoundUtils.INSTANCE.playBeepSound();
        lastTimeTowerWarning = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @NotNull
    public final String timeTowerCharges() {
        return "" + this.currentCharges() + '/' + this.maxCharges() + " Charges";
    }

    public final int currentCharges() {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        return chocolateFactoryStorage != null ? chocolateFactoryStorage.currentTimeTowerUses : -1;
    }

    private final int maxCharges() {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        return chocolateFactoryStorage != null ? chocolateFactoryStorage.maxTimeTowerUses : 3;
    }

    public final boolean timeTowerFull() {
        return this.currentCharges() >= this.maxCharges();
    }

    public final boolean timeTowerActive() {
        Object object = this.getProfileStorage();
        long currentTime = object != null && (object = ((ProfileSpecificStorage.ChocolateFactoryStorage)object).lastDataSave) != null ? ((SimpleTimeMark)object).unbox-impl() : SimpleTimeMark.Companion.farPast();
        long endTime = this.timeTowerEnds-uFjCsEo();
        return SimpleTimeMark.compareTo-gJLAdNM(endTime, currentTime) > 0;
    }

    private final long timeTowerEnds-uFjCsEo() {
        Object object = this.getProfileStorage();
        return object != null && (object = ((ProfileSpecificStorage.ChocolateFactoryStorage)object).currentTimeTowerEnds) != null ? ((SimpleTimeMark)object).unbox-impl() : SimpleTimeMark.Companion.farPast();
    }

    public final long timeTowerFullTimeMark-uFjCsEo() {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return SimpleTimeMark.Companion.farPast();
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        if (this.timeTowerFull()) {
            return SimpleTimeMark.Companion.farPast();
        }
        SimpleTimeMark nextChargeDuration = profileStorage.nextTimeTower;
        int remainingChargesAfter = profileStorage.maxTimeTowerUses - (profileStorage.currentTimeTowerUses + 1);
        long endTime = SimpleTimeMark.plus-qeHQSLg(nextChargeDuration.unbox-impl(), Duration.times-UwyO8pc(ChocolateFactoryAPI.INSTANCE.timeTowerChargeDuration-UwyO8pc(), remainingChargesAfter));
        return endTime;
    }

    public final long timeTowerActiveDuration-UwyO8pc() {
        if (!this.timeTowerActive()) {
            return Duration.Companion.getZERO-UwyO8pc();
        }
        Object object = this.getProfileStorage();
        long currentTime = object != null && (object = ((ProfileSpecificStorage.ChocolateFactoryStorage)object).lastDataSave) != null ? ((SimpleTimeMark)object).unbox-impl() : SimpleTimeMark.Companion.farPast();
        Object object2 = this.getProfileStorage();
        long endTime = object2 != null && (object2 = ((ProfileSpecificStorage.ChocolateFactoryStorage)object2).currentTimeTowerEnds) != null ? ((SimpleTimeMark)object2).unbox-impl() : SimpleTimeMark.Companion.farPast();
        return SimpleTimeMark.minus-I5LXd8s(endTime, currentTime);
    }

    @SubscribeEvent
    public final void onProfileChange(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastTimeTowerWarning = SimpleTimeMark.Companion.farPast();
    }

    private static final Unit onSecondPassed$lambda$0() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    private static final Unit checkTimeTowerExpired$lambda$1() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    private static final Unit checkTimeTowerWarning$lambda$2() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }
}

