/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.BazaarConfig;
import at.hannibal2.skyhanni.events.BazaarOpenedProductEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarData;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001e\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarBestSellMethod;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "event", "", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/BazaarOpenedProductEvent;", "onBazaarOpenedProduct", "(Lat/hannibal2/skyhanni/events/BazaarOpenedProductEvent;)V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "updateDisplay", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "config", "display", "Ljava/lang/String;", "Lnet/minecraft/item/ItemStack;", "lastClickedItem", "Lnet/minecraft/item/ItemStack;", "nextCloseWillResetItem", "Z", "1.8.9"})
public final class BazaarBestSellMethod {
    @NotNull
    public static final BazaarBestSellMethod INSTANCE = new BazaarBestSellMethod();
    @NotNull
    private static String display = "";
    @Nullable
    private static ItemStack lastClickedItem;
    private static boolean nextCloseWillResetItem;

    private BazaarBestSellMethod() {
    }

    private final BazaarConfig getConfig() {
        return SkyHanniMod.feature.inventory.bazaar;
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        display = "";
        if (lastClickedItem != null) {
            if (nextCloseWillResetItem) {
                lastClickedItem = null;
            }
            nextCloseWillResetItem = !nextCloseWillResetItem;
        }
    }

    @SubscribeEvent
    public final void onBazaarOpenedProduct(@NotNull BazaarOpenedProductEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        display = this.updateDisplay(event.getOpenedProduct());
    }

    private final String updateDisplay(NEUInternalName internalName) {
        if (internalName == null) {
            return "\u00a7cUnknown Bazaar item!";
        }
        int having = 0;
        having = InventoryUtils.INSTANCE.getAmountInInventory(internalName);
        ItemStack itemStack2 = lastClickedItem;
        if (itemStack2 != null) {
            ItemStack it = itemStack2;
            boolean bl = false;
            if (Intrinsics.areEqual(ItemUtils.INSTANCE.getInternalName(it), internalName)) {
                having += it.field_77994_a;
            }
        }
        if (having <= 0) {
            return "";
        }
        BazaarData data2 = BazaarApi.INSTANCE.getBazaarDataOrError(internalName);
        double totalDiff = (data2.getSellOfferPrice() - data2.getInstantBuyPrice()) * (double)having;
        String result2 = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, (int)totalDiff, false, 1, null);
        String name2 = ItemUtils.INSTANCE.getItemName(internalName);
        return name2 + "\u00a77 sell difference: \u00a76" + result2 + " coins";
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (((CharSequence)display).length() == 0) {
            return;
        }
        Position position = this.getConfig().bestSellMethodPos;
        Intrinsics.checkNotNullExpressionValue(position, "bestSellMethodPos");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, display, 0, 0, "Bazaar Best Sell Method", 6, null);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Slot slot = event.getSlot();
        lastClickedItem = slot != null ? slot.func_75211_c() : null;
        nextCloseWillResetItem = false;
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().bestSellMethod;
    }
}

