/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.inventory.HideNotClickableConfig;
import at.hannibal2.skyhanni.data.jsonobjects.repo.HideNotClickableItemsJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SalvageFilter;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.garden.composter.ComposterOverlay;
import at.hannibal2.skyhanni.features.garden.visitor.VisitorAPI;
import at.hannibal2.skyhanni.features.inventory.ShiftClickNPCSell;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.features.mining.fossilexcavator.FossilExcavatorAPI;
import at.hannibal2.skyhanni.features.rift.RiftAPI;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.MultiFilter;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b!\u0010\u001eJ\u001f\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\"\u0010\u001eJ\u001f\u0010#\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010\u001eJ\u001f\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b$\u0010\u001eJ\u001f\u0010%\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b%\u0010\u001eJ\u001f\u0010&\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b&\u0010\u001eJ\u001f\u0010'\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b'\u0010\u001eJ\u001f\u0010(\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b(\u0010\u001eJ\u001f\u0010)\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b)\u0010\u001eJ\u001f\u0010*\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b*\u0010\u001eJ\u001f\u0010+\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b+\u0010\u001eJ\u001f\u0010,\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b,\u0010\u001eJ\u001f\u0010-\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b-\u0010\u001eJ\u001f\u0010.\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b.\u0010\u001eJ\u001f\u0010/\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b/\u0010\u001eJ\u0017\u00100\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b0\u0010 J\u001f\u00101\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b1\u0010\u001eJ\u001f\u00102\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b2\u0010\u001eJ\u001f\u00103\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b3\u0010\u001eJ\u0017\u00104\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b4\u0010 J\u000f\u00105\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b5\u0010\u0018J\u0017\u00107\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000206H\u0007\u00a2\u0006\u0004\b7\u00108R\u001c\u0010=\u001a\n :*\u0004\u0018\u000109098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0016\u0010>\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010C\u001a\u00020B8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0014\u0010F\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0014\u0010H\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010GR\u001a\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00190I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0014\u0010L\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010GR\u0014\u0010M\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010GR\u001b\u0010S\u001a\u00020N8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010RR\u001b\u0010Y\u001a\u00020T8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\u00a8\u0006Z"}, d2={"Lat/hannibal2/skyhanni/features/inventory/HideNotClickableItems;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/SalvageFilter;", "data", "updateSalvageList", "(Lat/hannibal2/skyhanni/data/jsonobjects/repo/SalvageFilter;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$ForegroundDrawnEvent;", "onForegroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$ForegroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "", "bypassActive", "()Z", "", "chestName", "Lnet/minecraft/item/ItemStack;", "stack", "hide", "(Ljava/lang/String;Lnet/minecraft/item/ItemStack;)Z", "hideFossilExcavator", "(Lnet/minecraft/item/ItemStack;)Z", "hideResearchCenter", "hideRiftTransferChest", "hideRiftMotesGrubber", "hideComposter", "hideYourEquipment", "hideAttributeFusion", "hidePrivateIslandChest", "hidePotionBag", "hideFishingBag", "hideSackOfSacks", "hideAccessoryBag", "hideBasketOfSeeds", "hideNetherWartPouch", "hideTrickOrTreatBag", "hidePlayerTrade", "hideNpcSell", "hideInStorage", "hideSalvage", "hideBazaarOrAH", "isNotAuctionable", "isEnabled", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/inventory/HideNotClickableConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/HideNotClickableConfig;", "config", "hideReason", "Ljava/lang/String;", "showGreenLine", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastClickTime", "J", "Lat/hannibal2/skyhanni/utils/MultiFilter;", "hideNpcSellFilter", "Lat/hannibal2/skyhanni/utils/MultiFilter;", "hideInStorageFilter", "", "itemsToSalvage", "Ljava/util/List;", "hidePlayerTradeFilter", "notAuctionableFilter", "Ljava/util/regex/Pattern;", "seedsPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getSeedsPattern", "()Ljava/util/regex/Pattern;", "seedsPattern", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "netherWart$delegate", "Lkotlin/Lazy;", "getNetherWart", "()Lat/hannibal2/skyhanni/utils/NEUInternalName;", "netherWart", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHideNotClickableItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HideNotClickableItems.kt\nat/hannibal2/skyhanni/features/inventory/HideNotClickableItems\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,617:1\n12#2,7:618\n1557#3:625\n1628#3,3:626\n1755#3,3:629\n1755#3,3:632\n1755#3,3:635\n8#4:638\n1#5:639\n*S KotlinDebug\n*F\n+ 1 HideNotClickableItems.kt\nat/hannibal2/skyhanni/features/inventory/HideNotClickableItems\n*L\n81#1:618,7\n130#1:625\n130#1:626,3\n314#1:629,3\n375#1:632,3\n399#1:635,3\n413#1:638\n413#1:639\n*E\n"})
public final class HideNotClickableItems {
    @NotNull
    public static final HideNotClickableItems INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static String hideReason;
    private static boolean showGreenLine;
    private static long lastClickTime;
    @NotNull
    private static final MultiFilter hideNpcSellFilter;
    @NotNull
    private static final MultiFilter hideInStorageFilter;
    @NotNull
    private static final List<String> itemsToSalvage;
    @NotNull
    private static final MultiFilter hidePlayerTradeFilter;
    @NotNull
    private static final MultiFilter notAuctionableFilter;
    @NotNull
    private static final RepoPattern seedsPattern$delegate;
    @NotNull
    private static final Lazy netherWart$delegate;

    private HideNotClickableItems() {
    }

    private final HideNotClickableConfig getConfig() {
        return SkyHanniMod.feature.inventory.hideNotClickable;
    }

    private final Pattern getSeedsPattern() {
        return (Pattern)seedsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final NEUInternalName getNetherWart() {
        Lazy lazy = netherWart$delegate;
        return (NEUInternalName)lazy.getValue();
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        HideNotClickableItemsJson hideNotClickableItemsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "HideNotClickableItems";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            hideNotClickableItemsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, HideNotClickableItemsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        HideNotClickableItemsJson hideNotClickable = hideNotClickableItemsJson;
        hideNpcSellFilter.load(hideNotClickable.getHideNpcSell());
        hideInStorageFilter.load(hideNotClickable.getHideInStorage());
        hidePlayerTradeFilter.load(hideNotClickable.getHidePlayerTrade());
        notAuctionableFilter.load(hideNotClickable.getNotAuctionable());
        this.updateSalvageList(hideNotClickable.getSalvage());
    }

    private final void updateSalvageList(SalvageFilter data2) {
        itemsToSalvage.clear();
        itemsToSalvage.addAll((Collection<String>)data2.getItems());
        for (String armor : data2.getArmor()) {
            itemsToSalvage.add(armor + " Helmet");
            itemsToSalvage.add(armor + " Chestplate");
            itemsToSalvage.add(armor + " Leggings");
            itemsToSalvage.add(armor + " Boots");
        }
    }

    @SubscribeEvent
    public final void onForegroundDrawn(@NotNull GuiContainerEvent.ForegroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bypassActive()) {
            return;
        }
        if (!(event.getGui() instanceof GuiChest)) {
            return;
        }
        GuiContainer guiChest = event.getGui();
        Container container = guiChest.field_147002_h;
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest chest = (ContainerChest)container;
        String chestName = InventoryUtils.INSTANCE.getInventoryName(chest);
        for (Map.Entry<Slot, ItemStack> entry : InventoryUtils.INSTANCE.getLowerItems(chest).entrySet()) {
            Slot slot = entry.getKey();
            ItemStack stack = entry.getValue();
            if (this.hide(chestName, stack)) {
                RenderUtils.INSTANCE.highlight(slot, LorenzColor.DARK_GRAY.addOpacity(this.getConfig().opacity));
                continue;
            }
            if (!showGreenLine || !this.getConfig().itemsGreenLine) continue;
            RenderUtils.INSTANCE.drawBorder(slot, LorenzColor.GREEN.addOpacity(200));
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (this.bypassActive()) {
            return;
        }
        GuiScreen guiChest = Minecraft.func_71410_x().field_71462_r;
        if (!(guiChest instanceof GuiChest)) {
            return;
        }
        Container container = ((GuiChest)guiChest).field_147002_h;
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        String chestName = InventoryUtils.INSTANCE.getInventoryName((ContainerChest)container);
        ItemStack stack = event.getItemStack();
        Iterable $this$map$iv = InventoryUtils.INSTANCE.getItemsInOpenChest();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Slot slot = (Slot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.func_75211_c());
        }
        if (((List)destination$iv$iv).contains(stack)) {
            return;
        }
        if (!ItemUtils.getItemsInInventory$default(ItemUtils.INSTANCE, false, 1, null).contains(stack)) {
            return;
        }
        if (this.hide(chestName, stack)) {
            String first2 = event.getToolTip().get(0);
            event.getToolTip().clear();
            event.getToolTip().add("\u00a77" + StringUtils.removeColor$default(StringUtils.INSTANCE, first2, false, 1, null));
            event.getToolTip().add("");
            if (Intrinsics.areEqual(hideReason, "")) {
                event.getToolTip().add("\u00a74No hide reason!");
                ErrorManager.INSTANCE.skyHanniError("No hide reason for not clickable item!", new Pair[0]);
                throw new KotlinNothingValueException();
            }
            event.getToolTip().add("\u00a7c" + hideReason);
            if (this.getConfig().itemsBypass && !StringsKt.contains$default((CharSequence)hideReason, "SkyBlock Menu", false, 2, null)) {
                event.getToolTip().add("  \u00a77(Bypass by holding the " + KeyboardManager.INSTANCE.getModifierKeyName() + " key)");
            }
        }
    }

    @SubscribeEvent
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().itemsBlockClicks) {
            return;
        }
        if (this.bypassActive()) {
            return;
        }
        if (!(event.getGui() instanceof GuiChest)) {
            return;
        }
        String chestName = InventoryUtils.INSTANCE.openInventoryName();
        Slot slot = event.getSlot();
        if (slot == null) {
            return;
        }
        Slot slot2 = slot;
        if (slot2.field_75222_d == slot2.getSlotIndex()) {
            return;
        }
        if (slot2.func_75211_c() == null) {
            return;
        }
        ItemStack stack = slot2.func_75211_c();
        Intrinsics.checkNotNull(stack);
        if (this.hide(chestName, stack)) {
            event.cancel();
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastClickTime), DurationKt.toDuration(5, DurationUnit.SECONDS)) > 0) {
                lastClickTime = SimpleTimeMark.Companion.now-uFjCsEo();
            }
            return;
        }
    }

    private final boolean bypassActive() {
        return this.getConfig().itemsBypass && KeyboardManager.INSTANCE.isModifierKeyDown();
    }

    private final boolean hide(String chestName, ItemStack stack) {
        hideReason = "";
        showGreenLine = false;
        return this.hideNpcSell(stack) ? true : (this.hideInStorage(chestName, stack) ? true : (this.hideSalvage(chestName, stack) ? true : (this.hidePlayerTrade(chestName, stack) ? true : (this.hideBazaarOrAH(chestName, stack) ? true : (this.hideAccessoryBag(chestName, stack) ? true : (this.hideBasketOfSeeds(chestName, stack) ? true : (this.hideNetherWartPouch(chestName, stack) ? true : (this.hideTrickOrTreatBag(chestName, stack) ? true : (this.hideSackOfSacks(chestName, stack) ? true : (this.hideFishingBag(chestName, stack) ? true : (this.hidePotionBag(chestName, stack) ? true : (this.hidePrivateIslandChest(chestName, stack) ? true : (this.hideAttributeFusion(chestName, stack) ? true : (this.hideYourEquipment(chestName, stack) ? true : (this.hideComposter(chestName, stack) ? true : (this.hideRiftMotesGrubber(chestName, stack) ? true : (this.hideRiftTransferChest(chestName, stack) ? true : (this.hideFossilExcavator(stack) ? true : this.hideResearchCenter(chestName, stack)))))))))))))))))));
    }

    private final boolean hideFossilExcavator(ItemStack stack) {
        if (!FossilExcavatorAPI.INSTANCE.getInExcavatorMenu()) {
            return false;
        }
        showGreenLine = true;
        NEUInternalName nEUInternalName = ItemUtils.INSTANCE.getInternalNameOrNull(stack);
        if (nEUInternalName == null) {
            return true;
        }
        NEUInternalName internalName = nEUInternalName;
        if (Intrinsics.areEqual(internalName, FossilExcavatorAPI.INSTANCE.getScrapItem())) {
            return false;
        }
        ItemCategory itemCategory = ItemUtils.INSTANCE.getItemCategoryOrNull(stack);
        if (itemCategory == null) {
            return true;
        }
        ItemCategory category = itemCategory;
        if (category == ItemCategory.CHISEL) {
            return false;
        }
        hideReason = "\u00a7cNot a chisel or scrap!";
        return true;
    }

    private final boolean hideResearchCenter(String chestName, ItemStack stack) {
        if (!Intrinsics.areEqual(chestName, "Research Center")) {
            return false;
        }
        showGreenLine = true;
        NEUInternalName nEUInternalName = ItemUtils.INSTANCE.getInternalNameOrNull(stack);
        if (nEUInternalName == null) {
            return false;
        }
        NEUInternalName internalName = nEUInternalName;
        List<NEUInternalName> list = CollectionsKt.listOf(NEUInternalName.Companion.asInternalName("HELIX"));
        if (list.contains(internalName)) {
            return false;
        }
        if (internalName.endsWith("_FOSSIL")) {
            return false;
        }
        hideReason = "\u00a7cNot a fossil!";
        return true;
    }

    private final boolean hideRiftTransferChest(String chestName, ItemStack stack) {
        if (!Intrinsics.areEqual(chestName, "Rift Transfer Chest")) {
            return false;
        }
        showGreenLine = true;
        Boolean bl = SkyBlockItemModifierUtils.INSTANCE.isRiftTransferable(stack);
        if (bl == null) {
            return true;
        }
        boolean riftTransferable = bl;
        if (riftTransferable) {
            return false;
        }
        if (RiftAPI.INSTANCE.inRift()) {
            Boolean bl2 = SkyBlockItemModifierUtils.INSTANCE.isRiftExportable(stack);
            if (bl2 == null) {
                return true;
            }
            boolean riftExportable = bl2;
            if (riftExportable) {
                return false;
            }
        }
        hideReason = "Not Rift-Transferable!";
        return true;
    }

    private final boolean hideRiftMotesGrubber(String chestName, ItemStack stack) {
        if (!RiftAPI.INSTANCE.inRift()) {
            return false;
        }
        if (!Intrinsics.areEqual(chestName, "Motes Grubber") && !ShiftClickNPCSell.INSTANCE.getInInventory()) {
            return false;
        }
        showGreenLine = true;
        if (RiftAPI.INSTANCE.motesNpcPrice(stack) != null) {
            return false;
        }
        hideReason = "Not sellable for Motes!";
        return true;
    }

    private final boolean hideComposter(String chestName, ItemStack stack) {
        if (!ComposterOverlay.INSTANCE.getInInventory()) {
            return false;
        }
        showGreenLine = true;
        NEUInternalName internalName = ItemUtils.INSTANCE.getInternalName(stack);
        if (Intrinsics.areEqual(internalName, ComposterOverlay.INSTANCE.getCurrentOrganicMatterItem())) {
            return false;
        }
        if (Intrinsics.areEqual(internalName, ComposterOverlay.INSTANCE.getCurrentFuelItem())) {
            return false;
        }
        hideReason = "Only insert the selected items!";
        return true;
    }

    private final boolean hideYourEquipment(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "Your Equipment", false, 2, null)) {
            return false;
        }
        String[] stringArray = new String[]{"HELMET", "CARNIVAL MASK", "CHESTPLATE", "LEGGINGS", "BOOTS", "NECKLACE", "CLOAK", "BELT", "GLOVES", "BRACELET"};
        List<String> list = CollectionsKt.listOf(stringArray);
        for (String type2 : list) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(StringsKt.contains$default((CharSequence)it, "\u00a7l", false, 2, null) && StringsKt.contains$default((CharSequence)it, type2, false, 2, null))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            showGreenLine = true;
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be put into your equipment!";
            return true;
        }
        hideReason = "This item cannot be put into your equipment!";
        return true;
    }

    private final boolean hideAttributeFusion(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "Attribute Fusion", false, 2, null)) {
            return false;
        }
        showGreenLine = true;
        if (SkyBlockItemModifierUtils.INSTANCE.hasAttributes(stack)) {
            return false;
        }
        hideReason = "This item has no attributes!";
        return true;
    }

    private final boolean hidePrivateIslandChest(String chestName, ItemStack stack) {
        if (!Intrinsics.areEqual(chestName, "Chest") && !Intrinsics.areEqual(chestName, "Large Chest")) {
            return false;
        }
        if (!ItemUtils.INSTANCE.isSoulBound(stack)) {
            return false;
        }
        hideReason = "This item cannot be stored into a chest!";
        return true;
    }

    private final boolean hidePotionBag(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "Potion Bag", false, 2, null)) {
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be put into the potion bag!";
            return true;
        }
        showGreenLine = true;
        if (StringsKt.endsWith$default(ItemUtils.INSTANCE.cleanName(stack), " Potion", false, 2, null) || Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(stack), "Water Bottle")) {
            return false;
        }
        hideReason = "This item is not a potion!";
        return true;
    }

    private final boolean hideFishingBag(String chestName, ItemStack stack) {
        boolean bl;
        block6: {
            if (!StringsKt.startsWith$default(chestName, "Fishing Bag", false, 2, null)) {
                return false;
            }
            if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
                hideReason = "The SkyBlock Menu cannot be put into the fishing bag!";
                return true;
            }
            showGreenLine = true;
            Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, it, false, 1, null), "Fishing Bait")) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        hideReason = "This item is not a fishing bait!";
        return true;
    }

    private final boolean hideSackOfSacks(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "Sack of Sacks", false, 2, null)) {
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            return false;
        }
        showGreenLine = true;
        if (ItemUtils.INSTANCE.isSack(stack)) {
            return false;
        }
        hideReason = "This item is not a sack!";
        return true;
    }

    private final boolean hideAccessoryBag(String chestName, ItemStack stack) {
        boolean bl;
        block6: {
            if (!StringsKt.startsWith$default(chestName, "Accessory Bag", false, 2, null) && !StringsKt.startsWith$default(chestName, "Accessory Bag (", false, 2, null)) {
                return false;
            }
            if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
                return false;
            }
            showGreenLine = true;
            Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.contains$default((CharSequence)it, "ACCESSORY", false, 2, null) || StringsKt.contains$default((CharSequence)it, "HATCESSORY", false, 2, null))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        hideReason = "This item is not an accessory!";
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hideBasketOfSeeds(String chestName, ItemStack stack) {
        void $this$matchMatcher$iv;
        if (!StringsKt.startsWith$default(chestName, "Basket of Seeds", false, 2, null)) {
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be put into the basket of seeds!";
            return true;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getSeedsPattern();
        String text$iv = ItemUtils.INSTANCE.getInternalName(stack).asString();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$hideBasketOfSeeds_u24lambda_u245 = it$iv;
            boolean bl2 = false;
            return false;
        }
        hideReason = "This item is not a seed!";
        return true;
    }

    private final boolean hideNetherWartPouch(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "Nether Wart Pouch", false, 2, null)) {
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be put into the nether wart pouch!";
            return true;
        }
        if (Intrinsics.areEqual(ItemUtils.INSTANCE.getInternalName(stack), this.getNetherWart())) {
            return false;
        }
        hideReason = "This item is not a nether wart!";
        return true;
    }

    private final boolean hideTrickOrTreatBag(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "Trick or Treat Bag", false, 2, null)) {
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be put into the trick or treat bag!";
            return true;
        }
        if (Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(stack), "Green Candy") || Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(stack), "Purple Candy") || Intrinsics.areEqual(ItemUtils.INSTANCE.cleanName(stack), "Dark Candy")) {
            return false;
        }
        hideReason = "This item is not a spooky candy!";
        return true;
    }

    private final boolean hidePlayerTrade(String chestName, ItemStack stack) {
        if (!StringsKt.startsWith$default(chestName, "You    ", false, 2, null)) {
            return false;
        }
        if (ItemUtils.INSTANCE.isCoopSoulBound(stack)) {
            hideReason = "Soulbound items cannot be traded!";
            return true;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be traded!";
            return true;
        }
        String name2 = ItemUtils.INSTANCE.cleanName(stack);
        if (ItemUtils.INSTANCE.isSack(stack)) {
            hideReason = "Sacks cannot be traded!";
            return true;
        }
        boolean result2 = hidePlayerTradeFilter.match(name2);
        if (result2) {
            hideReason = "This item cannot be traded!";
        }
        return result2;
    }

    private final boolean hideNpcSell(ItemStack stack) {
        if (RiftAPI.INSTANCE.inRift()) {
            return false;
        }
        if (!ShiftClickNPCSell.INSTANCE.getInInventory()) {
            return false;
        }
        if (VisitorAPI.INSTANCE.getInInventory()) {
            return false;
        }
        showGreenLine = true;
        String name2 = ItemUtils.INSTANCE.cleanName(stack);
        int size = stack.field_77994_a;
        String amountText = " x" + size;
        if (StringsKt.endsWith$default(name2, amountText, false, 2, null)) {
            String string2 = name2.substring(0, name2.length() - amountText.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            name2 = string2;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be sold at the NPC!";
            return true;
        }
        if (!ItemUtils.INSTANCE.isRecombobulated(stack)) {
            if (LorenzUtils.INSTANCE.getNoTradeMode() && BazaarApi.INSTANCE.isBazaarItem(stack)) {
                return false;
            }
            if (hideNpcSellFilter.match(name2)) {
                return false;
            }
            if (ItemUtils.INSTANCE.isVanilla(stack) && !ItemUtils.INSTANCE.isEnchanted(stack)) {
                return false;
            }
        }
        hideReason = "This item should not be sold at the NPC!";
        return true;
    }

    private final boolean hideInStorage(String chestName, ItemStack stack) {
        if (!(StringsKt.contains$default((CharSequence)chestName, "Ender Chest", false, 2, null) || StringsKt.contains$default((CharSequence)chestName, "Backpack", false, 2, null) || Intrinsics.areEqual(chestName, "Storage"))) {
            return false;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be put into the storage!";
            return true;
        }
        String name2 = ItemUtils.INSTANCE.cleanName(stack);
        boolean result2 = hideInStorageFilter.match(name2);
        if (result2) {
            hideReason = "Bags cannot be put into the storage!";
        }
        return result2;
    }

    private final boolean hideSalvage(String chestName, ItemStack stack) {
        String[] stringArray = new String[]{"Salvage Item", "Salvage Items"};
        if (!CollectionUtils.equalsOneOf(chestName, stringArray)) {
            return false;
        }
        showGreenLine = true;
        if (ItemUtils.INSTANCE.isRecombobulated(stack)) {
            hideReason = "This item should not be salvaged! (Recombobulated)";
            return true;
        }
        for (String line : ItemUtils.INSTANCE.getLore(stack)) {
            if (!StringsKt.contains$default((CharSequence)line, "LEGENDARY DUNGEON", false, 2, null)) continue;
            hideReason = "This item should not be salvaged! (Legendary)";
            return true;
        }
        if (SkyBlockItemModifierUtils.INSTANCE.isMuseumDonated(stack)) {
            hideReason = "This item cannot be salvaged! (Donated to Museum)";
            return true;
        }
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            hideReason = "The SkyBlock Menu cannot be salvaged!";
            return true;
        }
        String name2 = ItemUtils.INSTANCE.cleanName(stack);
        for (String item : itemsToSalvage) {
            if (!StringsKt.endsWith$default(name2, item, false, 2, null)) continue;
            return false;
        }
        hideReason = "This item cannot be salvaged!";
        return true;
    }

    private final boolean hideBazaarOrAH(String chestName, ItemStack stack) {
        boolean auctionHouseInventory;
        boolean bazaarInventory = BazaarApi.INSTANCE.getInBazaarInventory();
        boolean bl = auctionHouseInventory = Intrinsics.areEqual(chestName, "Co-op Auction House") || Intrinsics.areEqual(chestName, "Auction House") || Intrinsics.areEqual(chestName, "Create BIN Auction") || Intrinsics.areEqual(chestName, "Create Auction");
        if (!bazaarInventory && !auctionHouseInventory) {
            return false;
        }
        showGreenLine = true;
        if (ItemUtils.INSTANCE.isSkyBlockMenuItem(stack)) {
            if (bazaarInventory) {
                hideReason = "The SkyBlock Menu is not a Bazaar Product!";
            }
            if (auctionHouseInventory) {
                hideReason = "The SkyBlock Menu cannot be auctioned!";
            }
            return true;
        }
        if (bazaarInventory != BazaarApi.INSTANCE.isBazaarItem(stack)) {
            if (bazaarInventory) {
                hideReason = "This item is not a Bazaar Product!";
            }
            if (auctionHouseInventory) {
                hideReason = "Bazaar Products cannot be auctioned!";
            }
            return true;
        }
        return this.isNotAuctionable(stack);
    }

    private final boolean isNotAuctionable(ItemStack stack) {
        if (ItemUtils.INSTANCE.isCoopSoulBound(stack)) {
            hideReason = "Soulbound items cannot be auctioned!";
            return true;
        }
        String name2 = ItemUtils.INSTANCE.cleanName(stack);
        if (ItemUtils.INSTANCE.isSack(stack)) {
            hideReason = "Sacks cannot be auctioned!";
            return true;
        }
        boolean result2 = notAuctionableFilter.match(name2);
        if (result2) {
            hideReason = "This item cannot be auctioned!";
        }
        return result2;
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().items;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "inventory.hideNotClickableItems", "inventory.hideNotClickable.items", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "inventory.hideNotClickableItemsBlockClicks", "inventory.hideNotClickable.itemsBlockClicks", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "inventory.hideNotClickableOpacity", "inventory.hideNotClickable.opacity", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "inventory.notClickableItemsBypass", "inventory.hideNotClickable.itemsBypass", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "inventory.hideNotClickableItemsGreenLine", "inventory.hideNotClickable.itemsGreenLine", null, 8, null);
    }

    private static final NEUInternalName netherWart_delegate$lambda$0() {
        return NEUInternalName.Companion.asInternalName("NETHER_STALK");
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(HideNotClickableItems.class, "seedsPattern", "getSeedsPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HideNotClickableItems();
        hideReason = "";
        lastClickTime = SimpleTimeMark.Companion.farPast();
        hideNpcSellFilter = new MultiFilter();
        hideInStorageFilter = new MultiFilter();
        itemsToSalvage = new ArrayList();
        hidePlayerTradeFilter = new MultiFilter();
        notAuctionableFilter = new MultiFilter();
        seedsPattern$delegate = RepoPattern.Companion.pattern("inventory.hidenotclickable.seeds", "SEEDS|CARROT_ITEM|POTATO_ITEM|PUMPKIN_SEEDS|SUGAR_CANE|MELON_SEEDS|CACTUS|INK_SACK-3");
        netherWart$delegate = LazyKt.lazy(HideNotClickableItems::netherWart_delegate$lambda$0);
    }
}

