/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.gui.quiver;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.combat.QuiverConfig;
import at.hannibal2.skyhanni.data.ArrowType;
import at.hannibal2.skyhanni.data.QuiverAPI;
import at.hannibal2.skyhanni.data.TitleManager;
import at.hannibal2.skyhanni.events.DungeonCompleteEvent;
import at.hannibal2.skyhanni.events.KuudraCompleteEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.QuiverUpdateEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u001d\u0010\u0010\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!R\u001c\u0010&\u001a\n #*\u0004\u0018\u00010\"0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/gui/quiver/QuiverWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DungeonCompleteEvent;", "event", "", "onDungeonComplete", "(Lat/hannibal2/skyhanni/events/DungeonCompleteEvent;)V", "Lat/hannibal2/skyhanni/events/KuudraCompleteEvent;", "onKuudraComplete", "(Lat/hannibal2/skyhanni/events/KuudraCompleteEvent;)V", "onInstanceComplete", "", "Lat/hannibal2/skyhanni/data/ArrowType;", "arrows", "instanceAlert", "(Ljava/util/Set;)V", "", "amount", "lowQuiverAlert", "(I)V", "Lat/hannibal2/skyhanni/events/QuiverUpdateEvent;", "onQuiverUpdate", "(Lat/hannibal2/skyhanni/events/QuiverUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldSwitch", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "", "inInstance", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/combat/QuiverConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/QuiverConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastLowQuiverReminder", "J", "", "arrowsInInstance", "Ljava/util/Set;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nQuiverWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuiverWarning.kt\nat/hannibal2/skyhanni/features/gui/quiver/QuiverWarning\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n774#2:101\n865#2,2:102\n1557#2:104\n1628#2,3:105\n*S KotlinDebug\n*F\n+ 1 QuiverWarning.kt\nat/hannibal2/skyhanni/features/gui/quiver/QuiverWarning\n*L\n48#1:101\n48#1:102,2\n58#1:104\n58#1:105,3\n*E\n"})
public final class QuiverWarning {
    @NotNull
    public static final QuiverWarning INSTANCE = new QuiverWarning();
    private static long lastLowQuiverReminder = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static Set<ArrowType> arrowsInInstance = new LinkedHashSet();

    private QuiverWarning() {
    }

    private final QuiverConfig getConfig() {
        return SkyHanniMod.feature.combat.quiverConfig;
    }

    @SubscribeEvent
    public final void onDungeonComplete(@NotNull DungeonCompleteEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.onInstanceComplete();
    }

    @SubscribeEvent
    public final void onKuudraComplete(@NotNull KuudraCompleteEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.onInstanceComplete();
    }

    /*
     * WARNING - void declaration
     */
    private final void onInstanceComplete() {
        void $this$filterTo$iv$iv;
        Set<ArrowType> arrows = arrowsInInstance;
        arrowsInInstance.clear();
        Iterable $this$filter$iv = arrows;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ArrowType it = (ArrowType)element$iv$iv;
            boolean bl = false;
            if (!(QuiverAPI.INSTANCE.getAmount(it) <= QuiverWarning.INSTANCE.getConfig().lowQuiverAmount)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        if (!((Collection)arrows).isEmpty() && this.getConfig().reminderAfterRun) {
            DelayedRun.INSTANCE.runNextTick(() -> QuiverWarning.onInstanceComplete$lambda$1(arrows));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void instanceAlert(Set<ArrowType> arrows) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = arrows;
        StringUtils stringUtils = StringUtils.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void arrowType;
            ArrowType arrowType2 = (ArrowType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = NEUItems.INSTANCE.getItemStackOrNull(arrowType.getInternalName());
            if (object == null || (object = ItemUtils.INSTANCE.getItemRarityOrNull((ItemStack)object)) == null || (object = ((LorenzRarity)((Object)object)).getChatColorCode()) == null) {
                object = "\u00a7f";
            }
            Object rarity = object;
            collection.add((String)rarity + arrowType.getArrow());
        }
        String arrowsText = StringUtils.createCommaSeparatedList$default(stringUtils, (List)destination$iv$iv, null, 1, null);
        TitleManager.INSTANCE.sendTitle-dWUq8MI("\u00a7cLow on arrows!", DurationKt.toDuration(5, DurationUnit.SECONDS), 3.6, 7.0f);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Low on " + arrowsText + '!', false, null, 6, null);
        SoundUtils.INSTANCE.repeatSound(100L, 30, SoundUtils.INSTANCE.getPlingSound());
    }

    private final void lowQuiverAlert(int amount) {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastLowQuiverReminder), DurationKt.toDuration(30, DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastLowQuiverReminder = SimpleTimeMark.Companion.now-uFjCsEo();
        TitleManager.INSTANCE.sendTitle-dWUq8MI("\u00a7cLow on arrows!", DurationKt.toDuration(5, DurationUnit.SECONDS), 3.6, 7.0f);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Low on arrows \u00a7e(" + NumberUtil.INSTANCE.addSeparators(amount) + " left)", false, null, 6, null);
    }

    @SubscribeEvent
    public final void onQuiverUpdate(@NotNull QuiverUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        int amount = event.getCurrentAmount();
        ArrowType arrowType = event.getCurrentArrow();
        if (arrowType == null) {
            return;
        }
        ArrowType arrow = arrowType;
        if (Intrinsics.areEqual(arrow, QuiverAPI.INSTANCE.getNONE_ARROW_TYPE())) {
            return;
        }
        if (this.inInstance()) {
            arrowsInInstance.add(arrow);
        }
        if (amount > this.getConfig().lowQuiverAmount) {
            return;
        }
        if (this.getConfig().lowQuiverNotification) {
            this.lowQuiverAlert(amount);
        }
    }

    @SubscribeEvent
    public final void onWorldSwitch(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        arrowsInInstance.clear();
    }

    private final boolean inInstance() {
        return DungeonAPI.INSTANCE.inDungeon() || KuudraAPI.INSTANCE.inKuudra();
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 35, "inventory.quiverAlert", "combat.quiverConfig.lowQuiverNotification", null, 8, null);
    }

    private static final Unit onInstanceComplete$lambda$1(Set $arrows) {
        Intrinsics.checkNotNullParameter($arrows, "$arrows");
        INSTANCE.instanceAlert($arrows);
        return Unit.INSTANCE;
    }
}

