/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.visitor;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.visitor.VisitorConfig;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenVisitor;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.visitor.HighlightVisitorsOutsideOfGarden$isVisitorNearby$;
import at.hannibal2.skyhanni.features.garden.visitor.HighlightVisitorsOutsideOfGarden$onSecondPassed$;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C02PacketUseEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aR*\u0010\u001e\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001c\u0010$\u001a\n !*\u0004\u0018\u00010 0 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/features/garden/visitor/HighlightVisitorsOutsideOfGarden;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lnet/minecraft/entity/Entity;", "entity", "", "getSkinOrTypeFor", "(Lnet/minecraft/entity/Entity;)Ljava/lang/String;", "", "isVisitor", "(Lnet/minecraft/entity/Entity;)Z", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "isVisitorNearby", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;", "onClickEntity", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;)V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/GardenVisitor;", "visitorJson", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/config/features/garden/visitor/VisitorConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/visitor/VisitorConfig;", "config", "getShouldBlock", "()Z", "shouldBlock", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHighlightVisitorsOutsideOfGarden.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightVisitorsOutsideOfGarden.kt\nat/hannibal2/skyhanni/features/garden/visitor/HighlightVisitorsOutsideOfGarden\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,110:1\n12#2,7:111\n1485#3:118\n1510#3,3:119\n1513#3,3:129\n1755#3,3:132\n381#4,7:122\n172#5:135\n144#5:139\n172#5:140\n477#6:136\n1317#6,2:137\n477#6:141\n1251#6,2:142\n*S KotlinDebug\n*F\n+ 1 HighlightVisitorsOutsideOfGarden.kt\nat/hannibal2/skyhanni/features/garden/visitor/HighlightVisitorsOutsideOfGarden\n*L\n40#1:111,7\n42#1:118\n42#1:119,3\n42#1:129,3\n64#1:132,3\n42#1:122,7\n74#1:135\n90#1:139\n90#1:140\n74#1:136\n76#1:137,2\n90#1:141\n90#1:142,2\n*E\n"})
public final class HighlightVisitorsOutsideOfGarden {
    @NotNull
    public static final HighlightVisitorsOutsideOfGarden INSTANCE = new HighlightVisitorsOutsideOfGarden();
    @NotNull
    private static Map<String, ? extends List<GardenVisitor>> visitorJson = MapsKt.emptyMap();

    private HighlightVisitorsOutsideOfGarden() {
    }

    private final VisitorConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().visitors;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        void $this$groupByTo$iv$iv;
        GardenJson gardenJson;
        void constant$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String string2 = "Garden";
        Type type2 = (Type)((Object)GardenJson.class);
        Object gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant((String)constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            gardenJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), (String)constant$iv, (Gson)gson$iv, GardenJson.class, type2);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + (String)constant$iv + '\'', e$iv);
        }
        Iterable $this$groupBy$iv = gardenJson.getVisitors().values();
        boolean bl = false;
        gson$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GardenVisitor it = (GardenVisitor)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = it.getMode();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        visitorJson = destination$iv$iv;
        for (List list : visitorJson.values()) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                GardenVisitor visitor2;
                String string3 = (visitor2 = (GardenVisitor)iterator2.next()).getSkinOrType();
                visitor2.setSkinOrType(string3 != null && (string3 = StringsKt.replace$default(string3, "\\n", "", false, 4, null)) != null ? StringsKt.replace$default(string3, "\n", "", false, 4, null) : null);
            }
        }
    }

    private final String getSkinOrTypeFor(Entity entity) {
        if (entity instanceof EntityPlayer) {
            String string2 = EntityUtils.INSTANCE.getSkinTexture((EntityPlayer)entity);
            if (string2 == null) {
                string2 = "no skin";
            }
            return string2;
        }
        String string3 = entity.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string3, "getSimpleName(...)");
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isVisitor(Entity entity) {
        boolean bl;
        String mode = HypixelData.INSTANCE.getMode();
        List<GardenVisitor> list = visitorJson.get(mode);
        if (list == null) {
            return false;
        }
        List<GardenVisitor> possibleJsons = list;
        String skinOrType = this.getSkinOrTypeFor(entity);
        Iterable $this$any$iv = possibleJsons;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            block8: {
                GardenVisitor it;
                block7: {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    it = (GardenVisitor)element$iv;
                    boolean bl2 = false;
                    if (it.getPosition() == null) break block7;
                    LorenzVec lorenzVec = it.getPosition();
                    BlockPos blockPos = entity.func_180425_c();
                    Intrinsics.checkNotNullExpressionValue(blockPos, "getPosition(...)");
                    if (!(lorenzVec.distance(LorenzVecKt.toLorenzVec(blockPos)) < 1.0)) break block8;
                }
                if (Intrinsics.areEqual(it.getSkinOrType(), skinOrType)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.getConfig().highlightVisitors) {
            return;
        }
        int color = ColorUtils.INSTANCE.withAlpha(LorenzColor.DARK_RED.toColor(), 50);
        EntityUtils this_$iv = EntityUtils.INSTANCE;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, onSecondPassed$$inlined$getEntities$1.INSTANCE);
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence<EntityLivingBase> $this$forEach$iv = SequencesKt.filter(sequence, HighlightVisitorsOutsideOfGarden::onSecondPassed$lambda$2);
        boolean $i$f$forEach = false;
        Iterator<EntityLivingBase> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            EntityLivingBase element$iv;
            EntityLivingBase it = element$iv = iterator2.next();
            boolean bl = false;
            RenderLivingEntityHelper.INSTANCE.setEntityColor(it, color, HighlightVisitorsOutsideOfGarden::onSecondPassed$lambda$4$lambda$3);
        }
    }

    private final boolean getShouldBlock() {
        boolean bl;
        VisitorConfig.VisitorBlockBehaviour visitorBlockBehaviour = this.getConfig().blockInteracting;
        switch (visitorBlockBehaviour == null ? -1 : WhenMappings.$EnumSwitchMapping$0[visitorBlockBehaviour.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = LorenzUtils.INSTANCE.isBingoProfile();
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isVisitorNearby(LorenzVec location) {
        boolean bl;
        block1: {
            void this_$iv;
            EntityUtils entityUtils = EntityUtils.INSTANCE;
            double radius$iv = 2.0;
            boolean $i$f$getEntitiesNearby = false;
            void this_$iv$iv = this_$iv;
            boolean $i$f$getEntities = false;
            Sequence<Entity> $this$filterIsInstance$iv$iv$iv = this_$iv$iv.getAllEntities();
            boolean $i$f$filterIsInstance = false;
            Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv$iv, isVisitorNearby$$inlined$getEntitiesNearby$1.INSTANCE);
            Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence<Entity> $this$any$iv = SequencesKt.filter(sequence, (Function1)new Function1<EntityLivingBase, Boolean>(location, radius$iv){
                final /* synthetic */ LorenzVec $location;
                final /* synthetic */ double $radius;
                {
                    this.$location = $location;
                    this.$radius = $radius;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Entity it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius;
                }
            });
            boolean $i$f$any = false;
            Iterator<Entity> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Entity element$iv = iterator2.next();
                EntityLivingBase it = (EntityLivingBase)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.isVisitor((Entity)it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onClickEntity(@NotNull PacketSentEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getShouldBlock()) {
            return;
        }
        WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
        if (worldClient == null) {
            return;
        }
        WorldClient world = worldClient;
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        EntityPlayerSP player = entityPlayerSP;
        if (player.func_70093_af()) {
            return;
        }
        Packet<?> packet = event.getPacket();
        C02PacketUseEntity c02PacketUseEntity = packet instanceof C02PacketUseEntity ? (C02PacketUseEntity)packet : null;
        if (c02PacketUseEntity == null) {
            return;
        }
        C02PacketUseEntity packet2 = c02PacketUseEntity;
        Entity entity = packet2.func_149564_a((World)world);
        if (entity == null) {
            return;
        }
        Entity entity2 = entity;
        if (this.isVisitor(entity2) || entity2 instanceof EntityArmorStand && this.isVisitorNearby(LorenzVecKt.getLorenzVec(entity2))) {
            event.cancel();
            if (packet2.func_149565_c() == C02PacketUseEntity.Action.INTERACT) {
                ChatUtils.INSTANCE.chatAndOpenConfig("Blocked you from interacting with a visitor. Sneak to bypass or click here to change settings.", new MutablePropertyReference0Impl(GardenAPI.INSTANCE.getConfig().visitors){

                    public Object get() {
                        return ((VisitorConfig)this.receiver).blockInteracting;
                    }

                    public void set(Object value) {
                        ((VisitorConfig)this.receiver).blockInteracting = (VisitorConfig.VisitorBlockBehaviour)((Object)value);
                    }
                });
            }
        }
    }

    private static final boolean onSecondPassed$lambda$2(EntityLivingBase it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !(it instanceof EntityArmorStand) && INSTANCE.isVisitor((Entity)it);
    }

    private static final boolean onSecondPassed$lambda$4$lambda$3() {
        return HighlightVisitorsOutsideOfGarden.INSTANCE.getConfig().highlightVisitors;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VisitorConfig.VisitorBlockBehaviour.values().length];
            try {
                nArray[VisitorConfig.VisitorBlockBehaviour.DONT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorConfig.VisitorBlockBehaviour.ALWAYS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorConfig.VisitorBlockBehaviour.ONLY_ON_BINGO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

