/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.pests.PestFinderConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzKeyPressEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.garden.pests.PestUpdateEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.GardenPlotAPI;
import at.hannibal2.skyhanni.features.garden.pests.PestAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0006\u00a2\u0006\u0004\b#\u0010\u0003J\r\u0010%\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&R\u001c\u0010+\u001a\n (*\u0004\u0018\u00010'0'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001b\u00103\u001a\u00020.8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestFinder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/pests/PestUpdateEvent;", "event", "", "onPestUpdate", "(Lat/hannibal2/skyhanni/events/garden/pests/PestUpdateEvent;)V", "update", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawDisplay", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/features/garden/GardenPlotAPI$Plot;", "plot", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "playerLocation", "drawName", "(Lat/hannibal2/skyhanni/features/garden/GardenPlotAPI$Plot;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzKeyPressEvent;", "onKeyClick", "(Lat/hannibal2/skyhanni/events/LorenzKeyPressEvent;)V", "teleportNearestInfestedPlot", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestFinderConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestFinderConfig;", "config", "display", "Ljava/util/List;", "Ljava/util/regex/Pattern;", "noPestsChatPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getNoPestsChatPattern", "()Ljava/util/regex/Pattern;", "noPestsChatPattern", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastKeyPress", "J", "1.8.9"})
public final class PestFinder {
    @NotNull
    public static final PestFinder INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static List<? extends Renderable> display;
    @NotNull
    private static final RepoPattern noPestsChatPattern$delegate;
    private static long lastKeyPress;

    private PestFinder() {
    }

    private final PestFinderConfig getConfig() {
        return PestAPI.INSTANCE.getConfig().pestFinder;
    }

    @NotNull
    public final Pattern getNoPestsChatPattern() {
        return (Pattern)noPestsChatPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @HandleEvent
    public final void onPestUpdate(@NotNull PestUpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.update();
    }

    private final void update() {
        if (this.isEnabled()) {
            display = this.drawDisplay();
        }
    }

    private final List<Renderable> drawDisplay() {
        List<Renderable> list;
        List<Renderable> $this$drawDisplay_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$drawDisplay_u24lambda_u242.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a76Total pests: \u00a7e" + PestAPI.INSTANCE.getScoreboardPests() + "\u00a76/\u00a7e8", 0.0, null, null, null, 30, null));
        for (GardenPlotAPI.Plot plot : PestAPI.INSTANCE.getInfestedPlots()) {
            int pests = GardenPlotAPI.INSTANCE.getPests(plot);
            String plotName = GardenPlotAPI.INSTANCE.getName(plot);
            boolean isInaccurate = GardenPlotAPI.INSTANCE.isPestCountInaccurate(plot);
            String pestsName = StringUtils.pluralize$default(StringUtils.INSTANCE, pests, "pest", null, false, 12, null);
            String name2 = "\u00a7e" + (isInaccurate ? "1+?" : Integer.valueOf(pests)) + " \u00a7c" + pestsName + " \u00a77in \u00a7b" + plotName;
            String[] stringArray = new String[]{"\u00a77Pests Found: \u00a7e" + (isInaccurate ? "Unknown" : Integer.valueOf(pests)), "\u00a77In plot \u00a7b" + plotName, "", "\u00a7eClick here to warp!"};
            Renderable renderable2 = Renderable.Companion.clickAndHover$default(Renderable.Companion, name2, CollectionsKt.listOf(stringArray), false, () -> PestFinder.drawDisplay$lambda$2$lambda$0(plot), null, 20, null);
            $this$drawDisplay_u24lambda_u242.add(renderable2);
        }
        if (PestAPI.INSTANCE.getInfestedPlots().isEmpty() && PestAPI.INSTANCE.getScoreboardPests() != 0) {
            $this$drawDisplay_u24lambda_u242.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7e" + PestAPI.INSTANCE.getScoreboardPests() + " \u00a76Bugged pests!", 0.0, null, null, null, 30, null));
            $this$drawDisplay_u24lambda_u242.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cTry opening your plots menu.", CollectionsKt.listOf("Runs /desk."), false, PestFinder::drawDisplay$lambda$2$lambda$1, null, 20, null));
        }
        return CollectionsKt.build(list);
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        display = CollectionsKt.emptyList();
        this.update();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().showDisplay) {
            return;
        }
        if (this.getConfig().onlyWithVacuum && !PestAPI.INSTANCE.hasVacuumInHand()) {
            return;
        }
        if (GardenAPI.INSTANCE.inGarden() && this.getConfig().showDisplay) {
            Position position = this.getConfig().position;
            Intrinsics.checkNotNullExpressionValue(position, "position");
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Pest Finder", false, 10, null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().showPlotInWorld) {
            return;
        }
        if (this.getConfig().onlyWithVacuum && !PestAPI.INSTANCE.hasVacuumInHand()) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(PestAPI.INSTANCE.getLastTimeVacuumHold-uFjCsEo()), DurationKt.toDuration(this.getConfig().showBorderForSeconds, DurationUnit.SECONDS)) > 0) {
                return;
            }
        }
        LorenzVec playerLocation = RenderUtils.INSTANCE.exactPlayerEyeLocation(event);
        PestFinderConfig.VisibilityType visibility = this.getConfig().visibilityType;
        boolean showBorder = visibility == PestFinderConfig.VisibilityType.BOTH || visibility == PestFinderConfig.VisibilityType.BORDER;
        boolean showName = visibility == PestFinderConfig.VisibilityType.BOTH || visibility == PestFinderConfig.VisibilityType.NAME;
        for (GardenPlotAPI.Plot plot : PestAPI.INSTANCE.getInfestedPlots()) {
            if (GardenPlotAPI.INSTANCE.isPlayerInside(plot)) {
                if (!showBorder) continue;
                GardenPlotAPI.renderPlot$default(GardenPlotAPI.INSTANCE, event, plot, LorenzColor.RED.toColor(), LorenzColor.DARK_RED.toColor(), false, 8, null);
                continue;
            }
            if (showBorder) {
                GardenPlotAPI.renderPlot$default(GardenPlotAPI.INSTANCE, event, plot, LorenzColor.GOLD.toColor(), LorenzColor.RED.toColor(), false, 8, null);
            }
            if (!showName) continue;
            this.drawName(plot, playerLocation, event);
        }
    }

    private final void drawName(GardenPlotAPI.Plot plot, LorenzVec playerLocation, LorenzRenderWorldEvent event) {
        int pests = GardenPlotAPI.INSTANCE.getPests(plot);
        String pestsName = StringUtils.pluralize$default(StringUtils.INSTANCE, pests, "pest", null, false, 12, null);
        String plotName = GardenPlotAPI.INSTANCE.getName(plot);
        LorenzVec middle = plot.getMiddle();
        boolean isInaccurate = GardenPlotAPI.INSTANCE.isPestCountInaccurate(plot);
        LorenzVec location = LorenzVec.copy$default(playerLocation, middle.getX(), 0.0, middle.getZ(), 2, null);
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.RED.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
        String text = "\u00a7e" + (isInaccurate ? "?" : Integer.valueOf(pests)) + " \u00a7c" + pestsName + " \u00a77in \u00a7b" + plotName;
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, text, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().noPestTitle) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getNoPestsChatPattern(), event.getMessage())) {
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7eNo pests!", DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        }
    }

    @SubscribeEvent
    public final void onKeyClick(@NotNull LorenzKeyPressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (NEUItems.INSTANCE.neuHasFocus()) {
            return;
        }
        if (event.getKeyCode() != this.getConfig().teleportHotkey) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastKeyPress), DurationKt.toDuration(2, DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastKeyPress = SimpleTimeMark.Companion.now-uFjCsEo();
        this.teleportNearestInfestedPlot();
    }

    public final void teleportNearestInfestedPlot() {
        if (!GardenAPI.INSTANCE.inGarden()) {
            ChatUtils.INSTANCE.userError("This command only works while on the Garden!");
        }
        GardenPlotAPI.Plot plot = PestAPI.INSTANCE.getNearestInfestedPlot();
        if (plot == null) {
            PestFinder $this$teleportNearestInfestedPlot_u24lambda_u243 = this;
            boolean bl = false;
            if ($this$teleportNearestInfestedPlot_u24lambda_u243.getConfig().backToGarden) {
                HypixelCommands.INSTANCE.warp("garden");
                return;
            }
            ChatUtils.INSTANCE.userError("No infested plots detected to warp to!");
            return;
        }
        GardenPlotAPI.Plot plot2 = plot;
        if (GardenPlotAPI.INSTANCE.isPlayerInside(plot2) && !this.getConfig().alwaysTp) {
            ChatUtils.INSTANCE.userError("You're already in an infested plot!");
            return;
        }
        GardenPlotAPI.INSTANCE.sendTeleportTo(plot2);
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && (this.getConfig().showDisplay || this.getConfig().showPlotInWorld);
    }

    private static final Unit drawDisplay$lambda$2$lambda$0(GardenPlotAPI.Plot $plot) {
        Intrinsics.checkNotNullParameter($plot, "$plot");
        GardenPlotAPI.INSTANCE.sendTeleportTo($plot);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$2$lambda$1() {
        HypixelCommands.INSTANCE.gardenDesk();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PestFinder.class, "noPestsChatPattern", "getNoPestsChatPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PestFinder();
        display = CollectionsKt.emptyList();
        noPestsChatPattern$delegate = RepoPattern.Companion.pattern("chat.garden.no.pest", "\u00a7cThere are not any Pests on your Garden right now! Keep farming!");
        lastKeyPress = SimpleTimeMark.Companion.farPast();
    }
}

