/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.inventory.plots;

import at.hannibal2.skyhanni.config.features.garden.PlotIconConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.events.render.gui.ReplaceItemEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u001c\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bRV\u0010#\u001aD\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u001f0\u001f\u0018\u0001 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u001f0\u001f\u0018\u00010 0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010'\u001a\u0004\u0018\u00010&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010*R\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020&0\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\"\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020&0\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u0014\u0010/\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010(R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u001e008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\"\u00103\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010%\u001a\u0004\b4\u0010\u0006\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/features/garden/inventory/plots/GardenPlotIcon;", "", "<init>", "()V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;", "replaceItem", "(Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/PlotIconConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/PlotIconConfig;", "config", "", "", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "getPlotList", "()Ljava/util/Map;", "plotList", "inInventory", "Z", "Lnet/minecraft/item/ItemStack;", "copyStack", "Lnet/minecraft/item/ItemStack;", "editMode", "I", "lastClickedSlotId", "originalStack", "Ljava/util/Map;", "cachedStack", "editStack", "", "whitelistedSlot", "Ljava/util/List;", "hardReset", "getHardReset", "setHardReset", "(Z)V", "1.8.9"})
public final class GardenPlotIcon {
    @NotNull
    public static final GardenPlotIcon INSTANCE = new GardenPlotIcon();
    private static boolean inInventory;
    @Nullable
    private static ItemStack copyStack;
    private static int editMode;
    private static int lastClickedSlotId;
    @NotNull
    private static Map<Integer, ItemStack> originalStack;
    @NotNull
    private static Map<Integer, ItemStack> cachedStack;
    @NotNull
    private static final ItemStack editStack;
    @NotNull
    private static final List<Integer> whitelistedSlot;
    private static boolean hardReset;

    private GardenPlotIcon() {
    }

    private final PlotIconConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().plotIcon;
    }

    private final Map<Integer, NEUInternalName> getPlotList() {
        Object object = GardenAPI.INSTANCE.getStorage();
        return object != null && (object = ((ProfileSpecificStorage.GardenStorage)object).plotIcon) != null ? ((ProfileSpecificStorage.GardenStorage.PlotIcon)object).plotList : null;
    }

    public final boolean getHardReset() {
        return hardReset;
    }

    public final void setHardReset(boolean bl) {
        hardReset = bl;
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().enabled && inInventory;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = Intrinsics.areEqual(event.getInventoryName(), "Configure Plots");
        if (!this.isEnabled()) {
            return;
        }
        for (Map.Entry<Integer, ItemStack> object : event.getInventoryItems().entrySet()) {
            int entry = ((Number)object.getKey()).intValue();
            ItemStack stack = object.getValue();
            Integer n = entry;
            originalStack.put(n, stack);
        }
        Map<Integer, NEUInternalName> map2 = this.getPlotList();
        if (map2 == null) {
            return;
        }
        Map<Integer, NEUInternalName> plotList = map2;
        for (Map.Entry<Integer, NEUInternalName> entry : plotList.entrySet()) {
            ItemStack old;
            Integer index = entry.getKey();
            NEUInternalName internalName = entry.getValue();
            Intrinsics.checkNotNull(originalStack.get(index));
            Intrinsics.checkNotNull(internalName);
            ItemStack itemStack2 = NEUItems.INSTANCE.getItemStack(internalName);
            Map<Integer, ItemStack> map3 = cachedStack;
            String string2 = old.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            ItemStack itemStack3 = ItemUtils.INSTANCE.editItemInfo(itemStack2, string2, true, ItemUtils.INSTANCE.getLore(old));
            map3.put(index, itemStack3);
        }
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
        editMode = 0;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void replaceItem(@NotNull ReplaceItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Map<Integer, NEUInternalName> map2 = this.getPlotList();
        if (map2 == null) {
            return;
        }
        Map<Integer, NEUInternalName> plotList = map2;
        if (hardReset) {
            plotList.clear();
            hardReset = false;
            return;
        }
        if (event.getInventory() instanceof ContainerLocalMenu) {
            if (event.getSlot() == 53) {
                event.replace(editStack);
            }
            if (!plotList.isEmpty() && plotList.containsKey(event.getSlot())) {
                if (lastClickedSlotId == event.getSlot()) {
                    lastClickedSlotId = -1;
                    return;
                }
                event.replace(cachedStack.get(event.getSlot()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        lastClickedSlotId = event.getSlotId();
        if (event.getSlotId() == 53) {
            event.cancel();
            if (event.getClickedButton() == 0) {
                if (editMode == 2) {
                    editMode = 0;
                } else {
                    int n = editMode;
                    editMode = n + 1;
                }
            } else if (event.getClickedButton() == 1) {
                if (editMode == 0) {
                    editMode = 2;
                } else {
                    int n = editMode;
                    editMode = n + -1;
                }
            }
            return;
        }
        if (editMode != 0) {
            int n = event.getSlotId();
            boolean bl = 54 <= n ? n < 90 : false;
            if (bl) {
                Slot slot;
                event.cancel();
                Slot slot2 = event.getSlot();
                if (slot2 == null || (slot2 = slot2.func_75211_c()) == null || (slot2 = slot2.func_77946_l()) == null) {
                    return;
                }
                Slot it = slot = slot2;
                boolean bl2 = false;
                it.field_77994_a = 1;
                copyStack = slot;
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a76\u00a7lClick an item in the desk menu to replace it with that item!", false, null, 6, null);
                return;
            }
            if (event.getSlotId() != 53) {
                Map<Integer, NEUInternalName> map2 = this.getPlotList();
                if (map2 == null) {
                    return;
                }
                Map<Integer, NEUInternalName> plotList = map2;
                if (!whitelistedSlot.contains(event.getSlotId())) {
                    return;
                }
                event.cancel();
                if (editMode == 2) {
                    plotList.remove(event.getSlotId());
                    return;
                }
                ItemStack itemStack2 = copyStack;
                if (itemStack2 == null) {
                    return;
                }
                ItemStack copyStack = itemStack2;
                plotList.put(event.getSlotId(), ItemUtils.INSTANCE.getInternalName(copyStack));
                cachedStack.put(event.getSlotId(), copyStack);
            }
        }
    }

    @SubscribeEvent
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Map<Integer, NEUInternalName> map2 = this.getPlotList();
        if (map2 == null) {
            return;
        }
        Map<Integer, NEUInternalName> plotList = map2;
        List<String> list = event.getToolTip();
        int index = event.getSlot().field_75222_d;
        if (index == 53) {
            list.clear();
            list.add("\u00a76Edit Mode");
            list.add("");
            list.add((editMode == 0 ? "\u00a76\u25ba " : "") + "\u00a7cOFF\u00a77: \u00a7bNothing change, behave like normal.");
            list.add((editMode == 1 ? "\u00a76\u25ba " : "") + "\u00a7aON\u00a77: \u00a7bClick an item in your inventory then click again");
            list.add((editMode == 1 ? "\u00a76\u25ba " : "") + "\u00a7bin the plot menu to change it to that item.");
            list.add((editMode == 2 ? "\u00a76\u25ba " : "") + "\u00a79RESET\u00a77: \u00a7bClick an item in the menu to reset it to default.");
            list.add("");
            list.add("\u00a7eClick to switch Edit Mode !");
            list.add("");
        }
        if (plotList.containsKey(index)) {
            ItemStack itemStack2 = originalStack.get(index);
            if (itemStack2 == null) {
                return;
            }
            ItemStack stack = itemStack2;
            List<String> lore = ItemUtils.INSTANCE.getLore(stack);
            list.clear();
            String string2 = stack.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            list.add(0, string2);
            int n = ((Collection)lore).size();
            for (int i2 = 0; i2 < n; ++i2) {
                list.add(i2 + 1, ItemUtils.INSTANCE.getLore(stack).get(i2));
            }
        }
    }

    static {
        lastClickedSlotId = -1;
        originalStack = new LinkedHashMap();
        cachedStack = new LinkedHashMap();
        editStack = new ItemStack(Items.field_151053_p);
        Integer[] integerArray = new Integer[]{2, 3, 4, 5, 6, 11, 12, 13, 14, 15, 20, 21, 23, 24, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42};
        whitelistedSlot = CollectionsKt.listOf(integerArray);
    }
}

