/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming.lane;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.FarmingLaneConfig;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.LaneSwitchNotificationConfig;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.LaneSwitchSoundSettings;
import at.hannibal2.skyhanni.events.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.garden.farming.FarmingLaneSwitchEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingDirection;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLane;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLaneAPI;
import at.hannibal2.skyhanni.features.misc.MovementSpeedDisplay;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001AB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0018\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0011J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010!\u001a\u00020 *\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b&\u0010\u0003R\u0019\u0010+\u001a\n (*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0018\u0010,\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001c\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0018\u00105\u001a\u0004\u0018\u0001048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u0010/R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0016\u0010<\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010=\u00a8\u0006B"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/farming/FarmingLaneSwitchEvent;", "event", "", "onFarmingLaneSwitch", "(Lat/hannibal2/skyhanni/events/garden/farming/FarmingLaneSwitchEvent;)V", "Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "", "calculateDistance", "()Z", "", "newPositon", "", "calculateDirection", "(D)Ljava/lang/Integer;", "showWarning", "calculateSpeed", "speed", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "calculateMovementState", "(D)Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "capAtBuildHeight", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "playUserSound", "Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "config", "currentPositon", "Ljava/lang/Double;", "currentDistance", "D", "", "", "display", "Ljava/util/List;", "Lkotlin/time/Duration;", "timeRemaining", "Lkotlin/time/Duration;", "lastSpeed", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastTimeFarming", "J", "lastPlaySound", "lastDirection", "I", "movementState", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "sameSpeedCounter", "MovementState", "1.8.9"})
public final class FarmingLaneFeatures {
    @NotNull
    public static final FarmingLaneFeatures INSTANCE = new FarmingLaneFeatures();
    @Nullable
    private static Double currentPositon;
    private static double currentDistance;
    @NotNull
    private static List<String> display;
    @Nullable
    private static Duration timeRemaining;
    private static double lastSpeed;
    private static long lastTimeFarming;
    private static long lastPlaySound;
    private static int lastDirection;
    @NotNull
    private static MovementState movementState;
    private static int sameSpeedCounter;

    private FarmingLaneFeatures() {
    }

    public final FarmingLaneConfig getConfig() {
        return FarmingLaneAPI.INSTANCE.getConfig();
    }

    @HandleEvent
    public final void onFarmingLaneSwitch(@NotNull FarmingLaneSwitchEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        display = CollectionsKt.emptyList();
    }

    @SubscribeEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        display = CollectionsKt.emptyList();
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().distanceDisplay && !this.getConfig().laneSwitchNotification.enabled) {
            return;
        }
        if (!this.calculateDistance()) {
            return;
        }
        if (!GardenAPI.INSTANCE.isCurrentlyFarming()) {
            return;
        }
        if (this.calculateSpeed()) {
            this.showWarning();
        }
        if (this.getConfig().distanceDisplay) {
            List<String> list;
            List<String> $this$onTick_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$onTick_u24lambda_u240.add("\u00a77Distance until switch: \u00a7e" + NumberUtil.INSTANCE.roundTo(currentDistance, 1));
            boolean normal = movementState == MovementState.NORMAL;
            String color = normal ? "\u00a7b" : "\u00a78";
            Duration duration = timeRemaining;
            if (duration == null) {
            } else {
                long timeRemaining = duration.unbox-impl();
                String format = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, timeRemaining, null, Duration.compareTo-LRDsOJo(timeRemaining, DurationKt.toDuration(20, DurationUnit.SECONDS)) < 0, false, 0, false, 29, null);
                String suffix = !normal ? " \u00a77(" + movementState.getLabel() + "\u00a77)" : "";
                $this$onTick_u24lambda_u240.add("\u00a77Time remaining: " + color + format + suffix);
                if (MovementSpeedDisplay.INSTANCE.getUsingSoulsandSpeed()) {
                    $this$onTick_u24lambda_u240.add("\u00a77Using inaccurate soul sand speed!");
                }
            }
            display = CollectionsKt.build(list);
        }
    }

    private final boolean calculateDistance() {
        boolean outside;
        FarmingLane farmingLane = FarmingLaneAPI.INSTANCE.getCurrentLane();
        if (farmingLane == null) {
            return false;
        }
        FarmingLane lane = farmingLane;
        double min = lane.getMin();
        double max = lane.getMax();
        double position = FarmingLaneAPI.INSTANCE.getValue(lane.getDirection(), LocationUtils.INSTANCE.playerLocation());
        boolean bl = outside = !(min <= position ? position <= max : false);
        if (outside) {
            display = CollectionsKt.emptyList();
            return false;
        }
        Integer n = this.calculateDirection(position);
        if (n == null) {
            return false;
        }
        int direction = n;
        switch (direction) {
            case 1: {
                double d = Math.abs(min - position);
                break;
            }
            case -1: {
                double d = Math.abs(max - position);
                break;
            }
            default: {
                double d = currentDistance = currentDistance;
            }
        }
        if (direction != lastDirection) {
            lastTimeFarming = SimpleTimeMark.Companion.farPast();
            lastDirection = direction;
        }
        return true;
    }

    private final Integer calculateDirection(double newPositon) {
        Double d = currentPositon;
        if (d == null) {
            FarmingLaneFeatures $this$calculateDirection_u24lambda_u241 = this;
            boolean bl = false;
            currentPositon = newPositon;
            return null;
        }
        double position = d;
        currentPositon = newPositon;
        double diff = position - newPositon;
        return diff > 0.0 ? Integer.valueOf(1) : (diff < 0.0 ? Integer.valueOf(-1) : Integer.valueOf(0));
    }

    private final void showWarning() {
        LaneSwitchNotificationConfig $this$showWarning_u24lambda_u242 = this.getConfig().laneSwitchNotification;
        boolean bl = false;
        if ($this$showWarning_u24lambda_u242.enabled) {
            String string2 = $this$showWarning_u24lambda_u242.text;
            Intrinsics.checkNotNullExpressionValue(string2, "text");
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, StringsKt.replace$default(string2, "&", "\u00a7", false, 4, null), DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPlaySound), TimeUtils.INSTANCE.getTicks-5sfh64U($this$showWarning_u24lambda_u242.sound.repeatDuration)) >= 0) {
                lastPlaySound = SimpleTimeMark.Companion.now-uFjCsEo();
                FarmingLaneFeatures.playUserSound();
            }
        }
    }

    private final boolean calculateSpeed() {
        double speed = NumberUtil.INSTANCE.roundTo(MovementSpeedDisplay.INSTANCE.getSpeed(), 2);
        movementState = this.calculateMovementState(speed);
        if (movementState != MovementState.NORMAL) {
            return false;
        }
        long timeRemaining = DurationKt.toDuration(currentDistance / speed, DurationUnit.SECONDS);
        FarmingLaneFeatures.timeRemaining = Duration.box-impl(timeRemaining);
        long warnAt = DurationKt.toDuration(this.getConfig().laneSwitchNotification.secondsBefore, DurationUnit.SECONDS);
        if (Duration.compareTo-LRDsOJo(timeRemaining, warnAt) >= 0) {
            lastTimeFarming = SimpleTimeMark.Companion.now-uFjCsEo();
            return false;
        }
        return Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastTimeFarming), warnAt) < 0;
    }

    private final MovementState calculateMovementState(double speed) {
        boolean speedTooSlow;
        if (!(lastSpeed == speed)) {
            lastSpeed = speed;
            sameSpeedCounter = 0;
        }
        int n = sameSpeedCounter;
        sameSpeedCounter = n + 1;
        if (speed == 0.0 && sameSpeedCounter > 1) {
            return MovementState.NOT_MOVING;
        }
        boolean bl = speedTooSlow = speed < 1.0;
        if (speedTooSlow && sameSpeedCounter > 5) {
            return MovementState.TOO_SLOW;
        }
        if (!MovementSpeedDisplay.INSTANCE.getUsingSoulsandSpeed() && sameSpeedCounter < 6) {
            return MovementState.CALCULATING;
        }
        return MovementState.NORMAL;
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().cornerWaypoints) {
            return;
        }
        FarmingLane farmingLane = FarmingLaneAPI.INSTANCE.getCurrentLane();
        if (farmingLane == null) {
            return;
        }
        FarmingLane lane = farmingLane;
        FarmingDirection direction = lane.getDirection();
        LorenzVec location = LocationUtils.INSTANCE.playerLocation();
        LorenzVec min = this.capAtBuildHeight(FarmingLaneAPI.INSTANCE.setValue(direction, location, lane.getMin()));
        LorenzVec max = this.capAtBuildHeight(FarmingLaneAPI.INSTANCE.setValue(direction, location, lane.getMax()));
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, min, LorenzColor.YELLOW.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, min, "\u00a7eLane Corner", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, max, LorenzColor.YELLOW.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, max, "\u00a7eLane Corner", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    private final LorenzVec capAtBuildHeight(LorenzVec $this$capAtBuildHeight) {
        return $this$capAtBuildHeight.getY() > 76.0 ? LorenzVec.copy$default($this$capAtBuildHeight, 0.0, 76.0, 0.0, 5, null) : $this$capAtBuildHeight;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().distanceDisplay) {
            return;
        }
        Position position = this.getConfig().distanceDisplayPosition;
        Intrinsics.checkNotNullExpressionValue(position, "distanceDisplayPosition");
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, position, display, 0, "Lane Display", 2, null);
    }

    @JvmStatic
    public static final void playUserSound() {
        LaneSwitchSoundSettings $this$playUserSound_u24lambda_u243 = FarmingLaneFeatures.INSTANCE.getConfig().laneSwitchNotification.sound;
        boolean bl = false;
        String string2 = $this$playUserSound_u24lambda_u243.name;
        Intrinsics.checkNotNullExpressionValue(string2, "name");
        SoundUtils.INSTANCE.playSound(SoundUtils.createSound$default(SoundUtils.INSTANCE, string2, $this$playUserSound_u24lambda_u243.pitch, 0.0f, 4, null));
    }

    static {
        display = CollectionsKt.emptyList();
        lastTimeFarming = SimpleTimeMark.Companion.farPast();
        lastPlaySound = SimpleTimeMark.Companion.farPast();
        movementState = MovementState.CALCULATING;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneFeatures$MovementState;", "", "", "label", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getLabel", "()Ljava/lang/String;", "NOT_MOVING", "TOO_SLOW", "CALCULATING", "NORMAL", "1.8.9"})
    public static final class MovementState
    extends Enum<MovementState> {
        @NotNull
        private final String label;
        public static final /* enum */ MovementState NOT_MOVING = new MovementState("\u00a7ePaused");
        public static final /* enum */ MovementState TOO_SLOW = new MovementState("\u00a7cToo slow!");
        public static final /* enum */ MovementState CALCULATING = new MovementState("\u00a7aCalculating..");
        public static final /* enum */ MovementState NORMAL = new MovementState("");
        private static final /* synthetic */ MovementState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MovementState(String label) {
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static MovementState[] values() {
            return (MovementState[])$VALUES.clone();
        }

        public static MovementState valueOf(String value) {
            return Enum.valueOf(MovementState.class, value);
        }

        @NotNull
        public static EnumEntries<MovementState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = movementStateArray = new MovementState[]{MovementState.NOT_MOVING, MovementState.TOO_SLOW, MovementState.CALCULATING, MovementState.NORMAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

