/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.CropClickEvent;
import at.hannibal2.skyhanni.events.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/CropClickEvent;", "onCropClick", "(Lat/hannibal2/skyhanni/events/CropClickEvent;)V", "notifyWrong", "Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;)V", "Lnet/minecraft/item/ItemStack;", "item", "readItem", "(Lnet/minecraft/item/ItemStack;)V", "Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "mode", "Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "", "lastPlaySoundTime", "J", "FungiMode", "1.8.9"})
public final class WrongFungiCutterWarning {
    @NotNull
    public static final WrongFungiCutterWarning INSTANCE = new WrongFungiCutterWarning();
    @NotNull
    private static FungiMode mode = FungiMode.UNKNOWN;
    private static long lastPlaySoundTime;

    private WrongFungiCutterWarning() {
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String message = event.getMessage();
        if (Intrinsics.areEqual(message, "\u00a7eFungi Cutter Mode: \u00a7r\u00a7cRed Mushrooms")) {
            mode = FungiMode.RED;
        }
        if (Intrinsics.areEqual(message, "\u00a7eFungi Cutter Mode: \u00a7r\u00a76Brown Mushrooms")) {
            mode = FungiMode.BROWN;
        }
    }

    @SubscribeEvent
    public final void onCropClick(@NotNull CropClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getClickType() != ClickType.LEFT_CLICK) {
            return;
        }
        if (event.getCrop() != CropType.MUSHROOM) {
            return;
        }
        String toString2 = event.getBlockState().toString();
        if (Intrinsics.areEqual(toString2, "minecraft:red_mushroom") && mode == FungiMode.BROWN) {
            this.notifyWrong();
        }
        if (Intrinsics.areEqual(toString2, "minecraft:brown_mushroom") && mode == FungiMode.RED) {
            this.notifyWrong();
        }
    }

    private final void notifyWrong() {
        if (!GardenAPI.INSTANCE.getConfig().fungiCutterWarn) {
            return;
        }
        LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7cWrong Fungi Cutter Mode!", DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        if (System.currentTimeMillis() > lastPlaySoundTime + (long)300) {
            lastPlaySoundTime = System.currentTimeMillis();
            SoundUtils.INSTANCE.playBeepSound();
        }
    }

    @SubscribeEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getCrop() == CropType.MUSHROOM) {
            ItemStack itemStack2 = event.getToolItem();
            if (itemStack2 == null) {
                throw new IllegalStateException("Tool item is null".toString());
            }
            this.readItem(itemStack2);
        } else {
            mode = FungiMode.UNKNOWN;
        }
    }

    private final void readItem(ItemStack item) {
        String string2 = SkyBlockItemModifierUtils.INSTANCE.getFungiCutterMode(item);
        if (string2 == null) {
            return;
        }
        String rawMode = string2;
        mode = FungiMode.Companion.getOrNull(rawMode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "", "<init>", "(Ljava/lang/String;I)V", "Companion", "RED", "BROWN", "UNKNOWN", "1.8.9"})
    public static final class FungiMode
    extends Enum<FungiMode> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ FungiMode RED;
        public static final /* enum */ FungiMode BROWN;
        public static final /* enum */ FungiMode UNKNOWN;
        private static final /* synthetic */ FungiMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FungiMode[] values() {
            return (FungiMode[])$VALUES.clone();
        }

        public static FungiMode valueOf(String value) {
            return Enum.valueOf(FungiMode.class, value);
        }

        @NotNull
        public static EnumEntries<FungiMode> getEntries() {
            return $ENTRIES;
        }

        static {
            RED = new FungiMode();
            BROWN = new FungiMode();
            UNKNOWN = new FungiMode();
            $VALUES = fungiModeArray = new FungiMode[]{FungiMode.RED, FungiMode.BROWN, FungiMode.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode$Companion;", "", "<init>", "()V", "", "mode", "Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "getOrNull", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "1.8.9"})
        @SourceDebugExtension(value={"SMAP\nWrongFungiCutterWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongFungiCutterWarning.kt\nat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n295#2,2:87\n*S KotlinDebug\n*F\n+ 1 WrongFungiCutterWarning.kt\nat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode$Companion\n*L\n82#1:87,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FungiMode getOrNull(@NotNull String mode) {
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter(mode, "mode");
                    Iterable $this$firstOrNull$iv = FungiMode.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FungiMode it = (FungiMode)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), mode)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                FungiMode fungiMode = v0;
                if (fungiMode == null) {
                    throw new IllegalStateException(("Unknown fungi mode: '" + mode + '\'').toString());
                }
                return fungiMode;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

