/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.NextConfig;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.GardenNextJacobContest;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.TimeUnit;
import at.hannibal2.skyhanni.utils.TimeUtils;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J#\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\t0\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R.\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\t0\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001e\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR#\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020 0\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenBestCropTime;", "", "<init>", "()V", "", "reset", "updateTimeTillNextCrop", "Lat/hannibal2/skyhanni/features/garden/CropType;", "currentCrop", "", "drawBestDisplay", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/util/List;", "", "gardenLevel", "getGardenExpForTier", "(I)I", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "event", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "display", "Ljava/util/List;", "getDisplay", "()Ljava/util/List;", "setDisplay", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "config", "", "", "timeTillNextCrop", "Ljava/util/Map;", "getTimeTillNextCrop", "()Ljava/util/Map;", "1.8.9"})
public final class GardenBestCropTime {
    @NotNull
    public static final GardenBestCropTime INSTANCE = new GardenBestCropTime();
    @NotNull
    private static List<? extends List<? extends Object>> display = CollectionsKt.emptyList();
    @NotNull
    private static final Map<CropType, Long> timeTillNextCrop = new LinkedHashMap();

    private GardenBestCropTime() {
    }

    @NotNull
    public final List<List<Object>> getDisplay() {
        return display;
    }

    public final void setDisplay(@NotNull List<? extends List<? extends Object>> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        display = list;
    }

    private final CropMilestonesConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().cropMilestones;
    }

    @NotNull
    public final Map<CropType, Long> getTimeTillNextCrop() {
        return timeTillNextCrop;
    }

    public final void reset() {
        timeTillNextCrop.clear();
        this.updateTimeTillNextCrop();
    }

    public final void updateTimeTillNextCrop() {
        boolean useOverflow = this.getConfig().overflow.bestCropTime;
        for (CropType crop : CropType.getEntries()) {
            Integer n = GardenCropSpeed.INSTANCE.getSpeed(crop);
            if (n == null) {
                continue;
            }
            int speed = n;
            if (GardenCropMilestones.INSTANCE.isMaxed(crop, useOverflow)) continue;
            long counter = GardenCropMilestones.INSTANCE.getCounter(crop);
            int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, crop, true);
            long cropsForCurrentTier = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, currentTier, crop, false, 4, null);
            int nextTier = (Boolean)this.getConfig().bestShowMaxedNeeded.get() != false ? 46 : currentTier + 1;
            long cropsForNextTier = GardenCropMilestones.getCropsForTier$default(GardenCropMilestones.INSTANCE, nextTier, crop, false, 4, null);
            long have = counter - cropsForCurrentTier;
            long need = cropsForNextTier - cropsForCurrentTier;
            long missing = need - have;
            long missingTimeSeconds = missing / (long)speed;
            long millis = missingTimeSeconds * (long)1000;
            Long l = millis;
            timeTillNextCrop.put(crop, l);
        }
    }

    @NotNull
    public final List<List<Object>> drawBestDisplay(@Nullable CropType currentCrop) {
        Map<CropType, Long> sorted2;
        Map<CropType, Long> map2;
        List newList = new ArrayList();
        if (timeTillNextCrop.size() < CropType.getEntries().size()) {
            this.updateTimeTillNextCrop();
        }
        boolean gardenExp = this.getConfig().next.bestType == NextConfig.BestTypeEntry.GARDEN_EXP;
        boolean useOverflow = this.getConfig().overflow.bestCropTime;
        if (gardenExp) {
            Map helpMap = new LinkedHashMap();
            for (Map.Entry<CropType, Long> entry : timeTillNextCrop.entrySet()) {
                CropType crop = entry.getKey();
                long time = ((Number)entry.getValue()).longValue();
                if (GardenCropMilestones.INSTANCE.isMaxed(crop, useOverflow)) continue;
                int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(GardenCropMilestones.INSTANCE.getCounter(crop), crop, true);
                int gardenExpForTier = this.getGardenExpForTier(currentTier + 1);
                long fakeTime = time / (long)gardenExpForTier;
                Long l = fakeTime;
                helpMap.put(crop, l);
            }
            map2 = CollectionUtils.INSTANCE.sorted(helpMap);
        } else {
            map2 = sorted2 = CollectionUtils.INSTANCE.sorted(timeTillNextCrop);
        }
        if (!this.getConfig().next.bestHideTitle) {
            String title;
            String string2 = title = gardenExp ? "\u00a72Garden Experience" : "\u00a7bSkyBlock Level";
            if (this.getConfig().next.bestCompact) {
                CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a7eBest Crop Time");
            } else {
                CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a7eBest Crop Time \u00a77(" + title + "\u00a77)");
            }
        }
        if (!this.getConfig().progress) {
            CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a7cCrop Milestone Progress Display is disabled!");
            return newList;
        }
        if (sorted2.isEmpty()) {
            CollectionUtils.INSTANCE.addAsSingletonList(newList, "\u00a7cFarm crops to add them to this list!");
            return newList;
        }
        int number = 0;
        for (CropType crop : sorted2.keySet()) {
            boolean isCurrent;
            Long l;
            if (GardenCropMilestones.INSTANCE.isMaxed(crop, useOverflow) || (l = timeTillNextCrop.get((Object)crop)) == null) continue;
            long millis = DurationKt.toDuration(l, DurationUnit.MILLISECONDS);
            TimeUnit biggestUnit = (TimeUnit)((Object)TimeUnit.getEntries().get(((CropMilestonesConfig.TimeFormatEntry)this.getConfig().highestTimeFormat.get()).ordinal()));
            String duration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, millis, biggestUnit, false, false, 2, false, 22, null);
            boolean bl = isCurrent = crop == currentCrop;
            if (++number > this.getConfig().next.showOnlyBest && (!this.getConfig().next.showCurrent || !isCurrent)) continue;
            List list = new ArrayList();
            if (!this.getConfig().next.bestCompact) {
                list.add("\u00a77" + number + "# ");
            }
            GardenAPI.addCropIcon$default(GardenAPI.INSTANCE, list, crop, 0.0, false, 6, null);
            String color = isCurrent ? "\u00a7e" : "\u00a77";
            String contestFormat = GardenNextJacobContest.INSTANCE.isNextCrop(crop) ? "\u00a7n" : "";
            int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(GardenCropMilestones.INSTANCE.getCounter(crop), crop, true);
            int nextTier = (Boolean)this.getConfig().bestShowMaxedNeeded.get() != false ? 46 : currentTier + 1;
            String cropName = !this.getConfig().next.bestCompact ? crop.getCropName() + ' ' : "";
            String tier = !this.getConfig().next.bestCompact ? "" + currentTier + '\u279c' + nextTier + "\u00a7r " : "";
            list.add(color + contestFormat + cropName + tier + "\u00a7b" + duration);
            if (gardenExp && !this.getConfig().next.bestCompact) {
                int gardenExpForTier = this.getGardenExpForTier(nextTier);
                list.add(" \u00a77(\u00a72" + gardenExpForTier + " \u00a77Exp)");
            }
            newList.add(list);
        }
        return newList;
    }

    private final int getGardenExpForTier(int gardenLevel) {
        return gardenLevel > 30 ? 300 : gardenLevel * 10;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestType", "garden.cropMilestones.next.bestType", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneShowOnlyBest", "garden.cropMilestones.next.showOnlyBest", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneShowCurrent", "garden.cropMilestones.next.showCurrent", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestCompact", "garden.cropMilestones.next.bestCompact", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestHideTitle", "garden.cropMilestones.next.bestHideTitle", null, 8, null);
        event.transform(17, "garden.cropMilestones.next.bestType", GardenBestCropTime::onConfigFix$lambda$0);
    }

    private static final JsonElement onConfigFix$lambda$0(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, NextConfig.BestTypeEntry.class);
    }
}

