/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.enums.OutsideSbFeature;
import at.hannibal2.skyhanni.config.features.garden.EliteFarmingWeightConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.other.EliteLeaderboard;
import at.hannibal2.skyhanni.data.jsonobjects.other.EliteLeaderboardJson;
import at.hannibal2.skyhanni.data.jsonobjects.other.ElitePlayerWeightJson;
import at.hannibal2.skyhanni.data.jsonobjects.other.EliteWeightsJson;
import at.hannibal2.skyhanni.data.jsonobjects.other.UpcomingLeaderboardPlayer;
import at.hannibal2.skyhanni.data.jsonobjects.other.WeightProfile;
import at.hannibal2.skyhanni.events.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.features.garden.pests.PestType;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.APIUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.json.BaseGsonBuilder;
import at.hannibal2.skyhanni.utils.json.SkyHanniTypeAdapters;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0011\u0010!\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b#\u0010\u0003J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020'H\u0002\u00a2\u0006\u0004\b*\u0010)J\u001d\u0010.\u001a\u00020\u00062\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u001d\u00a2\u0006\u0004\b.\u0010/J/\u00104\u001a\u00020\u00062\u0006\u0010,\u001a\u00020+2\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u000200H\u0002\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b8\u0010\u0003J\u000f\u00109\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b9\u0010\u0003J\u001f\u0010<\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b<\u0010=J\u000f\u0010>\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b>\u0010\u001fJ\u0017\u0010B\u001a\u00020A2\u0006\u0010@\u001a\u00020?H\u0002\u00a2\u0006\u0004\bB\u0010CJ\u0017\u0010E\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\bE\u0010&J\u001b\u0010G\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002000FH\u0002\u00a2\u0006\u0004\bG\u0010HJ+\u0010K\u001a\u0002002\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002000F2\u0006\u0010J\u001a\u000200H\u0002\u00a2\u0006\u0004\bK\u0010LJ\u0013\u0010N\u001a\u00020M*\u00020+H\u0002\u00a2\u0006\u0004\bN\u0010OJ\u0013\u0010P\u001a\u000200*\u00020+H\u0002\u00a2\u0006\u0004\bP\u0010QJ\u001b\u0010T\u001a\u00020\u00062\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00190R\u00a2\u0006\u0004\bT\u0010UJ!\u0010X\u001a\u00020\u00062\u0006\u0010V\u001a\u00020\u00192\b\b\u0002\u0010W\u001a\u00020'H\u0002\u00a2\u0006\u0004\bX\u0010YJ\u000f\u0010Z\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bZ\u0010\u0003R\u001c\u0010_\u001a\n \\*\u0004\u0018\u00010[0[8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R \u0010`\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020M0F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u001c\u0010c\u001a\b\u0012\u0004\u0012\u00020 0b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u0016\u0010e\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\be\u0010fR\u0016\u0010h\u001a\u00020g8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0016\u0010j\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bj\u0010kR\u0016\u0010l\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u0016\u0010n\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0016\u0010p\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010oR\u0016\u0010q\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bq\u0010oR\u0016\u0010r\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010kR\u0016\u0010s\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bs\u0010kR\u0016\u0010t\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010kR\u0016\u0010u\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bu\u0010mR\u001c\u0010x\u001a\b\u0012\u0004\u0012\u00020w0v8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010dR\u0016\u0010{\u001a\u0004\u0018\u00010w8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010zR#\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060|8BX\u0082\u0084\u0002\u00a2\u0006\r\n\u0004\b}\u0010~\u001a\u0005\b\u007f\u0010\u0080\u0001R)\u0010\u0086\u0001\u001a\f \\*\u0005\u0018\u00010\u0082\u00010\u0082\u00018BX\u0082\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0083\u0001\u0010~\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R%\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020 0b8BX\u0082\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0087\u0001\u0010~\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R\u0018\u0010\u008b\u0001\u001a\u00020g8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008b\u0001\u0010iR\u0018\u0010\u008c\u0001\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008c\u0001\u0010fR\"\u0010\u008d\u0001\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002000F8\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u008d\u0001\u0010aR\u0018\u0010\u008e\u0001\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008e\u0001\u0010kR\u0018\u0010\u008f\u0001\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u008f\u0001\u0010kR+\u0010\u0093\u0001\u001a\u000f\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002000\u0090\u00018BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0091\u0001\u0010~\u001a\u0005\b\u0092\u0001\u0010H\u00a8\u0006\u0094\u0001"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/FarmingWeightDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "event", "", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "update", "", "getLeaderboard", "()Ljava/lang/String;", "getWeight", "", "getRankGoal", "()I", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "getETA", "()Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "resetData", "message", "farmingChatMessage", "(Ljava/lang/String;)V", "", "isEnabled", "()Z", "isEtaEnabled", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "addedCounter", "addCrop", "(Lat/hannibal2/skyhanni/features/garden/CropType;I)V", "", "before", "after", "diff", "updateWeightPerSecond", "(Lat/hannibal2/skyhanni/features/garden/CropType;DDI)V", "getExactWeight", "()D", "loadLeaderboardIfAble", "checkOffScreenLeaderboardChanges", "direction", "oldPosition", "showLbChange", "(Ljava/lang/String;I)V", "loadLeaderboardPosition", "Lcom/google/gson/JsonObject;", "obj", "Lat/hannibal2/skyhanni/data/jsonobjects/other/EliteLeaderboardJson;", "toEliteLeaderboardJson", "(Lcom/google/gson/JsonObject;)Lat/hannibal2/skyhanni/data/jsonobjects/other/EliteLeaderboardJson;", "localProfile", "loadWeight", "", "calculateCollectionWeight", "()Ljava/util/Map;", "weightPerCrop", "totalWeight", "specialMushroomWeight", "(Ljava/util/Map;D)D", "", "getLocalCounter", "(Lat/hannibal2/skyhanni/features/garden/CropType;)J", "getFactor", "(Lat/hannibal2/skyhanni/features/garden/CropType;)D", "", "it", "lookUpCommand", "([Ljava/lang/String;)V", "name", "ignoreCooldown", "openWebsite", "(Ljava/lang/String;Z)V", "getCropWeights", "Lat/hannibal2/skyhanni/config/features/garden/EliteFarmingWeightConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/EliteFarmingWeightConfig;", "config", "localCounter", "Ljava/util/Map;", "", "display", "Ljava/util/List;", "profileId", "Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastLeaderboardUpdate", "J", "apiError", "Z", "leaderboardPosition", "I", "weight", "D", "localWeight", "weightPerSecond", "weightNeedsRecalculating", "isLoadingWeight", "isLoadingLeaderboard", "rankGoal", "", "Lat/hannibal2/skyhanni/data/jsonobjects/other/UpcomingLeaderboardPlayer;", "nextPlayers", "getNextPlayer", "()Lat/hannibal2/skyhanni/data/jsonobjects/other/UpcomingLeaderboardPlayer;", "nextPlayer", "Lkotlin/Function0;", "recalculate$delegate", "Lkotlin/Lazy;", "getRecalculate", "()Lkotlin/jvm/functions/Function0;", "recalculate", "Lcom/google/gson/Gson;", "eliteWeightApiGson$delegate", "getEliteWeightApiGson", "()Lcom/google/gson/Gson;", "eliteWeightApiGson", "errorMessage$delegate", "getErrorMessage", "()Ljava/util/List;", "errorMessage", "lastOpenWebsite", "lastName", "cropWeight", "attemptingCropWeightFetch", "hasFetchedCropWeights", "", "backupCropWeights$delegate", "getBackupCropWeights", "backupCropWeights", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFarmingWeightDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FarmingWeightDisplay.kt\nat/hannibal2/skyhanni/features/garden/farming/FarmingWeightDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,609:1\n1863#2,2:610\n16#3:612\n16#3:613\n16#3:615\n1#4:614\n*S KotlinDebug\n*F\n+ 1 FarmingWeightDisplay.kt\nat/hannibal2/skyhanni/features/garden/farming/FarmingWeightDisplay\n*L\n457#1:610,2\n474#1:612\n486#1:613\n579#1:615\n*E\n"})
public final class FarmingWeightDisplay {
    @NotNull
    public static final FarmingWeightDisplay INSTANCE = new FarmingWeightDisplay();
    @NotNull
    private static final Map<CropType, Long> localCounter = new LinkedHashMap();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();
    @NotNull
    private static String profileId = "";
    private static long lastLeaderboardUpdate = SimpleTimeMark.Companion.farPast();
    private static boolean apiError;
    private static int leaderboardPosition;
    private static double weight;
    private static double localWeight;
    private static double weightPerSecond;
    private static boolean weightNeedsRecalculating;
    private static boolean isLoadingWeight;
    private static boolean isLoadingLeaderboard;
    private static int rankGoal;
    @NotNull
    private static List<UpcomingLeaderboardPlayer> nextPlayers;
    @NotNull
    private static final Lazy recalculate$delegate;
    @NotNull
    private static final Lazy eliteWeightApiGson$delegate;
    @NotNull
    private static final Lazy errorMessage$delegate;
    private static long lastOpenWebsite;
    @NotNull
    private static String lastName;
    @NotNull
    private static final Map<CropType, Double> cropWeight;
    private static boolean attemptingCropWeightFetch;
    private static boolean hasFetchedCropWeights;
    @NotNull
    private static final Lazy backupCropWeights$delegate;

    private FarmingWeightDisplay() {
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        boolean shouldShow;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (GardenAPI.INSTANCE.hideExtraGuis()) {
            return;
        }
        boolean bl = shouldShow = apiError || this.getConfig().ignoreLow || weight >= 200.0;
        if (this.isEnabled() && shouldShow) {
            Position position = this.getConfig().pos;
            Intrinsics.checkNotNullExpressionValue(position, "pos");
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Farming Weight Display", false, 10, null);
        }
    }

    @SubscribeEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        weightPerSecond = -1.0;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.resetData();
    }

    @SubscribeEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        display = CollectionsKt.emptyList();
        profileId = "";
        weight = -1.0;
        nextPlayers.clear();
        rankGoal = -1;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            return;
        }
        this.update();
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        FarmingWeightDisplay.access$getCropWeights(FarmingWeightDisplay.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.transform$default(event, 1, "garden.eliteFarmingWeightoffScreenDropMessage", null, 4, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightDisplay", "garden.eliteFarmingWeights.display", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightPos", "garden.eliteFarmingWeights.pos", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightLeaderboard", "garden.eliteFarmingWeights.leaderboard", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightOvertakeETA", "garden.eliteFarmingWeights.overtakeETA", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightOffScreenDropMessage", "garden.eliteFarmingWeights.offScreenDropMessage", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightOvertakeETAAlways", "garden.eliteFarmingWeights.overtakeETAAlways", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightETAGoalRank", "garden.eliteFarmingWeights.ETAGoalRank", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.eliteFarmingWeightIgnoreLow", "garden.eliteFarmingWeights.ignoreLow", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 14, "garden.eliteFarmingWeight.offScreenDropMessage", "garden.eliteFarmingWeights.showLbChange", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 34, "garden.eliteFarmingWeights.ETAGoalRank", "garden.eliteFarmingWeights.etaGoalRank", null, 8, null);
    }

    private final EliteFarmingWeightConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().eliteFarmingWeights;
    }

    private final UpcomingLeaderboardPlayer getNextPlayer() {
        return CollectionsKt.firstOrNull(nextPlayers);
    }

    private final Function0<Unit> getRecalculate() {
        Lazy lazy = recalculate$delegate;
        return (Function0)lazy.getValue();
    }

    private final Gson getEliteWeightApiGson() {
        Lazy lazy = eliteWeightApiGson$delegate;
        return (Gson)lazy.getValue();
    }

    private final List<Renderable> getErrorMessage() {
        Lazy lazy = errorMessage$delegate;
        return (List)lazy.getValue();
    }

    private final void update() {
        if (!this.isEnabled()) {
            return;
        }
        if (apiError) {
            display = this.getErrorMessage();
            return;
        }
        if (weight == -1.0) {
            if (!isLoadingWeight) {
                String localProfile = HypixelData.INSTANCE.getProfileName();
                isLoadingWeight = true;
                if (display.isEmpty()) {
                    display = Renderable.Companion.singeltonString("\u00a76Farming Weight\u00a77: \u00a7eLoading..");
                }
                BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(localProfile, null){
                    int label;
                    final /* synthetic */ String $localProfile;
                    {
                        this.$localProfile = $localProfile;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                FarmingWeightDisplay.access$loadWeight(FarmingWeightDisplay.INSTANCE, this.$localProfile);
                                FarmingWeightDisplay.access$setLoadingWeight$p(false);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
            return;
        }
        String weight = this.getWeight();
        if (rankGoal == -1) {
            rankGoal = this.getRankGoal();
        }
        String leaderboard = this.getLeaderboard();
        List list = new ArrayList();
        list.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a76Farming Weight\u00a77: " + weight + leaderboard, CollectionsKt.listOf("\u00a7eClick to open your Farming Profile."), false, FarmingWeightDisplay::update$lambda$4, null, 20, null));
        if (this.isEtaEnabled() && (!(weightPerSecond == -1.0) || this.getConfig().overtakeETAAlways)) {
            Renderable renderable2 = this.getETA();
            if (renderable2 != null) {
                Renderable it = renderable2;
                boolean bl = false;
                list.add(it);
            }
        }
        display = list;
    }

    private final String getLeaderboard() {
        String string2;
        if (!this.getConfig().leaderboard) {
            return "";
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastLeaderboardUpdate), DurationKt.toDuration(10.5, DurationUnit.MINUTES)) > 0) {
            this.loadLeaderboardIfAble();
        }
        if (leaderboardPosition != -1) {
            String format = NumberUtil.INSTANCE.addSeparators(leaderboardPosition);
            string2 = " \u00a77[\u00a7b#" + format + "\u00a77]";
        } else {
            string2 = isLoadingLeaderboard ? " \u00a77[\u00a7b#?\u00a77]" : "";
        }
        return string2;
    }

    private final String getWeight() {
        Collection<Double> values2;
        if (weightNeedsRecalculating && !(values2 = this.calculateCollectionWeight().values()).isEmpty()) {
            localWeight = CollectionsKt.sumOfDouble((Iterable<Double>)values2);
            weightNeedsRecalculating = false;
        }
        double totalWeight = localWeight + weight;
        return "\u00a7e" + NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(totalWeight, 2));
    }

    private final int getRankGoal() {
        int parsed;
        String value = this.getConfig().etaGoalRank;
        int goal = 10000;
        Intrinsics.checkNotNull(value);
        Integer n = StringsKt.toIntOrNull(value);
        int n2 = parsed = n != null ? n : 0;
        if (parsed < 1 || parsed > goal) {
            ChatUtils.INSTANCE.chatAndOpenConfig("Invalid Farming Weight Overtake Goal! Click here to edit the Overtake Goal config value to a valid number [1-10000] to use this feature!", new MutablePropertyReference0Impl(GardenAPI.INSTANCE.getConfig().eliteFarmingWeights){

                public Object get() {
                    return ((EliteFarmingWeightConfig)this.receiver).etaGoalRank;
                }

                public void set(Object value) {
                    ((EliteFarmingWeightConfig)this.receiver).etaGoalRank = (String)value;
                }
            });
            this.getConfig().etaGoalRank = String.valueOf(goal);
        } else {
            goal = parsed;
        }
        if (rankGoal != goal) {
            this.loadLeaderboardIfAble();
        }
        return goal;
    }

    private final Renderable getETA() {
        String string2;
        if (weight < 0.0) {
            return null;
        }
        UpcomingLeaderboardPlayer upcomingLeaderboardPlayer = this.getNextPlayer();
        if (upcomingLeaderboardPlayer == null) {
            return Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cWaiting for leaderboard update...", CollectionsKt.listOf("\u00a7eClick here to load new data right now!"), false, this.getRecalculate(), null, 20, null);
        }
        UpcomingLeaderboardPlayer nextPlayer = upcomingLeaderboardPlayer;
        boolean showRankGoal = leaderboardPosition == -1 || leaderboardPosition > rankGoal;
        Ref.ObjectRef nextName = new Ref.ObjectRef();
        nextName.element = showRankGoal ? "" + '#' + rankGoal : nextPlayer.getName();
        double totalWeight = localWeight + weight;
        double weightUntilOvertake = nextPlayer.getWeight() - totalWeight;
        if (weightUntilOvertake < 0.0) {
            Object object;
            if (weightPerSecond > 0.0) {
                this.farmingChatMessage("You passed \u00a7b" + (String)nextName.element + " \u00a7ein the Farming Weight Leaderboard!");
            }
            if (leaderboardPosition == -1) {
                leaderboardPosition = 10000;
            } else {
                int n = leaderboardPosition;
                leaderboardPosition = n + -1;
            }
            if ((object = GardenAPI.INSTANCE.getStorage()) != null && (object = ((ProfileSpecificStorage.GardenStorage)object).farmingWeight) != null) {
                ((ProfileSpecificStorage.GardenStorage.FarmingWeightConfig)object).lastFarmingWeightLeaderboard = leaderboardPosition;
            }
            CollectionsKt.removeFirst(nextPlayers);
            nextName.element = nextPlayer.getName();
            weightUntilOvertake = nextPlayer.getWeight() - totalWeight;
        }
        if (nextPlayer.getWeight() == 0.0) {
            return Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cRejoin the garden to show ETA!", CollectionsKt.listOf("Click here to calculate the data right now!"), false, this.getRecalculate(), null, 20, null);
        }
        if (!(weightPerSecond == -1.0)) {
            long l;
            try {
                l = DurationKt.toDuration(weightUntilOvertake / weightPerSecond, DurationUnit.SECONDS);
            }
            catch (Exception e) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("weightPerSecond", weightPerSecond), TuplesKt.to("weightUntilOvertake", weightUntilOvertake), TuplesKt.to("totalWeight", totalWeight), TuplesKt.to("nextPlayer.weight", nextPlayer.getWeight())};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error calculating Farming ETA duration", pairArray, false, false, false, 56, null);
                return null;
            }
            long timeTillOvertake = l;
            String format = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, timeTillOvertake, null, false, false, 0, false, 31, null);
            string2 = " \u00a77(\u00a7b" + format + "\u00a77)";
        } else {
            string2 = "";
        }
        String timeFormat = string2;
        String weightFormat = NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(weightUntilOvertake, 2));
        String text = "\u00a7e" + weightFormat + timeFormat + " \u00a77behind \u00a7b" + (String)nextName.element;
        return showRankGoal ? Renderable.Companion.string$default(Renderable.Companion, text, 0.0, null, null, null, 30, null) : Renderable.Companion.clickAndHover$default(Renderable.Companion, text, CollectionsKt.listOf("\u00a7eClick to open the Farming Profile of \u00a7b" + (String)nextName.element + '.'), false, () -> FarmingWeightDisplay.getETA$lambda$6(nextName), null, 20, null);
    }

    private final void resetData() {
        apiError = false;
        weight = -1.0;
        weightPerSecond = -1.0;
        leaderboardPosition = -1;
        weightNeedsRecalculating = true;
        lastLeaderboardUpdate = SimpleTimeMark.Companion.farPast();
        nextPlayers.clear();
        rankGoal = -1;
        localCounter.clear();
    }

    private final void farmingChatMessage(String message) {
        String[] stringArray = new String[]{"\u00a7eClick to open your Farming Weight", "\u00a7eprofile on \u00a7celitebot.dev"};
        ChatUtils.hoverableChat$default(ChatUtils.INSTANCE, message, CollectionsKt.listOf(stringArray), "/shfarmingprofile " + LorenzUtils.INSTANCE.getPlayerName(), false, null, 24, null);
    }

    private final boolean isEnabled() {
        return (OutsideSbFeature.FARMING_WEIGHT.isSelected() && !LorenzUtils.INSTANCE.getInSkyBlock() || LorenzUtils.INSTANCE.getInSkyBlock() && (GardenAPI.INSTANCE.inGarden() || this.getConfig().showOutsideGarden)) && this.getConfig().display;
    }

    private final boolean isEtaEnabled() {
        return this.getConfig().overtakeETA;
    }

    public final void addCrop(@NotNull CropType crop, int addedCounter) {
        Intrinsics.checkNotNullParameter((Object)crop, "crop");
        if (addedCounter == 0) {
            return;
        }
        double before = this.getExactWeight();
        localCounter.put(crop, this.getLocalCounter(crop) + (long)addedCounter);
        double after = this.getExactWeight();
        this.updateWeightPerSecond(crop, before, after, addedCounter);
        weightNeedsRecalculating = true;
    }

    private final void updateWeightPerSecond(CropType crop, double before, double after, int diff) {
        Integer n = GardenCropSpeed.INSTANCE.getSpeed(crop);
        if (n == null) {
            return;
        }
        int speed = n;
        double weightDiff = (after - before) * (double)1000;
        weightPerSecond = weightDiff / (double)diff * (double)speed / (double)1000;
    }

    private final double getExactWeight() {
        Collection<Double> values2 = this.calculateCollectionWeight().values();
        return !values2.isEmpty() ? CollectionsKt.sumOfDouble((Iterable<Double>)values2) : 0.0;
    }

    private final void loadLeaderboardIfAble() {
        if (isLoadingLeaderboard) {
            return;
        }
        isLoadingLeaderboard = true;
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        ResultKt.throwOnFailure(object);
                        boolean wasNotLoaded = FarmingWeightDisplay.access$getLeaderboardPosition$p() == -1;
                        FarmingWeightDisplay.access$setLeaderboardPosition$p(FarmingWeightDisplay.access$loadLeaderboardPosition(FarmingWeightDisplay.INSTANCE));
                        if (wasNotLoaded && FarmingWeightDisplay.access$getConfig((FarmingWeightDisplay)FarmingWeightDisplay.INSTANCE).showLbChange) {
                            FarmingWeightDisplay.access$checkOffScreenLeaderboardChanges(FarmingWeightDisplay.INSTANCE);
                        }
                        if ((object2 = GardenAPI.INSTANCE.getStorage()) != null && (object2 = ((ProfileSpecificStorage.GardenStorage)object2).farmingWeight) != null) {
                            ((ProfileSpecificStorage.GardenStorage.FarmingWeightConfig)object2).lastFarmingWeightLeaderboard = FarmingWeightDisplay.access$getLeaderboardPosition$p();
                        }
                        FarmingWeightDisplay.access$setLastLeaderboardUpdate$p(SimpleTimeMark.Companion.now-uFjCsEo());
                        FarmingWeightDisplay.access$setLoadingLeaderboard$p(false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void checkOffScreenLeaderboardChanges() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (profileSpecificStorage == null) {
            return;
        }
        ProfileSpecificStorage profileSpecific = profileSpecificStorage;
        int oldPosition = profileSpecific.garden.farmingWeight.lastFarmingWeightLeaderboard;
        if (oldPosition <= 0) {
            return;
        }
        if (leaderboardPosition <= 0) {
            return;
        }
        int diff = leaderboardPosition - oldPosition;
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            this.showLbChange("\u00a7cdropped " + StringUtils.pluralize$default(StringUtils.INSTANCE, diff, "place", null, true, 4, null), oldPosition);
        } else {
            this.showLbChange("\u00a7arisen " + StringUtils.pluralize$default(StringUtils.INSTANCE, -diff, "place", null, true, 4, null), oldPosition);
        }
    }

    private final void showLbChange(String direction, int oldPosition) {
        this.farmingChatMessage("\u00a77Since your last visit to the \u00a7aGarden\u00a77, you have " + direction + " \u00a77on the \u00a7dFarming Leaderboard\u00a77. \u00a77(\u00a7e#" + NumberUtil.INSTANCE.addSeparators(oldPosition) + " \u00a77-> \u00a7e#" + NumberUtil.INSTANCE.addSeparators(leaderboardPosition) + "\u00a77)");
    }

    private final int loadLeaderboardPosition() {
        String uuid = LorenzUtils.INSTANCE.getPlayerUuid();
        String includeUpcoming = this.isEtaEnabled() ? "?includeUpcoming=true" : "";
        int goalRank = this.getRankGoal() + 1;
        String atRank = this.isEtaEnabled() && goalRank != 10001 ? "&atRank=" + goalRank : "";
        String url = "https://api.elitebot.dev/leaderboard/rank/farmingweight/" + uuid + '/' + profileId + includeUpcoming + atRank;
        JsonObject apiResponse = APIUtils.getJSONResponse$default(APIUtils.INSTANCE, url, false, 2, null);
        try {
            EliteLeaderboard apiData = this.toEliteLeaderboardJson(apiResponse).getData();
            if (this.isEtaEnabled()) {
                nextPlayers.clear();
                Iterable $this$forEach$iv = apiData.getUpcomingPlayers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UpcomingLeaderboardPlayer it = (UpcomingLeaderboardPlayer)element$iv;
                    boolean bl = false;
                    nextPlayers.add(it);
                }
            }
            return apiData.getRank();
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("url", url), TuplesKt.to("apiResponse", apiResponse)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error getting weight leaderboard position", pairArray, false, false, false, 56, null);
            return -1;
        }
    }

    private final EliteLeaderboardJson toEliteLeaderboardJson(JsonObject obj) {
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("data", (JsonElement)obj);
        Gson gson2 = this.getEliteWeightApiGson();
        Intrinsics.checkNotNullExpressionValue(gson2, "<get-eliteWeightApiGson>(...)");
        Gson $this$fromJson$iv = gson2;
        boolean $i$f$fromJson = false;
        Object object = $this$fromJson$iv.fromJson((JsonElement)jsonObject2, ReflectJvmMapping.getJavaType(Reflection.typeOf(EliteLeaderboardJson.class)));
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        return (EliteLeaderboardJson)object;
    }

    private final void loadWeight(String localProfile) {
        String uuid = LorenzUtils.INSTANCE.getPlayerUuid();
        String url = "https://api.elitebot.dev/weight/" + uuid;
        JsonObject apiResponse = APIUtils.getJSONResponse$default(APIUtils.INSTANCE, url, false, 2, null);
        Throwable error = null;
        try {
            WeightProfile selectedProfileEntry;
            block10: {
                Object v5;
                block8: {
                    WeightProfile it;
                    Iterable iterable;
                    ElitePlayerWeightJson apiData;
                    block9: {
                        Object v2;
                        block7: {
                            Gson gson2 = this.getEliteWeightApiGson();
                            Intrinsics.checkNotNullExpressionValue(gson2, "<get-eliteWeightApiGson>(...)");
                            Gson $this$fromJson$iv = gson2;
                            boolean $i$f$fromJson = false;
                            Object object = $this$fromJson$iv.fromJson((JsonElement)apiResponse, ReflectJvmMapping.getJavaType(Reflection.typeOf(ElitePlayerWeightJson.class)));
                            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
                            apiData = (ElitePlayerWeightJson)object;
                            String selectedProfileId = apiData.getSelectedProfileId();
                            iterable = apiData.getProfiles();
                            for (Object t : iterable) {
                                it = (WeightProfile)t;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(it.getProfileId(), selectedProfileId)) continue;
                                v2 = t;
                                break block7;
                            }
                            v2 = null;
                        }
                        selectedProfileEntry = v2;
                        if (selectedProfileEntry == null) break block9;
                        String string2 = selectedProfileEntry.getProfileName().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                        if (Intrinsics.areEqual(string2, localProfile) || Intrinsics.areEqual(localProfile, "")) break block10;
                    }
                    iterable = apiData.getProfiles();
                    for (Object t : iterable) {
                        it = (WeightProfile)t;
                        boolean bl = false;
                        String string3 = it.getProfileName().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                        if (!Intrinsics.areEqual(string3, localProfile)) continue;
                        v5 = t;
                        break block8;
                    }
                    v5 = null;
                }
                selectedProfileEntry = v5;
            }
            if (selectedProfileEntry != null) {
                profileId = selectedProfileEntry.getProfileId();
                weight = selectedProfileEntry.getTotalWeight();
                localCounter.clear();
                weightNeedsRecalculating = true;
                return;
            }
        }
        catch (Exception e) {
            error = e;
        }
        apiError = true;
        Throwable throwable = error;
        if (throwable == null) {
            throwable = new IllegalStateException("Error loading user farming weight");
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("url", url), TuplesKt.to("apiResponse", apiResponse), TuplesKt.to("localProfile", localProfile)};
        ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, throwable, "Error loading user farming weight\n\u00a7eLoading the farming weight data from elitebot.dev failed!\n\u00a7eYou can re-enter the garden to try to fix the problem.\n\u00a7cIf this message repeats, please report it on Discord", pairArray, false, false, false, 56, null);
    }

    private final Map<CropType, Double> calculateCollectionWeight() {
        Map weightPerCrop = new LinkedHashMap();
        double totalWeight = 0.0;
        for (CropType crop : CropType.getEntries()) {
            double weight = (double)this.getLocalCounter(crop) / this.getFactor(crop);
            Double d = weight;
            weightPerCrop.put(crop, d);
            totalWeight += weight;
        }
        if (totalWeight > 0.0) {
            weightPerCrop.put(CropType.MUSHROOM, this.specialMushroomWeight(weightPerCrop, totalWeight));
        }
        return weightPerCrop;
    }

    private final double specialMushroomWeight(Map<CropType, Double> weightPerCrop, double totalWeight) {
        Double d = weightPerCrop.get((Object)CropType.CACTUS);
        Intrinsics.checkNotNull(d);
        double cactusWeight = ((Number)d).doubleValue();
        Double d2 = weightPerCrop.get((Object)CropType.SUGAR_CANE);
        Intrinsics.checkNotNull(d2);
        double sugarCaneWeight = ((Number)d2).doubleValue();
        double doubleBreakRatio = (cactusWeight + sugarCaneWeight) / totalWeight;
        double normalRatio = (totalWeight - cactusWeight - sugarCaneWeight) / totalWeight;
        double mushroomFactor = this.getFactor(CropType.MUSHROOM);
        long mushroomCollection = this.getLocalCounter(CropType.MUSHROOM);
        return doubleBreakRatio * ((double)mushroomCollection / ((double)2 * mushroomFactor)) + normalRatio * ((double)mushroomCollection / mushroomFactor);
    }

    private final long getLocalCounter(CropType $this$getLocalCounter) {
        Long l = localCounter.get((Object)$this$getLocalCounter);
        return l != null ? l : 0L;
    }

    private final double getFactor(CropType $this$getFactor) {
        double d;
        Double d2 = cropWeight.get((Object)$this$getFactor);
        if (d2 != null) {
            d = d2;
        } else {
            Double d3 = this.getBackupCropWeights().get((Object)$this$getFactor);
            if (d3 != null) {
                d = d3;
            } else {
                throw new IllegalStateException(("Crop " + (Object)((Object)$this$getFactor) + " not in backupFactors!").toString());
            }
        }
        return d;
    }

    public final void lookUpCommand(@NotNull String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String name2 = it.length == 1 ? it[0] : LorenzUtils.INSTANCE.getPlayerName();
        this.openWebsite(name2, true);
    }

    private final void openWebsite(String name2, boolean ignoreCooldown) {
        if (!ignoreCooldown) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastOpenWebsite), DurationKt.toDuration(5, DurationUnit.SECONDS)) < 0 && Intrinsics.areEqual(name2, lastName)) {
                return;
            }
        }
        lastOpenWebsite = SimpleTimeMark.Companion.now-uFjCsEo();
        lastName = name2;
        OSUtils.openBrowser("https://elitebot.dev/@" + name2 + '/');
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Opening Farming Profile of player \u00a7b" + name2, false, null, 6, null);
    }

    static /* synthetic */ void openWebsite$default(FarmingWeightDisplay farmingWeightDisplay, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        farmingWeightDisplay.openWebsite(string2, bl);
    }

    private final void getCropWeights() {
        if (attemptingCropWeightFetch || hasFetchedCropWeights) {
            return;
        }
        attemptingCropWeightFetch = true;
        String url = "https://api.elitebot.dev/weights/all";
        JsonObject apiResponse = APIUtils.getJSONResponse$default(APIUtils.INSTANCE, url, false, 2, null);
        try {
            Gson gson2 = this.getEliteWeightApiGson();
            Intrinsics.checkNotNullExpressionValue(gson2, "<get-eliteWeightApiGson>(...)");
            Gson $this$fromJson$iv = gson2;
            boolean $i$f$fromJson = false;
            Object object = $this$fromJson$iv.fromJson((JsonElement)apiResponse, ReflectJvmMapping.getJavaType(Reflection.typeOf(EliteWeightsJson.class)));
            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
            EliteWeightsJson apiData = (EliteWeightsJson)object;
            apiData.getCrops();
            for (Map.Entry<CropType, Double> crop : apiData.getCrops().entrySet()) {
                cropWeight.put(crop.getKey(), crop.getValue());
            }
            hasFetchedCropWeights = true;
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("apiResponse", apiResponse)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error getting crop weights from elitebot.dev", pairArray, false, false, false, 56, null);
        }
    }

    private final Map<CropType, Double> getBackupCropWeights() {
        Lazy lazy = backupCropWeights$delegate;
        return (Map)lazy.getValue();
    }

    private static final Unit recalculate_delegate$lambda$1$lambda$0() {
        INSTANCE.resetData();
        return Unit.INSTANCE;
    }

    private static final Function0 recalculate_delegate$lambda$1() {
        return FarmingWeightDisplay::recalculate_delegate$lambda$1$lambda$0;
    }

    private static final Gson eliteWeightApiGson_delegate$lambda$2() {
        return BaseGsonBuilder.INSTANCE.gson().registerTypeAdapter((Type)((Object)CropType.class), (Object)SkyHanniTypeAdapters.INSTANCE.getCROP_TYPE().nullSafe()).registerTypeAdapter((Type)((Object)PestType.class), (Object)SkyHanniTypeAdapters.INSTANCE.getPEST_TYPE().nullSafe()).create();
    }

    private static final List errorMessage_delegate$lambda$3() {
        Renderable[] renderableArray = new Renderable[]{Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cFarming Weight error: Cannot load", CollectionsKt.listOf("\u00a7eClick here to reload the data right now!"), false, INSTANCE.getRecalculate(), null, 20, null), Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cdata from Elite Farmers!", CollectionsKt.listOf("\u00a7eClick here to reload the data right now!"), false, INSTANCE.getRecalculate(), null, 20, null), Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7eRejoin the garden or", CollectionsKt.listOf("\u00a7eClick here to reload the data right now!"), false, INSTANCE.getRecalculate(), null, 20, null), Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7eclick here to fix it.", CollectionsKt.listOf("\u00a7eClick here to reload the data right now!"), false, INSTANCE.getRecalculate(), null, 20, null)};
        return CollectionsKt.listOf(renderableArray);
    }

    private static final Unit update$lambda$4() {
        FarmingWeightDisplay.openWebsite$default(INSTANCE, LorenzUtils.INSTANCE.getPlayerName(), false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit getETA$lambda$6(Ref.ObjectRef $nextName) {
        Intrinsics.checkNotNullParameter($nextName, "$nextName");
        FarmingWeightDisplay.openWebsite$default(INSTANCE, (String)$nextName.element, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Map backupCropWeights_delegate$lambda$10() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(CropType.WHEAT, 100000.0), TuplesKt.to(CropType.CARROT, 302061.86), TuplesKt.to(CropType.POTATO, 300000.0), TuplesKt.to(CropType.SUGAR_CANE, 200000.0), TuplesKt.to(CropType.NETHER_WART, 250000.0), TuplesKt.to(CropType.PUMPKIN, 98284.71), TuplesKt.to(CropType.MELON, 485308.47), TuplesKt.to(CropType.MUSHROOM, 90178.06), TuplesKt.to(CropType.COCOA_BEANS, 267174.04), TuplesKt.to(CropType.CACTUS, 177254.45)};
        return MapsKt.mapOf(pairArray);
    }

    public static final /* synthetic */ void access$getCropWeights(FarmingWeightDisplay $this) {
        $this.getCropWeights();
    }

    public static final /* synthetic */ void access$loadWeight(FarmingWeightDisplay $this, String localProfile) {
        $this.loadWeight(localProfile);
    }

    public static final /* synthetic */ void access$setLoadingWeight$p(boolean bl) {
        isLoadingWeight = bl;
    }

    public static final /* synthetic */ int access$getLeaderboardPosition$p() {
        return leaderboardPosition;
    }

    public static final /* synthetic */ void access$setLeaderboardPosition$p(int n) {
        leaderboardPosition = n;
    }

    public static final /* synthetic */ int access$loadLeaderboardPosition(FarmingWeightDisplay $this) {
        return $this.loadLeaderboardPosition();
    }

    public static final /* synthetic */ EliteFarmingWeightConfig access$getConfig(FarmingWeightDisplay $this) {
        return $this.getConfig();
    }

    public static final /* synthetic */ void access$checkOffScreenLeaderboardChanges(FarmingWeightDisplay $this) {
        $this.checkOffScreenLeaderboardChanges();
    }

    public static final /* synthetic */ void access$setLastLeaderboardUpdate$p(long l) {
        lastLeaderboardUpdate = l;
    }

    public static final /* synthetic */ void access$setLoadingLeaderboard$p(boolean bl) {
        isLoadingLeaderboard = bl;
    }

    static {
        leaderboardPosition = -1;
        weight = -1.0;
        weightPerSecond = -1.0;
        rankGoal = -1;
        nextPlayers = new ArrayList();
        recalculate$delegate = LazyKt.lazy(FarmingWeightDisplay::recalculate_delegate$lambda$1);
        eliteWeightApiGson$delegate = LazyKt.lazy(FarmingWeightDisplay::eliteWeightApiGson_delegate$lambda$2);
        errorMessage$delegate = LazyKt.lazy(FarmingWeightDisplay::errorMessage_delegate$lambda$3);
        lastOpenWebsite = SimpleTimeMark.Companion.farPast();
        lastName = "";
        cropWeight = new LinkedHashMap();
        backupCropWeights$delegate = LazyKt.lazy(FarmingWeightDisplay::backupCropWeights_delegate$lambda$10);
    }
}

