/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.events.CropClickEvent;
import at.hannibal2.skyhanni.events.CropMilestoneUpdateEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\r\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0018\u0010 \u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\u001eR\"\u0010&\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010*R\"\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020,0+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/CropSpeedMeter;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/CropClickEvent;", "event", "", "onCropClick", "(Lat/hannibal2/skyhanni/events/CropClickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "updateDisplay", "", "", "renderDisplay", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/events/CropMilestoneUpdateEvent;", "onCropMilestoneUpdate", "(Lat/hannibal2/skyhanni/events/CropMilestoneUpdateEvent;)V", "breakBlock", "toggle", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/features/garden/CropType;", "currentCrop", "Lat/hannibal2/skyhanni/features/garden/CropType;", "", "currentBlocks", "I", "snapshot", "enabled", "Z", "getEnabled", "setEnabled", "(Z)V", "", "", "startCrops", "Ljava/util/Map;", "1.8.9"})
public final class CropSpeedMeter {
    @NotNull
    public static final CropSpeedMeter INSTANCE = new CropSpeedMeter();
    @NotNull
    private static List<String> display = CollectionsKt.emptyList();
    @Nullable
    private static CropType currentCrop;
    private static int currentBlocks;
    @NotNull
    private static List<String> snapshot;
    private static boolean enabled;
    @NotNull
    private static Map<CropType, Long> startCrops;

    private CropSpeedMeter() {
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void setEnabled(boolean bl) {
        enabled = bl;
    }

    @SubscribeEvent
    public final void onCropClick(@NotNull CropClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (startCrops.isEmpty()) {
            return;
        }
        CropType crop = event.getCrop();
        if (currentCrop != crop) {
            currentCrop = crop;
            currentBlocks = 0;
            snapshot = CollectionsKt.emptyList();
        }
        this.breakBlock();
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!LorenzTickEvent.isMod$default(event, 15, 0, 2, null)) {
            return;
        }
        this.updateDisplay();
    }

    private final void updateDisplay() {
        display = this.renderDisplay();
    }

    private final List<String> renderDisplay() {
        List list = new ArrayList();
        list.add("\u00a77Crop Speed Meter");
        if (startCrops.isEmpty()) {
            list.add("\u00a7cOpen \u00a7e/cropmilestones \u00a7cto start!");
            return list;
        }
        if (currentCrop == null) {
            list.add("\u00a7cStart breaking blocks!");
            return list;
        }
        CropType cropType = currentCrop;
        if (cropType != null) {
            CropType it = cropType;
            boolean bl = false;
            list.add(" \u00a77Current " + it.getCropName() + " counter: \u00a7e" + NumberUtil.INSTANCE.addSeparators(currentBlocks));
        }
        if (!((Collection)snapshot).isEmpty()) {
            CollectionsKt.addAll((Collection)list, (Iterable)snapshot);
        } else {
            list.add("\u00a7cOpen \u00a7e/cropmilestones \u00a7cagain to calculate!");
        }
        return list;
    }

    @SubscribeEvent
    public final void onCropMilestoneUpdate(@NotNull CropMilestoneUpdateEvent event) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, "event");
                if (!this.isEnabled()) {
                    return;
                }
                Map counters = new LinkedHashMap();
                for (CropType cropType : CropType.getEntries()) {
                    counters.put(cropType, GardenCropMilestones.INSTANCE.getCounter(cropType));
                }
                if (!startCrops.isEmpty()) break block2;
                startCrops = counters;
                currentCrop = null;
                snapshot = CollectionsKt.emptyList();
                break block3;
            }
            CropType cropType = currentCrop;
            if (cropType == null) break block3;
            CropType it = cropType;
            boolean bl = false;
            long l = GardenCropMilestones.INSTANCE.getCounter(it);
            Long l2 = startCrops.get((Object)it);
            Intrinsics.checkNotNull(l2);
            long crops = l - ((Number)l2).longValue();
            int blocks = currentBlocks;
            double cropsPerBlocks = NumberUtil.INSTANCE.roundTo((double)crops / (double)blocks, 3);
            List list = new ArrayList();
            list.add("");
            list.add("\u00a76Calculation results");
            list.add(" \u00a77Crops collected: " + NumberUtil.INSTANCE.addSeparators(crops));
            list.add(" \u00a77Blocks broken: " + NumberUtil.INSTANCE.addSeparators(blocks));
            list.add(" \u00a77Crops per Block: " + NumberUtil.INSTANCE.addSeparators(cropsPerBlocks));
            double baseDrops = it.getBaseDrops();
            double farmingFortune = NumberUtil.INSTANCE.roundTo(cropsPerBlocks * (double)100 / baseDrops, 3);
            list.add(" \u00a77Calculated farming Fortune: \u00a7e" + NumberUtil.INSTANCE.addSeparators(farmingFortune));
            list.add("\u00a7cOpen /cropmilestones again to recalculate!");
            snapshot = list;
            INSTANCE.updateDisplay();
        }
    }

    private final void breakBlock() {
        int n = currentBlocks;
        currentBlocks = n + 1;
    }

    public final void toggle() {
        enabled = !enabled;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Crop Speed Meter " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"), false, null, 6, null);
        startCrops = MapsKt.emptyMap();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = GardenAPI.INSTANCE.getConfig().cropSpeedMeterPos;
        Intrinsics.checkNotNullExpressionValue(position, "cropSpeedMeterPos");
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, position, display, 0, "Crop Speed Meter", 2, null);
    }

    public final boolean isEnabled() {
        return enabled && GardenAPI.INSTANCE.inGarden();
    }

    static {
        snapshot = CollectionsKt.emptyList();
        startCrops = MapsKt.emptyMap();
    }
}

