/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.contest;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.RenderItemTooltipEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.FarmingFortuneDisplay;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.contest.ContestBracket;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContest;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestAPI;
import at.hannibal2.skyhanni.features.garden.contest.JacobContestFFNeededDisplayKt;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J3\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$R\u001c\u0010)\u001a\n &*\u0004\u0018\u00010%0%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\"\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R,\u00101\u001a\u001a\u0012\u0004\u0012\u000200\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u000e0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/features/garden/contest/JacobContestFFNeededDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RenderItemTooltipEvent;", "event", "", "onRenderItemTooltip", "(Lat/hannibal2/skyhanni/events/RenderItemTooltipEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;", "contest", "", "drawDisplay", "(Lat/hannibal2/skyhanni/features/garden/contest/FarmingContest;)Ljava/util/List;", "", "farmingFortune", "", "formatFarmingFortune", "(D)Ljava/lang/String;", "Lat/hannibal2/skyhanni/features/garden/contest/ContestBracket;", "bracket", "", "", "map", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "getLine", "(Lat/hannibal2/skyhanni/features/garden/contest/ContestBracket;Ljava/util/Map;Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "config", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastToolTipTime", "J", "", "Lnet/minecraft/item/ItemStack;", "cache", "Ljava/util/Map;", "1.8.9"})
public final class JacobContestFFNeededDisplay {
    @NotNull
    public static final JacobContestFFNeededDisplay INSTANCE = new JacobContestFFNeededDisplay();
    @NotNull
    private static List<? extends List<? extends Object>> display = CollectionsKt.emptyList();
    private static long lastToolTipTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final Map<ItemStack, List<List<Object>>> cache = new LinkedHashMap();

    private JacobContestFFNeededDisplay() {
    }

    private final GardenConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig();
    }

    @SubscribeEvent
    public final void onRenderItemTooltip(@NotNull RenderItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!StringsKt.contains$default((CharSequence)InventoryUtils.INSTANCE.openInventoryName(), "Your Contests", false, 2, null)) {
            return;
        }
        ItemStack stack = event.getStack();
        List<List<Object>> oldData = cache.get(stack);
        if (oldData != null) {
            display = oldData;
            lastToolTipTime = SimpleTimeMark.Companion.now-uFjCsEo();
            return;
        }
        Long l = FarmingContestAPI.INSTANCE.getSbTimeFor(ItemUtils.INSTANCE.getName(stack));
        if (l == null) {
            return;
        }
        long time = l;
        FarmingContest farmingContest = FarmingContestAPI.INSTANCE.getContestAtTime(time);
        if (farmingContest == null) {
            return;
        }
        FarmingContest contest = farmingContest;
        List<List<Object>> newDisplay = this.drawDisplay(contest);
        display = newDisplay;
        cache.put(stack, newDisplay);
        lastToolTipTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        cache.clear();
    }

    private final List<List<Object>> drawDisplay(FarmingContest contest) {
        boolean bl;
        Object[] objectArray;
        List<List<List<Object>>> list;
        List<List<List<Object>>> $this$drawDisplay_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "\u00a76Minimum Farming Fortune needed");
        CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "");
        CropType crop = contest.getCrop();
        Object object = new Object[]{"\u00a77For this ", crop.getIcon(), "\u00a77" + crop.getCropName() + " contest:"};
        $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf(object));
        for (ContestBracket bracket2 : ContestBracket.getEntries()) {
            CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, INSTANCE.getLine(bracket2, contest.getBrackets(), crop));
        }
        CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "");
        object = FarmingContestAPI.INSTANCE.calculateAverages(crop);
        int size = ((Number)((Pair)object).component1()).intValue();
        Map averages = (Map)((Pair)object).component2();
        Object[] objectArray2 = new Object[]{"\u00a77For the last \u00a7e" + size + ' ', crop.getIcon(), "\u00a77" + crop.getCropName() + " contests:"};
        $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf(objectArray2));
        for (ContestBracket contestBracket : ContestBracket.getEntries()) {
            CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, INSTANCE.getLine(contestBracket, averages, crop));
        }
        CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "");
        Double blocksPerSecond = GardenCropSpeed.INSTANCE.getLatestBlocksPerSecond(crop);
        if (blocksPerSecond == null) {
            Object[] objectArray3 = new Object[]{"\u00a7cNo ", crop.getIcon(), "\u00a7cblocks/second data,"};
            $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf(objectArray3));
            CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "\u00a7cassuming 19.9 instead.");
        } else if (blocksPerSecond < 15.0) {
            Object[] objectArray4 = new Object[]{"\u00a77Your latest ", crop.getIcon(), "\u00a77blocks/second: \u00a7e" + NumberUtil.INSTANCE.roundTo(blocksPerSecond, 2)};
            $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf(objectArray4));
            $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf("\u00a7cThis is too low, showing 19.9 Blocks/second instead!"));
            blocksPerSecond = 19.9;
        }
        CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "");
        Double d = FarmingFortuneDisplay.INSTANCE.getLatestTrueFarmingFortune(crop);
        if (d == null) {
            CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "\u00a7cNo latest true FF saved!");
        } else {
            String farmingFortune = INSTANCE.formatFarmingFortune(d);
            objectArray = new Object[]{"\u00a76Your ", crop.getIcon(), "\u00a76FF: " + farmingFortune};
            $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf(objectArray));
        }
        CollectionUtils.INSTANCE.addAsSingletonList($this$drawDisplay_u24lambda_u240, "");
        if (blocksPerSecond == null || d == null) {
            bl = $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf("\u00a7cMissing data from above!"));
        } else {
            String predictedScore = NumberUtil.INSTANCE.addSeparators((int)((100.0 + d) * blocksPerSecond * crop.getBaseDrops() * (double)20 * (double)60 / (double)100));
            objectArray = new Object[]{"\u00a76Predicted ", crop.getIcon(), "\u00a76crops: " + predictedScore};
            bl = $this$drawDisplay_u24lambda_u240.add(CollectionsKt.listOf(objectArray));
        }
        return CollectionsKt.build(list);
    }

    private final String formatFarmingFortune(double farmingFortune) {
        return NumberUtil.INSTANCE.addSeparators(Math.ceil(farmingFortune));
    }

    private final String getLine(ContestBracket bracket, Map<ContestBracket, Integer> map2, CropType crop) {
        Integer n = map2.get((Object)bracket);
        if (n == null) {
            return ' ' + bracket.getDisplayName() + "\u00a7f: \u00a78Not found!";
        }
        int counter = n;
        double blocksPerSecond = JacobContestFFNeededDisplayKt.access$getRealBlocksPerSecond(crop);
        double cropsPerSecond = (double)counter / blocksPerSecond / (double)60;
        double farmingFortune = cropsPerSecond * (double)100 / (double)20 / crop.getBaseDrops() - (double)100;
        String format = this.formatFarmingFortune(RangesKt.coerceAtLeast(farmingFortune, 0.0));
        return ' ' + bracket.getDisplayName() + "\u00a7f: \u00a76" + format + " FF \u00a77(" + NumberUtil.INSTANCE.addSeparators(counter) + " crops)";
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!FarmingContestAPI.INSTANCE.getInInventory()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastToolTipTime), DurationKt.toDuration(200, DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        Position position = this.getConfig().farmingFortuneForContestPos;
        Intrinsics.checkNotNullExpressionValue(position, "farmingFortuneForContestPos");
        RenderUtils.renderStringsAndItems$default(RenderUtils.INSTANCE, position, display, 0, 0.0, "Jacob Contest Crop Data", 6, null);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().farmingFortuneForContest;
    }
}

