/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.command.CommandBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u000b\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000f\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0017\u001a\u00020\u0004*\u00020\u00152\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/features/garden/FarmingMilestoneCommand;", "", "<init>", "()V", "", "crop", "current", "target", "", "needsTime", "", "onCommand", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "", "args", "setGoal", "([Ljava/lang/String;)V", "strings", "", "onComplete", "([Ljava/lang/String;)Ljava/util/List;", "", "Lat/hannibal2/skyhanni/features/garden/CropType;", "formatOutput", "(JZLat/hannibal2/skyhanni/features/garden/CropType;)Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFarmingMilestoneCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FarmingMilestoneCommand.kt\nat/hannibal2/skyhanni/features/garden/FarmingMilestoneCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1557#2:102\n1628#2,3:103\n*S KotlinDebug\n*F\n+ 1 FarmingMilestoneCommand.kt\nat/hannibal2/skyhanni/features/garden/FarmingMilestoneCommand\n*L\n89#1:102\n89#1:103,3\n*E\n"})
public final class FarmingMilestoneCommand {
    @NotNull
    public static final FarmingMilestoneCommand INSTANCE = new FarmingMilestoneCommand();

    private FarmingMilestoneCommand() {
    }

    public final void onCommand(@Nullable String crop, @Nullable String current, @Nullable String target, boolean needsTime) {
        Integer targetMilestone;
        if (crop == null) {
            ChatUtils.INSTANCE.userError("No crop type entered");
            return;
        }
        CropType cropType = CropType.Companion.getByNameOrNull(crop);
        if (cropType == null) {
            FarmingMilestoneCommand $this$onCommand_u24lambda_u240 = this;
            boolean bl = false;
            ChatUtils.INSTANCE.userError("Invalid crop type entered");
            return;
        }
        CropType enteredCrop = cropType;
        String string2 = current;
        Integer currentMilestone = string2 != null ? StringsKt.toIntOrNull(string2) : null;
        String string3 = target;
        Integer n = targetMilestone = string3 != null ? StringsKt.toIntOrNull(string3) : null;
        if (currentMilestone == null) {
            long currentProgress = GardenCropMilestones.INSTANCE.getCounter(enteredCrop);
            int currentCropMilestone = GardenCropMilestones.INSTANCE.getTierForCropCount(currentProgress, enteredCrop, true) + 1;
            long cropsForTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentCropMilestone, enteredCrop, true);
            String output = this.formatOutput(cropsForTier - currentProgress, needsTime, enteredCrop);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77" + output + " needed to reach the next milestone", false, null, 6, null);
            return;
        }
        if (targetMilestone == null) {
            long cropsForTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentMilestone, enteredCrop, true);
            String output = this.formatOutput(cropsForTier, needsTime, enteredCrop);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77" + output + " needed for milestone \u00a77" + currentMilestone, false, null, 6, null);
            return;
        }
        if (currentMilestone >= targetMilestone) {
            ChatUtils.INSTANCE.userError("Entered milestone is greater than or the same as target milestone");
            return;
        }
        long currentAmount = GardenCropMilestones.INSTANCE.getCropsForTier(currentMilestone, enteredCrop, true);
        long targetAmount = GardenCropMilestones.INSTANCE.getCropsForTier(targetMilestone, enteredCrop, true);
        String output = this.formatOutput(targetAmount - currentAmount, needsTime, enteredCrop);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77" + output + " needed for milestone \u00a77" + currentMilestone + " \u00a7a-> \u00a77" + targetMilestone, false, null, 6, null);
    }

    public final void setGoal(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (object == null || (object = ((ProfileSpecificStorage)object).garden) == null || (object = ((ProfileSpecificStorage.GardenStorage)object).customGoalMilestone) == null) {
            return;
        }
        Map<CropType, Integer> storage2 = object;
        if (args2.length != 2) {
            ChatUtils.INSTANCE.userError("Usage: /shcropgoal <crop name> <target milestone>");
            return;
        }
        CropType cropType = CropType.Companion.getByNameOrNull(args2[0]);
        if (cropType == null) {
            FarmingMilestoneCommand $this$setGoal_u24lambda_u241 = this;
            boolean bl = false;
            ChatUtils.INSTANCE.userError("Not a crop type: '" + args2[0] + '\'');
            return;
        }
        CropType enteredCrop = cropType;
        Integer n = NumberUtil.INSTANCE.formatIntOrUserError(args2[1]);
        if (n == null) {
            return;
        }
        int targetLevel = n;
        long counter = GardenCropMilestones.INSTANCE.getCounter(enteredCrop);
        int level = GardenCropMilestones.getTierForCropCount$default(GardenCropMilestones.INSTANCE, counter, enteredCrop, false, 4, null);
        if (targetLevel <= level && targetLevel != 0) {
            ChatUtils.INSTANCE.userError("Custom goal milestone (" + targetLevel + ") must be greater than your current milestone (" + level + ").");
            return;
        }
        Integer n2 = targetLevel;
        storage2.put(enteredCrop, n2);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Custom goal milestone for \u00a7b" + enteredCrop.getCropName() + " \u00a7eset to \u00a7b" + targetLevel + '.', false, null, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> onComplete(@NotNull String[] strings) {
        List list;
        Intrinsics.checkNotNullParameter(strings, "strings");
        if (strings.length <= 1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CropType.getEntries();
            String[] stringArray = strings;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CropType cropType = (CropType)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSimpleName());
            }
            List list2 = CommandBase.func_175762_a((String[])stringArray, (Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String formatOutput(long $this$formatOutput, boolean needsTime, CropType crop) {
        if (!needsTime) {
            return NumberUtil.INSTANCE.addSeparators($this$formatOutput) + " \u00a7a" + crop.getCropName();
        }
        Integer n = GardenCropSpeed.INSTANCE.getSpeed(crop);
        int speed = n != null ? n : -1;
        long missingTime = DurationKt.toDuration($this$formatOutput / (long)speed, DurationUnit.SECONDS);
        return TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, missingTime, null, false, false, 0, false, 31, null) + "\u00a7a";
    }
}

