/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.AnitaShopConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.visitor.VisitorAPI;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.DisplayTableEntry;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'R\u001c\u0010,\u001a\n )*\u0004\u0018\u00010(0(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\"\u00102\u001a\u0002018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u00069"}, d2={"Lat/hannibal2/skyhanni/features/garden/AnitaMedalProfit;", "", "<init>", "()V", "", "name", "Lat/hannibal2/skyhanni/features/garden/AnitaMedalProfit$MedalType;", "getMedal", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/garden/AnitaMedalProfit$MedalType;", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "event", "", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "", "slot", "Lnet/minecraft/item/ItemStack;", "item", "", "Lat/hannibal2/skyhanni/utils/DisplayTableEntry;", "table", "readItem", "(ILnet/minecraft/item/ItemStack;Ljava/util/List;)V", "getItemName", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", "requiredItems", "", "getFullCost", "(Ljava/util/List;)D", "getRequiredItems", "(Lnet/minecraft/item/ItemStack;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/AnitaShopConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/AnitaShopConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Ljava/util/List;", "", "inInventory", "Z", "getInInventory", "()Z", "setInInventory", "(Z)V", "MedalType", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nAnitaMedalProfit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnitaMedalProfit.kt\nat/hannibal2/skyhanni/features/garden/AnitaMedalProfit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n295#2,2:194\n*S KotlinDebug\n*F\n+ 1 AnitaMedalProfit.kt\nat/hannibal2/skyhanni/features/garden/AnitaMedalProfit\n*L\n44#1:194,2\n*E\n"})
public final class AnitaMedalProfit {
    @NotNull
    public static final AnitaMedalProfit INSTANCE = new AnitaMedalProfit();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();
    private static boolean inInventory;

    private AnitaMedalProfit() {
    }

    private final AnitaShopConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().anitaShop;
    }

    public final boolean getInInventory() {
        return inInventory;
    }

    public final void setInInventory(boolean bl) {
        inInventory = bl;
    }

    private final MedalType getMedal(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = MedalType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MedalType it = (MedalType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDisplayName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.getConfig().medalProfitEnabled) {
            return;
        }
        if (!Intrinsics.areEqual(event.getInventoryName(), "Anita")) {
            return;
        }
        if (VisitorAPI.INSTANCE.getInInventory()) {
            return;
        }
        inInventory = true;
        List table2 = new ArrayList();
        for (Map.Entry<Integer, ItemStack> entry : event.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack item = entry.getValue();
            try {
                this.readItem(slot, item, table2);
            }
            catch (Throwable e) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("item", item), TuplesKt.to("name", ItemUtils.INSTANCE.getItemName(item)), TuplesKt.to("inventory name", InventoryUtils.INSTANCE.openInventoryName())};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error in AnitaMedalProfit while reading item '" + ItemUtils.INSTANCE.getItemName(item) + '\'', pairArray, false, false, false, 56, null);
            }
        }
        List newList = new ArrayList();
        newList.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a7eMedal Profit", 0.0, null, null, null, 30, null));
        newList.add(LorenzUtils.INSTANCE.fillTable(table2, 5, 0.7));
        display = newList;
    }

    private final void readItem(int slot, ItemStack item, List<DisplayTableEntry> table2) {
        double itemPrice;
        String string2 = this.getItemName(item);
        if (string2 == null) {
            return;
        }
        String itemName = string2;
        if (Intrinsics.areEqual(itemName, " ")) {
            return;
        }
        if (Intrinsics.areEqual(itemName, "\u00a7cClose")) {
            return;
        }
        if (Intrinsics.areEqual(itemName, "\u00a7eUnique Gold Medals")) {
            return;
        }
        if (Intrinsics.areEqual(itemName, "\u00a7aMedal Trades")) {
            return;
        }
        double fullCost = this.getFullCost(this.getRequiredItems(item));
        if (fullCost < 0.0) {
            return;
        }
        Pair<String, Integer> pair = ItemUtils.INSTANCE.readItemAmount(itemName);
        if (pair == null) {
            return;
        }
        Pair<String, Integer> pair2 = pair;
        String name2 = pair2.component1();
        int amount = ((Number)pair2.component2()).intValue();
        NEUInternalName internalName = NEUInternalName.Companion.fromItemNameOrNull(name2);
        if (internalName == null) {
            internalName = ItemUtils.INSTANCE.getInternalName(item);
        }
        if ((itemPrice = NEUItems.getPrice$default(NEUItems.INSTANCE, internalName, null, null, 3, null) * (double)amount) < 0.0) {
            return;
        }
        double profit = itemPrice - fullCost;
        String profitFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, profit, false, 1, null);
        String color = profit > 0.0 ? "\u00a76" : "\u00a7c";
        String[] stringArray = new String[]{itemName, "", "\u00a77Item price: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, itemPrice, false, 1, null) + ' ', "\u00a77Material cost: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, fullCost, false, 1, null) + ' ', "\u00a77Final profit: \u00a76" + profitFormat + ' '};
        List<String> hover = CollectionsKt.listOf(stringArray);
        table2.add(new DisplayTableEntry(itemName, color + profitFormat, profit, internalName, hover, CollectionsKt.listOf(slot)));
    }

    private final String getItemName(ItemStack item) {
        String name2 = ItemUtils.INSTANCE.getName(item);
        boolean isEnchantedBook = ItemUtils.INSTANCE.getItemCategoryOrNull(item) == ItemCategory.ENCHANTED_BOOK;
        return isEnchantedBook ? ItemUtils.INSTANCE.getItemName(item) : name2;
    }

    private final double getFullCost(List<String> requiredItems) {
        double jacobTicketPrice = NEUItems.getPrice$default(NEUItems.INSTANCE, NEUInternalName.Companion.asInternalName("JACOBS_TICKET"), null, null, 3, null);
        double otherItemsPrice = 0.0;
        for (String rawItemName : requiredItems) {
            double d;
            Pair<String, Integer> pair = ItemUtils.INSTANCE.readItemAmount(rawItemName);
            if (pair == null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("rawItemName", rawItemName)};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Error in Anita Medal Contest", "Could not read item amount", pairArray, false, false, false, null, 120, null);
                continue;
            }
            String name2 = pair.component1();
            int amount = ((Number)pair.component2()).intValue();
            MedalType medal = this.getMedal(name2);
            if (medal != null) {
                int bronze = medal.getFactorBronze() * amount;
                d = (double)bronze * jacobTicketPrice;
            } else {
                d = NEUItems.getPrice$default(NEUItems.INSTANCE, NEUInternalName.Companion.fromItemName(name2), null, null, 3, null) * (double)amount;
            }
            otherItemsPrice += d;
        }
        return otherItemsPrice;
    }

    private final List<String> getRequiredItems(ItemStack item) {
        List items = new ArrayList();
        boolean next = false;
        for (String line : ItemUtils.INSTANCE.getLore(item)) {
            if (Intrinsics.areEqual(line, "\u00a77Cost")) {
                next = true;
                continue;
            }
            if (!next) continue;
            if (Intrinsics.areEqual(line, "")) {
                next = false;
                continue;
            }
            items.add(StringsKt.replace$default(line, "\u00a78 ", " \u00a78", false, 4, null));
        }
        return items;
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (inInventory) {
            Position position = this.getConfig().medalProfitPos;
            Intrinsics.checkNotNullExpressionValue(position, "medalProfitPos");
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 5, "Anita Medal Profit", false, 8, null);
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.anitaMedalProfitEnabled", "garden.anitaShop.medalProfitEnabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.anitaMedalProfitPos", "garden.anitaShop.medalProfitPos", null, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/features/garden/AnitaMedalProfit$MedalType;", "", "", "displayName", "", "factorBronze", "<init>", "(Ljava/lang/String;ILjava/lang/String;I)V", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "I", "getFactorBronze", "()I", "GOLD", "SILVER", "BRONZE", "1.8.9"})
    public static final class MedalType
    extends Enum<MedalType> {
        @NotNull
        private final String displayName;
        private final int factorBronze;
        public static final /* enum */ MedalType GOLD = new MedalType("\u00a76Gold medal", 8);
        public static final /* enum */ MedalType SILVER = new MedalType("\u00a7fSilver medal", 2);
        public static final /* enum */ MedalType BRONZE = new MedalType("\u00a7cBronze medal", 1);
        private static final /* synthetic */ MedalType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MedalType(String displayName, int factorBronze) {
            this.displayName = displayName;
            this.factorBronze = factorBronze;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public final int getFactorBronze() {
            return this.factorBronze;
        }

        public static MedalType[] values() {
            return (MedalType[])$VALUES.clone();
        }

        public static MedalType valueOf(String value) {
            return Enum.valueOf(MedalType.class, value);
        }

        @NotNull
        public static EnumEntries<MedalType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = medalTypeArray = new MedalType[]{MedalType.GOLD, MedalType.SILVER, MedalType.BRONZE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

