/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.trophy;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.fishing.trophyfishing.TrophyFishingConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiPlayer;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiTrophyFish;
import at.hannibal2.skyhanni.data.jsonobjects.repo.TrophyFishInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.TrophyFishJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.NeuProfileDataLoadedEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyFishAPI;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyFishDisplay;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyRarity;
import at.hannibal2.skyhanni.utils.ChatUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJO\u0010\u0015\u001a\u00020\u00062\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\f2\u001e\u0010\u0014\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0019\u0010\u001e\u001a\u00020\u0010*\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0004\b!\u0010\"R\u001c\u0010'\u001a\n $*\u0004\u0018\u00010#0#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R+\u0010*\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0016\u0010,\u001a\u00020+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\"\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00180\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/NeuProfileDataLoadedEvent;", "onNeuProfileDataLoaded", "(Lat/hannibal2/skyhanni/events/NeuProfileDataLoadedEvent;)V", "", "", "", "Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyRarity;", "", "savedFishes", "", "Lkotlin/Triple;", "neuData", "updateFromNeuPv", "(Ljava/util/Map;Ljava/util/List;)V", "internalName", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/TrophyFishInfo;", "getInfo", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/data/jsonobjects/repo/TrophyFishInfo;", "name", "getInfoByName", "rarity", "getFilletValue", "(Lat/hannibal2/skyhanni/data/jsonobjects/repo/TrophyFishInfo;Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyRarity;)I", "Lnet/minecraft/util/ChatStyle;", "getTooltip", "(Ljava/lang/String;)Lnet/minecraft/util/ChatStyle;", "Lat/hannibal2/skyhanni/config/features/fishing/trophyfishing/TrophyFishingConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/trophyfishing/TrophyFishingConfig;", "config", "getFish", "()Ljava/util/Map;", "fish", "", "loadedNeu", "Z", "trophyFishInfo", "Ljava/util/Map;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTrophyFishManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrophyFishManager.kt\nat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishManager\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n12#2,7:101\n381#3,7:108\n1#4:115\n*S KotlinDebug\n*F\n+ 1 TrophyFishManager.kt\nat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishManager\n*L\n22#1:101,7\n47#1:108,7\n*E\n"})
public final class TrophyFishManager {
    @NotNull
    public static final TrophyFishManager INSTANCE = new TrophyFishManager();
    private static boolean loadedNeu;
    @NotNull
    private static Map<String, TrophyFishInfo> trophyFishInfo;

    private TrophyFishManager() {
    }

    private final TrophyFishingConfig getConfig() {
        return SkyHanniMod.feature.fishing.trophyFishing;
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        TrophyFishJson trophyFishJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "TrophyFish";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            trophyFishJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, TrophyFishJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        TrophyFishJson data2 = trophyFishJson;
        trophyFishInfo = data2.getTrophyFish();
    }

    @Nullable
    public final Map<String, Map<TrophyRarity, Integer>> getFish() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).crimsonIsle) != null ? ((ProfileSpecificStorage.CrimsonIsleStorage)object).trophyFishes : null;
    }

    @SubscribeEvent
    public final void onNeuProfileDataLoaded(@NotNull NeuProfileDataLoadedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (loadedNeu || !this.getConfig().loadFromNeuPV) {
            return;
        }
        Object object = event.getCurrentPlayerData();
        if (object == null || (object = ((HypixelApiPlayer)object).getTrophyFish()) == null || (object = ((HypixelApiTrophyFish)object).getCaught()) == null) {
            return;
        }
        Map<String, Integer> caughtTrophyFish = object;
        loadedNeu = true;
        Map<String, Map<TrophyRarity, Integer>> map2 = this.getFish();
        if (map2 == null) {
            return;
        }
        Map<String, Map<TrophyRarity, Integer>> savedFishes = map2;
        boolean changed = false;
        List neuData = new ArrayList();
        for (Map.Entry<String, Integer> entry : caughtTrophyFish.entrySet()) {
            TrophyRarity rarity;
            Map map3;
            String fishName = entry.getKey();
            int apiAmount = ((Number)entry.getValue()).intValue();
            if (TrophyRarity.Companion.getByName(fishName) == null) continue;
            String[] stringArray = new String[]{"_"};
            String name2 = CollectionsKt.joinToString$default(CollectionsKt.dropLast(StringsKt.split$default((CharSequence)fishName, stringArray, false, 0, 6, null), 1), "", null, null, 0, null, null, 62, null);
            Map<String, Map<TrophyRarity, Integer>> $this$getOrPut$iv = savedFishes;
            boolean $i$f$getOrPut = false;
            Map value$iv = $this$getOrPut$iv.get(name2);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(name2, answer$iv);
                map3 = answer$iv;
            } else {
                map3 = value$iv;
            }
            Map savedFishData = map3;
            Integer n = savedFishData.get((Object)rarity);
            int currentSavedAmount = n != null ? n : 0;
            neuData.add(new Triple<String, TrophyRarity, Integer>(name2, rarity, apiAmount));
            if (apiAmount <= currentSavedAmount) continue;
            changed = true;
        }
        if (changed) {
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Click here to load Trophy Fishing data from NEU PV!", () -> TrophyFishManager.onNeuProfileDataLoaded$lambda$1(savedFishes, neuData), "\u00a7eClick to load!", 0L, false, null, true, 56, null);
        }
    }

    private final void updateFromNeuPv(Map<String, ? extends Map<TrophyRarity, Integer>> savedFishes, List<? extends Triple<String, ? extends TrophyRarity, Integer>> neuData) {
        for (Triple<String, ? extends TrophyRarity, Integer> triple : neuData) {
            Map<TrophyRarity, Integer> saved;
            String name2 = triple.component1();
            TrophyRarity rarity = triple.component2();
            int newValue = ((Number)triple.component3()).intValue();
            if (savedFishes.get(name2) == null) continue;
            Integer n = saved.get((Object)rarity);
            int current = n != null ? n : 0;
            if (newValue <= current) continue;
            Integer n2 = newValue;
            saved.put(rarity, n2);
            ChatUtils.INSTANCE.debug("Updated trophy fishing data from NEU PV:  " + name2 + ' ' + (Object)((Object)rarity) + ": " + current + " -> " + newValue);
        }
        TrophyFishDisplay.INSTANCE.update();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Updated Trophy Fishing data via NEU PV!", false, null, 6, null);
    }

    @Nullable
    public final TrophyFishInfo getInfo(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        return trophyFishInfo.get(internalName);
    }

    @Nullable
    public final TrophyFishInfo getInfoByName(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name2, "name");
            Iterable iterable = trophyFishInfo.values();
            for (Object t : iterable) {
                TrophyFishInfo it = (TrophyFishInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDisplayName(), name2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final int getFilletValue(@NotNull TrophyFishInfo $this$getFilletValue, @NotNull TrophyRarity rarity) {
        Intrinsics.checkNotNullParameter($this$getFilletValue, "<this>");
        Intrinsics.checkNotNullParameter((Object)rarity, "rarity");
        return ((Number)$this$getFilletValue.getFillet().getOrDefault((Object)rarity, -1)).intValue();
    }

    @Nullable
    public final ChatStyle getTooltip(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        String string2 = TrophyFishAPI.INSTANCE.hoverInfo(internalName);
        if (string2 == null) {
            return null;
        }
        String display2 = string2;
        return new ChatStyle().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(display2)));
    }

    private static final Unit onNeuProfileDataLoaded$lambda$1(Map $savedFishes, List $neuData) {
        Intrinsics.checkNotNullParameter($savedFishes, "$savedFishes");
        Intrinsics.checkNotNullParameter($neuData, "$neuData");
        INSTANCE.updateFromNeuPv($savedFishes, $neuData);
        return Unit.INSTANCE;
    }

    static {
        trophyFishInfo = MapsKt.emptyMap();
    }
}

