/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.fishing.FishingAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/fishing/SharkFishCounter;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SeaCreatureFishEvent;", "event", "", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/SeaCreatureFishEvent;)V", "", "name", "", "sharkIndex", "(Ljava/lang/String;)I", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "count", "funnyComment", "(I)Ljava/lang/String;", "", "isWaterFishingRod", "()Z", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "counter", "Ljava/util/List;", "display", "Ljava/lang/String;", "hasWaterRodInHand", "Z", "1.8.9"})
public final class SharkFishCounter {
    @NotNull
    public static final SharkFishCounter INSTANCE = new SharkFishCounter();
    @NotNull
    private static List<Integer> counter;
    @NotNull
    private static String display;
    private static boolean hasWaterRodInHand;

    private SharkFishCounter() {
    }

    @SubscribeEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!SkyHanniMod.feature.fishing.sharkFishCounter) {
            return;
        }
        String name2 = event.getSeaCreature().getName();
        if (!StringsKt.contains$default((CharSequence)name2, "Shark", false, 2, null)) {
            return;
        }
        List<Integer> list = counter;
        int n = this.sharkIndex(name2);
        list.set(n, ((Number)list.get(n)).intValue() + (event.getDoubleHook() ? 2 : 1));
        display = "\u00a77Sharks caught: \u00a7e" + NumberUtil.INSTANCE.addSeparators(CollectionsKt.sumOfInt((Iterable<Integer>)counter)) + " \u00a77(\u00a7a" + ((Number)counter.get(0)).intValue() + " \u00a79" + ((Number)counter.get(1)).intValue() + " \u00a75" + ((Number)counter.get(2)).intValue() + " \u00a76" + ((Number)counter.get(3)).intValue() + "\u00a77)";
    }

    private final int sharkIndex(String name2) {
        return StringsKt.contains$default((CharSequence)name2, "Blue", false, 2, null) ? 1 : (StringsKt.contains$default((CharSequence)name2, "Tiger", false, 2, null) ? 2 : (StringsKt.contains$default((CharSequence)name2, "Great", false, 2, null) ? 3 : 0));
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!SkyHanniMod.feature.fishing.sharkFishCounter) {
            return;
        }
        if (LorenzTickEvent.isMod$default(event, 10, 0, 2, null)) {
            hasWaterRodInHand = this.isWaterFishingRod();
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!Intrinsics.areEqual(event.getMessage(), "\u00a7b\u00a7lFISHING FESTIVAL \u00a7r\u00a7eThe festival has concluded! Time to dry off and repair your rods!")) {
            return;
        }
        int count2 = CollectionsKt.sumOfInt((Iterable<Integer>)counter);
        if (count2 == 0) {
            return;
        }
        int n = ((Number)counter.get(0)).intValue();
        int b = ((Number)counter.get(1)).intValue();
        int t = ((Number)counter.get(2)).intValue();
        int g = ((Number)counter.get(3)).intValue();
        String total = NumberUtil.INSTANCE.addSeparators(count2);
        String funnyComment = this.funnyComment(count2);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You caught " + total + " \u00a7f(\u00a7a" + n + " \u00a79" + b + " \u00a75" + t + " \u00a76" + g + "\u00a7f) \u00a7esharks during this fishing festival. " + funnyComment, false, null, 6, null);
        Integer[] integerArray = new Integer[]{0, 0, 0, 0};
        counter = CollectionsKt.mutableListOf(integerArray);
        display = "";
    }

    private final String funnyComment(int count2) {
        return count2 < 50 ? "Well done!" : (count2 < 100 ? "Nice!" : (count2 < 150 ? "Really nice!" : (count2 < 200 ? "Super cool!" : (count2 < 250 ? "Mega cool!" : (count2 < 350 ? "Like a pro!" : "How???")))));
    }

    private final boolean isWaterFishingRod() {
        return FishingAPI.isFishing$default(FishingAPI.INSTANCE, false, 1, null) && !FishingAPI.INSTANCE.getHoldingLavaRod();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!SkyHanniMod.feature.fishing.sharkFishCounter) {
            return;
        }
        if (!hasWaterRodInHand) {
            return;
        }
        Position position = SkyHanniMod.feature.fishing.sharkFishCounterPos;
        Intrinsics.checkNotNullExpressionValue(position, "sharkFishCounterPos");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, display, 0, 0, "Shark Fish Counter", 6, null);
    }

    static {
        Integer[] integerArray = new Integer[]{0, 0, 0, 0};
        counter = CollectionsKt.mutableListOf(integerArray);
        display = "";
    }
}

