/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.fishing.FishingBaitWarningsConfig;
import at.hannibal2.skyhanni.events.FishingBobberInLiquidEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.features.fishing.FishingAPI;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001e\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/FishingBobberInLiquidEvent;", "onBobber", "(Lat/hannibal2/skyhanni/events/FishingBobberInLiquidEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;", "Lnet/minecraft/entity/item/EntityItem;", "onEntityEnterWorld", "(Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;)V", "checkBait", "", "before", "after", "showBaitChangeWarning", "(Ljava/lang/String;Ljava/lang/String;)V", "showNoBaitWarning", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/FishingBaitWarningsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishingBaitWarningsConfig;", "config", "lastBait", "Ljava/lang/String;", "wasUsingBait", "Z", "Lat/hannibal2/skyhanni/utils/TimeLimitedSet;", "Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings$Bait;", "baitEntities", "Lat/hannibal2/skyhanni/utils/TimeLimitedSet;", "Bait", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFishingBaitWarnings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingBaitWarnings.kt\nat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n774#2:106\n865#2,2:107\n2341#2,14:109\n*S KotlinDebug\n*F\n+ 1 FishingBaitWarnings.kt\nat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings\n*L\n72#1:106\n72#1:107,2\n72#1:109,14\n*E\n"})
public final class FishingBaitWarnings {
    @NotNull
    public static final FishingBaitWarnings INSTANCE = new FishingBaitWarnings();
    @Nullable
    private static String lastBait;
    private static boolean wasUsingBait;
    @NotNull
    private static final TimeLimitedSet<Bait> baitEntities;

    private FishingBaitWarnings() {
    }

    private final FishingBaitWarningsConfig getConfig() {
        return SkyHanniMod.feature.fishing.fishingBaitWarnings;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastBait = null;
        wasUsingBait = true;
    }

    @SubscribeEvent
    public final void onBobber(@NotNull FishingBobberInLiquidEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(500, DurationUnit.MILLISECONDS), FishingBaitWarnings::onBobber$lambda$0);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onEntityEnterWorld(@NotNull EntityEnterWorldEvent<EntityItem> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled() || !FishingAPI.isFishing$default(FishingAPI.INSTANCE, false, 1, null)) {
            return;
        }
        if (LocationUtils.INSTANCE.distanceToPlayer((Entity)event.getEntity()) > 10.0) {
            return;
        }
        DelayedRun.INSTANCE.runNextTick(() -> FishingBaitWarnings.onEntityEnterWorld$lambda$1(event));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBait() {
        Object v1;
        void $this$filterTo$iv$iv;
        EntityFishHook entityFishHook = FishingAPI.INSTANCE.getBobber();
        if (entityFishHook == null) {
            return;
        }
        EntityFishHook bobber = entityFishHook;
        Iterable $this$filter$iv = baitEntities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bait it = (Bait)element$iv$iv;
            boolean bl = false;
            if (!(it.distanceTo(bobber) < 8.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Bait it = (Bait)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distanceTo(bobber);
                do {
                    Object e$iv = iterator$iv.next();
                    Bait it2 = (Bait)e$iv;
                    $i$a$-minByOrNull-FishingBaitWarnings$checkBait$bait$2 = false;
                    double v$iv = it2.distanceTo(bobber);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Bait bait = v1;
        String bait2 = bait != null ? bait.getName() : null;
        baitEntities.clear();
        if (bait2 == null) {
            if (this.getConfig().noBaitWarning && !wasUsingBait) {
                this.showNoBaitWarning();
            }
        } else if (this.getConfig().baitChangeWarning) {
            String string2 = lastBait;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it, bait2)) {
                    INSTANCE.showBaitChangeWarning(it, bait2);
                }
            }
        }
        wasUsingBait = bait2 != null;
        lastBait = bait2;
    }

    private final void showBaitChangeWarning(String before, String after) {
        SoundUtils.INSTANCE.playClickSound();
        LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7eBait changed!", DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Fishing Bait changed: " + before + " \u00a7e-> " + after, false, null, 6, null);
    }

    private final void showNoBaitWarning() {
        SoundUtils.INSTANCE.playErrorSound();
        LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7cNo bait is used!", DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You're not using any fishing baits!", false, null, 6, null);
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && !KuudraAPI.INSTANCE.inKuudra();
    }

    private static final Unit onBobber$lambda$0() {
        INSTANCE.checkBait();
        return Unit.INSTANCE;
    }

    private static final Unit onEntityEnterWorld$lambda$1(EntityEnterWorldEvent $event) {
        Intrinsics.checkNotNullParameter($event, "$event");
        ItemStack itemStack2 = ((EntityItem)$event.getEntity()).func_92059_d();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "getEntityItem(...)");
        boolean isBait = FishingAPI.INSTANCE.isBait(itemStack2);
        if (isBait) {
            baitEntities.plusAssign(new Bait((EntityItem)$event.getEntity(), null, null, 6, null));
        }
        return Unit.INSTANCE;
    }

    static {
        wasUsingBait = true;
        baitEntities = new TimeLimitedSet(DurationKt.toDuration(750, DurationUnit.SECONDS), null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c2\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010\u0014\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings$Bait;", "", "Lnet/minecraft/entity/item/EntityItem;", "entity", "", "name", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "<init>", "(Lnet/minecraft/entity/item/EntityItem;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Lnet/minecraft/entity/projectile/EntityFishHook;", "bobber", "", "distanceTo", "(Lnet/minecraft/entity/projectile/EntityFishHook;)D", "component1", "()Lnet/minecraft/entity/item/EntityItem;", "component2", "()Ljava/lang/String;", "component3", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "copy", "(Lnet/minecraft/entity/item/EntityItem;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/features/fishing/FishingBaitWarnings$Bait;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/minecraft/entity/item/EntityItem;", "Ljava/lang/String;", "getName", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getLocation", "1.8.9"})
    private static final class Bait {
        @NotNull
        private final EntityItem entity;
        @NotNull
        private final String name;
        @NotNull
        private final LorenzVec location;

        public Bait(@NotNull EntityItem entity, @NotNull String name2, @NotNull LorenzVec location) {
            Intrinsics.checkNotNullParameter(entity, "entity");
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            this.entity = entity;
            this.name = name2;
            this.location = location;
        }

        public /* synthetic */ Bait(EntityItem entityItem, String string2, LorenzVec lorenzVec, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                ItemStack itemStack2 = entityItem.func_92059_d();
                Intrinsics.checkNotNullExpressionValue(itemStack2, "getEntityItem(...)");
                string2 = ItemUtils.INSTANCE.getName(itemStack2);
            }
            if ((n & 4) != 0) {
                lorenzVec = LorenzVecKt.getLorenzVec((Entity)entityItem);
            }
            this(entityItem, string2, lorenzVec);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final LorenzVec getLocation() {
            return this.location;
        }

        public final double distanceTo(@NotNull EntityFishHook bobber) {
            Intrinsics.checkNotNullParameter(bobber, "bobber");
            return this.location.distance(LorenzVecKt.getLorenzVec((Entity)bobber));
        }

        private final EntityItem component1() {
            return this.entity;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final LorenzVec component3() {
            return this.location;
        }

        @NotNull
        public final Bait copy(@NotNull EntityItem entity, @NotNull String name2, @NotNull LorenzVec location) {
            Intrinsics.checkNotNullParameter(entity, "entity");
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            return new Bait(entity, name2, location);
        }

        public static /* synthetic */ Bait copy$default(Bait bait, EntityItem entityItem, String string2, LorenzVec lorenzVec, int n, Object object) {
            if ((n & 1) != 0) {
                entityItem = bait.entity;
            }
            if ((n & 2) != 0) {
                string2 = bait.name;
            }
            if ((n & 4) != 0) {
                lorenzVec = bait.location;
            }
            return bait.copy(entityItem, string2, lorenzVec);
        }

        @NotNull
        public String toString() {
            return "Bait(entity=" + this.entity + ", name=" + this.name + ", location=" + this.location + ')';
        }

        public int hashCode() {
            int result2 = this.entity.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.location.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bait)) {
                return false;
            }
            Bait bait = (Bait)other;
            if (!Intrinsics.areEqual(this.entity, bait.entity)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, bait.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.location, bait.location);
        }
    }
}

