/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ItemsJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.TrophyFishInfo;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.FishingBobberCastEvent;
import at.hannibal2.skyhanni.events.FishingBobberInLiquidEvent;
import at.hannibal2.skyhanni.events.ItemInHandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.features.fishing.IsFishingDetection;
import at.hannibal2.skyhanni.features.fishing.SeaCreatureManager;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyFishManager;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyRarity;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b \b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0011\u0010\u0013\u001a\u00020\u0012*\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0013\u001a\u00020\u0012*\u00020\u0015\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u0011\u0010\u0017\u001a\u00020\u0012*\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0011\u0010\u0018\u001a\u00020\u0012*\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0011\u0010\u0019\u001a\u00020\u0012*\u00020\u0011\u00a2\u0006\u0004\b\u0019\u0010\u0014J\u0017\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010#\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0 H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020\u0015\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00122\b\b\u0002\u0010)\u001a\u00020\u0012\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010.\u001a\u00020&2\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b0\u00101R\u001b\u00107\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R%\u00108\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0 8\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010$R\"\u0010;\u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00109R\"\u0010=\u001a\u00020<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\"\u0010C\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010D\u001a\u0004\bE\u00101\"\u0004\bF\u0010GR\"\u0010H\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010D\u001a\u0004\bI\u00101\"\u0004\bJ\u0010GR\"\u0010K\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010D\u001a\u0004\bL\u00101\"\u0004\bM\u0010GR\u001c\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00150 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u00109R\u001c\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00150 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u00109R$\u0010P\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\"\u0010V\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010D\u001a\u0004\bW\u00101\"\u0004\bX\u0010GR\"\u0010Y\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010D\u001a\u0004\bZ\u00101\"\u0004\b[\u0010G\u00a8\u0006\\"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingAPI;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;", "Lnet/minecraft/entity/projectile/EntityFishHook;", "event", "", "onJoinWorld", "(Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;)V", "resetBobber", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lnet/minecraft/item/ItemStack;", "", "isFishingRod", "(Lnet/minecraft/item/ItemStack;)Z", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Z", "isLavaRod", "isWaterRod", "isBait", "Lat/hannibal2/skyhanni/events/ItemInHandChangeEvent;", "onItemInHandChange", "(Lat/hannibal2/skyhanni/events/ItemInHandChangeEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "Lnet/minecraft/block/BlockLiquid;", "kotlin.jvm.PlatformType", "getAllowedBlocks", "()Ljava/util/List;", "internalName", "", "getFilletPerTrophy", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)I", "checkRodInHand", "isFishing", "(Z)Z", "Lnet/minecraft/entity/item/EntityArmorStand;", "entity", "seaCreatureCount", "(Lnet/minecraft/entity/item/EntityArmorStand;)I", "isWearingTrophyArmor", "()Z", "Ljava/util/regex/Pattern;", "trophyArmorNames$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTrophyArmorNames", "()Ljava/util/regex/Pattern;", "trophyArmorNames", "lavaBlocks", "Ljava/util/List;", "getLavaBlocks", "waterBlocks", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastCastTime", "J", "getLastCastTime-uFjCsEo", "()J", "setLastCastTime-gJLAdNM", "(J)V", "holdingRod", "Z", "getHoldingRod", "setHoldingRod", "(Z)V", "holdingLavaRod", "getHoldingLavaRod", "setHoldingLavaRod", "holdingWaterRod", "getHoldingWaterRod", "setHoldingWaterRod", "lavaRods", "waterRods", "bobber", "Lnet/minecraft/entity/projectile/EntityFishHook;", "getBobber", "()Lnet/minecraft/entity/projectile/EntityFishHook;", "setBobber", "(Lnet/minecraft/entity/projectile/EntityFishHook;)V", "bobberHasTouchedLiquid", "getBobberHasTouchedLiquid", "setBobberHasTouchedLiquid", "wearingTrophyArmor", "getWearingTrophyArmor", "setWearingTrophyArmor", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFishingAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingAPI.kt\nat/hannibal2/skyhanni/features/fishing/FishingAPI\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,171:1\n12#2,7:172\n1755#3,3:179\n12308#4,2:182\n*S KotlinDebug\n*F\n+ 1 FishingAPI.kt\nat/hannibal2/skyhanni/features/fishing/FishingAPI\n*L\n123#1:172,7\n158#1:179,3\n167#1:182,2\n*E\n"})
public final class FishingAPI {
    @NotNull
    public static final FishingAPI INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern trophyArmorNames$delegate;
    @NotNull
    private static final List<BlockLiquid> lavaBlocks;
    @NotNull
    private static final List<BlockLiquid> waterBlocks;
    private static long lastCastTime;
    private static boolean holdingRod;
    private static boolean holdingLavaRod;
    private static boolean holdingWaterRod;
    @NotNull
    private static List<NEUInternalName> lavaRods;
    @NotNull
    private static List<NEUInternalName> waterRods;
    @Nullable
    private static EntityFishHook bobber;
    private static boolean bobberHasTouchedLiquid;
    private static boolean wearingTrophyArmor;

    private FishingAPI() {
    }

    private final Pattern getTrophyArmorNames() {
        return (Pattern)trophyArmorNames$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @NotNull
    public final List<BlockLiquid> getLavaBlocks() {
        return lavaBlocks;
    }

    public final long getLastCastTime-uFjCsEo() {
        return lastCastTime;
    }

    public final void setLastCastTime-gJLAdNM(long l) {
        lastCastTime = l;
    }

    public final boolean getHoldingRod() {
        return holdingRod;
    }

    public final void setHoldingRod(boolean bl) {
        holdingRod = bl;
    }

    public final boolean getHoldingLavaRod() {
        return holdingLavaRod;
    }

    public final void setHoldingLavaRod(boolean bl) {
        holdingLavaRod = bl;
    }

    public final boolean getHoldingWaterRod() {
        return holdingWaterRod;
    }

    public final void setHoldingWaterRod(boolean bl) {
        holdingWaterRod = bl;
    }

    @Nullable
    public final EntityFishHook getBobber() {
        return bobber;
    }

    public final void setBobber(@Nullable EntityFishHook entityFishHook) {
        bobber = entityFishHook;
    }

    public final boolean getBobberHasTouchedLiquid() {
        return bobberHasTouchedLiquid;
    }

    public final void setBobberHasTouchedLiquid(boolean bl) {
        bobberHasTouchedLiquid = bl;
    }

    public final boolean getWearingTrophyArmor() {
        return wearingTrophyArmor;
    }

    public final void setWearingTrophyArmor(boolean bl) {
        wearingTrophyArmor = bl;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onJoinWorld(@NotNull EntityEnterWorldEvent<EntityFishHook> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!holdingRod) {
            return;
        }
        if (!Intrinsics.areEqual(event.getEntity().field_146042_b, Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        lastCastTime = SimpleTimeMark.Companion.now-uFjCsEo();
        bobber = event.getEntity();
        bobberHasTouchedLiquid = false;
        new FishingBobberCastEvent(event.getEntity()).postAndCatch();
    }

    private final void resetBobber() {
        bobber = null;
        bobberHasTouchedLiquid = false;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.resetBobber();
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            wearingTrophyArmor = this.isWearingTrophyArmor();
        }
        EntityFishHook entityFishHook = bobber;
        if (entityFishHook == null) {
            return;
        }
        EntityFishHook bobber = entityFishHook;
        if (bobber.field_70128_L) {
            this.resetBobber();
        } else if (!bobberHasTouchedLiquid) {
            boolean bl;
            if (bobber.func_180799_ab() && holdingLavaRod) {
                bl = false;
            } else if (bobber.func_70090_H() && holdingWaterRod) {
                bl = true;
            } else {
                return;
            }
            boolean isWater = bl;
            bobberHasTouchedLiquid = true;
            new FishingBobberInLiquidEvent(bobber, isWater).postAndCatch();
        }
    }

    public final boolean isFishingRod(@NotNull ItemStack $this$isFishingRod) {
        Intrinsics.checkNotNullParameter($this$isFishingRod, "<this>");
        return this.isFishingRod(ItemUtils.INSTANCE.getInternalName($this$isFishingRod));
    }

    public final boolean isFishingRod(@NotNull NEUInternalName $this$isFishingRod) {
        Intrinsics.checkNotNullParameter($this$isFishingRod, "<this>");
        return this.isLavaRod($this$isFishingRod) || this.isWaterRod($this$isFishingRod);
    }

    public final boolean isLavaRod(@NotNull NEUInternalName $this$isLavaRod) {
        Intrinsics.checkNotNullParameter($this$isLavaRod, "<this>");
        return lavaRods.contains($this$isLavaRod);
    }

    public final boolean isWaterRod(@NotNull NEUInternalName $this$isWaterRod) {
        Intrinsics.checkNotNullParameter($this$isWaterRod, "<this>");
        return waterRods.contains($this$isWaterRod);
    }

    public final boolean isBait(@NotNull ItemStack $this$isBait) {
        Intrinsics.checkNotNullParameter($this$isBait, "<this>");
        return $this$isBait.field_77994_a == 1 && ItemUtils.INSTANCE.getItemCategoryOrNull($this$isBait) == ItemCategory.BAIT;
    }

    @SubscribeEvent
    public final void onItemInHandChange(@NotNull ItemInHandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        holdingRod = this.isFishingRod(event.getNewItem());
        holdingLavaRod = this.isLavaRod(event.getNewItem());
        holdingWaterRod = this.isWaterRod(event.getNewItem());
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        ItemsJson itemsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "Items";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            itemsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, ItemsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        ItemsJson data2 = itemsJson;
        lavaRods = data2.getLavaFishingRods();
        waterRods = data2.getWaterFishingRods();
    }

    private final List<BlockLiquid> getAllowedBlocks() {
        return holdingLavaRod ? lavaBlocks : waterBlocks;
    }

    public final int getFilletPerTrophy(@NotNull NEUInternalName internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        String internal = internalName.asString();
        String string2 = StringsKt.replace$default(StringsKt.substringBeforeLast$default(internal, "_", null, 2, null), "_", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String trophyFishName = string2;
        String trophyRarityName = StringsKt.substringAfterLast$default(internal, "_", null, 2, null);
        TrophyFishInfo info = TrophyFishManager.INSTANCE.getInfo(trophyFishName);
        TrophyRarity trophyRarity = TrophyRarity.Companion.getByName(trophyRarityName);
        if (trophyRarity == null) {
            trophyRarity = TrophyRarity.BRONZE;
        }
        TrophyRarity rarity = trophyRarity;
        TrophyFishInfo trophyFishInfo = info;
        return trophyFishInfo != null ? TrophyFishManager.INSTANCE.getFilletValue(trophyFishInfo, rarity) : 0;
    }

    public final boolean isFishing(boolean checkRodInHand) {
        return IsFishingDetection.INSTANCE.isFishing() || checkRodInHand && holdingRod;
    }

    public static /* synthetic */ boolean isFishing$default(FishingAPI fishingAPI, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return fishingAPI.isFishing(bl);
    }

    public final int seaCreatureCount(@NotNull EntityArmorStand entity) {
        boolean hasFishingMobName;
        boolean isSummonedSoul;
        String name2;
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter(entity, "entity");
            name2 = entity.func_70005_c_();
            if (Intrinsics.areEqual(name2, "Reindrake")) {
                return 0;
            }
            if (Intrinsics.areEqual(name2, "\u00a75Frosty the Snow Blaster")) {
                return 0;
            }
            if (Intrinsics.areEqual(name2, "Frosty")) {
                LorenzVec npcLocation = new LorenzVec(-1.5, 76.0, 92.5);
                if (LorenzVecKt.getLorenzVec((Entity)entity).distance(npcLocation) < 1.0) {
                    return 0;
                }
            }
            Intrinsics.checkNotNull(name2);
            isSummonedSoul = StringsKt.contains$default((CharSequence)name2, "'", false, 2, null);
            Iterable $this$any$iv = SeaCreatureManager.INSTANCE.getAllFishingMobs().keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)name2, it, false, 2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = hasFishingMobName = false;
            }
        }
        if (!hasFishingMobName || isSummonedSoul) {
            return 0;
        }
        if (Intrinsics.areEqual(name2, "Sea Emperor") || Intrinsics.areEqual(name2, "Rider of the Deep")) {
            return 2;
        }
        return 1;
    }

    private final boolean isWearingTrophyArmor() {
        boolean bl;
        block1: {
            ItemStack[] $this$all$iv = InventoryUtils.INSTANCE.getArmor();
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                Object object;
                ItemStack element$iv;
                ItemStack it = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (RegexUtils.INSTANCE.matches(INSTANCE.getTrophyArmorNames(), (object = it) != null && (object = ItemUtils.INSTANCE.getInternalName((ItemStack)object)) != null ? ((NEUInternalName)object).asString() : null)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(FishingAPI.class, "trophyArmorNames", "getTrophyArmorNames()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new FishingAPI();
        trophyArmorNames$delegate = RepoPattern.Companion.pattern("fishing.trophyfishing.armor", "(BRONZE|SILVER|GOLD|DIAMOND)_HUNTER_(HELMET|CHESTPLATE|LEGGINGS|BOOTS)");
        kPropertyArray = new BlockLiquid[]{Blocks.field_150353_l, Blocks.field_150356_k};
        lavaBlocks = CollectionsKt.listOf(kPropertyArray);
        kPropertyArray = new BlockLiquid[]{Blocks.field_150355_j, Blocks.field_150358_i};
        waterBlocks = CollectionsKt.listOf(kPropertyArray);
        lastCastTime = SimpleTimeMark.Companion.farPast();
        lavaRods = CollectionsKt.emptyList();
        waterRods = CollectionsKt.emptyList();
    }
}

