/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.winter;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.event.winter.WinterConfig;
import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockTime;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.Collection;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000fR\u001c\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001e\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/features/event/winter/NewYearCakeReminder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "markCakeClaimed", "", "isClaimed", "()Z", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "isCakeTime", "Lat/hannibal2/skyhanni/config/features/event/winter/WinterConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/winter/WinterConfig;", "config", "Ljava/util/regex/Pattern;", "sidebarDetectionPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getSidebarDetectionPattern", "()Ljava/util/regex/Pattern;", "sidebarDetectionPattern", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastReminderSend", "J", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nNewYearCakeReminder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewYearCakeReminder.kt\nat/hannibal2/skyhanni/features/event/winter/NewYearCakeReminder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1755#2,3:77\n*S KotlinDebug\n*F\n+ 1 NewYearCakeReminder.kt\nat/hannibal2/skyhanni/features/event/winter/NewYearCakeReminder\n*L\n74#1:77,3\n*E\n"})
public final class NewYearCakeReminder {
    @NotNull
    public static final NewYearCakeReminder INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern sidebarDetectionPattern$delegate;
    private static long lastReminderSend;

    private NewYearCakeReminder() {
    }

    private final WinterConfig getConfig() {
        return SkyHanniMod.feature.event.winter;
    }

    private final Pattern getSidebarDetectionPattern() {
        return (Pattern)sidebarDetectionPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Intrinsics.areEqual(event.getMessage(), "\u00a7aYou claimed a \u00a7r\u00a7cNew Year Cake\u00a7r\u00a7a!")) {
            this.markCakeClaimed();
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (Intrinsics.areEqual(event.getInventoryName(), "Baker")) {
            this.markCakeClaimed();
        }
    }

    private final void markCakeClaimed() {
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        if (playerSpecificStorage == null) {
            return;
        }
        PlayerSpecificStorage playerSpecific = playerSpecificStorage;
        playerSpecific.winter.cakeCollectedYear = SkyBlockTime.Companion.now().getYear();
    }

    private final boolean isClaimed() {
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        if (playerSpecificStorage == null) {
            return false;
        }
        PlayerSpecificStorage playerSpecific = playerSpecificStorage;
        return playerSpecific.winter.cakeCollectedYear == SkyBlockTime.Companion.now().getYear();
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!this.getConfig().newYearCakeReminder) {
            return;
        }
        if (!this.isCakeTime()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (this.isClaimed()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastReminderSend), DurationKt.toDuration(30, DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastReminderSend = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.INSTANCE.clickToActionOrDisable("Reminding you to grab the free New Year Cake. Click here to open the baker menu!", new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((WinterConfig)this.receiver).newYearCakeReminder;
            }

            public void set(Object value) {
                ((WinterConfig)this.receiver).newYearCakeReminder = (Boolean)value;
            }
        }, "open the baker menu", NewYearCakeReminder::onSecondPassed$lambda$0);
    }

    private final boolean isCakeTime() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ScoreboardData.INSTANCE.getSidebarLinesFormatted();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!RegexUtils.INSTANCE.matches(INSTANCE.getSidebarDetectionPattern(), it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit onSecondPassed$lambda$0() {
        HypixelCommands.INSTANCE.openBaker();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(NewYearCakeReminder.class, "sidebarDetectionPattern", "getSidebarDetectionPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new NewYearCakeReminder();
        sidebarDetectionPattern$delegate = RepoPattern.Companion.pattern("event.winter.newyearcake.reminder.sidebar", "\u00a7dNew Year Event!\u00a7f (?<time>.*)");
        lastReminderSend = SimpleTimeMark.Companion.farPast();
    }
}

