/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.jerry.frozentreasure;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.event.winter.FrozenTreasureConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.ScoreboardData;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.event.jerry.frozentreasure.FrozenTreasure;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import at.hannibal2.skyhanni.utils.tracker.TrackerData;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001CB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020%H\u0002\u00a2\u0006\u0004\b(\u0010'J\r\u0010)\u001a\u00020\u0006\u00a2\u0006\u0004\b)\u0010\u0003R\u001c\u0010.\u001a\n +*\u0004\u0018\u00010*0*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001b\u00104\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00107R\u001c\u0010:\u001a\b\u0012\u0004\u0012\u000205098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0016\u0010?\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010>R\"\u0010A\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010\u00140\u00140@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "map", "formatDisplay", "(Ljava/util/List;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker$Data;", "data", "drawDisplay", "(Lat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker$Data;)Ljava/util/List;", "", "amount", "", "formatNumber", "(Ljava/lang/Number;)Ljava/lang/String;", "calculateIce", "(Lat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker$Data;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "onJerryWorkshop", "()Z", "inGlacialCave", "resetCommand", "Lat/hannibal2/skyhanni/config/features/event/winter/FrozenTreasureConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/winter/FrozenTreasureConfig;", "config", "Ljava/util/regex/Pattern;", "compactPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getCompactPattern", "()Ljava/util/regex/Pattern;", "compactPattern", "", "estimatedIce", "J", "lastEstimatedIce", "", "icePerSecond", "Ljava/util/List;", "", "icePerHour", "I", "stoppedChecks", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "Data", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFrozenTreasureTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrozenTreasureTracker.kt\nat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n8#2:201\n1#3:202\n774#4:203\n865#4,2:204\n1863#4,2:206\n*S KotlinDebug\n*F\n+ 1 FrozenTreasureTracker.kt\nat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker\n*L\n124#1:201\n124#1:202\n131#1:203\n131#1:204,2\n49#1:206,2\n*E\n"})
public final class FrozenTreasureTracker {
    @NotNull
    public static final FrozenTreasureTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern compactPattern$delegate;
    private static long estimatedIce;
    private static long lastEstimatedIce;
    @NotNull
    private static List<Long> icePerSecond;
    private static int icePerHour;
    private static int stoppedChecks;
    @NotNull
    private static final SkyHanniTracker<Data> tracker;

    private FrozenTreasureTracker() {
    }

    private final FrozenTreasureConfig getConfig() {
        return SkyHanniMod.feature.event.winter.frozenTreasureTracker;
    }

    private final Pattern getCompactPattern() {
        return (Pattern)compactPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        icePerHour = 0;
        stoppedChecks = 0;
        icePerSecond = new ArrayList();
        tracker.update();
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.onJerryWorkshop()) {
            return;
        }
        long difference = estimatedIce - lastEstimatedIce;
        lastEstimatedIce = estimatedIce;
        if (difference == estimatedIce) {
            return;
        }
        if (difference == 0L) {
            if (icePerSecond.isEmpty()) {
                return;
            }
            ++stoppedChecks;
        } else {
            if (stoppedChecks > 60) {
                stoppedChecks = 0;
                icePerSecond.clear();
                icePerHour = 0;
            }
            while (stoppedChecks > 0) {
                --stoppedChecks;
                icePerSecond.add(0L);
            }
            icePerSecond.add(difference);
            List<Long> listCopy = icePerSecond;
            while (listCopy.size() > 1200) {
                listCopy.remove(0);
            }
            icePerSecond = listCopy;
        }
        icePerHour = (int)(CollectionsKt.averageOfLong((Iterable<Long>)icePerSecond) * (double)3600);
    }

    private final List<Searchable> formatDisplay(List<Searchable> map2) {
        List newList = new ArrayList();
        for (FrozenTreasureConfig.FrozenTreasureDisplayEntry index : this.getConfig().textFormat) {
            newList.add(map2.get(index.ordinal()));
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!ProfileStorageData.INSTANCE.getLoaded()) {
            return;
        }
        if (!this.onJerryWorkshop()) {
            return;
        }
        String message = ((Object)StringsKt.trim((CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null))).toString();
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getCompactPattern();
        boolean $i$f$matchMatcher = false;
        Object it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl = false;
        if (((Matcher)it$iv).matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u245 = it$iv;
            boolean bl2 = false;
            tracker.modify(FrozenTreasureTracker::onChat$lambda$5$lambda$4);
            if (FrozenTreasureTracker.INSTANCE.getConfig().hideMessages) {
                event.setBlockedReason("frozen treasure tracker");
            }
        }
        Iterable $this$filter$iv = FrozenTreasure.getEntries();
        boolean $i$f$filter = false;
        it$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FrozenTreasure it = (FrozenTreasure)((Object)element$iv$iv);
            boolean bl3 = false;
            if (!RegexUtils.INSTANCE.matches(it.getChatPattern(), message)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FrozenTreasure treasure : (List)destination$iv$iv) {
            tracker.modify(arg_0 -> FrozenTreasureTracker.onChat$lambda$7(treasure, arg_0));
            if (!this.getConfig().hideMessages) continue;
            event.setBlockedReason("frozen treasure tracker");
        }
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List list;
        List $this$drawDisplay_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        INSTANCE.calculateIce(data2);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a7e\u00a7lFrozen Treasure Tracker", null, null, null, 14, null);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a76" + INSTANCE.formatNumber(data2.getTreasuresMined()) + " Treasures Mined", null, null, null, 14, null);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a73" + INSTANCE.formatNumber(estimatedIce) + " Total Ice", null, null, null, 14, null);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a73" + INSTANCE.formatNumber(icePerHour) + " Ice/hr", null, null, null, 14, null);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a78" + INSTANCE.formatNumber(data2.getCompactProcs()) + " Compact Procs", null, null, null, 14, null);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "", null, null, null, 14, null);
        for (FrozenTreasure treasure : FrozenTreasure.getEntries()) {
            Integer n = data2.getTreasureCount().get((Object)treasure);
            int count2 = (n != null ? n : 0) * (FrozenTreasureTracker.INSTANCE.getConfig().showAsDrops ? treasure.getDefaultAmount() : 1);
            CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a7b" + INSTANCE.formatNumber(count2) + ' ' + treasure.getDisplayName(), treasure.getDisplayName(), null, null, 12, null);
        }
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "", null, null, null, 14, null);
        return CollectionsKt.build(list);
    }

    @NotNull
    public final String formatNumber(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter(amount, "amount");
        if (amount instanceof Integer) {
            return NumberUtil.INSTANCE.addSeparators(amount);
        }
        if (amount instanceof Long) {
            return NumberUtil.shortFormat$default(NumberUtil.INSTANCE, amount, false, 1, null);
        }
        return String.valueOf(amount);
    }

    private final void calculateIce(Data data2) {
        estimatedIce = (long)data2.getCompactProcs() * 160L;
        for (FrozenTreasure treasure : FrozenTreasure.getEntries()) {
            Integer n = data2.getTreasureCount().get((Object)treasure);
            int amount = n != null ? n : 0;
            estimatedIce += (long)(amount * treasure.getDefaultAmount() * treasure.getIceMultiplier());
        }
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.getConfig().enabled) {
            return;
        }
        if (!this.onJerryWorkshop()) {
            return;
        }
        if (this.getConfig().onlyInCave && !this.inGlacialCave()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        tracker.renderDisplay(position);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.frozenTreasureTracker", "event.winter.frozenTreasureTracker", null, 8, null);
        event.move(11, "event.winter.frozenTreasureTracker.textFormat", "event.winter.frozenTreasureTracker.textFormat", FrozenTreasureTracker::onConfigFix$lambda$9);
    }

    private final boolean onJerryWorkshop() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.WINTER);
    }

    private final boolean inGlacialCave() {
        return this.onJerryWorkshop() && ScoreboardData.INSTANCE.getSidebarLinesFormatted().contains(" \u00a77\u23e3 \u00a73Glacial Cave");
    }

    public final void resetCommand() {
        tracker.resetCommand();
    }

    private static final Data tracker$lambda$0() {
        return new Data();
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.frozenTreasureTracker;
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNull(it);
        return INSTANCE.formatDisplay(INSTANCE.drawDisplay(it));
    }

    private static final Unit onChat$lambda$5$lambda$4(Data it) {
        it.setCompactProcs(it.getCompactProcs() + 1);
        return Unit.INSTANCE;
    }

    private static final Unit onChat$lambda$7(FrozenTreasure $treasure, Data it) {
        Intrinsics.checkNotNullParameter((Object)$treasure, "$treasure");
        it.setTreasuresMined(it.getTreasuresMined() + 1);
        CollectionUtils.INSTANCE.addOrPut(it.getTreasureCount(), $treasure, 1);
        return Unit.INSTANCE;
    }

    private static final JsonElement onConfigFix$lambda$9(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntArrayListToEnumArrayList(element, FrozenTreasureConfig.FrozenTreasureDisplayEntry.class);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(FrozenTreasureTracker.class, "compactPattern", "getCompactPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new FrozenTreasureTracker();
        compactPattern$delegate = RepoPattern.Companion.pattern("event.jerry.frozentreasure.compact", "COMPACT! You found an Enchanted Ice!");
        icePerSecond = new ArrayList();
        tracker = new SkyHanniTracker<Data>("Frozen Treasure Tracker", FrozenTreasureTracker::tracker$lambda$0, FrozenTreasureTracker::tracker$lambda$1, new Pair[0], FrozenTreasureTracker::tracker$lambda$2);
        Iterable $this$forEach$iv = FrozenTreasure.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrozenTreasure it = (FrozenTreasure)((Object)element$iv);
            boolean bl = false;
            it.getChatPattern();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR.\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasureTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/TrackerData;", "<init>", "()V", "", "reset", "", "treasuresMined", "I", "getTreasuresMined", "()I", "setTreasuresMined", "(I)V", "compactProcs", "getCompactProcs", "setCompactProcs", "", "Lat/hannibal2/skyhanni/features/event/jerry/frozentreasure/FrozenTreasure;", "treasureCount", "Ljava/util/Map;", "getTreasureCount", "()Ljava/util/Map;", "setTreasureCount", "(Ljava/util/Map;)V", "1.8.9"})
    public static final class Data
    extends TrackerData {
        @Expose
        private int treasuresMined;
        @Expose
        private int compactProcs;
        @Expose
        @NotNull
        private Map<FrozenTreasure, Integer> treasureCount = new LinkedHashMap();

        @Override
        public void reset() {
            this.treasureCount.clear();
            this.treasuresMined = 0;
            this.compactProcs = 0;
        }

        public final int getTreasuresMined() {
            return this.treasuresMined;
        }

        public final void setTreasuresMined(int n) {
            this.treasuresMined = n;
        }

        public final int getCompactProcs() {
            return this.compactProcs;
        }

        public final void setCompactProcs(int n) {
            this.compactProcs = n;
        }

        @NotNull
        public final Map<FrozenTreasure, Integer> getTreasureCount() {
            return this.treasureCount;
        }

        public final void setTreasureCount(@NotNull Map<FrozenTreasure, Integer> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.treasureCount = map2;
        }
    }
}

