/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityEggsConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.hoppity.EggFoundEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityAPI;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggLocations;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggType;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.event.hoppity.MythicRabbitPetWarning;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RecalculatingValue;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u0006*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ!\u0010\u0014\u001a\u00020\u0006*\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u0006*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000fJ#\u0010\u001a\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\u0003J\u000f\u0010)\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b)\u0010\u0003J\u0015\u0010*\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\u0004\b*\u0010+J\u0013\u0010,\u001a\u00020\u001c*\u00020\u001fH\u0002\u00a2\u0006\u0004\b,\u0010-J\u0013\u0010.\u001a\u00020\u001c*\u00020\u001fH\u0002\u00a2\u0006\u0004\b.\u0010-J\r\u0010/\u001a\u00020\u001c\u00a2\u0006\u0004\b/\u0010\u001eJ#\u00103\u001a\u000202*\u00020\u00122\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000205H\u0007\u00a2\u0006\u0004\b6\u00107J\u001b\u0010:\u001a\u00020\u00062\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001808\u00a2\u0006\u0004\b:\u0010;R\u001c\u0010@\u001a\n =*\u0004\u0018\u00010<0<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010B\u001a\u00020A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0018\u0010D\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0018\u0010F\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010ER\u0016\u0010H\u001a\u00020G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010IR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00120K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0016\u0010N\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010P\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010ER\u0016\u0010Q\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010ER\u0016\u0010S\u001a\u00020R8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0016\u0010U\u001a\u00020G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010IR\u001c\u0010W\u001a\b\u0012\u0004\u0012\u0002020V8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010MR$\u0010X\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010E\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R(\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00120V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b]\u0010M\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR$\u0010c\u001a\u0004\u0018\u00010b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010d\u001a\u0004\be\u0010f\"\u0004\bg\u0010hR$\u0010i\u001a\u0004\u0018\u00010\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bi\u0010j\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u0018\u0010p\u001a\u00020\u001c*\u00020o8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u001b\u0010u\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\br\u0010s\u001a\u0004\bt\u0010\u001e\u00a8\u0006v"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocator;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/hoppity/EggFoundEvent;", "event", "", "onEggFound", "(Lat/hannibal2/skyhanni/events/hoppity/EggFoundEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "resetData", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "drawGuessLocations", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "islandEggsLocations", "drawDuplicateEggs", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;Ljava/util/Set;)V", "drawGuessImmediately", "location", "", "label", "drawEggWaypoint", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/lang/String;)V", "", "shouldShowAllEggs", "()Z", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "calculateEggPosition", "trySendingGraph", "isValidEggLocation", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "isVillagerParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)Z", "isEnchantmentParticle", "isEnabled", "firstPoint", "secondPoint", "", "getEggLocationWeight", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "args", "testPathfind", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityEggsConfig;", "config", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "locatorItem", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "lastParticlePosition", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastParticlePositionForever", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastChange", "J", "lastClick", "", "validParticleLocations", "Ljava/util/List;", "drawLocations", "Z", "firstPos", "secondPos", "", "ticksSinceLastParticleFound", "I", "lastGuessMade", "", "eggLocationWeights", "sharedEggLocation", "getSharedEggLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "setSharedEggLocation", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "possibleEggLocations", "getPossibleEggLocations", "()Ljava/util/List;", "setPossibleEggLocations", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;", "currentEggType", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;", "getCurrentEggType", "()Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;", "setCurrentEggType", "(Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggType;)V", "currentEggNote", "Ljava/lang/String;", "getCurrentEggNote", "()Ljava/lang/String;", "setCurrentEggNote", "(Ljava/lang/String;)V", "Lnet/minecraft/item/ItemStack;", "isLocatorItem", "(Lnet/minecraft/item/ItemStack;)Z", "locatorInHotbar$delegate", "Lat/hannibal2/skyhanni/utils/RecalculatingValue;", "getLocatorInHotbar", "locatorInHotbar", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHoppityEggLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoppityEggLocator.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n774#2:344\n865#2,2:345\n1557#2:347\n1628#2,3:348\n1053#2:351\n1557#2:352\n1628#2,3:353\n774#2:356\n865#2,2:357\n1557#2:359\n1628#2,3:360\n1062#2:363\n1755#2,3:364\n1755#2,3:367\n*S KotlinDebug\n*F\n+ 1 HoppityEggLocator.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocator\n*L\n109#1:344\n109#1:345,2\n247#1:347\n247#1:348,3\n249#1:351\n251#1:352\n251#1:353,3\n255#1:356\n255#1:357,2\n257#1:359\n257#1:360,3\n259#1:363\n286#1:364,3\n298#1:367,3\n*E\n"})
public final class HoppityEggLocator {
    @NotNull
    public static final HoppityEggLocator INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final NEUInternalName locatorItem;
    @Nullable
    private static LorenzVec lastParticlePosition;
    @Nullable
    private static LorenzVec lastParticlePositionForever;
    private static long lastChange;
    private static long lastClick;
    @NotNull
    private static final List<LorenzVec> validParticleLocations;
    private static boolean drawLocations;
    @NotNull
    private static LorenzVec firstPos;
    @NotNull
    private static LorenzVec secondPos;
    private static int ticksSinceLastParticleFound;
    private static long lastGuessMade;
    @NotNull
    private static List<Double> eggLocationWeights;
    @Nullable
    private static LorenzVec sharedEggLocation;
    @NotNull
    private static List<LorenzVec> possibleEggLocations;
    @Nullable
    private static HoppityEggType currentEggType;
    @Nullable
    private static String currentEggNote;
    @NotNull
    private static final RecalculatingValue locatorInHotbar$delegate;

    private HoppityEggLocator() {
    }

    private final HoppityEggsConfig getConfig() {
        return HoppityEggsManager.INSTANCE.getConfig();
    }

    @Nullable
    public final LorenzVec getSharedEggLocation() {
        return sharedEggLocation;
    }

    public final void setSharedEggLocation(@Nullable LorenzVec lorenzVec) {
        sharedEggLocation = lorenzVec;
    }

    @NotNull
    public final List<LorenzVec> getPossibleEggLocations() {
        return possibleEggLocations;
    }

    public final void setPossibleEggLocations(@NotNull List<LorenzVec> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        possibleEggLocations = list;
    }

    @Nullable
    public final HoppityEggType getCurrentEggType() {
        return currentEggType;
    }

    public final void setCurrentEggType(@Nullable HoppityEggType hoppityEggType) {
        currentEggType = hoppityEggType;
    }

    @Nullable
    public final String getCurrentEggNote() {
        return currentEggNote;
    }

    public final void setCurrentEggNote(@Nullable String string2) {
        currentEggNote = string2;
    }

    @HandleEvent
    public final void onEggFound(@NotNull EggFoundEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getType().isResetting()) {
            this.resetData();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.resetData();
    }

    private final void resetData() {
        validParticleLocations.clear();
        ticksSinceLastParticleFound = -1;
        possibleEggLocations = CollectionsKt.emptyList();
        firstPos = new LorenzVec();
        secondPos = new LorenzVec();
        drawLocations = false;
        sharedEggLocation = null;
        currentEggType = null;
        currentEggNote = null;
        lastParticlePosition = null;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        this.drawGuessImmediately(event);
        if (drawLocations) {
            this.drawGuessLocations(event);
            return;
        }
        LorenzVec lorenzVec = sharedEggLocation;
        if (lorenzVec != null) {
            LorenzVec it = lorenzVec;
            boolean bl = false;
            if (HoppityEggLocator.INSTANCE.getConfig().sharedWaypoints) {
                INSTANCE.drawEggWaypoint(event, it, "\u00a7aShared Egg");
                return;
            }
        }
        Set<LorenzVec> islandEggsLocations = HoppityEggLocations.INSTANCE.getIslandLocations();
        if (this.shouldShowAllEggs()) {
            if (this.getConfig().hideDuplicateWaypoints) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = islandEggsLocations;
                boolean $i$f$filter = false;
                Iterable bl = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LorenzVec it = (LorenzVec)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!HoppityEggLocations.INSTANCE.hasCollectedEgg(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                islandEggsLocations = CollectionsKt.toSet((List)destination$iv$iv);
            }
            for (LorenzVec eggLocation : islandEggsLocations) {
                this.drawEggWaypoint(event, eggLocation, "\u00a7aEgg");
            }
            return;
        }
        this.drawDuplicateEggs(event, islandEggsLocations);
    }

    private final void drawGuessLocations(LorenzRenderWorldEvent $this$drawGuessLocations) {
        LorenzVec eyeLocation = RenderUtils.INSTANCE.exactPlayerEyeLocation($this$drawGuessLocations);
        Iterator iterator2 = ((Iterable)possibleEggLocations).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            LorenzVec eggLocation = (LorenzVec)iterator2.next();
            this.drawEggWaypoint($this$drawGuessLocations, eggLocation, "\u00a7aGuess #" + (index + 1));
            if (!this.getConfig().showLine) continue;
            RenderUtils.INSTANCE.draw3DLine($this$drawGuessLocations, eyeLocation, eggLocation.add(0.5, 0.5, 0.5), LorenzColor.GREEN.toColor(), 2, false);
        }
    }

    private final void drawDuplicateEggs(LorenzRenderWorldEvent $this$drawDuplicateEggs, Set<LorenzVec> islandEggsLocations) {
        if (!this.getConfig().highlightDuplicateEggLocations || !this.getConfig().showNearbyDuplicateEggLocations) {
            return;
        }
        for (LorenzVec eggLocation : islandEggsLocations) {
            double dist = LocationUtils.INSTANCE.distanceToPlayer(eggLocation);
            if (!(dist < 10.0) || !HoppityEggLocations.INSTANCE.hasCollectedEgg(eggLocation)) continue;
            float alpha = (float)RangesKt.coerceAtMost(((double)10 - dist) / (double)10, 0.5);
            RenderUtils.INSTANCE.drawColor($this$drawDuplicateEggs, eggLocation, LorenzColor.RED, false, alpha);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, $this$drawDuplicateEggs, LorenzVec.add$default(eggLocation, 0, 1, 0, 5, null), "\u00a7cDuplicate Location!", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    private final void drawGuessImmediately(LorenzRenderWorldEvent $this$drawGuessImmediately) {
        block5: {
            if (!this.getConfig().waypointsImmediately) break block5;
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastClick), DurationKt.toDuration(5, DurationUnit.SECONDS)) < 0) {
                LorenzVec lorenzVec = lastParticlePositionForever;
                if (lorenzVec != null) {
                    LorenzVec it = lorenzVec;
                    boolean bl = false;
                    if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastChange), DurationKt.toDuration(300, DurationUnit.MILLISECONDS)) < 0) {
                        LorenzVec eyeLocation = RenderUtils.INSTANCE.exactPlayerEyeLocation($this$drawGuessImmediately);
                        if (eyeLocation.distance(it) > 2.0) {
                            String string2 = HoppityEggLocator.INSTANCE.getConfig().waypointColor;
                            Intrinsics.checkNotNullExpressionValue(string2, "waypointColor");
                            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, $this$drawGuessImmediately, it, ColorUtils.INSTANCE.toChromaColor(string2), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
                            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, $this$drawGuessImmediately, LorenzVec.add$default(it, 0, 1, 0, 5, null), "\u00a7aGuess", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                        }
                        if (!drawLocations && HoppityEggLocator.INSTANCE.getConfig().showLine) {
                            RenderUtils.INSTANCE.draw3DLine($this$drawGuessImmediately, eyeLocation, it.add(0.5, 0.5, 0.5), LorenzColor.GREEN.toColor(), 2, false);
                        }
                    }
                }
            }
        }
    }

    private final void drawEggWaypoint(LorenzRenderWorldEvent $this$drawEggWaypoint, LorenzVec location, String label) {
        String possibleDuplicateLabel;
        boolean shouldMarkDuplicate = this.getConfig().highlightDuplicateEggLocations && HoppityEggLocations.INSTANCE.hasCollectedEgg(location);
        String string2 = possibleDuplicateLabel = shouldMarkDuplicate ? label + " \u00a7c(Duplicate Location)" : label;
        if (!shouldMarkDuplicate) {
            String string3 = this.getConfig().waypointColor;
            Intrinsics.checkNotNullExpressionValue(string3, "waypointColor");
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, $this$drawEggWaypoint, location, ColorUtils.INSTANCE.toChromaColor(string3), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
        } else {
            RenderUtils.INSTANCE.drawColor($this$drawEggWaypoint, location, LorenzColor.RED.toColor(), false, 0.5f);
        }
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, $this$drawEggWaypoint, LorenzVec.add$default(location, 0, 1, 0, 5, null), possibleDuplicateLabel, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    private final boolean shouldShowAllEggs() {
        return this.getConfig().showAllWaypoints && !this.getLocatorInHotbar() && HoppityEggType.Companion.eggsRemaining();
    }

    @SubscribeEvent
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getLocatorInHotbar()) {
            return;
        }
        if (!this.isVillagerParticle(event) && !this.isEnchantmentParticle(event)) {
            return;
        }
        LorenzVec lorenzVec = lastParticlePosition;
        if (lorenzVec == null) {
            HoppityEggLocator $this$onReceiveParticle_u24lambda_u243 = this;
            boolean bl = false;
            lastParticlePositionForever = lastParticlePosition = event.getLocation();
            lastChange = SimpleTimeMark.Companion.now-uFjCsEo();
            return;
        }
        LorenzVec lastParticlePosition = lorenzVec;
        if (Intrinsics.areEqual(lastParticlePosition, event.getLocation())) {
            validParticleLocations.add(event.getLocation());
            ticksSinceLastParticleFound = 0;
        }
        HoppityEggLocator.lastParticlePosition = null;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (validParticleLocations.isEmpty()) {
            return;
        }
        int n = ticksSinceLastParticleFound;
        if ((ticksSinceLastParticleFound = n + 1) < 6) {
            return;
        }
        this.calculateEggPosition();
        ticksSinceLastParticleFound = 0;
        validParticleLocations.clear();
        lastParticlePosition = null;
    }

    @SubscribeEvent
    public final void onItemClick(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        ItemStack itemStack2 = event.getItemInHand();
        if (itemStack2 == null) {
            return;
        }
        ItemStack item = itemStack2;
        if (event.getClickType() == ClickType.RIGHT_CLICK && this.isLocatorItem(item)) {
            lastClick = SimpleTimeMark.Companion.now-uFjCsEo();
            MythicRabbitPetWarning.INSTANCE.check();
            this.trySendingGraph();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateEggPosition() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$sortedBy$iv;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastGuessMade), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastGuessMade = SimpleTimeMark.Companion.now-uFjCsEo();
        possibleEggLocations = CollectionsKt.emptyList();
        Set<LorenzVec> islandEggsLocations = HoppityEggLocations.INSTANCE.getIslandLocations();
        int listSize = validParticleLocations.size();
        if (listSize < 5) {
            return;
        }
        LorenzVec secondPoint = CollectionsKt.removeLast(validParticleLocations);
        firstPos = CollectionsKt.removeLast(validParticleLocations);
        double xDiff = secondPoint.getX() - firstPos.getX();
        double yDiff = secondPoint.getY() - firstPos.getY();
        double zDiff = secondPoint.getZ() - firstPos.getZ();
        secondPos = new LorenzVec(secondPoint.getX() + xDiff * (double)1000, secondPoint.getY() + yDiff * (double)1000, secondPoint.getZ() + zDiff * (double)1000);
        Iterable $this$map$iv2 = islandEggsLocations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            LorenzVec lorenzVec = (LorenzVec)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it, INSTANCE.getEggLocationWeight((LorenzVec)((Object)it), firstPos, secondPos)));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List sortedEggs = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getSecond()));
            }
        });
        $this$map$iv2 = sortedEggs;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NumberUtil.INSTANCE.roundTo(((Number)it.getSecond()).doubleValue(), 3));
        }
        eggLocationWeights = CollectionsKt.take((List)destination$iv$iv, 5);
        Iterable $this$filter$iv = sortedEggs;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it2.getSecond()).doubleValue() < 1.0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair it2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add((LorenzVec)it2.getFirst());
        }
        List filteredEggs = (List)destination$iv$iv2;
        Iterable $this$sortedByDescending$iv = filteredEggs;
        boolean $i$f$sortedByDescending = false;
        List maxLineDistance = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                LorenzVec it = (LorenzVec)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.nearestPointOnLine(HoppityEggLocator.access$getFirstPos$p(), HoppityEggLocator.access$getSecondPos$p()).distance(HoppityEggLocator.access$getFirstPos$p()));
                it = (LorenzVec)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.nearestPointOnLine(HoppityEggLocator.access$getFirstPos$p(), HoppityEggLocator.access$getSecondPos$p()).distance(HoppityEggLocator.access$getFirstPos$p()));
            }
        });
        if (maxLineDistance.isEmpty()) {
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7cNo eggs found, try getting closer", DurationKt.toDuration(2, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
            return;
        }
        secondPos = ((LorenzVec)CollectionsKt.first(maxLineDistance)).nearestPointOnLine(firstPos, secondPos);
        possibleEggLocations = filteredEggs;
        if (drawLocations) {
            return;
        }
        drawLocations = true;
        this.trySendingGraph();
    }

    private final void trySendingGraph() {
        if (!this.getConfig().showPathFinder) {
            return;
        }
        LorenzVec lorenzVec = CollectionsKt.firstOrNull(possibleEggLocations);
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        String string2 = this.getConfig().waypointColor;
        Intrinsics.checkNotNullExpressionValue(string2, "waypointColor");
        Color color = ColorUtils.INSTANCE.toChromaColor(string2);
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, location, color, null, false, HoppityEggLocator::trySendingGraph$lambda$10, 12, null);
    }

    public final boolean isValidEggLocation(@NotNull LorenzVec location) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(location, "location");
            Iterable $this$any$iv = HoppityEggLocations.INSTANCE.getIslandLocations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LorenzVec it = (LorenzVec)element$iv;
                    boolean bl2 = false;
                    if (!(it.distance(location) < 5.0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isVillagerParticle(ReceiveParticleEvent $this$isVillagerParticle) {
        return $this$isVillagerParticle.getType() == EnumParticleTypes.VILLAGER_HAPPY && $this$isVillagerParticle.getSpeed() == 0.0f && $this$isVillagerParticle.getCount() == 1;
    }

    private final boolean isEnchantmentParticle(ReceiveParticleEvent $this$isEnchantmentParticle) {
        return $this$isEnchantmentParticle.getType() == EnumParticleTypes.ENCHANTMENT_TABLE && $this$isEnchantmentParticle.getSpeed() == -2.0f && $this$isEnchantmentParticle.getCount() == 10;
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().waypoints && !GardenAPI.INSTANCE.inGarden() && !ReminderUtils.INSTANCE.isBusy(true) && HoppityAPI.INSTANCE.isHoppityEvent();
    }

    private final boolean isLocatorItem(ItemStack $this$isLocatorItem) {
        return Intrinsics.areEqual(ItemUtils.INSTANCE.getInternalName($this$isLocatorItem), locatorItem);
    }

    private final boolean getLocatorInHotbar() {
        return (Boolean)locatorInHotbar$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final double getEggLocationWeight(LorenzVec $this$getEggLocationWeight, LorenzVec firstPoint, LorenzVec secondPoint) {
        double distToLine = $this$getEggLocationWeight.distanceToLine(firstPoint, secondPoint);
        double distToStart = $this$getEggLocationWeight.distance(firstPoint);
        double distMultiplier = distToStart * (double)2 / (double)100 + (double)5;
        double disMultiplierSquared = distMultiplier * distMultiplier;
        return distToLine / disMultiplierSquared;
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Hoppity Eggs Locations");
        if (!this.isEnabled()) {
            event.addIrrelevant("not in skyblock or waypoints are disabled");
            return;
        }
        event.addIrrelevant(HoppityEggLocator::onDebugDataCollect$lambda$14);
    }

    public final void testPathfind(@NotNull String[] args2) {
        block1: {
            Intrinsics.checkNotNullParameter(args2, "args");
            int target = NumberUtil.INSTANCE.formatInt(args2[0]);
            Map<String, LorenzVec> map2 = HoppityEggLocations.INSTANCE.getApiEggLocations().get((Object)LorenzUtils.INSTANCE.getSkyBlockIsland());
            if (map2 == null) break block1;
            Map<String, LorenzVec> it = map2;
            boolean bl = false;
            Iterator iterator2 = ((Iterable)it.values()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i2 = n++;
                LorenzVec location = (LorenzVec)iterator2.next();
                if (i2 != target) continue;
                IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, location, null, null, false, null, 30, null);
                return;
            }
        }
    }

    private static final boolean trySendingGraph$lambda$10() {
        return HoppityEggLocator.INSTANCE.getConfig().showPathFinder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean locatorInHotbar_delegate$lambda$13() {
        ItemStack it;
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) return false;
        Iterable $this$any$iv = InventoryUtils.INSTANCE.getItemsInHotbar();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ItemStack)element$iv;
            boolean bl = false;
        } while (!INSTANCE.isLocatorItem(it));
        return true;
    }

    private static final Unit onDebugDataCollect$lambda$14(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        $this$addIrrelevant.add("First Pos: " + firstPos);
        $this$addIrrelevant.add("Second Pos: " + secondPos);
        $this$addIrrelevant.add("Possible Egg Locations: " + possibleEggLocations.size());
        $this$addIrrelevant.add("Egg Location Weights: " + eggLocationWeights);
        $this$addIrrelevant.add("Last Time Checked: " + Duration.getInWholeSeconds-impl(SimpleTimeMark.passedSince-UwyO8pc(lastGuessMade)) + "s ago");
        $this$addIrrelevant.add("Draw Locations: " + drawLocations);
        StringBuilder stringBuilder = new StringBuilder().append("Shared Egg Location: ");
        Object object = sharedEggLocation;
        if (object == null) {
            object = "None";
        }
        $this$addIrrelevant.add(stringBuilder.append(object).toString());
        StringBuilder stringBuilder2 = new StringBuilder().append("Current Egg Type: ");
        Object object2 = currentEggType;
        if (object2 == null) {
            object2 = "None";
        }
        $this$addIrrelevant.add(stringBuilder2.append(object2).toString());
        StringBuilder stringBuilder3 = new StringBuilder().append("Current Egg Note: ");
        String string2 = currentEggNote;
        if (string2 == null) {
            string2 = "None";
        }
        $this$addIrrelevant.add(stringBuilder3.append(string2).toString());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LorenzVec access$getFirstPos$p() {
        return firstPos;
    }

    public static final /* synthetic */ LorenzVec access$getSecondPos$p() {
        return secondPos;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(HoppityEggLocator.class, "locatorInHotbar", "getLocatorInHotbar()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HoppityEggLocator();
        locatorItem = NEUInternalName.Companion.asInternalName("EGGLOCATOR");
        lastChange = SimpleTimeMark.Companion.farPast();
        lastClick = SimpleTimeMark.Companion.farPast();
        validParticleLocations = new ArrayList();
        firstPos = new LorenzVec();
        secondPos = new LorenzVec();
        ticksSinceLastParticleFound = -1;
        lastGuessMade = SimpleTimeMark.Companion.farPast();
        eggLocationWeights = CollectionsKt.emptyList();
        possibleEggLocations = CollectionsKt.emptyList();
        locatorInHotbar$delegate = new RecalculatingValue(DurationKt.toDuration(1, DurationUnit.SECONDS), HoppityEggLocator::locatorInHotbar_delegate$lambda$13, null);
    }
}

