/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityCallWarningConfig;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzKeyPressEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.time.Instant;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000eJ\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010#\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001d\u001a\u0004\b\"\u0010\u001fR\u001b\u0010&\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001d\u001a\u0004\b%\u0010\u001fR\u001c\u0010+\u001a\n (*\u0004\u0018\u00010'0'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0018\u00102\u001a\u0004\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0018\u00104\u001a\u0004\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0018\u00109\u001a\u0004\u0018\u0001088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCallWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzKeyPressEvent;", "event", "", "onKeyPress", "(Lat/hannibal2/skyhanni/events/LorenzKeyPressEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRender", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "readPickupUuid", "startWarningUser", "stopWarningUser", "", "isEnabled", "()Z", "Ljava/util/regex/Pattern;", "initHoppityCallPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getInitHoppityCallPattern", "()Ljava/util/regex/Pattern;", "initHoppityCallPattern", "callRingPattern$delegate", "getCallRingPattern", "callRingPattern", "pickupHoppityCallPattern$delegate", "getPickupHoppityCallPattern", "pickupHoppityCallPattern", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityCallWarningConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityCallWarningConfig;", "config", "Lnet/minecraft/client/audio/ISound;", "warningSound", "Lnet/minecraft/client/audio/ISound;", "activeWarning", "Z", "Ljava/time/Instant;", "nextWarningTime", "Ljava/time/Instant;", "finalWarningTime", "Lkotlin/time/Duration;", "callLength", "J", "", "acceptUUID", "Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHoppityCallWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoppityCallWarning.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityCallWarning\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class HoppityCallWarning {
    @NotNull
    public static final HoppityCallWarning INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern initHoppityCallPattern$delegate;
    @NotNull
    private static final RepoPattern callRingPattern$delegate;
    @NotNull
    private static final RepoPattern pickupHoppityCallPattern$delegate;
    @NotNull
    private static ISound warningSound;
    private static boolean activeWarning;
    @Nullable
    private static Instant nextWarningTime;
    @Nullable
    private static Instant finalWarningTime;
    private static final long callLength;
    @Nullable
    private static String acceptUUID;

    private HoppityCallWarning() {
    }

    private final Pattern getInitHoppityCallPattern() {
        return (Pattern)initHoppityCallPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getCallRingPattern() {
        return (Pattern)callRingPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getPickupHoppityCallPattern() {
        return (Pattern)pickupHoppityCallPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final HoppityCallWarningConfig getConfig() {
        return HoppityEggsManager.INSTANCE.getConfig().hoppityCallWarning;
    }

    @SubscribeEvent
    public final void onKeyPress(@NotNull LorenzKeyPressEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (this.getConfig().acceptHotkey == 0 || this.getConfig().acceptHotkey != event.getKeyCode()) {
                return;
            }
            String string2 = acceptUUID;
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            String string3 = acceptUUID;
            Intrinsics.checkNotNull(string3);
            HypixelCommands.INSTANCE.callback(string3);
            acceptUUID = null;
        }
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<String> soundProperty = this.getConfig().hoppityCallSound;
        Property[] propertyArray = new Property[]{soundProperty};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, () -> HoppityCallWarning.onConfigLoad$lambda$1(soundProperty));
        nextWarningTime = null;
        finalWarningTime = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (RegexUtils.INSTANCE.matches(this.getCallRingPattern(), event.getMessage()) && acceptUUID == null) {
            this.readPickupUuid(event);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getInitHoppityCallPattern(), event.getMessage())) {
            this.startWarningUser();
        }
        if (RegexUtils.INSTANCE.matches(this.getPickupHoppityCallPattern(), event.getMessage())) {
            this.stopWarningUser();
        }
    }

    @SubscribeEvent
    public final void onTick(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!activeWarning) {
            return;
        }
        if (nextWarningTime == null || finalWarningTime == null) {
            return;
        }
        Instant currentTime = Instant.now();
        if (currentTime.isAfter(nextWarningTime)) {
            SoundUtils.INSTANCE.repeatSound(100L, 10, warningSound);
            nextWarningTime = currentTime.plusMillis(100L);
        }
        if (currentTime.compareTo(finalWarningTime) >= 0) {
            this.stopWarningUser();
        }
    }

    @SubscribeEvent
    public final void onRender(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled() || !activeWarning) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        double randomizationAlphaDouble = ((double)2 + Math.sin((double)Instant.now().toEpochMilli() / (double)1000)) * (double)255 / (double)4;
        int randomizationAlphaInt = RangesKt.coerceIn((int)randomizationAlphaDouble, new IntRange(0, 255));
        int shiftedRandomAlpha = randomizationAlphaInt << 24;
        int n = minecraft.field_71443_c;
        int n2 = minecraft.field_71440_d;
        String string2 = this.getConfig().flashColor;
        Intrinsics.checkNotNullExpressionValue(string2, "flashColor");
        Gui.func_73734_a((int)0, (int)0, (int)n, (int)n2, (int)(shiftedRandomAlpha | ColorUtils.INSTANCE.toChromaColorInt(string2) & 0xFFFFFF));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private final void readPickupUuid(LorenzChatEvent event) {
        IChatComponent clickEvent;
        Object it;
        Object object;
        block7: {
            block6: {
                it = object = event.getChatComponent().func_150253_a();
                boolean bl = false;
                Object object2 = it.size() >= 3 ? object : null;
                if (object2 == null) {
                    return;
                }
                Object siblings = object2;
                IChatComponent iChatComponent = (IChatComponent)siblings.get(2);
                if (iChatComponent == null || (iChatComponent = iChatComponent.func_150256_b()) == null || (iChatComponent = iChatComponent.func_150235_h()) == null) {
                    return;
                }
                clickEvent = iChatComponent;
                String string2 = clickEvent.func_150669_a().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (!Intrinsics.areEqual(string2, "run_command")) break block6;
                String string3 = clickEvent.func_150668_b();
                Intrinsics.checkNotNullExpressionValue(string3, "getValue(...)");
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                if (StringsKt.startsWith$default(string4, "/cb", false, 2, null)) break block7;
            }
            return;
        }
        String string5 = clickEvent.func_150668_b();
        Intrinsics.checkNotNullExpressionValue(string5, "getValue(...)");
        String string6 = string5.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
        it = object = StringsKt.replace$default(string6, "/cb ", "", false, 4, null);
        boolean bl = false;
        Object object3 = acceptUUID = StringUtils.INSTANCE.isValidUuid((String)it) ? object : null;
        if (acceptUUID != null) {
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(12, DurationUnit.SECONDS), HoppityCallWarning::readPickupUuid$lambda$4);
        }
    }

    private final void startWarningUser() {
        if (activeWarning) {
            return;
        }
        activeWarning = true;
        SoundUtils.INSTANCE.repeatSound(100L, 10, warningSound);
        Instant currentTime = Instant.now();
        nextWarningTime = currentTime.plusMillis(100L);
        Instant instant = finalWarningTime;
        if (instant == null) {
            instant = currentTime.plusMillis(Duration.getInWholeMilliseconds-impl(callLength));
        }
        finalWarningTime = instant;
    }

    private final void stopWarningUser() {
        activeWarning = false;
        finalWarningTime = null;
        nextWarningTime = null;
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    private static final void onConfigLoad$lambda$1(Property $soundProperty) {
        Object t = $soundProperty.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        warningSound = SoundUtils.createSound$default(SoundUtils.INSTANCE, (String)t, 1.0f, 0.0f, 4, null);
    }

    private static final Unit readPickupUuid$lambda$4() {
        acceptUUID = null;
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(HoppityCallWarning.class, "initHoppityCallPattern", "getInitHoppityCallPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(HoppityCallWarning.class, "callRingPattern", "getCallRingPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(HoppityCallWarning.class, "pickupHoppityCallPattern", "getPickupHoppityCallPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HoppityCallWarning();
        initHoppityCallPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("hoppity.call.init", "\u00a7e\u2706 \u00a7r(?:\u00a7a|\u00a7b)Hoppity\u00a7r\u00a7e \u2706.*");
        callRingPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("hoppity.call.ring", "\u00a7a\u2706 (?:RING\\.{3} ?){1,3}(?:\u00a7r \u00a7r\u00a72\u00a7l\\[PICK UP])?");
        pickupHoppityCallPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("hoppity.call.pickup", "\u00a7e\\[NPC] \u00a7aHoppity\u00a7f: \u00a7b\u2706 \u00a7f\u00a7rWhat's up, .*\u00a7f\\?");
        warningSound = SoundUtils.createSound$default(SoundUtils.INSTANCE, "note.pling", 1.0f, 0.0f, 4, null);
        callLength = DurationKt.toDuration(7, DurationUnit.SECONDS);
    }
}

