/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.carnival;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.event.carnival.CarnivalConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.Perk;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R2\u0010)\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#2\r\u0010$\u001a\t\u0018\u00010\"\u00a2\u0006\u0002\b#8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001b\u00102\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001b\u00105\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010/\u001a\u0004\b4\u00101\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/features/event/carnival/CarnivalReminder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassedEvent", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onLorenzChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "checkDate", "check", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/event/carnival/CarnivalConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/carnival/CarnivalConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CarnivalStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CarnivalStorage;", "storage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "nextCheckTime", "J", "claimedToday", "Z", "Ljava/time/LocalDate;", "Lorg/jetbrains/annotations/Nullable;", "value", "getLastClaimedDay", "()Ljava/time/LocalDate;", "setLastClaimedDay", "(Ljava/time/LocalDate;)V", "lastClaimedDay", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "repoGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "ticketClaimedPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTicketClaimedPattern", "()Ljava/util/regex/Pattern;", "ticketClaimedPattern", "alreadyClaimedPattern$delegate", "getAlreadyClaimedPattern", "alreadyClaimedPattern", "1.8.9"})
public final class CarnivalReminder {
    @NotNull
    public static final CarnivalReminder INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private static long nextCheckTime;
    private static boolean claimedToday;
    @NotNull
    private static final RepoPatternGroup repoGroup;
    @NotNull
    private static final RepoPattern ticketClaimedPattern$delegate;
    @NotNull
    private static final RepoPattern alreadyClaimedPattern$delegate;

    private CarnivalReminder() {
    }

    private final CarnivalConfig getConfig() {
        return SkyHanniMod.feature.event.carnival;
    }

    private final ProfileSpecificStorage.CarnivalStorage getStorage() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.carnival : null;
    }

    private final LocalDate getLastClaimedDay() {
        ProfileSpecificStorage.CarnivalStorage carnivalStorage = this.getStorage();
        return carnivalStorage != null ? carnivalStorage.lastClaimedDay : null;
    }

    private final void setLastClaimedDay(LocalDate value) {
        block0: {
            if (this.getStorage() == null) break block0;
            this.getStorage().lastClaimedDay = value;
        }
    }

    private final Pattern getTicketClaimedPattern() {
        return (Pattern)ticketClaimedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getAlreadyClaimedPattern() {
        return (Pattern)alreadyClaimedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @SubscribeEvent
    public final void onSecondPassedEvent(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled() || SimpleTimeMark.isInFuture-impl(nextCheckTime)) {
            return;
        }
        this.check();
    }

    @SubscribeEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        claimedToday = false;
        if (!this.isEnabled()) {
            return;
        }
        nextCheckTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(30.0, DurationUnit.SECONDS));
        this.checkDate();
        this.check();
    }

    @SubscribeEvent
    public final void onLorenzChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled() && !claimedToday) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getTicketClaimedPattern(), event.getMessage()) && !RegexUtils.INSTANCE.matches(this.getAlreadyClaimedPattern(), event.getMessage())) {
            return;
        }
        claimedToday = true;
        this.setLastClaimedDay(ZonedDateTime.now(ZoneOffset.UTC).toLocalDate());
    }

    private final void checkDate() {
        LocalDate currentDay = ZonedDateTime.now(ZoneOffset.UTC).toLocalDate();
        LocalDate lastClaimedDay = this.getLastClaimedDay();
        claimedToday = lastClaimedDay != null && !currentDay.isAfter(lastClaimedDay);
    }

    public final void check() {
        if (claimedToday) {
            this.checkDate();
        } else if (!ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            ChatUtils.INSTANCE.clickToActionOrDisable("Carnival Tickets are ready to be claimed!", new MutablePropertyReference0Impl(this.getConfig()){

                public Object get() {
                    return ((CarnivalConfig)this.receiver).reminderDailyTickets;
                }

                public void set(Object value) {
                    ((CarnivalConfig)this.receiver).reminderDailyTickets = (Boolean)value;
                }
            }, "warp to The Carnival", CarnivalReminder::check$lambda$0);
            nextCheckTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(5.0, DurationUnit.MINUTES));
        }
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().reminderDailyTickets && Perk.CHIVALROUS_CARNIVAL.isActive();
    }

    private static final Unit check$lambda$0() {
        HypixelCommands.INSTANCE.warp("carnival");
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CarnivalReminder.class, "ticketClaimedPattern", "getTicketClaimedPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(CarnivalReminder.class, "alreadyClaimedPattern", "getAlreadyClaimedPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CarnivalReminder();
        nextCheckTime = SimpleTimeMark.Companion.farFuture-uFjCsEo();
        repoGroup = RepoPattern.Companion.group("carnival.tickets");
        ticketClaimedPattern$delegate = repoGroup.pattern("claimed", "\u00a7aYou claimed \u00a7r\u00a7aCarnival Ticket \u00a7r\u00a78x25\u00a7r\u00a7a!");
        alreadyClaimedPattern$delegate = repoGroup.pattern("already", "\u00a7e\\[NPC\\] \u00a7aCarnival Leader\u00a7f: \u00a7rYou've already claimed your \u00a7aCarnival Tickets \u00a7ffor \u00a7btoday\u00a7f, but I'm happy to answer any questions you might have.");
    }
}

