/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.dungeon.DungeonConfig;
import at.hannibal2.skyhanni.events.DungeonStartEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001d\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010#\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\"\u0010-\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010&\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonMilestonesDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "update", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/DungeonStartEvent;", "onDungeonStart", "(Lat/hannibal2/skyhanni/events/DungeonStartEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "config", "Ljava/util/regex/Pattern;", "milestonePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMilestonePattern", "()Ljava/util/regex/Pattern;", "milestonePattern", "", "display", "Ljava/lang/String;", "", "currentMilestone", "I", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "timeReached", "J", "color", "getColor", "()Ljava/lang/String;", "setColor", "(Ljava/lang/String;)V", "1.8.9"})
public final class DungeonMilestonesDisplay {
    @NotNull
    public static final DungeonMilestonesDisplay INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern milestonePattern$delegate;
    @NotNull
    private static String display;
    private static int currentMilestone;
    private static long timeReached;
    @NotNull
    private static String color;

    private DungeonMilestonesDisplay() {
    }

    private final DungeonConfig getConfig() {
        return SkyHanniMod.feature.dungeon;
    }

    private final Pattern getMilestonePattern() {
        return (Pattern)milestonePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @NotNull
    public final String getColor() {
        return color;
    }

    public final void setColor(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        color = string2;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            return;
        }
        if (currentMilestone >= 3) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(timeReached), DurationKt.toDuration(3, DurationUnit.SECONDS)) > 0 && ((CharSequence)display).length() > 0) {
                String string2 = display.substring(1);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                display = string2;
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getMilestonePattern(), event.getMessage())) {
            event.setBlockedReason("dungeon_milestone");
            int n = currentMilestone;
            currentMilestone = n + 1;
            this.update();
        }
    }

    private final void update() {
        String string2;
        if (currentMilestone > 3) {
            return;
        }
        if (currentMilestone == 3) {
            timeReached = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        switch (currentMilestone) {
            case 0: 
            case 1: {
                string2 = "\u00a7c";
                break;
            }
            case 2: {
                string2 = "\u00a7e";
                break;
            }
            default: {
                string2 = "\u00a7a";
            }
        }
        color = string2;
        display = "Current Milestone: " + currentMilestone;
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        display = "";
        currentMilestone = 0;
    }

    @SubscribeEvent
    public final void onDungeonStart(@NotNull DungeonStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        currentMilestone = 0;
        this.update();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = this.getConfig().showMileStonesDisplayPos;
        Intrinsics.checkNotNullExpressionValue(position, "showMileStonesDisplayPos");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, color + display, 0, 0, "Dungeon Milestone", 6, null);
    }

    private final boolean isEnabled() {
        return DungeonAPI.INSTANCE.inDungeon() && this.getConfig().showMilestonesDisplay;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DungeonMilestonesDisplay.class, "milestonePattern", "getMilestonePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DungeonMilestonesDisplay();
        milestonePattern$delegate = RepoPattern.Companion.pattern("dungeon.milestone", "\u00a7e\u00a7l.*Milestone \u00a7r\u00a7e.\u00a7r\u00a77: You have (?:tanked and )?(?:dealt|healed) \u00a7r\u00a7.*\u00a7r\u00a77.*so far! \u00a7r\u00a7a.*");
        display = "";
        timeReached = SimpleTimeMark.Companion.farPast();
        color = "";
    }
}

