/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.mobs;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.combat.MobsConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001b\u0010\"\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001b\u0010%\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010!R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010+R\u0016\u00102\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010+\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/features/combat/mobs/ArachneSpawnTimer;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onPacketReceive", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "arachneFragmentPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getArachneFragmentPattern", "()Ljava/util/regex/Pattern;", "arachneFragmentPattern", "arachneCrystalPattern$delegate", "getArachneCrystalPattern", "arachneCrystalPattern", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "arachneAltarLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "arachneSpawnTime", "J", "saveNextTickParticles", "Z", "", "particleCounter", "I", "lastTickTime", "searchTime", "1.8.9"})
public final class ArachneSpawnTimer {
    @NotNull
    public static final ArachneSpawnTimer INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern arachneFragmentPattern$delegate;
    @NotNull
    private static final RepoPattern arachneCrystalPattern$delegate;
    @NotNull
    private static final LorenzVec arachneAltarLocation;
    private static long arachneSpawnTime;
    private static boolean saveNextTickParticles;
    private static int particleCounter;
    private static long lastTickTime;
    private static long searchTime;

    private ArachneSpawnTimer() {
    }

    private final MobsConfig getConfig() {
        return SkyHanniMod.feature.combat.mobs;
    }

    private final Pattern getArachneFragmentPattern() {
        return (Pattern)arachneFragmentPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getArachneCrystalPattern() {
        return (Pattern)arachneCrystalPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        searchTime = SimpleTimeMark.Companion.farPast();
        lastTickTime = SimpleTimeMark.Companion.farPast();
        particleCounter = 0;
        saveNextTickParticles = false;
        arachneSpawnTime = SimpleTimeMark.Companion.farPast();
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (SimpleTimeMark.isInPast-impl(arachneSpawnTime)) {
            return;
        }
        long countDown = SimpleTimeMark.timeUntil-UwyO8pc(arachneSpawnTime);
        String format = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, countDown, null, true, false, 0, false, 29, null);
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, arachneAltarLocation, "\u00a7b" + format, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        String string2 = StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String message = string2;
        if (RegexUtils.INSTANCE.matches(this.getArachneFragmentPattern(), message) || RegexUtils.INSTANCE.matches(this.getArachneCrystalPattern(), message)) {
            if (RegexUtils.INSTANCE.matches(this.getArachneCrystalPattern(), message)) {
                saveNextTickParticles = true;
                searchTime = SimpleTimeMark.Companion.now-uFjCsEo();
                particleCounter = 0;
                lastTickTime = SimpleTimeMark.Companion.farPast();
            } else {
                arachneSpawnTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(19, DurationUnit.SECONDS));
            }
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.SPIDER_DEN, priority=1, receiveCancelled=true)
    public final void onPacketReceive(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!saveNextTickParticles) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(searchTime), DurationKt.toDuration(3, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (particleCounter == 0 && SimpleTimeMark.isFarPast-impl(lastTickTime)) {
            lastTickTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastTickTime), DurationKt.toDuration(60, DurationUnit.MILLISECONDS)) > 0) {
            arachneSpawnTime = particleCounter <= 20 ? SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(21, DurationUnit.SECONDS)) : SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(37, DurationUnit.SECONDS));
            saveNextTickParticles = false;
            return;
        }
        Packet<?> packet = event.getPacket();
        if (packet instanceof S2APacketParticles) {
            LorenzVec location = LorenzVecKt.toLorenzVec((S2APacketParticles)packet).roundTo(2);
            if (arachneAltarLocation.distance(location) > 30.0) {
                return;
            }
            if (((S2APacketParticles)packet).func_179749_a() == EnumParticleTypes.REDSTONE && ((S2APacketParticles)packet).func_149227_j() == 1.0f) {
                ++particleCounter;
            }
        }
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.SPIDER_DEN) && Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Arachne's Sanctuary") && this.getConfig().showArachneSpawnTimer;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ArachneSpawnTimer.class, "arachneFragmentPattern", "getArachneFragmentPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ArachneSpawnTimer.class, "arachneCrystalPattern", "getArachneCrystalPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ArachneSpawnTimer();
        patternGroup = RepoPattern.Companion.group("combat.mobs.spawntime.arachne");
        arachneFragmentPattern$delegate = patternGroup.pattern("fragment", "^\u2604 [a-z0-9_]{2,22} placed an arachne's calling! something is awakening! \\(4/4\\)$");
        arachneCrystalPattern$delegate = patternGroup.pattern("crystal", "^\u2604 [a-z0-9_]{2,22} placed an arachne crystal! something is awakening!$");
        arachneAltarLocation = new LorenzVec(-283.0f, 51.0f, -179.0f);
        arachneSpawnTime = SimpleTimeMark.Companion.farPast();
        lastTickTime = SimpleTimeMark.Companion.farPast();
        searchTime = SimpleTimeMark.Companion.farPast();
    }
}

